/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ant;

import com.ibm.icu.dev.tool.UOption;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.unicode.cldr.ant.CLDRConverterTool;

public class CLDRBuild
extends Task {
    private String toolName;
    private String srcFile;
    private String destFile;
    private boolean noArgs = false;
    private Vector runs = new Vector();
    private UOption srcDir = UOption.SOURCEDIR();
    private UOption destDir = UOption.DESTDIR();
    private static final String ALL = ".*";
    private static final char FILE_EXT_SEPARATOR = '.';

    public static boolean matchesFileName(String locales, String fileName) {
        String locale = fileName.substring(0, fileName.indexOf(".xml"));
        return CLDRBuild.matchesLocale(locales, locale);
    }

    public static boolean matchesLocale(String locales, String locale) {
        String[] arr = locales.split("\\s+");
        for (int i = 0; i < arr.length; ++i) {
            if (!locale.matches(arr[i]) && !locale.equals(arr[i])) continue;
            return true;
        }
        return false;
    }

    public TreeMap getLocalesList(Config config, String src, String dest) {
        int j;
        File srcdir = new File(src);
        File[] srcFiles = srcdir.listFiles(new Filter(this.srcFile));
        File destdir = new File(dest);
        File[] destFiles = destdir.listFiles(new Filter(this.destFile));
        TreeMap<String, String> ret = new TreeMap<String, String>();
        if (config != null) {
            Locales locs = config.getLocales();
            Vector locsList = locs.getList();
            block0: for (int i = 0; i < locsList.size(); ++i) {
                String fileName;
                Object obj = locsList.get(i);
                if (obj instanceof Exclude) {
                    Exclude exc = (Exclude)((Object)obj);
                    if (exc.locales == null) {
                        CLDRBuild.errln("locales attribute not set for exclude element!", true);
                    }
                    if (exc.locales.equals(ALL)) {
                        for (j = 0; j < srcFiles.length; ++j) {
                            ret.remove(srcFiles[j].getName());
                        }
                        continue;
                    }
                    for (j = 0; j < srcFiles.length; ++j) {
                        fileName = srcFiles[j].getName();
                        if (!CLDRBuild.matchesFileName(exc.locales, fileName)) continue;
                        ret.remove(fileName);
                        continue block0;
                    }
                    continue;
                }
                if (!(obj instanceof Include)) continue;
                Include inc = (Include)((Object)obj);
                if (inc.locales == null) {
                    CLDRBuild.errln("locales attribute not set for include element!", true);
                }
                if (inc.locales.equals(ALL)) {
                    for (j = 0; j < srcFiles.length; ++j) {
                        ret.put(srcFiles[j].getName(), inc.draft);
                    }
                    continue;
                }
                for (j = 0; j < srcFiles.length; ++j) {
                    fileName = srcFiles[j].getName();
                    if (!CLDRBuild.matchesFileName(inc.locales, fileName)) continue;
                    ret.put(fileName, inc.draft);
                    continue block0;
                }
            }
        } else {
            for (int i = 0; i < srcFiles.length; ++i) {
                ret.put(srcFiles[i].getName(), ALL);
            }
        }
        for (int i = 0; i < destFiles.length; ++i) {
            String destName = destFiles[i].getName();
            long destMod = destFiles[i].lastModified();
            destName = destName.substring(0, destName.indexOf(46) + 1);
            if (this.srcFile != null) {
                int save;
                destName = destName + this.getFileExtension(this.srcFile);
                for (j = save = 0; j < srcFiles.length; ++j) {
                    String srcName = srcFiles[j].getName();
                    if (!srcName.matches(destName)) continue;
                    save = j;
                    if (destMod <= srcFiles[j].lastModified()) continue;
                    ret.remove(srcName);
                }
                continue;
            }
            if (!destFiles[i].exists()) continue;
            ret.remove(this.destFile);
        }
        if (ret.size() == 0 && destFiles.length == 1) {
            return null;
        }
        return ret;
    }

    private String getFileExtension(String name) {
        int i = name.indexOf(42);
        if (i > -1) {
            return name.substring(i + 1, name.length());
        }
        i = name.indexOf(46);
        if (i > -1) {
            return name.substring(i + 1, name.length());
        }
        return name;
    }

    public static void errln(String msg, boolean exit) {
        System.err.println("ERROR: " + msg);
        if (exit) {
            System.exit(-1);
        }
    }

    public static void warnln(String msg) {
        System.out.println("WARNING: " + msg);
    }

    public static void infoln(String msg) {
        System.out.println("INFO: " + msg);
    }

    private String getDirString(Hashtable runArgs, UOption key) {
        String value = (String)runArgs.get("--" + key.longName);
        if (value == null) {
            value = (String)runArgs.get("-" + String.valueOf(key.shortName));
        }
        return value;
    }

    public void execute() throws BuildException {
        if (this.toolName == null) {
            throw new BuildException("Tool name not set");
        }
        Iterator iter = this.runs.iterator();
        while (iter.hasNext()) {
            Hashtable runArgs;
            Run run = (Run)((Object)iter.next());
            Config config = run.getConfig();
            TreeMap localesMap = this.getLocalesList(config, this.getDirString(runArgs = run.getArgs(null), this.srcDir), this.getDirString(runArgs, this.destDir));
            if (localesMap == null || localesMap.size() == 0 && !this.noArgs) continue;
            String[] args = new String[runArgs.size() * 2];
            int i = 0;
            StringBuffer printArgs = new StringBuffer();
            Iterator iter1 = runArgs.keySet().iterator();
            while (iter1.hasNext()) {
                String key = (String)iter1.next();
                String value = (String)runArgs.get(key);
                args[i++] = key;
                if (value.length() > 0) {
                    args[i++] = value;
                }
                printArgs.append(key);
                printArgs.append(" ");
                printArgs.append(value);
                printArgs.append(" ");
            }
            while (i < args.length) {
                args[i] = "";
                ++i;
            }
            Object obj = CLDRBuild.createObject(this.toolName);
            if (obj instanceof CLDRConverterTool) {
                CLDRConverterTool tool = (CLDRConverterTool)obj;
                tool.setLocalesMap(localesMap);
                if (run.deprecates != null) {
                    tool.setAliasLocaleList(((Run)run).deprecates.aliasLocaleList);
                    tool.setAliasMap(((Run)run).deprecates.aliasMap);
                    tool.setEmptyLocaleList(((Run)run).deprecates.emptyLocaleList);
                }
                if (run.config != null) {
                    if (((Run)run).config.paths != null) {
                        tool.setPathList(((Run)run).config.paths.pathList);
                    }
                    if (run.config.ofb != null) {
                        tool.setOverrideFallbackList(run.config.ofb.list);
                    }
                }
                tool.processArgs(args);
            } else {
                CLDRBuild.errln(this.toolName + " not a subclass of CLDRConverterTool! Cannot execute. Exiting", true);
            }
            System.out.println("");
        }
    }

    private static Object createObject(String className) {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (InstantiationException e) {
            CLDRBuild.errln(e.getMessage(), true);
        }
        catch (IllegalAccessException e) {
            CLDRBuild.errln(e.getMessage(), true);
        }
        catch (ClassNotFoundException e) {
            CLDRBuild.errln(e.getMessage(), true);
        }
        return object;
    }

    public void addConfiguredRun(Run run) {
        this.runs.add(run);
    }

    public void setToolName(String name) {
        this.toolName = name;
    }

    public void setSrcFile(String sf) {
        this.srcFile = sf;
    }

    public void setDestFile(String df) {
        this.destFile = df;
    }

    public void setNoArgs(String bool) {
        this.noArgs = bool.equals("true");
    }

    public static class OverrideFallback
    extends Task {
        private ArrayList list = new ArrayList();

        public void addConfiguredPaths(Paths paths) {
            this.list.add(paths);
        }
    }

    public static class CoverageLevel
    extends Task {
        public String group;
        public String level;
        public String locales;
        public String draft;
        public String org;

        public void setDraft(String dft) {
            this.draft = dft;
        }

        public void setLevel(String lvl) {
            this.level = lvl;
        }

        public void setLocales(String locs) {
            this.locales = locs;
        }

        public void setOrg(String o) {
            this.org = o;
        }

        public void setGroup(String g) {
            this.group = g;
        }
    }

    public static class Paths
    extends Task {
        public String fallback;
        public String locales;
        public String draft;
        private Vector pathList = new Vector();

        public void addConfiguredInclude(Include inc) {
            this.pathList.add(inc);
        }

        public void addConfiguredExclude(Exclude ex) {
            this.pathList.add(ex);
        }

        public void setFallback(String fb) {
            this.fallback = fb;
        }

        public void setLocales(String locs) {
            this.locales = locs;
        }

        public void setDraft(String dft) {
            this.draft = dft;
        }

        public void addConfiguredCoverageLevel(CoverageLevel level) {
            if (level.group != null && level.org == null || level.org != null && level.group == null) {
                CLDRBuild.errln("Invalid specification of coverageLevel element. org && group not set!", true);
            }
            if (level.level == null) {
                CLDRBuild.errln("Invalid specification of coverageLevel element. level not set!", true);
            }
            this.pathList.add(level);
        }
    }

    public static class EmptyLocale
    extends Task {
        String locale;
        String list;

        public void setLocale(String loc) {
            this.locale = loc;
        }

        public void setList(String list) {
            this.list = list;
        }
    }

    public static class AliasLocale
    extends Task {
        String locale;

        public void setLocale(String loc) {
            this.locale = loc;
        }
    }

    public static class Alias
    extends Task {
        String from;
        String to;
        String xpath;

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setXpath(String xp) {
            this.xpath = xp;
        }
    }

    public static class Deprecates
    extends Task {
        protected ArrayList aliasLocaleList = null;
        protected ArrayList emptyLocaleList = null;
        protected TreeMap aliasMap = null;

        public void addConfiguredAlias(Alias alias) {
            if (this.aliasMap == null) {
                this.aliasMap = new TreeMap();
            }
            this.aliasMap.put(alias.from, new CLDRConverterTool.Alias(alias.to, alias.xpath));
        }

        public void addConfiguredEmptyLocale(EmptyLocale alias) {
            if (this.emptyLocaleList == null) {
                this.emptyLocaleList = new ArrayList();
            }
            this.emptyLocaleList.add(alias.locale);
        }

        public void addConfiguredAliasLocale(AliasLocale alias) {
            if (this.aliasLocaleList == null) {
                this.aliasLocaleList = new ArrayList();
            }
            this.aliasLocaleList.add(alias.locale);
        }
    }

    public static class Exclude
    extends Include {
    }

    public static class Include
    extends Task {
        public String draft;
        public String locales;
        public String xpath;
        public String preferAlt;

        public void setDraft(String ds) {
            this.draft = ds;
        }

        public void setLocales(String locs) {
            this.locales = locs;
        }

        public void setXpath(String xp) {
            this.xpath = xp;
        }

        public void setPreferAlt(String pa) {
            this.preferAlt = pa;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Include)) {
                return false;
            }
            Include other = (Include)((Object)o);
            if (o == this) {
                return true;
            }
            return this.locales.equals(other.locales) && (this.draft == other.draft || this.draft != null && other.draft != null && this.draft.equals(other.draft)) && (this.xpath == other.xpath || this.xpath != null && other.xpath != null && this.xpath.equals(other.xpath)) && (this.preferAlt == other.preferAlt || this.preferAlt != null && other.preferAlt != null && this.preferAlt.equals(other.preferAlt));
        }

        public int hashCode() {
            return this.locales.hashCode() + this.draft != null ? this.draft.hashCode() : (0 + this.xpath != null ? this.xpath.hashCode() : (0 + this.preferAlt != null ? this.preferAlt.hashCode() : 0));
        }
    }

    public static class Locales
    extends Task {
        private Vector localesList = new Vector();

        public void addConfiguredInclude(Include inc) {
            this.localesList.add(inc);
        }

        public void addConfiguredExclude(Exclude ex) {
            this.localesList.add(ex);
        }

        public Vector getList() {
            return this.localesList;
        }
    }

    public static class Config
    extends Task {
        protected Locales locales;
        protected Paths paths;
        private OverrideFallback ofb = null;
        private String type;

        public void addConfiguredLocales(Locales loc) {
            if (this.locales != null) {
                throw new BuildException("Multiple <locales> elements not supported");
            }
            this.locales = loc;
        }

        public void addConfiguredPaths(Paths ps) {
            if (this.paths != null) {
                throw new BuildException("Multiple <paths> elements not supported");
            }
            this.paths = ps;
        }

        public void addConfiguredOverrideFallback(OverrideFallback ofb) {
            if (this.ofb != null) {
                CLDRBuild.errln("Multiple <overrideFallback> elements not allowed!", true);
            }
            this.ofb = ofb;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Locales getLocales() {
            return this.locales;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class Arg
    extends Task {
        String name;
        String value = "";

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Args
    extends Task {
        Vector args = new Vector();

        public void addConfiguredArg(Arg arg) {
            this.args.add(arg);
        }

        public Hashtable getArgs(Hashtable hash) {
            if (this.args.size() == 0) {
                return hash;
            }
            Iterator iter = this.args.iterator();
            while (iter.hasNext()) {
                Arg arg = (Arg)((Object)iter.next());
                hash.put(arg.name, arg.value);
            }
            return hash;
        }
    }

    public static class Run
    extends Task {
        private String type;
        private Args args;
        private Config config;
        private Deprecates deprecates;

        public void setType(String type) {
            this.type = type;
        }

        public void addConfiguredArgs(Args args) {
            this.args = args;
        }

        public void addConfiguredConfig(Config conf) {
            this.config = conf;
        }

        public void addConfiguredDeprecates(Deprecates dep) {
            this.deprecates = dep;
        }

        public Hashtable getArgs(Hashtable hash) {
            if (hash == null) {
                hash = new Hashtable();
            }
            this.args.getArgs(hash);
            return hash;
        }

        public Config getConfig() {
            return this.config;
        }

        public String getType() {
            return this.type;
        }
    }

    public class Filter
    implements FileFilter {
        private String filePattern;

        public Filter(String fp) {
            this.filePattern = fp;
        }

        public Filter() {
        }

        public boolean accept(File pathname) {
            return this.filePattern != null && pathname.getName().matches(this.filePattern);
        }
    }
}

