/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.unicode.cldr.ant.CLDRBuild;
import org.unicode.cldr.test.CoverageLevel;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;
import org.w3c.dom.Node;

public abstract class CLDRConverterTool {
    protected ArrayList aliasLocaleList = null;
    protected ArrayList emptyLocaleList = null;
    protected TreeMap aliasMap = null;
    protected TreeMap localesMap = null;
    protected Vector pathList = null;
    protected List ofbList = null;
    private CoverageLevel coverageLevel = null;

    public abstract void processArgs(String[] var1);

    public void setAliasMap(TreeMap map) {
        this.aliasMap = map;
    }

    public void setAliasLocaleList(ArrayList list) {
        this.aliasLocaleList = list;
    }

    public void setEmptyLocaleList(ArrayList list) {
        this.emptyLocaleList = list;
    }

    public void setLocalesMap(TreeMap map) {
        this.localesMap = map;
    }

    public void setPathList(Vector list) {
        this.pathList = list;
    }

    public void setOverrideFallbackList(List list) {
        this.ofbList = list;
    }

    protected Node mergeOverrideFallbackNodes(Node main, String locale) {
        for (int i = 0; i < this.ofbList.size(); ++i) {
            CLDRBuild.Paths path = (CLDRBuild.Paths)((Object)this.ofbList.get(i));
            if (!CLDRBuild.matchesLocale(path.locales, locale)) continue;
        }
        return main;
    }

    private void initCoverageLevel(String localeName, boolean exemplarsContainA_Z, String supplementalDir) {
        if (this.coverageLevel == null) {
            CLDRFile sd = CLDRFile.make("supplementalData", supplementalDir, true);
            CLDRFile smd = CLDRFile.make("supplementalMetadata", supplementalDir, true);
            HashMap options = new HashMap();
            this.coverageLevel = new CoverageLevel();
            this.coverageLevel.init(sd, smd, options);
            ArrayList errors = new ArrayList();
            this.coverageLevel.setFile(localeName, exemplarsContainA_Z, null, null, errors);
        }
    }

    protected List computeConvertibleXPaths(List xpathList, boolean exemplarsContainA_Z, String localeName, String supplementalDir) {
        String draft = (String)this.localesMap.get(localeName + ".xml");
        XPathParts parts = new XPathParts(null, null);
        if (draft != null) {
            for (int i = 0; i < xpathList.size(); ++i) {
                Map attr = (parts = parts.set((String)xpathList.get(i))).getAttributes(parts.size() - 1);
                String draftVal = (String)attr.get("draft");
                if (draftVal == null || draftVal.matches(draft)) continue;
                xpathList.remove(i);
            }
        }
        if (this.pathList == null) {
            return xpathList;
        }
        ArrayList<String> myXPathList = new ArrayList<String>(xpathList.size());
        StandardCodes sc = StandardCodes.make();
        for (int i = 0; i < xpathList.size(); ++i) {
            String xpath = (String)xpathList.get(i);
            parts = parts.set(xpath);
            Map attr = parts.getAttributes(parts.size() - 1);
            boolean include = false;
            for (int j = 0; j < this.pathList.size(); ++j) {
                String altVal;
                String draftVal;
                Object obj = this.pathList.get(j);
                if (obj instanceof CLDRBuild.CoverageLevel) {
                    this.initCoverageLevel(localeName, exemplarsContainA_Z, supplementalDir);
                    CLDRBuild.CoverageLevel level = (CLDRBuild.CoverageLevel)((Object)obj);
                    if (level.locales != null && !CLDRBuild.matchesLocale(level.locales, localeName) || level.group != null && !sc.isLocaleInGroup(localeName, level.group, level.org)) continue;
                    CoverageLevel.Level cv = CoverageLevel.Level.get(level.level);
                    if (this.coverageLevel.getCoverageLevel(xpath).compareTo(cv) > 0) continue;
                    String draftVal2 = (String)attr.get("draft");
                    if (level.draft != null) {
                        if (draftVal2 == null && (level.draft.equals("false") || level.draft.equals(".*"))) {
                            include = true;
                            continue;
                        }
                        if (draftVal2 != null && draftVal2.matches(level.draft)) {
                            include = true;
                            continue;
                        }
                        include = false;
                        continue;
                    }
                    if (draftVal2 != null) continue;
                    include = true;
                    continue;
                }
                if (obj instanceof CLDRBuild.Exclude) {
                    CLDRBuild.Exclude exc = (CLDRBuild.Exclude)((Object)obj);
                    if (exc.locales != null && !CLDRBuild.matchesLocale(exc.locales, localeName) || exc.xpath == null || !xpath.matches(exc.xpath)) continue;
                    draftVal = (String)attr.get("draft");
                    altVal = (String)attr.get("alt");
                    boolean altExc = false;
                    boolean draftExc = false;
                    if (exc.preferAlt == null && altVal == null) {
                        altExc = true;
                    } else if (exc.preferAlt == null && altVal != null) {
                        altExc = true;
                    } else if (exc.preferAlt != null && altVal == null) {
                        altExc = false;
                    } else {
                        String nxp = (String)xpathList.get(i + 1);
                        XPathParts nparts = new XPathParts(null, null).set(nxp);
                        Map nattr = nparts.getAttributes(parts.size() - 1);
                        if (parts.isLike(nparts) && (altVal = (String)nattr.get("alt")).matches(exc.preferAlt)) {
                            draftVal = (String)nattr.get("draft");
                            xpath = nxp;
                            ++i;
                            altExc = true;
                        }
                    }
                    if (exc.draft == null && draftVal == null) {
                        draftExc = true;
                    } else if (exc.draft != null && draftVal == null) {
                        if (exc.draft.equals("false") || exc.draft.equals(".*")) {
                            draftExc = true;
                        }
                    } else if (exc.draft == null && draftVal != null) {
                        draftExc = false;
                    } else if (draftVal.matches(exc.draft)) {
                        draftExc = true;
                    }
                    if (!altExc || !draftExc) continue;
                    include = false;
                    continue;
                }
                if (obj instanceof CLDRBuild.Include) {
                    CLDRBuild.Include inc = (CLDRBuild.Include)((Object)obj);
                    if (inc.locales != null && !CLDRBuild.matchesLocale(inc.locales, localeName) || inc.xpath == null || !xpath.matches(inc.xpath)) continue;
                    draftVal = (String)attr.get("draft");
                    altVal = (String)attr.get("alt");
                    boolean altInc = false;
                    if (inc.preferAlt == null && altVal == null) {
                        altInc = true;
                    } else if (inc.preferAlt == null && altVal != null) {
                        altInc = false;
                    } else if (inc.preferAlt != null && altVal == null) {
                        String nxp = (String)xpathList.get(i + 1);
                        XPathParts nparts = new XPathParts(null, null).set(nxp);
                        Map nattr = nparts.getAttributes(parts.size() - 1);
                        if (parts.isLike(nparts) && (altVal = (String)nattr.get("alt")).matches(inc.preferAlt)) {
                            draftVal = (String)nattr.get("draft");
                            xpath = nxp;
                            ++i;
                            altInc = true;
                        }
                    } else if (altVal.matches(inc.preferAlt)) {
                        altInc = true;
                    }
                    boolean draftInc = false;
                    if (inc.draft == null && draftVal == null) {
                        draftInc = true;
                    } else if (inc.draft != null && draftVal == null) {
                        if (inc.draft.equals("false") || inc.draft.equals(".*")) {
                            draftInc = true;
                        }
                    } else if (inc.draft == null && draftVal != null) {
                        draftInc = false;
                    } else if (draftVal.matches(inc.draft)) {
                        draftInc = true;
                    }
                    if (!altInc || !draftInc) continue;
                    include = true;
                    continue;
                }
                System.err.println("ERROR: computeConvertibleXPath method cannot handle object of type: " + obj.getClass().toString());
            }
            if (!include) continue;
            myXPathList.add(xpath);
        }
        return myXPathList;
    }

    public static class Alias {
        public String to;
        public String xpath;

        public Alias(String to, String xpath) {
            this.to = to;
            this.xpath = xpath;
        }
    }
}

