/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.ant.CLDRConverterTool;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class ConvertTransforms
extends CLDRConverterTool {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int SKIP_COMMENTS = 5;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/transforms/"), UOption.DESTDIR().setDefault("../../dropbox/gen/icu-transforms/"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"commentSkip", (char)'c', (int)0)};
    static final String HELP_TEXT1 = "Use the following options\n-h or -?\t for this message\n-" + ConvertTransforms.options[2].shortName + "\t source directory. Default = -s" + Utility.getCanonicalName("../../common/main/") + "\n" + "\tExample:-sC:\\Unicode-CVS2\\cldr\\common\\gen\\source\\" + "\n" + "-" + ConvertTransforms.options[3].shortName + "\t destination directory. Default = -d" + Utility.getCanonicalName("../../dropbox/gen/main/") + "\n" + "-m<regex>\t to restrict the files to what matches <regex>" + "\n";
    private boolean skipComments;
    static Transliterator fixup = Transliterator.getInstance((String)"[:Mn:]any-hex/java");
    static XPathParts parts = new XPathParts();

    public static void main(String[] args) throws Exception {
        ConvertTransforms ct = new ConvertTransforms();
        ct.processArgs(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTransforms(String inputDirectory, String matchingPattern, String outputDirectory) throws IOException {
        System.out.println(new File(inputDirectory).getCanonicalPath());
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make(inputDirectory, matchingPattern);
        Set ids = cldrFactory.getAvailable();
        PrintWriter index = BagFormatter.openUTF8Writer((String)outputDirectory, (String)"root.txt");
        this.doHeader(index, "//", "root.txt");
        try {
            index.println("root {");
            index.println("    RuleBasedTransliteratorIDs {");
            this.addAlias(index, "Tone", "Digit", "", "Pinyin", "NumericPinyin", "");
            this.addAlias(index, "Digit", "Tone", "", "NumericPinyin", "Pinyin", "");
            Iterator idIterator = ids.iterator();
            while (idIterator.hasNext()) {
                String id = (String)idIterator.next();
                if (id.equals("All")) continue;
                try {
                    this.convertFile(cldrFactory, id, outputDirectory, index);
                }
                catch (IOException e) {
                    System.err.println("Failure in: " + id);
                    throw e;
                }
            }
            index.println("    }");
            index.println("    TransliteratorNamePattern {");
            index.println("        // Format for the display name of a Transliterator.");
            index.println("        // This is the language-neutral form of this resource.");
            index.println("        \"{0,choice,0#|1#{1}|2#{1}-{2}}\" // Display name");
            index.println("    }");
            index.println("    // Transliterator display names");
            index.println("    // This is the English form of this resource.");
            index.println("    \"%Translit%Hex\"         { \"%Translit%Hex\" }");
            index.println("    \"%Translit%UnicodeName\" { \"%Translit%UnicodeName\" }");
            index.println("    \"%Translit%UnicodeChar\" { \"%Translit%UnicodeChar\" }");
            index.println("    TransliterateLATIN{        ");
            index.println("    \"\",");
            index.println("    \"\"");
            index.println("    }");
            index.println("}");
        }
        finally {
            index.close();
        }
    }

    private void convertFile(CLDRFile.Factory cldrFactory, String id, String outputDirectory, PrintWriter index) throws IOException {
        PrintWriter output = null;
        String filename = null;
        CLDRFile cldrFile = cldrFactory.make(id, false);
        if (cldrFile.getDtdVersion().equals("1.4") && (id.indexOf("Ethiopic") >= 0 || id.indexOf("CanadianAboriginal") >= 0)) {
            System.out.println("WARNING: Skipping file for 1.4" + id);
            return;
        }
        boolean first = true;
        Iterator it = cldrFile.iterator("", CLDRFile.ldmlComparator);
        while (it.hasNext()) {
            String path = (String)it.next();
            String value = cldrFile.getStringValue(path);
            if (first) {
                filename = this.addIndexInfo(index, path, id);
                if (filename == null) {
                    return;
                }
                output = BagFormatter.openUTF8Writer((String)outputDirectory, (String)filename);
                this.doHeader(output, "#", filename);
                first = false;
            }
            if (path.indexOf("/comment") >= 0) {
                if (this.skipComments) continue;
                if (!value.trim().startsWith("#")) {
                    value = value + "# ";
                }
                output.println(value);
                continue;
            }
            if (path.indexOf("/tRule") >= 0) {
                value = value.replace('\u2192', '>');
                value = value.replace('\u2190', '<');
                value = value.replaceAll("\u2194", "<>");
                value = fixup.transliterate(value);
                output.println(value);
                continue;
            }
            throw new IllegalArgumentException("Unknown element: " + path + "\t " + value);
        }
        output.close();
    }

    private String replaceUnquoted(String value, String toReplace, String replacement) {
        int pos = 0;
        while ((pos = value.indexOf(toReplace, pos)) >= 0) {
            if (this.hasOddNumberOfQuotesBefore(value, pos)) {
                pos += toReplace.length();
            }
            value = value.substring(0, pos) + replacement + value.substring(pos + toReplace.length());
            pos += replacement.length();
        }
        return value;
    }

    private boolean hasOddNumberOfQuotesBefore(String value, int pos) {
        int pos2 = 0;
        int count = 0;
        while ((pos2 = value.indexOf(39, pos2 + 1)) >= 0) {
            ++count;
        }
        return (count & 1) != 0;
    }

    private String addIndexInfo(PrintWriter index, String path, String transID) {
        parts.set(path);
        Map attributes = parts.findAttributes("transform");
        if (attributes == null) {
            return null;
        }
        String source = (String)attributes.get("source");
        String target = (String)attributes.get("target");
        String variant = (String)attributes.get("variant");
        String direction = (String)attributes.get("direction");
        String visibility = (String)attributes.get("visibility");
        String status = "internal".equals(visibility) ? "internal" : "file";
        String id = source + "-" + target;
        String rid = target + "-" + source;
        String filename = source + "_" + target;
        if (variant != null) {
            id = id + "/" + variant;
            rid = rid + "/" + variant;
            filename = filename + "_" + variant;
        }
        filename = filename + ".txt";
        if (direction.equals("both") || direction.equals("forward")) {
            System.out.println("    " + id + "    " + filename + "    " + "FORWARD");
            index.println("        " + id + " {");
            index.println("            " + status + " {");
            index.println("                resource:process(transliterator) {\"" + filename + "\"}");
            index.println("                direction {\"FORWARD\"}");
            index.println("            }");
            index.println("        }");
        }
        if (direction.equals("both") || direction.equals("backward")) {
            System.out.println("    " + rid + "    " + filename + "    " + "REVERSE");
            index.println("        " + rid + " {");
            index.println("            " + status + " {");
            index.println("                resource:process(transliterator) {\"" + filename + "\"}");
            index.println("                direction {\"REVERSE\"}");
            index.println("            }");
            index.println("        }");
        }
        index.println();
        return filename;
    }

    void addAlias(PrintWriter index, String aliasSource, String aliasTarget, String aliasVariant, String originalSource, String originalTarget, String originalVariant) {
        this.addAlias(index, this.getName(aliasSource, aliasTarget, aliasVariant), this.getName(originalSource, originalTarget, originalVariant));
    }

    private void addAlias(PrintWriter index, String alias, String original) {
        index.println("        " + alias + " {");
        index.println("            alias {\"" + original + "\"}");
        index.println("        }");
    }

    String getName(String source, String target, String variant) {
        String id = source + "-" + target;
        if (variant != null && variant.length() != 0) {
            id = id + "/" + variant;
        }
        return id;
    }

    private void fixData(String inputDirectory, String matchingPattern, String outputDirectory) throws IOException {
        File dir = new File(inputDirectory);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String line;
            if (files[i].isDirectory()) continue;
            BufferedReader input = BagFormatter.openUTF8Reader((String)"", (String)files[i].getCanonicalPath());
            PrintWriter output = BagFormatter.openUTF8Writer((String)"", (String)(outputDirectory + files[i].getName()));
            while ((line = input.readLine()) != null) {
                if (line.indexOf("DOCTYPE") >= 0) {
                    line = line.replaceAll(" ldml ", " supplementalData ");
                }
                output.println(line);
            }
            input.close();
            output.close();
        }
    }

    private void doHeader(PrintWriter output, String quoteSymbol, String filename) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        output.print('\ufeff');
        output.println(quoteSymbol + " ***************************************************************************");
        output.println(quoteSymbol + " *");
        output.println(quoteSymbol + " *  Copyright (C) 2004-" + sdf.format(new Date()) + ", International Business Machines");
        output.println(quoteSymbol + " *  Corporation; Unicode, Inc.; and others.  All Rights Reserved.");
        output.println(quoteSymbol + " *");
        output.println(quoteSymbol + " ***************************************************************************");
        output.println(quoteSymbol + " File: " + filename);
        output.println(quoteSymbol + " Generated from CLDR: " + new Date());
        output.println(quoteSymbol + "");
    }

    public void processArgs(String[] args) {
        UOption.parseArgs((String[])args, (UOption[])options);
        if (ConvertTransforms.options[0].doesOccur || ConvertTransforms.options[1].doesOccur) {
            System.out.println(HELP_TEXT1);
            return;
        }
        String sourceDir = ConvertTransforms.options[2].value;
        String targetDir = ConvertTransforms.options[3].value;
        String match = ConvertTransforms.options[4].value;
        this.skipComments = ConvertTransforms.options[5].doesOccur;
        try {
            this.writeTransforms(sourceDir, match, targetDir + File.separator);
        }
        catch (IOException ex) {
            RuntimeException e = new RuntimeException();
            e.initCause(ex.getCause());
            throw e;
        }
        finally {
            System.out.println("DONE");
        }
    }
}

