/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Utility;

public class ExtractICUData {
    static Set skipLines = new HashSet<String>(Arrays.asList("#--------------------------------------------------------------------", "# Copyright (c) 1999-2005, International Business Machines", "# Copyright (c) 1999-2004, International Business Machines", "# Corporation and others. All Rights Reserved.", "#--------------------------------------------------------------------"));
    static Set skipFiles = new HashSet<String>(Arrays.asList("el", "en", "root"));
    static String fixLineRules = "'<>' > '\u2194';'<' > '\u2190';'>' > '\u2192';'&' > '\u00a7';('\\u00'[0-7][0-9A-Fa-f]) > $1;('\\u'[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]) > |@&hex-any/java($1);([[:whitespace:][:Default_Ignorable_Code_Point:][:C:]-[\\u0020\\u200E\\0009]]) > &any-hex/java($1);";
    static Transliterator fixLine = Transliterator.createFromRules((String)"foo", (String)fixLineRules, (int)0);
    private static final String INDEX = "index";
    private static final String RB_RULE_BASED_IDS = "RuleBasedTransliteratorIDs";
    static String idPattern = "\\s*(\\p{L}+)(?:[_-](\\p{L}+))?(?:\\[_/](\\p{L}+))?";
    static Matcher idMatcher = Pattern.compile(idPattern).matcher("");
    static Matcher instanceMatcher = Pattern.compile("\\s*(\\[.*\\]\\s*)?(.*)").matcher("");
    static Matcher privateFiles = Pattern.compile(".*(Spacedhan|InterIndic|ThaiLogical|ThaiSemi).*").matcher("");
    static Matcher allowNames = Pattern.compile("(Fullwidth|Halfwidth|NumericPinyin|Publishing)").matcher("");
    static Set collectedNames = new TreeSet();

    public static void main(String[] args) throws Exception {
        ExtractICUData.generateTransliterators();
        System.out.println("Done");
    }

    static void generateTransliterators() throws IOException {
        Matcher fileFilter = Pattern.compile(".*").matcher("");
        CLDRFile accumulatedItems = CLDRFile.makeSupplemental("allItems");
        ExtractICUData.getTranslitIndex(accumulatedItems);
        File translitSource = new File("C:\\cvsdata\\icu\\icu\\source\\data\\translit\\");
        System.out.println("Source: " + translitSource.getCanonicalPath());
        File[] fileArray = translitSource.listFiles();
        ArrayList<File> list = new ArrayList<File>(Arrays.asList(fileArray));
        List<String> extras = Arrays.asList("Arabic_Latin.txt", "CanadianAboriginal_Latin.txt", "Cyrillic_Latin.txt", "Georgian_Latin.txt", "Latin_Armenian.txt", "Latin_Ethiopic.txt", "Syriac_Latin.txt", "Thaana_Latin.txt");
        list.addAll(extras);
        String[] attributesOut = new String[1];
        for (int i = 0; i < list.size(); ++i) {
            String line;
            String coreName;
            String fileName;
            Object file = list.get(i);
            String string = fileName = file instanceof File ? ((File)file).getName() : (String)file;
            if (file instanceof File && extras.contains(fileName)) {
                System.out.println("Skipping old version: " + fileName);
            }
            if (!fileName.endsWith(".txt") || skipFiles.contains(coreName = fileName.substring(0, fileName.length() - 4))) continue;
            String id = ExtractICUData.fixTransID(coreName, attributesOut);
            String outName = id.replace('/', '-');
            String attributes = attributesOut[0];
            attributes = attributes + "[@direction=\"both\"]";
            System.out.println(coreName + "\t=>\t" + outName + " => " + attributes);
            if (!fileFilter.reset(fileName).matches()) continue;
            BufferedReader input = file instanceof File ? BagFormatter.openUTF8Reader((String)(((File)file).getParent() + File.separator), (String)fileName) : Utility.getUTF8Data(fileName);
            CLDRFile outFile = CLDRFile.makeSupplemental(fileName);
            int count = 0;
            String prefixBase = "//supplementalData[@version=\"1.4\"]/transforms/transform" + attributes;
            String rulePrefix = prefixBase + "/tRule[@_q=\"";
            String commentPrefix = prefixBase + "/comment[@_q=\"";
            StringBuffer accumulatedLines = new StringBuffer();
            while ((line = input.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if (skipLines.contains(line = line.trim()) || line.length() == 0) continue;
                String fixedLine = ExtractICUData.fixTransRule(line);
                accumulatedLines.append("\n\t\t");
                accumulatedLines.append(fixedLine);
                String prefix = line.startsWith("#") ? commentPrefix : rulePrefix;
                ExtractICUData.addInTwo(outFile, accumulatedItems, prefix + ++count + "\"]", fixedLine);
            }
            PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen//translit/gen/", (String)(outName + ".xml"));
            outFile.write(pw);
            pw.close();
        }
        PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen//translit/gen/", (String)"All.xml");
        accumulatedItems.write(pw);
        pw.close();
    }

    private static void addInTwo(CLDRFile outFile, CLDRFile accumulatedItems, String path, String value) {
        outFile.add(path, value);
        accumulatedItems.add(path, value);
    }

    private static String fixTransRule(String line) {
        String fixedLine = line;
        fixedLine = fixLine.transliterate(line);
        return fixedLine;
    }

    private static void getTranslitIndex(CLDRFile accumulatedItems) throws IOException {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((String)"com/ibm/icu/impl/data/icudt36b/translit", (String)INDEX);
        ICUResourceBundle transIDs = bundle.get(RB_RULE_BASED_IDS);
        String[] attributesOut = new String[1];
        int count = 0;
        int maxRows = transIDs.getSize();
        for (int row = 0; row < maxRows; ++row) {
            ICUResourceBundle colBund = transIDs.get(row);
            String ID = colBund.getKey();
            ICUResourceBundle res = colBund.get(0);
            String type = res.getKey();
            if (type.equals("file") || type.equals("internal")) continue;
            if (type.equals("alias")) {
                CLDRFile outFile = CLDRFile.makeSupplemental("transformAliases");
                ID = ExtractICUData.fixTransID(ID, attributesOut);
                String outName = ID.replace('/', '-');
                String attributes = attributesOut[0];
                attributes = attributes + "[@direction=\"forward\"]";
                System.out.println(ID + " => " + attributes);
                String prefix = "//supplementalData[@version=\"1.4\"]/transforms/transform" + attributes + "/tRule[@_q=\"";
                String resString = res.getString();
                if (!instanceMatcher.reset(resString).matches()) {
                    System.out.println("Doesn't match id: " + resString);
                } else {
                    String filter = instanceMatcher.group(1);
                    if (filter != null) {
                        filter = ExtractICUData.fixTransRule(filter);
                        outFile.add(prefix + ++count + "\"]", "::" + filter + ";");
                        accumulatedItems.add(prefix + ++count + "\"]", "::" + filter + ";");
                    }
                    String rest = instanceMatcher.group(2);
                    String[] pieces = rest.split(";");
                    for (int i = 0; i < pieces.length; ++i) {
                        String piece = pieces[i].trim();
                        if (piece.length() == 0) continue;
                        piece = ExtractICUData.fixTransID(piece, null);
                        outFile.add(prefix + ++count + "\"]", "::" + piece + ";");
                        accumulatedItems.add(prefix + ++count + "\"]", "::" + piece + ";");
                    }
                }
                PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen//translit/gen/", (String)(outName + ".xml"));
                outFile.write(pw);
                pw.close();
                continue;
            }
            throw new RuntimeException("Unknown type: " + type);
        }
    }

    private static String fixTransID(String id, String[] attributesOut) {
        if (!idMatcher.reset(id).matches()) {
            System.out.println("Doesn't match id:: " + id);
        } else {
            String source = ExtractICUData.fixTransIDPart(idMatcher.group(1));
            String target = ExtractICUData.fixTransIDPart(idMatcher.group(2));
            String variant = ExtractICUData.fixTransIDPart(idMatcher.group(3));
            if (attributesOut != null) {
                attributesOut[0] = "[@source=\"" + source + "\"]" + "[@target=\"" + target + "\"]" + (variant == null ? "" : "[@variant=\"" + variant + "\"]");
                if (privateFiles.reset(id).matches()) {
                    attributesOut[0] = attributesOut[0] + "[@visibility=\"internal\"]";
                }
            }
            target = target == null ? "" : "-" + target;
            variant = variant == null ? "" : "/" + variant;
            id = source + target + variant;
        }
        return id;
    }

    private static String fixTransIDPart(String name) {
        if (name == null) {
            return name;
        }
        int code = UScript.getCodeFromName((String)name);
        if (code < 0) {
            collectedNames.add(name);
        }
        if (name.equals("Tone")) {
            return "Pinyin";
        }
        if (name.equals("Digit")) {
            return "NumericPinyin";
        }
        if (name.equals("Jamo")) {
            return "ConjoiningJamo";
        }
        if (name.equals("LowerLatin")) {
            return "Latin";
        }
        return name;
    }

    static void testProps() {
        String propName;
        int[][] ranges = new int[][]{{0, 49}, {4096, 4117}, {12288, 12288}, {16384, 16397}};
        Collator col = Collator.getInstance((ULocale)ULocale.ROOT);
        ((RuleBasedCollator)col).setNumericCollation(true);
        TreeMap alpha = new TreeMap((Comparator<String>)col);
        for (int range = 0; range < ranges.length; ++range) {
            block9: for (int propIndex = ranges[range][0]; propIndex < ranges[range][1]; ++propIndex) {
                propName = UCharacter.getPropertyName((int)propIndex, (int)1);
                String shortPropName = UCharacter.getPropertyName((int)propIndex, (int)0);
                propName = ExtractICUData.getName(propIndex, propName, shortPropName);
                TreeSet<String> valueOrder = new TreeSet<String>((Comparator<String>)col);
                alpha.put(propName, valueOrder);
                switch (range) {
                    case 0: {
                        valueOrder.add("[binary]");
                        continue block9;
                    }
                    case 2: {
                        valueOrder.add("[double]");
                        continue block9;
                    }
                    case 3: {
                        valueOrder.add("[string]");
                        continue block9;
                    }
                    case 1: {
                        for (int valueIndex = 0; valueIndex < 256; ++valueIndex) {
                            try {
                                String valueName = UCharacter.getPropertyValueName((int)propIndex, (int)valueIndex, (int)1);
                                String shortValueName = UCharacter.getPropertyValueName((int)propIndex, (int)valueIndex, (int)0);
                                valueName = ExtractICUData.getName(valueIndex, valueName, shortValueName);
                                valueOrder.add(valueName);
                                continue;
                            }
                            catch (RuntimeException e) {
                                // empty catch block
                            }
                        }
                        continue block9;
                    }
                }
            }
        }
        PrintStream out = System.out;
        Iterator it = alpha.keySet().iterator();
        while (it.hasNext()) {
            propName = (String)it.next();
            Set values = (Set)alpha.get(propName);
            out.println("<tr><td>" + propName + "</td>");
            out.println("<td><table>");
            Iterator it2 = values.iterator();
            while (it2.hasNext()) {
                String propValue = (String)it2.next();
                System.out.println("<tr><td>" + propValue + "</td></tr>");
            }
            out.println("</table></td></tr>");
        }
    }

    private static String getName(int index, String valueName, String shortValueName) {
        if (valueName == null) {
            if (shortValueName == null) {
                return String.valueOf(index);
            }
            return shortValueName;
        }
        if (shortValueName == null) {
            return valueName;
        }
        if (valueName.equals(shortValueName)) {
            return valueName;
        }
        return valueName + "\u00a0(" + shortValueName + ")";
    }
}

