/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.icu.GenerateCldrTests;
import org.unicode.cldr.util.CachingEntityResolver;
import org.unicode.cldr.util.Utility;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class GenerateSidewaysView {
    static final boolean DEBUG = false;
    static final boolean DEBUG2 = false;
    static final boolean DEBUG_SHOW_ADD = false;
    static final boolean DEBUG_ELEMENT = false;
    static final boolean DEBUG_SHOW_BAT = false;
    static final boolean FIX_ZONE_ALIASES = true;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int SKIP = 5;
    private static final int TZADIR = 6;
    private static final int NONVALIDATING = 7;
    private static final int SHOW_DTD = 8;
    private static final int TRANSLIT = 9;
    private static final String NEWLINE = "\n";
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("C:\\ICU4C\\locale\\common\\main\\"), UOption.DESTDIR().setDefault("C:\\DATA\\GEN\\cldr\\main\\"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"skip", (char)'z', (int)1).setDefault("zh_(C|S|HK|M).*"), UOption.create((String)"tzadir", (char)'t', (int)1).setDefault("C:\\ICU4J\\icu4j\\src\\com\\ibm\\icu\\dev\\tool\\cldr\\"), UOption.create((String)"nonvalidating", (char)'n', (int)0), UOption.create((String)"dtd", (char)'w', (int)0), UOption.create((String)"transliterate", (char)'y', (int)0)};
    private static String timeZoneAliasDir = null;
    static Collator DEFAULT_COLLATION = null;
    static final Set IGNOREABLE = new HashSet<String>(Arrays.asList("draft"));
    static final Set IGNORELIST = new HashSet<String>(Arrays.asList("draft", "standard", "references", "validSubLocales"));
    static final Set LEAFNODES = new HashSet<String>(Arrays.asList("alias", "default", "firstDay", "mapping", "measurementSystem", "minDays", "orientation", "settings", "weekendStart", "weekendEnd"));
    static MapComparator elementOrdering = new MapComparator();
    static MapComparator attributeOrdering = new MapComparator();
    static MapComparator valueOrdering = new MapComparator();
    OrderedMap data;
    MyContentHandler DEFAULT_HANDLER;
    MyDeclHandler DEFAULT_DECLHANDLER;
    XMLReader xmlReader;
    static PrintWriter log;
    static Map cache;
    String filename;
    GenerateSidewaysView parent;
    Set zoneIDs;
    static TripleData tripleData;
    static SidewaysView sidewaysView;
    String finalComment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SAXException, IOException {
        UOption.parseArgs((String[])args, (UOption[])options);
        Matcher skipper = Pattern.compile(GenerateSidewaysView.options[5].value).matcher("");
        Matcher matcher = Pattern.compile(GenerateSidewaysView.options[4].value).matcher("");
        log = BagFormatter.openUTF8Writer((String)GenerateSidewaysView.options[3].value, (String)"log.txt");
        timeZoneAliasDir = GenerateSidewaysView.options[6].value;
        try {
            File sourceDir = new File(GenerateSidewaysView.options[2].value);
            String[] contents = sourceDir.list();
            for (int i = 0; i < contents.length; ++i) {
                if (!contents[i].endsWith(".xml") || contents[i].startsWith("supplementalData") || !matcher.reset(contents[i]).matches() || skipper.reset(contents[i]).matches()) continue;
                log.println();
                log.println("Processing " + contents[i]);
                String baseName = contents[i].substring(0, contents[i].length() - 4);
                GenerateSidewaysView temp = GenerateSidewaysView.getCLDR(baseName, !GenerateSidewaysView.options[7].doesOccur);
                if (GenerateSidewaysView.options[8].doesOccur) {
                    temp.writeDTDCheck();
                }
                temp.writeTo(GenerateSidewaysView.options[3].value, baseName);
                Utility.generateBat(GenerateSidewaysView.options[2].value, baseName + ".xml", GenerateSidewaysView.options[3].value, baseName + ".xml", null);
                sidewaysView.putData(temp.data, baseName);
                log.flush();
            }
            sidewaysView.showCacheData();
        }
        finally {
            log.close();
            System.out.println("Done");
        }
    }

    private void writeDTDCheck() {
        this.DEFAULT_DECLHANDLER.checkData();
    }

    static Collator getDefaultCollation() {
        if (DEFAULT_COLLATION != null) {
            return DEFAULT_COLLATION;
        }
        RuleBasedCollator temp = (RuleBasedCollator)Collator.getInstance((ULocale)ULocale.ENGLISH);
        temp.setStrength(15);
        temp.setNumericCollation(true);
        DEFAULT_COLLATION = temp;
        return temp;
    }

    private static String[] getCodes(ULocale locale, String tableName) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance((ULocale)locale);
        ICUResourceBundle table = bundle.getWithFallback(tableName);
        ArrayList stuff = new ArrayList();
        Enumeration keys = table.getKeys();
        while (keys.hasMoreElements()) {
            stuff.add(keys.nextElement());
        }
        String[] result = new String[stuff.size()];
        return stuff.toArray(result);
    }

    static GenerateSidewaysView getCLDR(String s, boolean validating) throws SAXException, IOException {
        GenerateSidewaysView temp = (GenerateSidewaysView)cache.get(s);
        if (temp == null) {
            temp = new GenerateSidewaysView(s, validating);
            cache.put(s, temp);
        }
        return temp;
    }

    private GenerateSidewaysView(String filename, boolean validating) throws SAXException, IOException {
        attributeOrdering.add((Comparable)((Object)"alt"));
        attributeOrdering.add((Comparable)((Object)"draft"));
        this.data = new OrderedMap();
        this.DEFAULT_HANDLER = new MyContentHandler();
        this.DEFAULT_DECLHANDLER = new MyDeclHandler();
        this.parent = null;
        this.zoneIDs = new HashSet();
        this.finalComment = null;
        this.filename = filename;
        this.xmlReader = this.createXMLReader(validating);
        String parentName = GenerateSidewaysView.getParentFilename(filename);
        if (parentName != null) {
            this.parent = GenerateSidewaysView.getCLDR(parentName, validating);
        }
        this.xmlReader.setContentHandler(this.DEFAULT_HANDLER);
        this.xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.DEFAULT_HANDLER);
        if (GenerateSidewaysView.options[8].doesOccur) {
            this.xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", this.DEFAULT_DECLHANDLER);
        }
        this.readFrom(GenerateSidewaysView.options[2].value, filename);
        if (this.parent != null) {
            EndNode value;
            Object key;
            Parent parentOut = new Parent();
            TreeMap<Object, GenerateSidewaysView> toRemove = new TreeMap<Object, GenerateSidewaysView>();
            Iterator it = this.data.iterator();
            while (it.hasNext()) {
                Object inheritedValue;
                key = it.next();
                if (((ElementChain)key).containsElement("identity") || !(value = (EndNode)this.data.get(key)).equals(inheritedValue = this.getInheritedValue(key, parentOut))) continue;
                toRemove.put(key, parentOut.parent);
            }
            it = toRemove.keySet().iterator();
            while (it.hasNext()) {
                key = (ElementChain)it.next();
                value = (EndNode)this.data.get(key);
                GenerateSidewaysView parent = (GenerateSidewaysView)toRemove.get(key);
                EndNode parentValue = (EndNode)parent.data.get(key);
                log.println("Removing " + ((ElementChain)key).toString(true, 0, Integer.MAX_VALUE) + "\t" + value);
                ElementChain parentKey = (ElementChain)parent.data.getKeyFor((ElementChain)key);
                log.println("\tIn " + parent.filename + ":\t" + parentKey.toString(true, 0, Integer.MAX_VALUE) + "\t" + parentValue);
                this.data.remove(key);
            }
        }
    }

    private Object getInheritedValue(Object key, Parent parentOut) {
        if (this.parent == null) {
            parentOut.parent = null;
            return null;
        }
        EndNode value = (EndNode)this.parent.data.get(key);
        if (value != null) {
            parentOut.parent = this.parent;
            return value;
        }
        return this.parent.getInheritedValue(key, parentOut);
    }

    private static String getParentFilename(String filename) {
        if (filename.equals("zh_TW")) {
            return "zh_Hant";
        }
        int pos = filename.lastIndexOf(95);
        if (pos >= 0) {
            return filename.substring(0, pos);
        }
        if (filename.equals("root")) {
            return null;
        }
        return "root";
    }

    private void writeTo(String dir, String filename) throws IOException {
        PrintWriter out = BagFormatter.openUTF8Writer((String)dir, (String)(filename + ".xml"));
        out.println(this);
        out.close();
    }

    public void readFrom(String dir, String filename) throws SAXException, IOException {
        File f = new File(dir + filename + ".xml");
        System.out.println("Parsing: " + f.getCanonicalPath());
        log.println("Parsing: " + f.getCanonicalPath());
        this.xmlReader.parse(new InputSource(new FileInputStream(f)));
    }

    private Set findDuplicateZoneIDs() {
        HashSet result = new HashSet();
        Iterator it = this.zoneIDs.iterator();
        while (it.hasNext()) {
            Object possibleOmission = it.next();
            String o = TimeZoneAliases.get(possibleOmission);
            if (o == null || !this.zoneIDs.contains(o)) continue;
            result.add(possibleOmission);
        }
        return result;
    }

    public String toString() {
        ElementChain empty;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE ldml SYSTEM \"http://www.unicode.org/cldr/dtd/1.2/beta/ldml.dtd\">\n");
        Set duplicateZoneIDs = this.findDuplicateZoneIDs();
        ElementChain old = empty = new ElementChain();
        Iterator it = this.data.iterator();
        while (it.hasNext()) {
            String zoneTypeValue;
            ElementChain key = (ElementChain)it.next();
            Element zoneElement = key.getElement("zone");
            if (zoneElement != null && (zoneTypeValue = zoneElement.getValue("type")) != null && duplicateZoneIDs.contains(zoneTypeValue)) continue;
            zoneElement = key.getElement("weekendEnd");
            if (zoneElement != null && "00:00".equals(zoneTypeValue = zoneElement.getValue("time"))) {
                log.println("BAD WEEKENDEND TIME: " + zoneTypeValue);
            }
            EndNode value = (EndNode)this.data.get(key);
            key.writeDifference(old, value, buffer);
            old = key;
        }
        empty.writeDifference(old, null, buffer);
        this.writeElementComment(buffer, this.finalComment, 0);
        return buffer.toString();
    }

    static boolean equalsIgnoringWhitespace(String a, String b) {
        int i = 0;
        int j = 0;
        while (true) {
            int d;
            int c;
            if (UCharacter.isUWhiteSpace((int)(c = i < a.length() ? (int)a.charAt(i++) : 65535))) {
                continue;
            }
            while (UCharacter.isUWhiteSpace((int)(d = j < b.length() ? (int)b.charAt(j++) : 65535))) {
            }
            if (c != d) {
                return false;
            }
            if (c == 65535) break;
        }
        return true;
    }

    private void writeElementComment(StringBuffer out, String comment, int common) {
        if (comment != null) {
            GenerateSidewaysView.indent(common, out);
            out.append("<!-- ");
            out.append(comment);
            if (comment.indexOf(10) >= 0) {
                out.append("\r\n");
                GenerateSidewaysView.indent(common, out);
            } else {
                out.append(" ");
            }
            out.append("-->\r\n");
        }
    }

    static int compareInt(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    static void indent(int count, StringBuffer out) {
        for (int i = 0; i < count; ++i) {
            out.append("\t");
        }
    }

    ElementChain putData(ElementChain stack, String associatedData) {
        EndNode alreadyThere;
        ElementChain result = new ElementChain(stack);
        EndNode value = new EndNode();
        value.string = associatedData;
        Element lastElement = result.getLast();
        if (LEAFNODES.contains(lastElement.elementName)) {
            if (associatedData.length() != 0) {
                System.err.println("Leaf Node must be empty: " + lastElement + "\tData: " + associatedData);
            }
            value.attributes = lastElement.attributes;
            lastElement.attributes = new SimpleAttributes();
            value.string = null;
        }
        if ((alreadyThere = (EndNode)this.data.get(result)) != null) {
            System.err.println("Overriding: " + result + "\tOld Value: " + alreadyThere + ",\t New Value: " + value);
        }
        this.data.put(result, value);
        return result;
    }

    XMLReader createXMLReader(boolean validating) {
        XMLReader result = null;
        try {
            result = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            result.setFeature("http://xml.org/sax/features/validation", validating);
        }
        catch (SAXException e1) {
            try {
                result = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                result.setFeature("http://xml.org/sax/features/validation", validating);
            }
            catch (SAXException e2) {
                try {
                    result = XMLReaderFactory.createXMLReader("gnu.xml.aelfred2.XmlReader");
                    result.setFeature("http://xml.org/sax/features/validation", validating);
                }
                catch (SAXException e3) {
                    try {
                        result = XMLReaderFactory.createXMLReader("com.bluecast.xml.Piccolo");
                        result.setFeature("http://xml.org/sax/features/validation", validating);
                    }
                    catch (SAXException e4) {
                        try {
                            result = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                            result.setFeature("http://xml.org/sax/features/validation", validating);
                        }
                        catch (SAXException e5) {
                            try {
                                result = XMLReaderFactory.createXMLReader();
                                result.setFeature("http://xml.org/sax/features/validation", validating);
                            }
                            catch (SAXException e6) {
                                throw new NoClassDefFoundError("No SAX parser is available, or unable to set validation correctly");
                            }
                        }
                    }
                }
            }
        }
        try {
            result.setEntityResolver(new CachingEntityResolver());
        }
        catch (Throwable e) {
            System.out.println("WARNING: Can't set caching entity resolver  -  error " + e.toString());
            e.printStackTrace();
        }
        return result;
    }

    private static void writeFooterAndClose(PrintWriter out) {
        out.println("Generated " + Calendar.getInstance().getTime());
        out.println("</body></html>");
        out.close();
    }

    static {
        cache = new HashMap();
        tripleData = new TripleData();
        sidewaysView = new SidewaysView();
    }

    class MyContentHandler
    implements ContentHandler,
    LexicalHandler {
        ElementChain contextStack;
        String lastChars;
        boolean justPopped;
        int commentStack;

        MyContentHandler() {
            this.contextStack = new ElementChain();
            this.lastChars = "";
            this.justPopped = false;
            this.commentStack = 0;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                this.contextStack.push(qName, attributes, GenerateSidewaysView.this.finalComment);
                GenerateSidewaysView.this.finalComment = null;
                this.justPopped = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (this.lastChars.length() != 0 || !this.justPopped) {
                    GenerateSidewaysView.this.putData(this.contextStack, this.lastChars);
                    this.lastChars = "";
                }
                this.contextStack.pop(qName);
                this.justPopped = true;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                String value = new String(ch, start, length);
                this.lastChars = this.lastChars + value;
                this.justPopped = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.commentStack = 0;
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            ++this.commentStack;
        }

        public void endDTD() throws SAXException {
            --this.commentStack;
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.commentStack != 0) {
                return;
            }
            String comment = new String(ch, start, length).trim();
            GenerateSidewaysView.this.finalComment = GenerateSidewaysView.this.finalComment == null ? comment : GenerateSidewaysView.this.finalComment + GenerateSidewaysView.NEWLINE + comment;
        }
    }

    class MyDeclHandler
    implements DeclHandler {
        Map element_childComparator = new TreeMap();
        boolean showReason = false;
        Set SKIP_LIST = new HashSet<String>(Arrays.asList("collation", "base", "settings", "suppress_contractions", "optimize", "rules", "reset", "context", "p", "pc", "s", "sc", "t", "tc", "q", "qc", "i", "ic", "extend", "x"));
        Object DONE = new Object();

        MyDeclHandler() {
        }

        public void checkData() {
            block5: {
                this.showReason = false;
                ArrayList<Object> orderingList = new ArrayList<Object>();
                while (true) {
                    Object first;
                    if ((first = this.getFirst(orderingList)) == this.DONE) {
                        log.println("Successful Ordering");
                        int count = 0;
                        Iterator it = orderingList.iterator();
                        while (it.hasNext()) {
                            log.println(++count + it.next().toString());
                        }
                        break block5;
                    }
                    if (first == null) break;
                    orderingList.add(first);
                }
                this.showReason = true;
                this.getFirst(orderingList);
                log.println();
                log.println("Failed ordering. So far:");
                Iterator<Object> it = orderingList.iterator();
                while (it.hasNext()) {
                    log.print("\t" + it.next());
                }
                log.println();
                log.println("Items:");
                it = this.element_childComparator.keySet().iterator();
                while (it.hasNext()) {
                    this.showRow(it.next(), true);
                }
                log.println();
            }
        }

        private void showRow(Object parent, boolean skipEmpty) {
            List items = (List)this.element_childComparator.get(parent);
            if (skipEmpty && items.size() == 0) {
                return;
            }
            log.print(parent);
            Iterator it2 = items.iterator();
            while (it2.hasNext()) {
                log.print("\t" + it2.next());
            }
            log.println();
        }

        private Object getFirst(List orderingList) {
            Set keys = this.element_childComparator.keySet();
            HashSet failures = new HashSet();
            boolean allZero = true;
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                List list = (List)this.element_childComparator.get(it.next());
                if (list.size() == 0) continue;
                allZero = false;
                Object possibleFirst = list.get(0);
                if (!failures.contains(possibleFirst) && this.isAlwaysFirst(possibleFirst)) {
                    this.removeEverywhere(possibleFirst);
                    return possibleFirst;
                }
                failures.add(possibleFirst);
            }
            if (allZero) {
                return this.DONE;
            }
            return null;
        }

        private void removeEverywhere(Object possibleFirst) {
            Iterator it2 = this.element_childComparator.keySet().iterator();
            while (it2.hasNext()) {
                List list2 = (List)this.element_childComparator.get(it2.next());
                list2.remove(possibleFirst);
            }
        }

        private boolean isAlwaysFirst(Object possibleFirst) {
            if (this.showReason) {
                log.println("Trying: " + possibleFirst);
            }
            Iterator it2 = this.element_childComparator.keySet().iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                List list2 = (List)this.element_childComparator.get(key);
                int pos = list2.indexOf(possibleFirst);
                if (pos <= 0) continue;
                if (this.showReason) {
                    log.print("Failed at:\t");
                    this.showRow(key, false);
                }
                return false;
            }
            return true;
        }

        public void elementDecl(String name, String model) throws SAXException {
            if (this.SKIP_LIST.contains(name)) {
                return;
            }
            String[] list = model.split("[^A-Z0-9a-z]");
            ArrayList<String> mc = new ArrayList<String>();
            if (name.equals("currency")) {
                mc.add("alias");
                mc.add("symbol");
                mc.add("pattern");
            }
            for (int i = 0; i < list.length; ++i) {
                if (list[i].length() == 0) continue;
                if (mc.contains(list[i])) {
                    log.println("Duplicate attribute " + name + ", " + list[i]);
                    continue;
                }
                mc.add(list[i]);
            }
            this.element_childComparator.put(name, mc);
        }

        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }
    }

    static class SidewaysView {
        EndNodeComparator enc = new EndNodeComparator();
        Map contextCache = new TreeMap();
        Set fileNames = new TreeSet();
        Set allTypes = new TreeSet();

        SidewaysView() {
        }

        void putData(OrderedMap data, String filename) {
            Iterator it = data.iterator();
            while (it.hasNext()) {
                TreeSet<String> files;
                ElementChain original = (ElementChain)it.next();
                ElementChain copy = original.createRemovingAttributes(IGNORELIST);
                EndNode endNode = (EndNode)data.get(copy);
                TreeMap<EndNode, TreeSet<String>> dataToFile = (TreeMap<EndNode, TreeSet<String>>)this.contextCache.get(copy);
                if (dataToFile == null) {
                    dataToFile = new TreeMap<EndNode, TreeSet<String>>(this.enc);
                    this.contextCache.put(copy, dataToFile);
                }
                if ((files = (TreeSet<String>)dataToFile.get(endNode)) == null) {
                    files = new TreeSet<String>();
                    dataToFile.put(endNode, files);
                }
                files.add(filename);
            }
            if (filename.indexOf(95) < 0 || filename.equals("zh_Hant")) {
                this.fileNames.add(filename);
            }
        }

        int getChainDepth(ElementChain ec) {
            Element e = (Element)ec.contexts.get(1);
            String result = e.elementName;
            if (result.equals("numbers") || result.equals("localeDisplayNames") || result.equals("dates")) {
                return 3;
            }
            return 2;
        }

        String getChainName(ElementChain ec, int limit) {
            Element e = (Element)ec.contexts.get(1);
            String result = e.elementName;
            for (int i = 2; i < limit; ++i) {
                e = (Element)ec.contexts.get(i);
                result = result + "_" + e.elementName;
            }
            return result;
        }

        void showCacheData() throws IOException {
            UnicodeSet untransliteratedCharacters = new UnicodeSet();
            TreeSet<String> translitErrors = new TreeSet<String>();
            GenerateCldrTests.DraftChecker dc = new GenerateCldrTests.DraftChecker(options[2].value);
            dc.isDraft("en");
            this.writeStyleSheet();
            PrintWriter out = null;
            String lastChainName = "";
            int lineCounter = 1;
            Iterator<Object> it = this.contextCache.keySet().iterator();
            while (it.hasNext()) {
                Object data;
                int limit;
                ElementChain stack = (ElementChain)it.next();
                String chainName = this.getChainName(stack, limit = this.getChainDepth(stack));
                if (!chainName.equals(lastChainName)) {
                    if (out != null) {
                        out.println("</table>");
                        GenerateSidewaysView.writeFooterAndClose(out);
                    }
                    this.allTypes.add(chainName);
                    out = this.openAndDoHeader(chainName);
                    lastChainName = chainName;
                    lineCounter = 0;
                }
                String key = stack.toString(true, limit, Integer.MAX_VALUE);
                out.println("<tr><td colspan='2' class='head'><a href='#" + ++lineCounter + "' name='" + lineCounter + "'>" + lineCounter + "</a>&nbsp;" + TransliteratorUtilities.toHTML.transliterate(key) + "</td></tr>");
                Map dataToFile = (Map)this.contextCache.get(stack);
                TreeSet remainingFiles = new TreeSet(this.fileNames);
                Iterator it2 = dataToFile.keySet().iterator();
                while (it2.hasNext()) {
                    data = it2.next();
                    remainingFiles.removeAll((Set)dataToFile.get(data));
                }
                if (!remainingFiles.contains("zh")) {
                    remainingFiles.remove("zh_Hant");
                }
                it2 = dataToFile.keySet().iterator();
                while (it2.hasNext()) {
                    data = (EndNode)it2.next();
                    String dataStyle = "";
                    Set files = (Set)dataToFile.get(data);
                    if (files.contains("root")) {
                        files.addAll(remainingFiles);
                        dataStyle = " class='nodata'";
                    }
                    String extra = "";
                    if (((EndNode)data).string != null && options[9].doesOccur && GenerateCldrTests.NON_LATIN.containsSome(((EndNode)data).string)) {
                        try {
                            extra = GenerateCldrTests.toLatin.transliterate(((EndNode)data).string);
                            untransliteratedCharacters.addAll(extra);
                            extra = extra.equals(((EndNode)data).string) ? "" : "<br>(\"" + TransliteratorUtilities.toHTML.transliterate(extra) + "\")";
                        }
                        catch (RuntimeException e) {
                            translitErrors.add(e.getMessage());
                        }
                    }
                    out.print("<tr><th" + dataStyle + (lineCounter == 1 ? " width='20%'" : "") + ">\"" + data + "\"" + extra + "</th><td>");
                    boolean first = true;
                    Iterator it3 = files.iterator();
                    while (it3.hasNext()) {
                        boolean emphasize;
                        if (first) {
                            first = false;
                        } else {
                            out.print(" ");
                        }
                        String localeID = (String)it3.next();
                        boolean bl = emphasize = localeID.equals("root") || localeID.indexOf(95) >= 0;
                        if (dc.isDraft(localeID)) {
                            out.print("<i>");
                        }
                        if (emphasize) {
                            out.print("<b>");
                        }
                        out.print("\u00b7" + localeID + "\u00b7");
                        if (emphasize) {
                            out.print("</b>");
                        }
                        if (!dc.isDraft(localeID)) continue;
                        out.print("</i>");
                    }
                    out.println("</td></tr>");
                }
            }
            if (out == null) {
                System.err.println("Out = null?");
            } else {
                out.println("</table>");
                GenerateSidewaysView.writeFooterAndClose(out);
                out.close();
            }
            this.writeIndex();
            tripleData.writeData();
            untransliteratedCharacters.retainAll(GenerateCldrTests.NON_LATIN);
            log.println("Untranslated Characters*: " + untransliteratedCharacters.toPattern(false));
            log.println("Untranslated Characters* (hex): " + untransliteratedCharacters.toPattern(true));
            untransliteratedCharacters.closeOver(2);
            log.println("Untranslated Characters: " + untransliteratedCharacters.toPattern(false));
            log.println("Untranslated Characters (hex): " + untransliteratedCharacters.toPattern(true));
            it = translitErrors.iterator();
            while (it.hasNext()) {
                log.println(it.next());
            }
        }

        private PrintWriter openAndDoHeader(String type) throws IOException {
            String fileName = type + ".html";
            PrintWriter out = BagFormatter.openUTF8Writer((String)options[3].value, (String)("by_type" + File.separator + fileName));
            out.println("<html><head>");
            out.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
            out.println("<title>Comparison By Type: " + TransliteratorUtilities.toHTML.transliterate(type) + "</title>");
            out.println("<link rel='stylesheet' type='text/css' href='http://oss.software.ibm.com/cvs/icu/~checkout~/icuhtml/common.css'>");
            out.println("<link rel='stylesheet' type='text/css' href='by_type.css'>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h2>By-Type Chart for //ldml/" + type.replace('_', '/') + "/...</h1>");
            out.println("<p><a href=\"index.html\">By-Type Chart Index</a> | <a href='http://www.jtcsv.com/cgibin/cldrwiki.pl?InterimVettingCharts'>Interim Vetting Charts</a>| <a href='http://oss.software.ibm.com/cvs/icu/~checkout~/locale/docs/tr35.html'>LDML Specification</a>| <a href='http://www.unicode.org/cldr/filing_bug_reports.html'>Filing Bug Reports</a>| <a href='http://oss.software.ibm.com/cvs/icu/~checkout~/locale/comparison_charts.html'>Cross Platform Charts</a></p>");
            out.println("<p>This chart shows values across locales for different fields. Each value is listed under the field designator (in XML XPath format), followed by all the locales that use it. Locales are omitted if the value would be the same as the parent's. The locales are listed in the format: \u00b7aa\u00b7 for searching. The value appears in red if it is the same as the root. Draft locales are italic-gray; territory locales are bold.</p>");
            out.println("<table>");
            return out;
        }

        private void writeStyleSheet() throws IOException {
            PrintWriter out = BagFormatter.openUTF8Writer((String)options[3].value, (String)("by_type" + File.separator + "by_type.css"));
            out.println(".head { font-weight:bold; background-color:#DDDDFF }");
            out.println("td, th { border: 1px solid #0000FF; text-align }");
            out.println("th { width:10% }");
            out.println("i { color: gray }");
            out.println(".nodata { background-color:#FF0000 }");
            out.println("table {margin-top: 1em}");
            out.close();
        }

        private void writeIndex() throws IOException {
            String fileName = "index.html";
            PrintWriter out = BagFormatter.openUTF8Writer((String)options[3].value, (String)("by_type" + File.separator + fileName));
            out.println("<html><head>");
            out.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
            out.println("<title>Comparison By Type: index</title>");
            out.println("<link rel='stylesheet' type='text/css' href='http://oss.software.ibm.com/cvs/icu/~checkout~/icuhtml/common.css'>");
            out.println("<link rel='stylesheet' type='text/css' href='by_type.css'>");
            out.println("</head>");
            out.println("<body><h1>By Type Chart Index</h1>");
            out.println("<p>The following are charts for the individual datatypes, that show a comparison across locales for different fields. For example, in the orientation chart, one can see that all locales are left-to-right except \u00b7ar\u00b7 \u00b7fa\u00b7 \u00b7he\u00b7 \u00b7ps\u00b7 (and their children).</p><p>Note: these charts do not yet include collations</p>");
            out.println("<ul>");
            Iterator e = this.allTypes.iterator();
            while (e.hasNext()) {
                String f = (String)e.next();
                out.println(" <li><a href=\"" + f + ".html" + "\">" + f + "</a>");
            }
            out.println("</ul>");
            out.println("<a href='http://www.jtcsv.com/cgibin/cldrwiki.pl?ByType'>About this chart</a> <br/>");
            GenerateSidewaysView.writeFooterAndClose(out);
        }
    }

    static class EndNodeComparator
    implements Comparator {
        EndNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            EndNode these = (EndNode)o1;
            EndNode that = (EndNode)o2;
            if (these.string != null) {
                if (that.string != null) {
                    return GenerateSidewaysView.getDefaultCollation().compare(these.string, that.string);
                }
                return -1;
            }
            if (that.attributes != null) {
                return these.attributes.compareTo(that.attributes);
            }
            return 1;
        }
    }

    static class EndNode {
        String string;
        SimpleAttributes attributes;

        EndNode() {
        }

        public void set(Object associatedData) {
            if (associatedData instanceof String) {
                this.string = (String)associatedData;
                this.attributes = null;
            } else {
                this.attributes = (SimpleAttributes)associatedData;
                this.string = null;
            }
        }

        public String toString() {
            return this.toString(-1);
        }

        public String toString(int type) {
            if (this.string != null) {
                return TransliteratorUtilities.toHTML.transliterate(this.string);
            }
            return this.attributes.toString();
        }
    }

    public static class OrderedMap {
        private Map map = new TreeMap();
        private List list = new ArrayList();

        public void put(Object a, Object b) {
            this.map.put(a, b);
            this.list.add(a);
        }

        public Object getKeyFor(ElementChain key) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get(i).equals(key)) continue;
                return key;
            }
            return null;
        }

        public void remove(Object object) {
            this.map.remove(object);
            this.list.remove(object);
        }

        public Object get(Object a) {
            return this.map.get(a);
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public int size() {
            return this.list.size();
        }

        public Object get(int index) {
            return this.list.get(index);
        }
    }

    public static class MapComparator {
        Map ordering = new TreeMap();
        List rankToName = new ArrayList();

        MapComparator() {
        }

        MapComparator(Comparable[] data) {
            for (int i = 0; i < data.length; ++i) {
                this.add(data[i]);
            }
        }

        public void add(Comparable newObject) {
            Object already = this.ordering.get(newObject);
            if (already == null) {
                this.ordering.put(newObject, new Integer(this.rankToName.size()));
                this.rankToName.add(newObject);
            }
        }

        public int compare(Comparable a, Comparable b) {
            Comparable aa = (Comparable)this.ordering.get(a);
            Object bb = this.ordering.get(b);
            if (aa == null || bb == null) {
                return a.compareTo(b);
            }
            return aa.compareTo(bb);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Iterator it = this.rankToName.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                buffer.append("\"").append(key).append("\",\n");
            }
            return buffer.toString();
        }
    }

    class ElementChain
    implements Comparable {
        List contexts;

        ElementChain() {
            this.contexts = new ArrayList();
        }

        public Element getElement(String string) {
            for (int i = 0; i < this.contexts.size(); ++i) {
                Element x = (Element)this.contexts.get(i);
                if (!string.equals(x.elementName)) continue;
                return x;
            }
            return null;
        }

        public void setAttribute(String element, String attribute, String value) {
            for (int i = 0; i < this.contexts.size(); ++i) {
                Element context = (Element)this.contexts.get(i);
                if (!context.elementName.equals(element)) continue;
                context = new Element(context);
                context.attributes.set(element, attribute, value);
                this.contexts.set(i, context);
                break;
            }
        }

        ElementChain(ElementChain other) {
            this.contexts = new ArrayList(other.contexts);
        }

        public ElementChain push(String elementName, Attributes attributes, String comment) {
            elementOrdering.add((Comparable)((Object)elementName));
            this.contexts.add(new Element(elementName, attributes, comment));
            return this;
        }

        public void pop(String elementName) {
            int last = this.contexts.size() - 1;
            Element c = (Element)this.contexts.get(last);
            if (!c.elementName.equals(elementName)) {
                throw new IllegalArgumentException("mismatch");
            }
            this.contexts.remove(last);
        }

        public String toString() {
            return this.toString(true, 0, Integer.MAX_VALUE);
        }

        public String toString(boolean path, int startLevel, int limitLevel) {
            StringBuffer buffer = new StringBuffer();
            if (startLevel < 0) {
                startLevel = 0;
            }
            if (limitLevel > this.contexts.size()) {
                limitLevel = this.contexts.size();
            }
            for (int i = startLevel; i < limitLevel; ++i) {
                Element e = (Element)this.contexts.get(i);
                if (path) {
                    buffer.append("/" + e.toString(-1));
                    continue;
                }
                buffer.append(e.toString(1));
            }
            return buffer.toString();
        }

        public boolean equals(Object other) {
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return ((Object)this.contexts).hashCode();
        }

        public int compareTo(Object o) {
            ElementChain that = (ElementChain)o;
            int minLen = Math.min(this.contexts.size(), that.contexts.size());
            for (int i = 0; i < minLen; ++i) {
                int result = ((Element)this.contexts.get(i)).compareTo(that.contexts.get(i));
                if (result == 0) continue;
                return result;
            }
            return GenerateSidewaysView.compareInt(this.contexts.size(), that.contexts.size());
        }

        public void writeDifference(ElementChain former, EndNode value, StringBuffer out) {
            int result;
            int common;
            int csize = this.contexts.size();
            int fsize = former.contexts.size();
            int minLen = Math.min(csize, fsize);
            for (common = 0; common < minLen && (result = ((Element)this.contexts.get(common)).compareTo(former.contexts.get(common))) == 0; ++common) {
            }
            for (int j = fsize - 2; j >= common; --j) {
                GenerateSidewaysView.indent(j, out);
                out.append(((Element)former.contexts.get(j)).toString(2));
                out.append(GenerateSidewaysView.NEWLINE);
            }
            if (csize == 0) {
                return;
            }
            while (common < csize - 1) {
                Element ee = (Element)this.contexts.get(common);
                GenerateSidewaysView.this.writeElementComment(out, ee.comment, common);
                GenerateSidewaysView.indent(common, out);
                out.append(ee.toString(1));
                out.append(GenerateSidewaysView.NEWLINE);
                ++common;
            }
            Element ee = (Element)this.contexts.get(csize - 1);
            GenerateSidewaysView.this.writeElementComment(out, ee.comment, common);
            GenerateSidewaysView.indent(common, out);
            if (value == null || "".equals(value.string)) {
                out.append(ee.toString(0));
            } else if (value.string == null) {
                Element temp = new Element(ee);
                temp.attributes.add(value.attributes);
                out.append(temp.toString(0));
            } else {
                out.append(ee.toString(1));
                out.append(value.toString(0));
                out.append(ee.toString(2));
            }
            out.append(GenerateSidewaysView.NEWLINE);
        }

        public boolean containsElement(String string) {
            return this.getElement(string) != null;
        }

        public Element getLast() {
            return (Element)this.contexts.get(this.contexts.size() - 1);
        }

        public ElementChain createRemovingAttributes(Set ignorelist) {
            ElementChain result = new ElementChain(this);
            for (int i = 0; i < this.contexts.size(); ++i) {
                Element e = (Element)this.contexts.get(i);
                e.removeAttributes(ignorelist);
            }
            return result;
        }
    }

    class Element
    implements Comparable {
        String elementName;
        SimpleAttributes attributes;
        String comment;
        static final int PATH = -1;
        static final int NO_VALUE = 0;
        static final int START_VALUE = 1;
        static final int END_VALUE = 2;

        Element(String elementName, Attributes attributes, String comment) {
            this.elementName = elementName;
            this.attributes = new SimpleAttributes(attributes, elementName);
            this.comment = comment;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.set(this.elementName, attribute, value);
        }

        public String getValue(String attributeName) {
            return this.attributes.getValue(attributeName);
        }

        Element(Element other) {
            this.elementName = other.elementName;
            this.attributes = new SimpleAttributes(other.attributes, this.elementName);
            this.comment = other.comment;
        }

        public String toString() {
            return this.toString(-1);
        }

        public String toString(int type) {
            String a = this.attributes.toString(type == -1, this.elementName.equals("zone"));
            String result = type == -1 ? this.elementName + a : (type == 0 ? "<" + this.elementName + a + "/>" : (type == 2 ? "</" + this.elementName + ">" : "<" + this.elementName + a + ">"));
            return result;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            Element that = (Element)o;
            int result = elementOrdering.compare((Comparable)((Object)this.elementName), (Comparable)((Object)that.elementName));
            if (result != 0) {
                return result;
            }
            return this.attributes.compareTo(that.attributes);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Element)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public void removeAttributes(Set ignorelist) {
            this.attributes.removeAttributes(ignorelist);
        }
    }

    static class TripleData {
        Map elementToAttributeToValues = new TreeMap(GenerateSidewaysView.getDefaultCollation());
        Map bigguys = null;
        static final String ANYSTRING = "[any]";
        Object[][] fixList = new Object[][]{{"alias", "path", "<valid XPath within locale tree>"}, {"alias", "source", "<valid locale ID>"}, {"day", "type", new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"}}, {"era", "type", "<non-negative number>"}, {"*", "day", new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"}}, {"generation", "date", "<yyyy-MM-dd format>"}, {"version", "number", "<n.m format>"}, {"*", "time", "<HH:mm (00:00..24:00)>"}, {"orientation", "*", new String[]{"left-to-right", "right-to-left", "top-to-bottom", "bottom-to-top"}}, {"minDays", "count", new String[]{"1", "2", "3", "4", "5", "6", "7"}}, {"language", "type", "%%%language"}, {"script", "type", "%%%script"}, {"territory", "type", "%%%region"}, {"variant", "type", "%%%variant"}, {"zone", "type", "%%%tzid"}, {"currency", "type", "%%%currency"}, {"calendar", "type", new String[]{"buddhist", "chinese", "gregorian", "hebrew", "islamic", "islamic-civil", "japanese", "arabic[alias]", "civil-arabic[alias]", "thai-buddhist[alias]"}}, {"measurementSystem", "type", new String[]{"metric", "US", "UK"}}, {"type", "type", "<any type value--with appropriate key>"}, {"type", "key", "<any element name having 'type' attribute>"}, {"key", "type", "<any element name having 'type' attribute>"}, {"[any]", "draft", new String[]{"true", "approved", "provisional", "unconfirmed", "false*"}}, {"[any]", "alt", new String[]{"proposed", "variant"}}, {"[any]", "references", "<list of references>"}, {"[any]", "standard", "<list of standards>"}, {"[any]", "validSubLocales", "<list of sub-locales>"}, {"collation", "type", new String[]{"phonebook", "traditional", "direct", "pinyin", "stroke", "posix", "big5han", "gb2312han"}}, {"settings", "strength", new String[]{"primary", "secondary", "tertiary", "quaternary", "identical"}}, {"settings", "alternate", new String[]{"non-ignorable", "shifted"}}, {"settings", "backwards", new String[]{"on", "off"}}, {"settings", "normalization", new String[]{"on", "off"}}, {"settings", "caseLevel", new String[]{"on", "off"}}, {"settings", "caseFirst", new String[]{"upper", "lower", "off"}}, {"settings", "hiraganaQuarternary", new String[]{"on", "off"}}, {"settings", "numeric", new String[]{"on", "off"}}, {"reset", "before", new String[]{"primary", "secondary", "tertiary"}}, {"default", "choice", "<any type value legal for one of the peer elements>"}, {"mapping", "registry", "<any charset registry, iana preferred>"}, {"mapping", "choice", "<any valid charset from the given registry>"}, {"abbreviationFallback", "choice", new String[]{"standard", "GMT"}}, {"preferenceOrdering", "choice", "<space-delimited list of timezone IDs>"}, {"exemplarCharacters", "type", new String[]{"standard", "auxiliary"}}, {"decimalFormatLength", "type", new String[]{"full", "long", "medium", "short"}}, {"scientificFormatLength", "type", new String[]{"full", "long", "medium", "short"}}, {"currencyFormatLength", "type", new String[]{"full", "long", "medium", "short"}}, {"percentFormatLength", "type", new String[]{"full", "long", "medium", "short"}}, {"field", "type", new String[]{"era", "year", "month", "week", "day", "weekday", "dayperiod", "hour", "minute", "second", "zone"}}, {"relative", "type", "<integer>"}, {"pattern", "type", "<valid pattern for format>"}, {"dateFormat", "type", new String[]{"standard", "<special-key>"}}, {"timeFormat", "type", new String[]{"standard", "<special-key>"}}, {"dateTimeFormat", "type", new String[]{"standard", "<special-key>"}}, {"decimalFormat", "type", new String[]{"standard", "<special-key>"}}, {"scientificFormat", "type", new String[]{"standard", "<special-key>"}}, {"percentFormat", "type", new String[]{"standard", "<special-key>"}}, {"currencyFormat", "type", new String[]{"standard", "<special-key>"}}};
        String[] pieces = new String[50];

        TripleData() {
        }

        private void recordData(String element, String attribute, String value) {
            TreeSet<String> valueSet;
            TreeMap<String, TreeSet<String>> elementToAttribute;
            if (!element.equals(ANYSTRING) && IGNORELIST.contains(attribute)) {
                return;
            }
            if (this.bigguys == null) {
                this.init();
            }
            if ((elementToAttribute = (TreeMap<String, TreeSet<String>>)this.elementToAttributeToValues.get(element)) == null) {
                elementToAttribute = new TreeMap<String, TreeSet<String>>((Comparator<String>)GenerateSidewaysView.getDefaultCollation());
                this.elementToAttributeToValues.put(element, elementToAttribute);
            }
            if ((valueSet = (TreeSet<String>)elementToAttribute.get(attribute)) == null) {
                valueSet = new TreeSet<String>((Comparator<String>)GenerateSidewaysView.getDefaultCollation());
                elementToAttribute.put(attribute, valueSet);
            }
            if (value != null) {
                valueSet.add(value);
            }
        }

        private void writeData() throws IOException {
            String fileName = "attributeList.html";
            PrintWriter out = BagFormatter.openUTF8Writer((String)options[3].value, (String)("by_type" + File.separator + fileName));
            out.println("<html><head>");
            out.println("<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
            out.println("<title>Element/Attribute/Value</title>");
            out.println("<link rel='stylesheet' type='text/css' href='http://oss.software.ibm.com/cvs/icu/~checkout~/icuhtml/common.css'>");
            out.println("<link rel='stylesheet' type='text/css' href='by_type.css'>");
            out.println("</head><body>");
            out.println("<table>");
            for (int i = 0; i < this.fixList.length; ++i) {
                String attributeItem;
                Object[] row = this.fixList[i];
                String elementItem = (String)row[0];
                if (elementItem.equals("*") || (attributeItem = (String)row[1]).equals("*")) continue;
                this.recordData(elementItem, attributeItem, null);
            }
            Iterator it = this.elementToAttributeToValues.keySet().iterator();
            while (it.hasNext()) {
                String element = (String)it.next();
                boolean newElement = true;
                Map elementToAttribute = (Map)this.elementToAttributeToValues.get(element);
                Set attributeKeys = elementToAttribute.keySet();
                Iterator it2 = attributeKeys.iterator();
                while (it2.hasNext()) {
                    String attribute = (String)it2.next();
                    boolean newAttribute = true;
                    Collection valueSet = this.getValues(element, elementToAttribute, attribute);
                    out.println("<tr>");
                    if (newElement) {
                        out.print("<td rowSpan='" + attributeKeys.size() + "'>" + element + "</td>");
                        out.println("<!-- " + valueSet.size() + ", " + attributeKeys.size() + "-->");
                        newElement = false;
                    }
                    if (newAttribute) {
                        out.print("<td>" + attribute + "</td>");
                        out.println("<!-- " + valueSet.size() + "-->");
                        newAttribute = false;
                    }
                    out.print("<td>");
                    boolean newSet = true;
                    Iterator it3 = valueSet.iterator();
                    while (it3.hasNext()) {
                        String value = (String)it3.next();
                        if (newSet) {
                            newSet = false;
                        } else {
                            out.print(", ");
                        }
                        out.print(TransliteratorUtilities.toHTML.transliterate("\"" + value + "\""));
                    }
                    out.println("</td></tr>");
                }
            }
            out.println("</table>");
            GenerateSidewaysView.writeFooterAndClose(out);
        }

        private void init() {
            try {
                String line;
                this.bigguys = new HashMap();
                BufferedReader br = BagFormatter.openUTF8Reader((String)timeZoneAliasDir, (String)"idList.txt");
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    com.ibm.icu.impl.Utility.split((String)line, (char)';', (String[])this.pieces);
                    String tag = this.pieces[0].trim();
                    String id = this.pieces[1].trim();
                    this.addTagValue(tag, id);
                }
                br.close();
                this.addTagValue("language", "root");
                this.addTagValue("script", "Qaai");
                this.addTagValue("variant", "POSIX");
                this.addTagValue("variant", "REVISED");
                this.addTagValue("variant", "bokmal");
                this.addTagValue("variant", "nynorsk");
                this.addTagValue("variant", "aaland");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void addTagValue(String tag, String id) {
            TreeSet<String> c = (TreeSet<String>)this.bigguys.get(tag);
            if (c == null) {
                c = new TreeSet<String>();
                this.bigguys.put(tag, c);
            }
            com.ibm.icu.impl.Utility.split((String)id, (char)',', (String[])this.pieces);
            for (int i = 0; i < this.pieces.length; ++i) {
                if (this.pieces[i].length() == 0) continue;
                c.add(this.pieces[i].trim());
            }
        }

        private Collection getValues(String element, Map elementToAttribute, String attribute) {
            for (int i = 0; i < this.fixList.length; ++i) {
                Object[] row = this.fixList[i];
                String elementItem = (String)row[0];
                String attributeItem = (String)row[1];
                if (!attribute.equals(attributeItem) && !"*".equals(attributeItem) || !element.equals(elementItem) && !"*".equals(elementItem)) continue;
                if (row[2] instanceof String) {
                    String valueItem = (String)row[2];
                    if (valueItem.startsWith("%%%")) {
                        Collection result = (Collection)this.bigguys.get(valueItem.substring(3));
                        TreeSet s = new TreeSet((Collection)elementToAttribute.get(attribute));
                        s.removeAll(result);
                        if (s.size() != 0) {
                            System.out.print("Warning: Missing values for " + element + ", " + attribute + ": ");
                            Iterator it = s.iterator();
                            while (it.hasNext()) {
                                System.out.print(it.next() + " ");
                            }
                            System.out.println();
                        }
                        return result;
                    }
                    ArrayList<String> result = new ArrayList<String>();
                    result.add(valueItem);
                    return result;
                }
                return Arrays.asList((Object[])row[2]);
            }
            return (Collection)elementToAttribute.get(attribute);
        }

        int getValueCount(Map elementToAttribute) {
            int result = 0;
            Iterator it2 = elementToAttribute.keySet().iterator();
            while (it2.hasNext()) {
                String attribute = (String)it2.next();
                Set valueSet = (Set)elementToAttribute.get(attribute);
                result += valueSet.size();
            }
            return result;
        }
    }

    class SimpleAttributes
    implements Comparable {
        Set contents = new TreeSet();

        SimpleAttributes() {
        }

        SimpleAttributes(SimpleAttributes other, String elementName) {
            this.contents.clear();
            this.contents.addAll(other.contents);
        }

        SimpleAttributes(Attributes attributes, String elementName) {
            boolean inZone = elementName.equals("zone");
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    if (inZone && name.equals("type")) {
                        GenerateSidewaysView.this.zoneIDs.add(value);
                    }
                    if (elementName.equals("ldml") && name.equals("version") || name.equals("type") && value.equals("standard")) continue;
                    this.contents.add(new SimpleAttribute(name, value));
                    tripleData.recordData(elementName, name, value);
                }
            }
        }

        public String toString() {
            return this.toString(true, false);
        }

        public String toString(boolean path, boolean isZone) {
            StringBuffer buffer = new StringBuffer();
            Iterator it = this.contents.iterator();
            while (it.hasNext()) {
                String replacement;
                SimpleAttribute a = (SimpleAttribute)it.next();
                if (isZone && a.name.equals("type") && (replacement = TimeZoneAliases.get(a.value)) != null) {
                    a = new SimpleAttribute("type", replacement);
                }
                buffer.append(a.toString(path));
            }
            return buffer.toString();
        }

        public int compareTo(Object o) {
            SimpleAttribute a2;
            SimpleAttribute a;
            int result;
            SimpleAttributes that = (SimpleAttributes)o;
            if (this.contents.size() == 0 && that.contents.size() == 0) {
                return 0;
            }
            Iterator it = this.contents.iterator();
            Iterator it2 = that.contents.iterator();
            do {
                a = this.getSkipping(it);
                a2 = this.getSkipping(it2);
                if (a == null) {
                    if (a2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (a2 != null) continue;
                return 1;
            } while ((result = a.compareTo(a2)) == 0);
            return result;
        }

        private SimpleAttribute getSkipping(Iterator it) {
            while (it.hasNext()) {
                SimpleAttribute a = (SimpleAttribute)it.next();
                if (IGNOREABLE.contains(a.name)) continue;
                return a;
            }
            return null;
        }

        public SimpleAttributes set(String element, String attribute, String value) {
            Iterator it = this.contents.iterator();
            while (it.hasNext()) {
                SimpleAttribute sa = (SimpleAttribute)it.next();
                if (!sa.name.equals(attribute)) continue;
                this.contents.remove(sa);
                break;
            }
            this.contents.add(new SimpleAttribute(attribute, value));
            tripleData.recordData(element, attribute, value);
            return this;
        }

        public String getValue(String attributeName) {
            Iterator it = this.contents.iterator();
            while (it.hasNext()) {
                SimpleAttribute sa = (SimpleAttribute)it.next();
                if (!sa.name.equals(attributeName)) continue;
                return sa.value;
            }
            return null;
        }

        public void add(SimpleAttributes attributes) {
            this.contents.addAll(attributes.contents);
        }

        public void removeAttributes(Set ignorelist) {
            Iterator it = this.contents.iterator();
            while (it.hasNext()) {
                SimpleAttribute sa = (SimpleAttribute)it.next();
                if (!ignorelist.contains(sa.name)) continue;
                it.remove();
            }
        }
    }

    static class SimpleAttribute
    implements Comparable {
        String name;
        String value;

        SimpleAttribute(String name, String value) {
            attributeOrdering.add((Comparable)((Object)name));
            valueOrdering.add((Comparable)((Object)value));
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object other) {
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean path) {
            if (path) {
                return "[@" + this.name + "='" + TransliteratorUtilities.toHTML.transliterate(this.value) + "']";
            }
            return " " + this.name + "=\"" + TransliteratorUtilities.toXML.transliterate(this.value) + "\"";
        }

        public int compareTo(Object o) {
            SimpleAttribute that = (SimpleAttribute)o;
            int result = attributeOrdering.compare((Comparable)((Object)this.name), (Comparable)((Object)that.name));
            if (result != 0) {
                return result;
            }
            return valueOrdering.compare((Comparable)((Object)this.value), (Comparable)((Object)that.value));
        }
    }

    static class Parent {
        GenerateSidewaysView parent;

        Parent() {
        }
    }

    public static class TimeZoneAliases {
        static Map map = null;

        static void init() {
            map = new HashMap();
            try {
                String line;
                BufferedReader br = BagFormatter.openUTF8Reader((String)timeZoneAliasDir, (String)"timezone_aliases.txt");
                String[] pieces = new String[2];
                while ((line = br.readLine()) != null) {
                    com.ibm.icu.impl.Utility.split((String)line, (char)';', (String[])pieces);
                    map.put(pieces[0].trim(), pieces[1].trim());
                }
                br.close();
                map.put("", "EMPTY-REMOVE");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static String get(Object id) {
            if (map == null) {
                TimeZoneAliases.init();
            }
            return (String)map.get(id);
        }
    }
}

