/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LDMLComparator {
    private static final int OPT_SUN_JDK = 1;
    private static final int OPT_IBM_JDK = 2;
    private static final int OPT_WINDOWS = 4;
    private static final int OPT_HP_UX = 8;
    private static final int OPT_SOLARIS = 16;
    private static final int OPT_IBM_TOR = 32;
    private static final int OPT_APPLE = 64;
    private static final int OPT_ICU = 128;
    private static final int OPT_OTHER = 256;
    private static final int OPT_SOURCE = 512;
    private static final int OPT_DEST = 1024;
    private static final int OPT_LINUX = 2048;
    private static final int OPT_AIX = 4096;
    private static final int OPT_COMMON = 8192;
    private static final int OPT_DIFF = 16384;
    private static final int OPT_DIFF_REF_COMMON = 32768;
    private static final int OPT_BULK = 65536;
    private static final int OPT_CASE_SENSITIVE = 131072;
    private static final int OPT_VETTING = 262144;
    private static final int OPT_UNKNOWN = 524288;
    private static final String COMMON = "common";
    private static final String ICU = "icu";
    private static final String IBM_TOR = "ibm";
    private static final String WINDOWS = "windows";
    private static final String SUNJDK = "sunjdk";
    private static final String IBMJDK = "ibmjdk";
    private static final String HPUX = "hp";
    private static final String APPLE = "apple";
    private static final String SOLARIS = "solaris";
    private static final String OPEN_OFFICE = "open_office";
    private static final String AIX = "aix";
    private static final String LINUX = "linux";
    private static final String ALTERNATE = "ALT";
    private static final String ALTERNATE_TITLE = "(Original)";
    private static final String ALT_COLOR = "#DDDDFD";
    private static final String DIFF = "diff";
    private static final String DIFF_REF_COMMON = "diff_ref_common";
    private static final String BULK = "bulk";
    private static final String CASE_SENSITIVE = "case_sensitive";
    private static final String VETTING = "vetting";
    private static final String[] PLATFORM_PRINT_ORDER = new String[]{"common", "icu", "windows", "sunjdk", "ibmjdk", "ibm", "apple", "solaris", "open_office", "aix", "linux", "hp"};
    private static final String[] USER_OPTIONS = new String[]{"-common", "-icu", "-ibm", "-windows", "-sunjdk", "-ibmjdk", "-hp", "-apple", "-solaris", "-open_office", "-aix", "-linux", "-s", "-d", "-diff", "-diff_ref_common", "-bulk", "-case_sensitive", "-vetting"};
    Hashtable optionTable = new Hashtable();
    private String sourceFolder = ".";
    private String destFolder = ".";
    private String localeStr;
    private String ourCvsVersion = "";
    private Calendar cal = Calendar.getInstance();
    private Hashtable colorHash = new Hashtable();
    private String goldFileName;
    private String goldKey;
    private int numPlatforms = 0;
    private int serialNumber = 0;
    private TreeMap compareMap = new TreeMap();
    private Hashtable doesNotExist = new Hashtable();
    private Hashtable requested = new Hashtable();
    private Hashtable deprecatedLanguageCodes = new Hashtable();
    private Hashtable deprecatedCountryCodes = new Hashtable();
    private TreeSet vettingSet = new TreeSet();
    private String encoding = "UTF-8";
    private Vector m_PlatformVect = new Vector();
    private Vector m_PlatformFolderVect = new Vector();
    private int m_iOptions;
    private TreeMap m_AccumulatedResultsMap = new TreeMap();
    private int m_iTotalConflictingElements = 0;
    private int m_iTotalNonConflictingElements = 0;
    private TreeMap m_LocaleSummaryDataMap = new TreeMap();
    private boolean m_Vetting = false;
    private int m_totalCount = 0;
    private String m_Messages = "";

    public static void main(String[] args) {
        LDMLComparator comparator = new LDMLComparator();
        comparator.processArgs(args);
    }

    LDMLComparator() {
        this.colorHash.put(COMMON, "#AD989D");
        this.colorHash.put(ICU, "#CCFF00");
        this.colorHash.put(IBM_TOR, "#FF7777");
        this.colorHash.put(WINDOWS, "#98FB98");
        this.colorHash.put(SUNJDK, "#FF6633");
        this.colorHash.put(IBMJDK, "#CCFFFF");
        this.colorHash.put(HPUX, "#FFE4B5");
        this.colorHash.put(APPLE, "#FFBBBB");
        this.colorHash.put(SOLARIS, "#CC9966");
        this.colorHash.put(OPEN_OFFICE, "#FFFF33");
        this.colorHash.put(AIX, "#EB97FE");
        this.colorHash.put(LINUX, "#1191F1");
        this.deprecatedLanguageCodes.put("iw", "he");
        this.deprecatedLanguageCodes.put("in", "id");
        this.deprecatedLanguageCodes.put("ji", "yi");
        this.deprecatedLanguageCodes.put("jw", "jv");
        this.deprecatedCountryCodes.put("TP", "TL");
        this.deprecatedCountryCodes.put("ZR", "CD");
    }

    private void processArgs(String[] args) {
        this.m_iOptions = this.identifyOptions(args);
        if (args.length < 2 || (this.m_iOptions & 0x80000) != 0) {
            this.printUsage();
            return;
        }
        boolean[] warning = new boolean[]{false};
        Enumeration en = this.optionTable.keys();
        try {
            if ((this.m_iOptions & 0x10000) != 0) {
                this.doBulkComparison();
            } else {
                this.localeStr = this.goldFileName.substring(this.goldFileName.lastIndexOf(File.separatorChar) + 1, this.goldFileName.lastIndexOf(46));
                String fileName = this.destFolder + File.separator + this.localeStr + ".html";
                this.m_totalCount = 0;
                if ((this.m_iOptions & 0x40000) != 0) {
                    this.m_Vetting = true;
                    this.addVettable(this.goldFileName, this.goldKey);
                } else {
                    this.addToCompareMap(this.goldFileName, this.goldKey);
                }
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String compFile = (String)this.optionTable.get(key);
                    if ((this.m_iOptions & 0x40000) != 0) {
                        this.addVettable(this.goldFileName, this.goldKey);
                        continue;
                    }
                    this.addToCompareMap(compFile, key);
                }
                if (this.m_totalCount != 0 || !this.m_Vetting) {
                    this.ourCvsVersion = "";
                    this.getCVSVersion();
                    OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), this.encoding);
                    System.out.println("INFO: Writing: " + fileName + "\t(" + this.m_totalCount + " items)");
                    PrintWriter writer = new PrintWriter(os);
                    this.printHTML(writer, this.localeStr);
                    ULocale ourLocale = new ULocale(this.localeStr);
                    String idxFileName = this.destFolder + File.separator + ourLocale.getDisplayLanguage() + "_" + ourLocale.getDisplayCountry() + "_" + this.localeStr + ".idx";
                    OutputStreamWriter is = new OutputStreamWriter((OutputStream)new FileOutputStream(idxFileName), "utf-8");
                    PrintWriter indexwriter = new PrintWriter(is);
                    indexwriter.println("<tr>");
                    indexwriter.println(" <td>" + this.localeStr + "</td>");
                    indexwriter.println(" <td><a href=\"" + this.localeStr + ".html" + "\">" + ourLocale.getDisplayName() + "</a></td>");
                    indexwriter.println(" <td>" + this.m_totalCount + "</td>");
                    indexwriter.println(" <td>" + LDMLUtilities.getCVSLink(this.localeStr, this.ourCvsVersion) + this.ourCvsVersion + "</a></td>");
                    indexwriter.println("</tr>");
                    is.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printUsage() {
        System.err.println("Usage: LDMLComparator [<option>:<gold>] filename1 [option] filename2 ... \n LDMLComparator [-common:<gold>] filename [-icu] filename [-ibmjdk] filename [-windows] filename [-hpux]  filename [-solaris] filename [-ibmtor] filename [-apple] filename [-sunjdk]  filename [-open_office] filename [-aix] filename [-linux] filename [-diff / -diff_ref_common] [-bulk] [-case_sensitive (only active if -diff of -diff-ref-common option selected)]");
        System.err.println("\nExample 1: \n LDMLComparator -solaris:gold foldername1 -sunjdk foldername2 -common foldername3 -diff-ref-common -bulk\n\t\t will do a bulk comparison of the locales in folder1 and folder2 \n \t\t and print the values of any differing elements plus the \n\t\t corresponding element's value in folder3 to bulk.html \n\t\t as well as a summary to bulk_summary.html \n");
        System.err.println("Example 2: \nLDMLComparator -common:gold filename1 -sunjdk filename2 -diff \n\t\t will do a comparison of the locales specified by filename1 and \n\t\t filename2 and print the values of any differing elements \n\t\t to a file called filename1.html in the current directory \n");
    }

    private int identifyOptions(String[] options) {
        int result = 0;
        for (int j = 0; j < options.length; ++j) {
            String option = options[j];
            boolean isGold = false;
            if (option.startsWith("-")) {
                if (option.indexOf(":gold") > 0) {
                    option = option.substring(0, option.indexOf(":"));
                    isGold = true;
                }
                boolean optionRecognized = false;
                for (int i = 0; i < USER_OPTIONS.length; ++i) {
                    if (!USER_OPTIONS[i].equals(option)) continue;
                    result |= 1 << i;
                    optionRecognized = true;
                    if (USER_OPTIONS[i].equals("-s")) {
                        this.sourceFolder = options[++j];
                        break;
                    }
                    if (USER_OPTIONS[i].equals("-d")) {
                        this.destFolder = options[++j];
                        break;
                    }
                    if (USER_OPTIONS[i].equals("-diff") || USER_OPTIONS[i].equals("-diff_ref_common") || USER_OPTIONS[i].equals("-bulk")) break;
                    if (USER_OPTIONS[i].equals("-vetting")) {
                        this.m_Vetting = true;
                        break;
                    }
                    if (USER_OPTIONS[i].equals("-case_sensitive")) break;
                    if (!isGold) {
                        this.optionTable.put(option.substring(1, option.length()), options[++j]);
                    } else {
                        this.goldFileName = options[++j];
                        this.goldKey = option.substring(1, option.length());
                    }
                    this.m_PlatformVect.add(option.substring(1, option.length()));
                    this.m_PlatformFolderVect.add(options[j]);
                    break;
                }
                if (optionRecognized) continue;
                result |= 0x80000;
                continue;
            }
            if (!this.m_Vetting) continue;
            this.vettingSet.add(option);
        }
        return result;
    }

    private void printTableHeader(PrintWriter writer) {
        writer.print("            <tr>\n                <th>N.</th>\n                <th>ParentNode</th>\n                <th>Name</th>\n                <th>ID</th>\n");
        for (int i = 0; i < PLATFORM_PRINT_ORDER.length && PLATFORM_PRINT_ORDER[i] != null; ++i) {
            String name = PLATFORM_PRINT_ORDER[i];
            Object obj = this.requested.get(name);
            if (obj == null || this.doesNotExist.get(name) != null) continue;
            String folder = name + "/main/";
            if (name.equals(ICU) || name.equals(COMMON) || name.indexOf("jdk") >= 0) {
                int index = this.localeStr.indexOf("_");
                String parent = "";
                if (index > -1) {
                    parent = this.localeStr.substring(0, index);
                }
                writer.print("                <th bgcolor=\"" + (String)this.colorHash.get(name) + "\">" + name.toUpperCase() + " (<a href=\"../../" + folder + this.localeStr + ".xml\">" + this.localeStr + "</a>," + " <a href=\"../../" + folder + parent + ".xml\">" + parent + "</a>," + " <a href=\"../../" + folder + "root.xml\">root</a>)" + "</th>\n");
            } else {
                writer.print("                <th bgcolor=\"" + (String)this.colorHash.get(name) + "\">" + name.toUpperCase() + " (<a href=\"../../" + folder + this.localeStr + ".xml\">" + this.localeStr + "</a>)" + "</th>\n");
            }
            ++this.numPlatforms;
        }
        if (this.m_Vetting) {
            writer.print("<th bgcolor=\"#DDDDFD\">(Original)</th>");
        }
        writer.print("            </tr>\n");
    }

    private void printTableHeaderForDifferences(PrintWriter writer) {
        writer.print("            <tr>\n                <th width=10%>N.</th>\n                <th width=10%>ParentNode</th>\n                <th width=10%>Name</th>\n                <th width=10%>ID</th>\n");
        for (int i = 0; i < this.m_PlatformVect.size(); ++i) {
            String name = (String)this.m_PlatformVect.elementAt(i);
            String folder = name + "/xml/";
            writer.print("                <th bgcolor=\"" + (String)this.colorHash.get(name) + "\">" + name.toUpperCase() + " (<a href=\"../" + folder + this.localeStr + ".xml\">xml</a>)" + "</th>\n");
        }
        if (this.m_Vetting) {
            writer.print("<th>(Original)</th>");
        }
        writer.print("            </tr>\n");
    }

    private boolean printDifferentValues(CompareElement element, PrintWriter writer) {
        int i;
        boolean isEqual = true;
        if (element.node.compareTo("generation") == 0 || element.node.compareTo("version") == 0) {
            return isEqual;
        }
        String compareTo = null;
        boolean bFoundFirst = false;
        for (i = 0; i < this.m_PlatformVect.size(); ++i) {
            String value = (String)element.platformData.get(this.m_PlatformVect.elementAt(i));
            if (value == null) continue;
            if (!bFoundFirst) {
                compareTo = value;
                bFoundFirst = true;
                continue;
            }
            if (Normalizer.compare((String)compareTo, (String)value, (int)0) == 0) {
                isEqual = true;
                continue;
            }
            if (Normalizer.compare((String)compareTo, (String)value, (int)65536) == 0) {
                if ((this.m_iOptions & 0x20000) == 0) {
                    isEqual = true;
                    continue;
                }
                isEqual = false;
                break;
            }
            isEqual = false;
            break;
        }
        if (!isEqual) {
            writer.print("            <tr>\n");
            writer.print("                <td><a NAME=\"" + this.serialNumber + "\" href=\"#" + this.serialNumber + "\">" + this.serialNumber + "</a></td>\n");
            writer.print("                <td>" + this.mapToAbbr(element.parentNode) + "</td>\n");
            writer.print("                <td>" + this.mapToAbbr(element.node) + "</td>\n");
            writer.print("                <td>" + element.index + "</td>\n");
            for (i = 0; i < this.m_PlatformVect.size(); ++i) {
                String val = (String)element.platformData.get(this.m_PlatformVect.elementAt(i));
                if (val != null) {
                    writer.print("                <td>" + val + "</td>\n");
                    continue;
                }
                writer.print("                <td>&nbsp;</td>\n");
            }
            writer.print("            </tr>\n");
            ++this.serialNumber;
        }
        return isEqual;
    }

    private boolean printDifferentValuesWithRef(CompareElement element, PrintWriter writer) {
        int i;
        boolean isEqual = true;
        if (element.node.compareTo("generation") == 0 || element.node.compareTo("version") == 0) {
            return isEqual;
        }
        String compareTo = null;
        boolean bFoundFirst = false;
        for (i = 0; i < this.m_PlatformVect.size(); ++i) {
            String value;
            String platform = (String)this.m_PlatformVect.elementAt(i);
            if (platform.compareTo(COMMON) == 0 || (value = (String)element.platformData.get(platform)) == null) continue;
            if (!bFoundFirst) {
                compareTo = value;
                bFoundFirst = true;
                continue;
            }
            if (Normalizer.compare((String)compareTo, (String)value, (int)0) == 0) {
                isEqual = true;
                continue;
            }
            if (Normalizer.compare((String)compareTo, (String)value, (int)65536) == 0) {
                if (element.parentNode.compareTo("timeFormat") == 0 || element.parentNode.compareTo("dateFormat") == 0) {
                    isEqual = true;
                    continue;
                }
                if ((this.m_iOptions & 0x20000) == 0) {
                    isEqual = true;
                    continue;
                }
                isEqual = false;
                break;
            }
            isEqual = false;
            break;
        }
        if (!isEqual) {
            writer.print("            <tr>\n");
            writer.print("                <td><a NAME=\"" + this.serialNumber + "\" href=\"#" + this.serialNumber + "\">" + this.serialNumber + "</a></td>\n");
            writer.print("                <td>" + this.mapToAbbr(element.parentNode) + "</td>\n");
            writer.print("                <td>" + this.mapToAbbr(element.node) + "</td>\n");
            writer.print("                <td>" + element.index + "</td>\n");
            for (i = 0; i < this.m_PlatformVect.size(); ++i) {
                String val = (String)element.platformData.get(this.m_PlatformVect.elementAt(i));
                if (val != null) {
                    writer.print("                <td>" + val + "</td>\n");
                    continue;
                }
                writer.print("                <td>&nbsp;</td>\n");
            }
            writer.print("            </tr>\n");
            ++this.serialNumber;
        }
        return isEqual;
    }

    private void printValue(CompareElement element, PrintWriter writer) {
        writer.print("            <tr>\n");
        writer.print("                <td><a NAME=\"" + this.serialNumber + "\" href=\"#" + this.serialNumber + "\">" + this.serialNumber + "</a></td>\n");
        writer.print("                <td>" + this.mapToAbbr(element.parentNode) + "</td>\n");
        writer.print("                <td>" + this.mapToAbbr(element.node) + "</td>\n");
        writer.print("                <td>" + element.index + "</td>\n");
        ++this.serialNumber;
        for (int i = 0; i < PLATFORM_PRINT_ORDER.length; ++i) {
            String value = (String)element.platformData.get(PLATFORM_PRINT_ORDER[i]);
            String color = (String)this.colorHash.get(PLATFORM_PRINT_ORDER[i]);
            boolean caseDiff = false;
            boolean isEqual = false;
            if (value == null) {
                if (this.requested.get(PLATFORM_PRINT_ORDER[i]) == null || this.doesNotExist.get(PLATFORM_PRINT_ORDER[i]) != null) continue;
                writer.print("                <td>&nbsp;</td>\n");
                continue;
            }
            for (int j = 0; j < i; ++j) {
                String compareTo = (String)element.platformData.get(PLATFORM_PRINT_ORDER[j]);
                if (compareTo == null) continue;
                if (value.equals("")) {
                    color = "#FFFFFF";
                    break;
                }
                if (element.parentNode.indexOf("decimal") > -1 || element.parentNode.indexOf("currency") > -1) {
                    if (!this.comparePatterns(compareTo, value)) continue;
                    color = (String)this.colorHash.get(PLATFORM_PRINT_ORDER[j]);
                    isEqual = true;
                    break;
                }
                if (Normalizer.compare((String)compareTo, (String)value, (int)0) == 0) {
                    color = (String)this.colorHash.get(PLATFORM_PRINT_ORDER[j]);
                    isEqual = true;
                    break;
                }
                if (Normalizer.compare((String)compareTo, (String)value, (int)65536) != 0) continue;
                caseDiff = true;
                color = (String)this.colorHash.get(PLATFORM_PRINT_ORDER[j]);
                break;
            }
            if (isEqual) {
                value = "=";
            }
            if (this.m_Vetting) {
                String altText = (String)element.platformData.get(ALTERNATE);
                writer.print("<td>" + value);
                String parName = this.mapToAbbr(element.parentNode);
                if (parName.indexOf("_dateFormat") != -1 || parName.indexOf("_timeFormat") != -1) {
                    writer.print("<form method=\"POST\" action=\"http://oss.software.ibm.com/cgi-bin/icu/lx/\"><input type=hidden name=\"_\" value=\"" + this.localeStr + "\"/>" + "<input type=hidden name=\"x\" value=\"" + "dat" + "\"/>" + "<input type=hidden name=\"str\" value=\"" + value + "\"/>" + "<input type=submit value=\"" + "Test" + "\"/>" + "</form>");
                }
                if (element.referenceUrl != null) {
                    writer.print("<br><div align='right'><a href=\"" + element.referenceUrl + "\"><i>(Ref)</i></a></div>");
                }
                writer.print("</td>");
                if (altText == null) continue;
                writer.print("        <td bgcolor=#DDDDFD>" + altText);
                writer.print("</td>\n");
                continue;
            }
            if (caseDiff) {
                writer.print("                <td bgcolor=" + color + ">" + value + "&#x2020;");
            } else {
                writer.print("                <td bgcolor=" + color + ">" + value);
            }
            writer.print("</td>\n");
        }
        writer.print("            </tr>\n");
    }

    private String mapToAbbr(String source) {
        if (source.equals("icu:ruleBasedNumberFormat")) {
            return "icu:rbnf";
        }
        if (source.equals("icu:ruleBasedNumberFormats")) {
            return "icu:rbnfs";
        }
        if (source.equals("exemplarCharacters")) {
            return "exemplarC";
        }
        if (source.equals("localizedPatternChars")) {
            return "lpc";
        }
        return source;
    }

    private void printHTML(PrintWriter writer, String localeStr) {
        ULocale locale = new ULocale(localeStr);
        String displayLang = locale.getDisplayLanguage();
        String dispCountry = locale.getDisplayCountry();
        String dispVariant = locale.getDisplayVariant();
        String displayName = localeStr + " (" + locale.getDisplayName() + ") ";
        if ((this.m_iOptions & 0x8000) != 0) {
            writer.print("<p>   Common data shown for reference purposes only</p>\n");
        }
        if (!this.m_Vetting) {
            writer.print("<html>\n    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n        <title>" + localeStr + "</title>\n" + "    </head>\n" + "    <style>\n" + "         <!--\n" + "         table        { border-spacing: 0; border-collapse: collapse; width: 100%; \n" + "                        border: 1px solid black }\n" + "         td, th       { width: 10%; border-spacing: 0; border-collapse: collapse; color: black; \n" + "                        vertical-align: top; border: 1px solid black }\n" + "         -->\n" + "     </style>" + "     <body bgcolor=\"#FFFFFF\">\n" + "        <p><b>" + displayName + "<a href=\"http://oss.software.ibm.com/cgi-bin/icu/lx/en/?_=" + localeStr + "\">Demo</a>, " + "<a href=\"../../comparison_charts.html\">Cover Page</a>, " + "<a href=\"./index.html\">Index</a>, " + "<a href=\"../collation/" + localeStr + ".html\">Collation</a> " + "</b></p>\n" + "        <table>\n");
        } else {
            writer.print("<html>\n    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n        <title>Draft/Alt: " + localeStr + "</title>\n" + "    </head>\n" + "    <style>\n" + "         <!--\n" + "         table        { border-spacing: 0; border-collapse: collapse;  \n" + "                        border: 1px solid black }\n" + "         td, th       { border-spacing: 0; border-collapse: collapse;  color: black; \n" + "                        vertical-align: top; border: 1px solid black }\n" + "         -->\n" + "     </style>" + "     <body bgcolor=\"#FFFFFF\">\n" + "        <p><b>" + displayName + "<a href=\"http://oss.software.ibm.com/cgi-bin/icu/lx/en/?_=" + localeStr + "\">Demo</a>, " + "<a href=\"./index.html\">Main and About</a>, " + "</b></p>\n");
            if (this.ourCvsVersion != null && this.ourCvsVersion.length() > 0) {
                writer.println("<h3><tt>" + LDMLUtilities.getCVSLink(localeStr) + localeStr + ".xml</a> version " + LDMLUtilities.getCVSLink(localeStr, this.ourCvsVersion) + this.ourCvsVersion + "</a></tt></h3>");
            }
            writer.print("        <table>\n");
        }
        if ((this.m_iOptions & 0x4000) != 0 || (this.m_iOptions & 0x8000) != 0) {
            this.printTableHeaderForDifferences(writer);
        } else {
            this.printTableHeader(writer);
        }
        Iterator iter = this.compareMap.keySet().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null) {
                Object value = this.compareMap.get(obj);
                if (!(value instanceof CompareElement)) {
                    throw new RuntimeException("The object stored in the compare map is not an instance of CompareElement");
                }
                CompareElement element = (CompareElement)value;
                if ((this.m_iOptions & 0x4000) != 0) {
                    this.printDifferentValues(element, writer);
                    continue;
                }
                if ((this.m_iOptions & 0x8000) != 0) {
                    this.printDifferentValuesWithRef(element, writer);
                    continue;
                }
                this.printValue(element, writer);
                continue;
            }
            throw new RuntimeException("No objects stored in the compare map!");
        }
        writer.print("        </table>\n");
        if (this.m_Vetting) {
            if (this.m_Messages.length() > 0) {
                writer.print("<table bgcolor=\"#FFBBBB\" border=3><tr><th>Warnings (please see source LDML)</th></tr><tr><td>" + this.m_Messages + "</td></tr></table><p/><p/>\n");
            }
            writer.print("<i>Interim page - subject to change</i> (<a href=\"./index.html\">Help</a>)<br/>");
        }
        writer.print("        <p>Created on: " + this.cal.getTime() + "</p>\n" + "    </body>\n" + "</html>\n");
        writer.flush();
        writer.flush();
    }

    private Document getFullyResolvedLocale(String localeName, String fileName) {
        int index = fileName.lastIndexOf(File.separatorChar);
        String sourceDir = fileName.substring(0, index + 1);
        String locale = fileName.substring(index + 1, fileName.lastIndexOf("."));
        System.out.println("INFO: Creating fully resolved tree for : " + fileName);
        Document doc = LDMLUtilities.getFullyResolvedLDML(sourceDir, locale, true, true, true, true);
        return doc;
    }

    private boolean addToCompareMap(String fileName, String key) {
        Document testDoc = this.getFullyResolvedLocale(key, fileName);
        this.requested.put(key, "");
        if (null == testDoc) {
            this.doesNotExist.put(key, "");
            return false;
        }
        return this.extractMergeData(testDoc, key, false);
    }

    private Document getParsedLocale(String localeName, String fileName) {
        int index = fileName.lastIndexOf(File.separatorChar);
        String sourceDir = fileName.substring(0, index + 1);
        String locale = fileName.substring(index + 1, fileName.lastIndexOf("."));
        System.out.println("INFO: Parsing " + fileName);
        Document doc = LDMLUtilities.parse(fileName, true);
        return doc;
    }

    private boolean addVettable(String fileName, String key) {
        Document testDoc = this.getParsedLocale(key, fileName);
        this.requested.put(key, "");
        if (null == testDoc) {
            this.doesNotExist.put(key, "");
            return false;
        }
        return this.extractMergeData(testDoc, key, false);
    }

    private boolean comparePatterns(String pat1, String pat2) {
        try {
            double args1 = 1.0E10;
            double args2 = -1.0E10;
            DecimalFormat fmt = new DecimalFormat();
            fmt.applyPattern(pat1);
            String s1 = fmt.format(args1);
            String s3 = fmt.format(args2);
            fmt.applyPattern(pat2);
            String s2 = fmt.format(args1);
            String s4 = fmt.format(args2);
            if (s1.equals(s2) && s3.equals(s4)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String trim(String source) {
        int stop;
        int start;
        char[] src = source.toCharArray();
        char[] dest = new char[src.length];
        for (start = 0; start < src.length && UCharacter.isWhitespace((int)src[start]); ++start) {
        }
        for (stop = src.length - 1; stop > 0 && (UCharacter.isWhitespace((int)src[stop]) || src[stop] == '\u00a0'); --stop) {
        }
        if (stop != -1 && start != src.length) {
            System.arraycopy(src, start, dest, 0, stop - start + 1);
            return new String(dest, 0, stop - start + 1);
        }
        return new String();
    }

    private final void addElement(String childNode, String parentNode, String id, String index, String platformValue, String platformName) {
        this.addElement(childNode, parentNode, id, index, platformValue, platformName, null);
    }

    /*
     * WARNING - void declaration
     */
    private void addElement(String childNode, String parentNode, String id, String index, String platformValue, String platformName, String referenceUrl) {
        void var9_9;
        CompareElement element;
        ++this.m_totalCount;
        Object obj = this.compareMap.get(id);
        if (obj == null) {
            element = new CompareElement();
            element.index = index;
            element.parentNode = parentNode;
            element.node = childNode;
            element.referenceUrl = referenceUrl;
            this.compareMap.put(id, element);
        } else if (obj instanceof CompareElement) {
            element = (CompareElement)obj;
        } else {
            throw new RuntimeException("The object stored in the compareMap is not a CompareElement object!");
        }
        if (!(var9_9.index.equals(index) && var9_9.node.equals(childNode) && var9_9.parentNode.equals(parentNode))) {
            throw new RuntimeException("The retrieved object is not the same as the one trying to be saved, id is " + id);
        }
        var9_9.platformData.put(platformName, platformValue);
    }

    private boolean childrenAreElements(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private String getTag(String childNodeName, String index) {
        if (childNodeName.indexOf("month") > -1) {
            int i = Integer.parseInt(index);
            StringBuffer temp = new StringBuffer();
            temp.append((char)(97 + i));
            return temp.toString();
        }
        if (childNodeName.indexOf("day") > -1) {
            if (index.equals("sun")) {
                return "a";
            }
            if (index.equals("mon")) {
                return "b";
            }
            if (index.equals("tue")) {
                return "c";
            }
            if (index.equals("wed")) {
                return "d";
            }
            if (index.equals("thu")) {
                return "e";
            }
            if (index.equals("fri")) {
                return "f";
            }
            if (index.equals("sat")) {
                return "g";
            }
        } else {
            return index;
        }
        return "";
    }

    private boolean extractMergeData(Node node, String key, boolean parentDraft) {
        for (Node childOfSource = node.getFirstChild(); childOfSource != null; childOfSource = childOfSource.getNextSibling()) {
            String alt;
            if (childOfSource.getNodeType() != 1) continue;
            String altText = null;
            Node altForChild = null;
            boolean subDraft = parentDraft;
            String childOfSourceName = childOfSource.getNodeName();
            if (childOfSourceName.equals("collations") || childOfSource.equals("special") || childOfSourceName.indexOf(":") > -1) continue;
            if (this.m_Vetting && LDMLUtilities.isNodeDraft(childOfSource) && !subDraft) {
                subDraft = true;
            }
            String referenceUrl = null;
            if (this.m_Vetting && (referenceUrl = LDMLUtilities.getAttributeValue(childOfSource, "references")) != null && referenceUrl.length() == 0) {
                referenceUrl = null;
            }
            if (this.m_Vetting && (alt = LDMLUtilities.getAttributeValue(childOfSource, "alt")) != null) {
                if (alt.equals("proposed")) {
                    if (!subDraft) {
                        throw new IllegalArgumentException("***** ERROR Proposed but not draft? " + childOfSource.toString());
                    }
                    altForChild = LDMLUtilities.getNonAltNodeLike(node, childOfSource);
                    if (altForChild == null) {
                        System.out.println("WARNING: can't find a node like this one: " + childOfSource.toString() + " - consider removing the alt=\"proposed\" attribute.");
                        alt = null;
                    }
                } else if (subDraft) {
                    String type = LDMLUtilities.getAttributeValue(childOfSource, "type");
                    if (type == null) {
                        type = "";
                    }
                    this.m_Messages = this.m_Messages + " <br> UNKNOWN alt type '" + alt + "' for " + node.getNodeName() + "/" + childOfSourceName + "/" + type;
                    System.err.println("Warning: unknown alt type '" + alt + "'  - *IGNORING*. " + childOfSource.toString());
                    continue;
                }
            }
            if (!this.childrenAreElements(childOfSource)) {
                String mytype;
                NamedNodeMap at;
                Node mytypeNode;
                Node calendar;
                String mytype2;
                Node mytypeNode2;
                String temp;
                NamedNodeMap attr = childOfSource.getAttributes();
                Node typeNode = attr.getNamedItem("type");
                Node altNode = attr.getNamedItem("alt");
                String index = "";
                if (typeNode != null) {
                    String temp2;
                    if (childOfSource.getNodeName().equals("era") && !key.equals(COMMON)) {
                        int j = Integer.parseInt(typeNode.getNodeValue());
                        if (j > 0) {
                            --j;
                        }
                        typeNode.setNodeValue(Integer.toString(j));
                    }
                    if (!(temp2 = typeNode.getNodeValue()).equals("standard")) {
                        index = temp2;
                    }
                }
                String alt2 = null;
                if (altNode != null) {
                    alt2 = altNode.getNodeValue();
                }
                if (this.m_Vetting) {
                    Node keyNode = attr.getNamedItem("key");
                    String keyIndex = "";
                    if (keyNode != null) {
                        temp = keyNode.getNodeValue();
                        index = index + " (" + temp + ")";
                    }
                }
                String nodeValue = "";
                Node valueNode = childOfSource.getFirstChild();
                if (valueNode != null && !(temp = this.trim(valueNode.getNodeValue())).equals("standard")) {
                    nodeValue = temp;
                }
                if (altForChild != null) {
                    String temp3;
                    Node valueNode2 = altForChild.getFirstChild();
                    altText = valueNode2 != null ? (!(temp3 = this.trim(valueNode2.getNodeValue())).equals("standard") ? temp3 : "??? alt=standard") : "??? alt has no value";
                }
                Node parentNode = childOfSource.getParentNode();
                String parentNodeName = this.trim(parentNode.getNodeName());
                String childNodeName = this.trim(childOfSource.getNodeName());
                Node grandParentNode = childOfSource.getParentNode().getParentNode();
                String grandParentNodeName = grandParentNode.getNodeName();
                NamedNodeMap parentAttrib = parentNode.getAttributes();
                String type = "";
                if (parentAttrib != null && (mytypeNode2 = parentAttrib.getNamedItem("type")) != null && !(mytype2 = mytypeNode2.getNodeValue()).equals("standard")) {
                    if (!parentNodeName.equals("calendar")) {
                        type = mytype2;
                    } else {
                        parentNodeName = mytype2;
                    }
                }
                if (grandParentNodeName.equals("eras")) {
                    String gptType;
                    calendar = grandParentNode.getParentNode();
                    NamedNodeMap gpa = calendar.getAttributes();
                    Node gptNode = gpa.getNamedItem("type");
                    if (gptNode != null && !(gptType = gptNode.getNodeValue()).equals("standard")) {
                        grandParentNodeName = gptType;
                    }
                    parentNodeName = grandParentNodeName + "\u200b_" + parentNodeName;
                }
                if (grandParentNodeName.equals("calendar")) {
                    String gptType;
                    NamedNodeMap gpa = grandParentNode.getAttributes();
                    Node gptNode = gpa.getNamedItem("type");
                    if (gptNode != null && !(gptType = gptNode.getNodeValue()).equals("standard")) {
                        grandParentNodeName = gptType;
                    }
                    parentNodeName = grandParentNodeName + "\u200b_" + parentNodeName;
                }
                if (grandParentNodeName.equals("monthContext") || grandParentNodeName.equals("dayContext") || grandParentNodeName.equals("dateFormatLength") || grandParentNodeName.equals("timeFormatLength") || grandParentNodeName.equals("dateTimeFormatLength")) {
                    String ptType;
                    NamedNodeMap pa;
                    Node ptNode;
                    String gptType;
                    NamedNodeMap gpa;
                    Node gptNode;
                    String ggptType;
                    calendar = grandParentNode.getParentNode().getParentNode();
                    NamedNodeMap ggpa = calendar.getAttributes();
                    Node ggptNode = ggpa.getNamedItem("type");
                    if (ggptNode != null && !(ggptType = ggptNode.getNodeValue()).equals("standard")) {
                        grandParentNodeName = ggptType;
                        parentNodeName = ggptType + "\u200b_" + parentNodeName;
                    }
                    if ((gptNode = (gpa = grandParentNode.getAttributes()).getNamedItem("type")) != null && !(gptType = gptNode.getNodeValue()).equals("standard")) {
                        parentNodeName = parentNodeName + "\u200b_" + gptType;
                    }
                    if ((ptNode = (pa = parentNode.getAttributes()).getNamedItem("type")) != null && !(ptType = ptNode.getNodeValue()).equals("standard")) {
                        parentNodeName = parentNodeName + "\u200b_" + ptType;
                    }
                }
                if ((childNodeName.equals("pattern") || grandParentNodeName.equals("zone")) && parentNodeName.indexOf("date") == -1 && parentNodeName.indexOf("time") == -1 && (mytypeNode = (at = grandParentNode.getAttributes()).getNamedItem("type")) != null && !(mytype = mytypeNode.getNodeValue()).equals("standard")) {
                    type = type.equals("") ? mytype : type + "\u200b_" + mytype;
                }
                if (grandParentNodeName.equals("special") || parentNodeName.equals("special") || childNodeName.equals("special") || grandParentNodeName.indexOf(":") > 0) continue;
                if (!nodeValue.equals("") && !childOfSource.getNodeName().equals("version")) {
                    String temp4;
                    if (childNodeName.equals("language")) {
                        temp4 = (String)this.deprecatedLanguageCodes.get(index);
                        if (temp4 != null) {
                            index = temp4;
                        }
                    } else if (childNodeName.equals("territory")) {
                        temp4 = (String)this.deprecatedCountryCodes.get(index);
                        if (temp4 != null) {
                            index = temp4;
                        }
                        if (index != null && alt2 != null) {
                            index = index + "_" + alt2;
                        }
                    }
                    String id = "";
                    id = !type.equals("") ? parentNodeName + "_" + childNodeName + "_" + type + "_" + this.getTag(childNodeName, index) + "_" + grandParentNodeName : parentNodeName + "_" + childNodeName + "_" + this.getTag(childNodeName, index) + "_" + grandParentNodeName;
                    if (!index.equals("")) {
                        if (!(index.equals(nodeValue) || index.equals("Fallback") || this.m_Vetting && !subDraft)) {
                            this.addElement(childNodeName, parentNodeName, id, index, nodeValue, key, referenceUrl);
                            if (altText != null) {
                                this.addElement(childNodeName, parentNodeName, id, index, altText, ALTERNATE, null);
                            }
                        }
                    } else if (!(type.equals(nodeValue) || type.equals("Fallback") || this.m_Vetting && !subDraft)) {
                        this.addElement(childNodeName, parentNodeName, id, type, nodeValue, key, referenceUrl);
                        if (altText != null) {
                            this.addElement(childNodeName, parentNodeName, id, index, altText, ALTERNATE, null);
                        }
                    }
                }
                if (attr.getLength() <= 0 || typeNode != null || this.m_Vetting && !subDraft) continue;
                for (int i = 0; i < attr.getLength(); ++i) {
                    Node item = attr.item(i);
                    String attrName = item.getNodeName();
                    String subAltText = null;
                    if (attrName.equals("type") || attrName.equals("alt") || attrName.equals("draft")) continue;
                    if (grandParentNodeName.equals("zone")) {
                        parentNodeName = grandParentNodeName + "\u200b_" + parentNodeName;
                    }
                    String id = grandParentNodeName + "_" + parentNodeName + "_" + childNodeName + "_" + type + "_" + attrName;
                    String subNodeValue = item.getNodeValue();
                    if (altForChild != null) {
                        subAltText = "?";
                        System.err.println(parentNodeName + "/" + childNodeName + " alt?? : " + altText);
                        throw new IllegalArgumentException("UNKNOWN ALT SUBTAG + " + parentNodeName + "/" + childNodeName + " alt?? : " + altText + " not " + subNodeValue);
                    }
                    if (!index.equals("")) {
                        this.addElement(childNodeName, parentNodeName, id, index, subNodeValue, key);
                        continue;
                    }
                    if (!type.equals("")) {
                        this.addElement(childNodeName, parentNodeName, id, type, subNodeValue, key);
                        continue;
                    }
                    if (attrName.equals("draft")) continue;
                    this.addElement(childNodeName, parentNodeName, id, attrName, subNodeValue, key);
                }
                continue;
            }
            this.extractMergeData(childOfSource, key, subDraft);
        }
        return true;
    }

    private void doBulkComparison() {
        String fileName = this.destFolder + "/" + "Bulk.html";
        System.out.println("INFO: Creating file named: " + fileName);
        String fileName_summary = this.destFolder + "/" + "Bulk_summary.html";
        System.out.println("INFO: Creating file named: " + fileName_summary);
        try {
            String[] fileList;
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), this.encoding);
            OutputStreamWriter os_summary = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName_summary), this.encoding);
            PrintWriter writer = new PrintWriter(os);
            PrintWriter writer_summary = new PrintWriter(os_summary);
            this.printHTMLStart(writer);
            this.printInfo(writer);
            this.printHTMLStart(writer_summary);
            File localeDir = null;
            TreeSet<String> localeTreeSet = new TreeSet<String>();
            for (int i = 0; i < this.m_PlatformFolderVect.size(); ++i) {
                localeDir = new File((String)this.m_PlatformFolderVect.elementAt(i));
                fileList = localeDir.list();
                for (int j = 0; j < fileList.length; ++j) {
                    String platform;
                    if (!fileList[j].endsWith(".xml") || fileList[j].compareTo("root.xml") == 0 || fileList[j].compareTo("supplementalData.xml") == 0 || (this.m_iOptions & 0x8000) != 0 && (platform = (String)this.m_PlatformVect.elementAt(i)).compareTo(COMMON) == 0) continue;
                    localeTreeSet.add(fileList[j]);
                }
            }
            Object[] localeArray = localeTreeSet.toArray();
            int i = 0;
            for (i = 0; i < localeArray.length; ++i) {
                String platforms_with_this_locale = "";
                String localeFile = (String)localeArray[i];
                this.localeStr = localeFile.substring(0, localeFile.indexOf(46));
                System.out.println("INFO: locale : " + this.localeStr);
                for (int j = 0; j < this.m_PlatformFolderVect.size(); ++j) {
                    localeDir = new File((String)this.m_PlatformFolderVect.elementAt(j));
                    fileList = localeDir.list();
                    for (int k = 0; k < fileList.length; ++k) {
                        if (fileList[k].compareTo(localeFile) != 0) continue;
                        String key = (String)this.m_PlatformVect.elementAt(j);
                        String xmlFileName = localeDir + "/" + localeArray[i];
                        this.addToCompareMap(xmlFileName, key);
                        if ((this.m_iOptions & 0x8000) != 0 && key.compareTo(COMMON) == 0) continue;
                        platforms_with_this_locale = platforms_with_this_locale + key;
                        platforms_with_this_locale = platforms_with_this_locale + ",  ";
                    }
                }
                this.printHTMLLocaleStart(writer, i, platforms_with_this_locale);
                this.printTableHeaderForDifferences(writer);
                this.walkCompareMap(writer, this.localeStr, platforms_with_this_locale);
                this.compareMap.clear();
                this.printHTMLLocaleEnd(writer);
            }
            this.printLocaleSummaryToHTML(writer_summary);
            this.printAccumulatedResultsToHTML(writer_summary);
            this.printHTMLEnd(writer, i);
            this.printHTMLEnd(writer_summary, i);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("INFO: Finished writing file named: " + fileName);
        System.out.println("INFO: Finished writing file named: " + fileName_summary);
    }

    private void printHTMLStart(PrintWriter writer) {
        writer.print("<html>\n    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n    </head>\n    <style>\n         <!--\n         table        { border-spacing: 0; border-collapse: collapse; width:100%; \n                        border: 1px solid black }\n         td, th       { border-spacing: 0; border-collapse: collapse; color: black; \n                        vertical-align: top; border: 1px solid black }\n         -->\n     </style>     <body bgcolor=\"#FFFFFF\"> \n        <p><b>LOCALE DATA AUDIT</b></p>");
        writer.print("        <p>Created on: " + this.cal.getTime() + "</p>\n");
    }

    private void printInfo(PrintWriter writer) {
        if ((this.m_iOptions & 0x8000) != 0 || (this.m_iOptions & 0x4000) != 0) {
            writer.print("        <p>locale elements where there is a difference between at least two platforms are shown. \nIf a locale element is the same across all platforms it is not shown </p>");
        }
        if ((this.m_iOptions & 0x8000) != 0) {
            writer.print("<p>   Common data is shown for reference purposes only and is not part of the comparison</p>\n");
        }
    }

    private void printHTMLEnd(PrintWriter writer, int iTotalNumLocales) {
        writer.print("<p>&nbsp;</p>");
        writer.print("<p>&nbsp;</p>");
        writer.print("          <p><b>SUMMARY : </b></p>");
        String platforms = "";
        for (int i = 0; i < this.m_PlatformVect.size(); ++i) {
            if ((this.m_iOptions & 0x8000) != 0 && this.m_PlatformVect.elementAt(i).equals(COMMON)) continue;
            platforms = platforms + this.m_PlatformVect.elementAt(i);
            platforms = platforms + ", ";
        }
        writer.print("          <p><b>Platforms compared : " + platforms + "</b></p>");
        writer.print("          <p><b>Total Number of locales audited : " + iTotalNumLocales + "</b></p>" + "           <p><b>Total Number of conflicting locale data across all locales : " + this.serialNumber + "</b></p>" + "           <p><b>Number of locale elements where a conflict was found for at least one locale : " + this.m_iTotalConflictingElements + "</b></p>" + "           <p><b>Number of locale elements where no conflicts were found for any locale having this element : " + this.m_iTotalNonConflictingElements + "</b></p>" + "    </body>\n" + "</html>\n");
        writer.flush();
        writer.flush();
    }

    private void printHTMLLocaleStart(PrintWriter writer, int iLocaleCounter, String platforms_with_this_locale) {
        ULocale locale = new ULocale(this.localeStr);
        String displayLang = locale.getDisplayLanguage();
        String dispCountry = locale.getDisplayCountry();
        String dispVariant = locale.getDisplayVariant();
        String displayName = this.localeStr + " (" + displayLang + "_" + dispCountry;
        displayName = dispVariant.length() > 0 ? displayName + "_" + dispVariant + ") " : displayName + ") ";
        writer.print("        <p><b>" + iLocaleCounter + "&nbsp;&nbsp;&nbsp;" + displayName + "</b>" + "<b>&nbsp;&nbsp;&nbsp; platforms with this locale : " + platforms_with_this_locale + "</b></p>\n" + "        <table>\n");
    }

    private void printHTMLLocaleEnd(PrintWriter writer) {
        writer.print("        </table>\n");
    }

    private void walkCompareMap(PrintWriter writer, String locale, String platforms) {
        SummaryData summData = new SummaryData();
        Iterator iter = this.compareMap.keySet().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null) {
                Object value = this.compareMap.get(obj);
                if (!(value instanceof CompareElement)) {
                    throw new RuntimeException("The object stored in the compare map is not an instance of CompareElement");
                }
                CompareElement element = (CompareElement)value;
                boolean bIsEqual = true;
                if ((this.m_iOptions & 0x4000) != 0) {
                    bIsEqual = this.printDifferentValues(element, writer);
                    this.AddToAccumulatedResultsMap((String)obj, element, this.localeStr, bIsEqual);
                } else if ((this.m_iOptions & 0x8000) != 0) {
                    bIsEqual = this.printDifferentValuesWithRef(element, writer);
                    this.AddToAccumulatedResultsMap((String)obj, element, this.localeStr, bIsEqual);
                } else {
                    this.printValue(element, writer);
                }
                if (bIsEqual) continue;
                ++summData.m_iNumConflictingElements;
                continue;
            }
            throw new RuntimeException("No objects stored in the compare map!");
        }
        summData.m_szPlatforms = platforms;
        this.m_LocaleSummaryDataMap.put(locale, summData);
    }

    private void AddToAccumulatedResultsMap(String id, CompareElement element, String locale, boolean bIsEqual) {
        if (element == null) {
            return;
        }
        Object obj = this.m_AccumulatedResultsMap.get(id);
        if (obj == null) {
            AccumulatedResults ad = new AccumulatedResults();
            ad.index = element.index;
            ad.node = element.node;
            ad.parentNode = element.parentNode;
            ad.type = element.type;
            if (!bIsEqual) {
                ad.localeVectDiff.add(locale);
            } else {
                ad.localeVectSame.add(locale);
            }
            this.m_AccumulatedResultsMap.put(id, ad);
        } else if (obj instanceof AccumulatedResults) {
            AccumulatedResults ad = (AccumulatedResults)obj;
            if (!(ad.index.equals(element.index) && ad.node.equals(element.node) && ad.parentNode.equals(element.parentNode))) {
                throw new RuntimeException("The retrieved AccumulatedResults is not the same as the one trying to be saved - " + id);
            }
            if (!bIsEqual) {
                ad.localeVectDiff.add(locale);
            } else {
                ad.localeVectSame.add(locale);
            }
        } else {
            throw new RuntimeException("The object stored in the compareMap is not a CompareElement object!");
        }
    }

    private void printAccumulatedResultsToHTML(PrintWriter writer) {
        writer.print("<p>&nbsp;</p>");
        writer.print("<p>&nbsp;</p>");
        writer.print("<p><b>Table below shows the number of locales where conflicts did and didn't occur on a per locale element basis");
        writer.print("&nbsp;&nbsp; (For brevity, locale elements where no conflicts were detected for any locale are not shown) </b></p>");
        writer.print("<p></p>");
        writer.print("      <table width=\"700\">\n");
        writer.print("            <tr>\n                <th width=5%>N.</th>\n                <th width=10%>ParentNode</th>\n                <th width=10%>Name</th>\n                <th width=10%>ID</th>\n                <th width=10%># of non-conflicting locales</th>                <th width=10%># of conflicting locales</th>                <th width=45%>Locales where conflicts were found</th>            </tr>\n");
        Iterator iter = this.m_AccumulatedResultsMap.keySet().iterator();
        int iCounter = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null) {
                Object value = this.m_AccumulatedResultsMap.get(obj);
                if (!(value instanceof AccumulatedResults)) {
                    throw new RuntimeException("The object stored in the AccumulateDifferencesMap is not an instance of AccumulateDifferences");
                }
                AccumulatedResults ad = (AccumulatedResults)value;
                if (ad.localeVectDiff.size() > 0) {
                    ++this.m_iTotalConflictingElements;
                    writer.print("            <tr>\n");
                    writer.print("                <td>" + iCounter++ + "</td>\n");
                    writer.print("                <td>" + ad.parentNode + "</td>\n");
                    writer.print("                <td>" + ad.node + "</td>\n");
                    writer.print("                <td>" + ad.index + "</td>\n");
                    writer.print("                <td>" + ad.localeVectSame.size() + "</td>\n");
                    writer.print("                <td>" + ad.localeVectDiff.size() + "</td>\n");
                    String locales = "";
                    for (int i = 0; i < ad.localeVectDiff.size(); ++i) {
                        locales = locales + ad.localeVectDiff.elementAt(i);
                        locales = locales + ", ";
                    }
                    writer.print("                <td>" + locales + "</td>\n");
                    writer.print("            </tr>\n");
                    continue;
                }
                ++this.m_iTotalNonConflictingElements;
                continue;
            }
            throw new RuntimeException("No objects stored in the AccumulateDifferencesMap!");
        }
        writer.print("      </table>\n");
    }

    private void printLocaleSummaryToHTML(PrintWriter writer) {
        writer.print("<p>&nbsp;</p>");
        writer.print("<p>&nbsp;</p>");
        writer.print("<p><b>Table below shows the number of conflicting elements on a per locale basis\n</b></p>");
        writer.print("<p></p>");
        writer.print("      <table width=\"700\">\n");
        writer.print("            <tr>\n                <th width=5%>N.</th>\n                <th width=20%>Locale</th>\n                <th width=40%>Platforms With This Locale</th>\n                <th width=35%># of elements where a conflict was found</th>\n            </tr>\n");
        Iterator iter = this.m_LocaleSummaryDataMap.keySet().iterator();
        int iCounter = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null) {
                Object value = this.m_LocaleSummaryDataMap.get(obj);
                if (!(value instanceof SummaryData)) {
                    throw new RuntimeException("The object stored in the AccumulateDifferencesMap is not an instance of AccumulateDifferences");
                }
                SummaryData summData = (SummaryData)value;
                writer.print("            <tr>\n");
                writer.print("                <td>" + iCounter++ + "</td>\n");
                writer.print("                <td>" + (String)obj + "</td>\n");
                writer.print("                <td>" + summData.m_szPlatforms + "</td>\n");
                writer.print("                <td>" + summData.m_iNumConflictingElements + "</td>\n");
                writer.print("            </tr>\n");
                continue;
            }
            throw new RuntimeException("No objects stored in the AccumulateDifferencesMap!");
        }
        writer.print("      </table>\n");
    }

    private void getCVSVersion() {
        this.ourCvsVersion = LDMLUtilities.getCVSVersion(this.goldFileName);
    }

    private class SummaryData {
        String m_szPlatforms;
        int m_iNumConflictingElements;

        private SummaryData() {
        }
    }

    private class AccumulatedResults {
        String node;
        String index;
        String parentNode;
        String type;
        Vector localeVectDiff = new Vector();
        Vector localeVectSame = new Vector();

        private AccumulatedResults() {
        }
    }

    private class CompareElement {
        String node;
        String index;
        String parentNode;
        String type;
        Hashtable platformData = new Hashtable();
        String referenceUrl;

        private CompareElement() {
        }
    }
}

