/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.tool.UOption;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.unicode.cldr.util.LDMLUtilities;
import org.unicode.cldr.util.XPathTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class LDMLNodesAdder {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int MAINFILE = 2;
    private static final int EXTRACTFILE = 3;
    private static final int DESTFILE = 4;
    private static final int ADDONLY = 5;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create((String)"main", (char)'m', (int)1), UOption.create((String)"extract", (char)'e', (int)1), UOption.DESTDIR(), UOption.create((String)"add-only", (char)'a', (int)0)};
    private String mainfile = null;
    private String destfile = null;
    private String extractfile = null;
    private boolean addonly = false;

    public static void main(String[] args) {
        LDMLNodesAdder cnv = new LDMLNodesAdder();
        cnv.processArgs(args);
    }

    private void usage() {
        System.out.println("\nUsage: LDMLNodesAdder [OPTIONS] [XPATH1] [XPATH2]\n\nThis program is used to extract nodes from extract LDML file and merge \nthe extracted nodes with the main LDML file\nPlease refer to the following options. Options are not case sensitive.\nOptions:\n-m or --main               The LDML file to which the extracted nodes are merged\n-o or --extract            The LDML file from which the nodes need to be extracted\n-d or --destination        destination directory, followed by the path, default is current directory.\n-a or --add-only           Don't replace existing nodes in the main document.\n-h or -? or --help         this usage text.\nexample: com.ibm.icu.dev.tool.cldr.LDMLNodesAdder -m locale/common/main/en.xml -o locale/ibmjdk/main/en.xml //ldml/dates/calendars/calendar[@type='chinese'] //ldml/posix");
        System.exit(-1);
    }

    private void processArgs(String[] args) {
        int remainingArgc = 0;
        try {
            remainingArgc = UOption.parseArgs((String[])args, (UOption[])options);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.toString());
            e.printStackTrace();
            this.usage();
        }
        if (args.length == 0 || LDMLNodesAdder.options[0].doesOccur || LDMLNodesAdder.options[1].doesOccur) {
            this.usage();
        }
        if (LDMLNodesAdder.options[2].doesOccur) {
            this.mainfile = LDMLNodesAdder.options[2].value;
        }
        if (LDMLNodesAdder.options[4].doesOccur) {
            this.destfile = LDMLNodesAdder.options[4].value;
        }
        if (LDMLNodesAdder.options[3].doesOccur) {
            this.extractfile = LDMLNodesAdder.options[3].value;
        }
        if (LDMLNodesAdder.options[5].doesOccur) {
            this.addonly = true;
        }
        if (this.destfile == null) {
            throw new RuntimeException("Destination not specified");
        }
        if (remainingArgc < 1) {
            this.usage();
            System.exit(-1);
        }
        try {
            Document maindoc = LDMLUtilities.parse(this.mainfile, false);
            Document extractdoc = LDMLUtilities.parse(this.extractfile, false);
            System.out.println("INFO: Merging nodes and marking them draft");
            this.mergeNodes(maindoc, extractdoc, args, remainingArgc);
            System.out.println("INFO: Removing specials");
            this.removeSpecials(maindoc);
            System.out.println("INFO: Fixing eras");
            this.fixEras(maindoc);
            maindoc.normalize();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.destfile), "UTF-8");
            PrintWriter pw = new PrintWriter(writer);
            LDMLUtilities.printDOMTree(maindoc, pw, "http://www.unicode.org/cldr/dtd/1.3/ldml.dtd", null);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mergeNodes(Document maindoc, Document extractdoc, String[] args, int argc) {
        for (int i = 0; i < argc; ++i) {
            Node extract = LDMLUtilities.getNode(extractdoc, args[i]);
            Node nodeInSource = LDMLUtilities.getNode(maindoc, args[i]);
            Node parentNode = null;
            StringBuffer xpath = new StringBuffer(args[i]);
            if (nodeInSource == null) {
                int j = 0;
                while (parentNode == null) {
                    XPathTokenizer.deleteToken(xpath);
                    parentNode = LDMLUtilities.getNode(maindoc, xpath.toString());
                    if (j > 0) {
                        extract = extract.getParentNode();
                    }
                    ++j;
                }
                extract = maindoc.importNode(extract, true);
                parentNode.appendChild(extract);
                Attr draft = maindoc.createAttribute("draft");
                draft.setValue("true");
                ((Element)extract).setAttributeNode(draft);
                continue;
            }
            if (this.addonly) continue;
            parentNode = nodeInSource.getParentNode();
            extract = maindoc.importNode(extract, true);
            parentNode.replaceChild(extract, nodeInSource);
            Attr draft = maindoc.createAttribute("draft");
            draft.setValue("true");
            ((Element)extract).setAttributeNode(draft);
        }
    }

    private void removeSpecials(Document doc) {
        Node[] nodes = LDMLUtilities.getElementsByTagName(doc, "special");
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                Node parent = nodes[i].getParentNode();
                parent.removeChild(nodes[i]);
            }
        }
    }

    private void fixEras(Document doc) {
        Node[] nodes = LDMLUtilities.getElementsByTagName(doc, "era");
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                NamedNodeMap attr = nodes[i].getAttributes();
                Node type = attr.getNamedItem("type");
                if (type == null) continue;
                String val = type.getNodeValue();
                int j = Integer.parseInt(val);
                if (j > 0) {
                    --j;
                }
                type.setNodeValue(Integer.toString(j));
            }
        }
    }
}

