/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ByteArrayWrapper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class SimpleConverter {
    public char[] cb = new char[100];
    public CharBuffer charBuffer = CharBuffer.wrap(this.cb);
    public byte[] bb = new byte[100];
    public ByteBuffer byteBuffer = ByteBuffer.wrap(this.bb);
    public CharsetEncoder ce;
    public CharsetDecoder cd;

    public SimpleConverter(Charset cs) {
        this.ce = cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.cd = cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public UnicodeSet getCharset() {
        UnicodeSet result = new UnicodeSet();
        for (char i = '\u0000'; i < '\u10000'; ++i) {
            String backMap;
            if ('\ud800' <= i && i < '\ue000') {
                if (i >= '\udc00') continue;
                for (int j = 56320; j <= 57344; ++j) {
                    String backMap2;
                    this.cb[0] = i;
                    this.cb[1] = (char)j;
                    ByteArrayWrapper ab = this.encode(2);
                    if (ab == null || (backMap2 = this.decode(ab.size)).length() != 2 || UTF16.charAt((String)backMap2, (int)0) != i) continue;
                    result.add((int)i);
                }
                continue;
            }
            this.cb[0] = i;
            ByteArrayWrapper ab = this.encode(1);
            if (ab == null || (backMap = this.decode(ab.size)).length() != 1 || backMap.charAt(0) != i) continue;
            result.add((int)i);
        }
        return result;
    }

    public ByteArrayWrapper encode(int len) {
        this.charBuffer.limit(len);
        this.charBuffer.position(0);
        this.byteBuffer.clear();
        this.ce.reset();
        CoderResult result = this.ce.encode(this.charBuffer, this.byteBuffer, true);
        if (result.isError()) {
            return null;
        }
        this.byteBuffer.flip();
        return new ByteArrayWrapper(this.byteBuffer);
    }

    public String decode(int len) {
        this.byteBuffer.limit(len);
        this.byteBuffer.position(0);
        this.charBuffer.clear();
        this.cd.reset();
        CoderResult result = this.cd.decode(this.byteBuffer, this.charBuffer, true);
        if (result.isError()) {
            return null;
        }
        this.charBuffer.flip();
        return String.valueOf(this.cb, 0, this.charBuffer.limit());
    }
}

