/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.LDMLLocaleWriterForOO;
import org.unicode.cldr.ooo.Logging;
import org.unicode.cldr.ooo.OOLocaleReader;
import org.unicode.cldr.ooo.OOToLDMLMapper;
import org.unicode.cldr.ooo.Utilities;

public class ConvertOOLocale {
    private static final int OPT_SINGLE = 1;
    private static final int OPT_BULK = 2;
    private static final int OPT_DATE_TIME = 4;
    private static final int OPT_RES_REFS = 8;
    private static final int OPT_DEST_DIR = 256;
    private static final int OPT_DTD_DIR = 512;
    private static final int OPT_CLDR_VER = 1024;
    private static final int OPT_CLDR_ONLY = 2048;
    private static final int OPT_INVALID = 16384;
    private static final String SINGLE = "-single";
    private static final String BULK = "-bulk";
    private static final String DATE_TIME = "-date_time";
    private static final String RES_REFS = "-res_refs";
    private static final String DEST_DIR = "-dest_dir";
    private static final String DTD_DIR = "-dtd_dir";
    private static final String CLDR_VER = "-cldr_ver";
    private static final String CLDR_ONLY = "-cldr_only";
    private static final String[] USER_OPTIONS = new String[]{"-single", "-bulk", "-date_time", "-res_refs", "-dest_dir", "-dtd_dir", "-cldr_ver", "-cldr_only"};
    private String m_inFile = null;
    private String m_inDir = null;
    private LDMLLocaleWriterForOO m_LDMLLocaleWriterForOO = null;
    private String m_localeStr = null;
    private int m_iOptions = 0;
    private String m_dest_dir = "main";
    private String m_dtd_dir = null;
    private String m_cldr_ver = "1.3";
    private boolean m_bConvertDateTime = false;
    private boolean m_bWriteCLDROnly = false;

    public ConvertOOLocale(String[] options) {
        this.m_iOptions = this.identifyOptions(options);
        if ((this.m_iOptions & 4) != 0) {
            this.m_bConvertDateTime = true;
        }
        if ((this.m_iOptions & 0x4000) != 0) {
            this.printUsage();
        } else if ((this.m_iOptions & 1) != 0) {
            if (this.m_inFile == null) {
                this.printUsage();
            } else {
                this.processSingle();
            }
        } else if ((this.m_iOptions & 2) != 0) {
            if (this.m_inDir == null) {
                this.printUsage();
            } else {
                this.processBulk();
            }
        } else {
            this.printUsage();
        }
    }

    public static void main(String[] args) {
        try {
            Logging.setLevel(true, true, true, true);
            new ConvertOOLocale(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("Unknown error: " + t);
        }
    }

    private short identifyOptions(String[] options) {
        if (options == null) {
            return 16384;
        }
        short result = 0;
        for (int j = 0; j < options.length; ++j) {
            String option = options[j];
            if (!option.startsWith("-")) continue;
            boolean optionRecognized = false;
            for (int i = 0; i < USER_OPTIONS.length; i = (int)((short)(i + 1))) {
                if (!USER_OPTIONS[i].equals(option)) continue;
                result = (short)(result | (short)(1 << i));
                optionRecognized = true;
                break;
            }
            if (!optionRecognized) {
                result = (short)(result | 0x4000);
            }
            if (option.compareTo(SINGLE) == 0 && j < options.length - 1) {
                this.m_inFile = options[++j];
                File fin = new File(this.m_inFile);
                if (!fin.isFile()) {
                    result = (short)(result | 0x4000);
                } else {
                    this.m_localeStr = Utilities.extractLocaleFromFilename(this.m_inFile);
                }
            } else if (option.compareTo(BULK) == 0 && j < options.length - 1) {
                this.m_inDir = options[++j];
                File din = new File(this.m_inDir);
                if (!din.isDirectory()) {
                    result = (short)(result | 0x4000);
                }
            }
            if (option.compareTo(DEST_DIR) == 0 && j < options.length - 1) {
                this.m_dest_dir = options[++j];
            }
            if (option.compareTo(DTD_DIR) == 0 && j < options.length - 1) {
                this.m_dtd_dir = options[++j];
                File din = new File(this.m_dtd_dir);
                if (!din.isDirectory()) {
                    result = (short)(result | 0x4000);
                }
            }
            if (option.compareTo(CLDR_VER) == 0 && j < options.length - 1) {
                this.m_cldr_ver = options[++j];
            }
            if (option.compareTo(CLDR_ONLY) != 0) continue;
            this.m_bWriteCLDROnly = true;
        }
        return result;
    }

    private void printUsage() {
        System.err.println("");
        System.err.println("DESCRIPTION:");
        System.err.println("  Converts OpenOffice.org locale data to CLDR's LDML format");
        System.err.println("");
        System.err.println("USAGE:");
        System.err.println("  ConvertOOLocalw [-single inFile] | [-bulk inDir]  [-date_time] [-res_refs] [-dest_dir] [-dtd_dir] [-cldr_ver]");
        System.err.println("");
        System.err.println("OPTIONS:");
        System.err.println("  -single    : converty the specified file");
        System.err.println("  -bulk      : convert all xml files in the specified directory");
        System.err.println("  -date_time : convert date/time format strings to be LDML compliant");
        System.err.println("  -res_refs  : resolve fully all OpenOffice.org XML refs");
        System.err.println("  -dest_dir  : the dir where output is written (it will be created if non existant) (dafault=./main) ");
        System.err.println("  -dtd_dir   : the location of the dtds (ldml.dtd and ldmlOpenOffice.dtd)");
        System.err.println("  -cldr_ver  : the CLDR version (default =1.3) this is used to determine the URL of the DTD if -dtd_dir not specified");
        System.err.println("  -cldr_only : only write data that can be mapped to CLDR. Used for importing new locales into CLDR.");
        System.err.println("");
        System.err.println("EXAMPLES:");
        System.err.println("  ConvertOOLocale -single OOFileName.xml");
        System.err.println("    will create the LDML file in the \"main\" subfolder (\"main\" will be created if it doesn't exist)");
        System.err.println("  ConvertOOLocale -bulk OODirName  ");
        System.err.println("    will create the LDML files in the \"main\" subfolder (\"main\" will be created if it doesn't exist)");
        System.err.println("");
    }

    private void processSingle() {
        Hashtable localeInfo;
        Vector format;
        Vector collators;
        Vector translits;
        Vector OutlineNumberingLevels;
        Vector numLevels;
        Hashtable reservedWords;
        Hashtable forbiddenChars;
        Hashtable minDaysInFirstWeek;
        Hashtable startDayOfWeek;
        Hashtable wideEras;
        Hashtable abbrEras;
        Hashtable wideMonths;
        Hashtable abbrMonths;
        Hashtable wideDays;
        Hashtable abbrDays;
        boolean bResolveRefs = false;
        if ((this.m_iOptions & 8) != 0) {
            bResolveRefs = true;
        }
        OOLocaleReader reader = new OOLocaleReader(this.m_inFile);
        reader.readDocument(bResolveRefs);
        PrintStream ps = Utilities.setLocaleWriter2(this.m_localeStr, null, this.m_dest_dir);
        this.m_LDMLLocaleWriterForOO = new LDMLLocaleWriterForOO(ps, this.m_bWriteCLDROnly);
        Hashtable aliases = OOToLDMLMapper.mapRefs(reader.m_Refs2);
        this.m_LDMLLocaleWriterForOO.setAliases(aliases);
        String ns = null;
        if (!this.m_bWriteCLDROnly) {
            ns = "openOffice";
        }
        this.m_LDMLLocaleWriterForOO.open(ns, this.m_dtd_dir, "ldmlOpenOffice.dtd", this.m_cldr_ver);
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put("version number", "$Revision: 1.9 $");
        if (OOLocaleReader.m_LangId != null) {
            data.put("language type", OOLocaleReader.m_LangId);
        }
        if (OOLocaleReader.m_Country_CountryID != null) {
            data.put("territory type", OOLocaleReader.m_Country_CountryID);
        }
        if (reader.m_PlatformID != null) {
            data.put("platformId", reader.m_PlatformID);
        }
        this.m_LDMLLocaleWriterForOO.writeIdentity(data);
        data.clear();
        if (OOLocaleReader.m_LangId != null) {
            data.put("language type", OOLocaleReader.m_LangId);
        }
        if (reader.m_Language_DefaultName != null) {
            data.put("defaultName " + OOLocaleReader.m_LangId, reader.m_Language_DefaultName);
        }
        if (OOLocaleReader.m_Country_CountryID != null) {
            data.put("territory type", OOLocaleReader.m_Country_CountryID);
        }
        if (reader.m_Country_DefaultName != null) {
            data.put("defaultName " + OOLocaleReader.m_Country_CountryID, reader.m_Country_DefaultName);
        }
        this.m_LDMLLocaleWriterForOO.writeLocaleDisplaynames(data);
        data.clear();
        Hashtable markers = OOToLDMLMapper.MapDelimiters(reader.m_Markers);
        if (markers != null) {
            data.putAll(markers);
        }
        this.m_LDMLLocaleWriterForOO.writeDelimiterss(data);
        data.clear();
        String measSys = OOToLDMLMapper.MapMeasurementSystem(reader.m_MeasurementSystem);
        if (measSys != null) {
            data.put("measurement", measSys);
        }
        this.m_LDMLLocaleWriterForOO.writeMeasurement(data);
        data.clear();
        Vector calendars = OOToLDMLMapper.MapCalendar(reader.m_Calendars);
        if (calendars != null) {
            data.put("calendar type", calendars);
        }
        if ((abbrDays = OOToLDMLMapper.MapDays(reader.m_AbbrDays)) != null) {
            data.put("dayWidth abbreviated", abbrDays);
        }
        if ((wideDays = OOToLDMLMapper.MapDays(reader.m_WideDays)) != null) {
            data.put("dayWidth wide", wideDays);
        }
        if ((abbrMonths = OOToLDMLMapper.MapMonths(reader.m_AbbrMonths)) != null) {
            data.put("monthWidth abbreviated", abbrMonths);
        }
        if ((wideMonths = OOToLDMLMapper.MapMonths(reader.m_WideMonths)) != null) {
            data.put("monthWidth wide", wideMonths);
        }
        if ((double)Float.parseFloat(this.m_cldr_ver) > 1.3999) {
            Hashtable abbrQuarters;
            Hashtable wideQuarters = OOToLDMLMapper.MapWideQuarters(reader.m_ReservedWords);
            if (wideQuarters != null) {
                data.put("quarterWidth wide", wideQuarters);
            }
            if ((abbrQuarters = OOToLDMLMapper.MapAbbrQuarters(reader.m_ReservedWords)) != null) {
                data.put("quarterWidth abbreviated", abbrQuarters);
            }
            reader.m_ReservedWords.remove("quarter1Word");
            reader.m_ReservedWords.remove("quarter2Word");
            reader.m_ReservedWords.remove("quarter3Word");
            reader.m_ReservedWords.remove("quarter4Word");
            reader.m_ReservedWords.remove("quarter1Abbreviation");
            reader.m_ReservedWords.remove("quarter2Abbreviation");
            reader.m_ReservedWords.remove("quarter3Abbreviation");
            reader.m_ReservedWords.remove("quarter4Abbreviation");
        }
        if ((abbrEras = OOToLDMLMapper.MapEras(reader.m_AbbrEras)) != null) {
            data.put("eraAbbr", abbrEras);
        }
        if ((wideEras = OOToLDMLMapper.MapEras(reader.m_WideEras)) != null) {
            data.put("eraNames", wideEras);
        }
        if ((startDayOfWeek = OOToLDMLMapper.MapStartDayOfWeek(reader.m_StartDayOfWeek)) != null) {
            data.put("firstDay", startDayOfWeek);
        }
        if ((minDaysInFirstWeek = OOToLDMLMapper.MapMinDaysInFirstWeek(reader.m_MinDaysInFirstweek)) != null) {
            data.put("minDays", minDaysInFirstWeek);
        }
        if (reader.m_TimeAM != null) {
            data.put("am", reader.m_TimeAM);
        }
        if (reader.m_TimePM != null) {
            data.put("pm", reader.m_TimePM);
        }
        Hashtable formatElements_date = new Hashtable();
        Hashtable formatCodes_date = new Hashtable();
        Hashtable formatDefaultNames_date = new Hashtable();
        Hashtable flexDate = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_date, formatCodes_date, formatDefaultNames_date, "DATE", this.m_localeStr, this.m_bConvertDateTime, flexDate);
        data.put("dateFormat", formatElements_date);
        data.put("dateFormat pattern", formatCodes_date);
        data.put("dateFormatdefaultName", formatDefaultNames_date);
        Hashtable formatElements_time = new Hashtable();
        Hashtable formatCodes_time = new Hashtable();
        Hashtable formatDefaultNames_time = new Hashtable();
        Hashtable flexTime = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_time, formatCodes_time, formatDefaultNames_time, "TIME", this.m_localeStr, this.m_bConvertDateTime, flexTime);
        data.put("timeFormat", formatElements_time);
        data.put("timeFormat pattern", formatCodes_time);
        data.put("timeFormatdefaultName", formatDefaultNames_time);
        Hashtable formatElements_date_time = new Hashtable();
        Hashtable formatCodes_date_time = new Hashtable();
        Hashtable formatDefaultNames_date_time = new Hashtable();
        Hashtable flexDateTime = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_date_time, formatCodes_date_time, formatDefaultNames_date_time, "DATE_TIME", this.m_localeStr, this.m_bConvertDateTime, flexDateTime);
        data.put("dateTimeFormat", formatElements_date_time);
        data.put("dateTimeFormat pattern", formatCodes_date_time);
        data.put("dateTimeFormatdefaultName", formatDefaultNames_date_time);
        this.m_LDMLLocaleWriterForOO.writeDates(data);
        data.clear();
        Hashtable symbols = new Hashtable();
        symbols = OOToLDMLMapper.MapSymbols(reader.m_Separators);
        if (symbols != null) {
            data.put("symbols", symbols);
        }
        data.put("currencies", reader.m_CurrencyData);
        Hashtable formatElements_fn = new Hashtable();
        Hashtable formatCodes_fn = new Hashtable();
        Hashtable formatDefaultNames_fn = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_fn, formatCodes_fn, formatDefaultNames_fn, "FIXED_NUMBER", this.m_localeStr, this.m_bConvertDateTime, null);
        data.put("decimalFormats", formatElements_fn);
        data.put("decimalFormats pattern", formatCodes_fn);
        data.put("decimalFormatsdefaultName", formatDefaultNames_fn);
        Hashtable formatElements_sn = new Hashtable();
        Hashtable formatCodes_sn = new Hashtable();
        Hashtable formatDefaultNames_sn = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_sn, formatCodes_sn, formatDefaultNames_sn, "SCIENTIFIC_NUMBER", this.m_localeStr, this.m_bConvertDateTime, null);
        data.put("scientificFormats", formatElements_sn);
        data.put("scientificFormats pattern", formatCodes_sn);
        data.put("scientificFormatsdefaultName", formatDefaultNames_sn);
        Hashtable formatElements_pn = new Hashtable();
        Hashtable formatCodes_pn = new Hashtable();
        Hashtable formatDefaultNames_pn = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_pn, formatCodes_pn, formatDefaultNames_pn, "PERCENT_NUMBER", this.m_localeStr, this.m_bConvertDateTime, null);
        data.put("percentFormats", formatElements_pn);
        data.put("percentFormats pattern", formatCodes_pn);
        data.put("percentFormatsdefaultName", formatDefaultNames_pn);
        Hashtable formatElements_c = new Hashtable();
        Hashtable formatCodes_c = new Hashtable();
        Hashtable formatDefaultNames_c = new Hashtable();
        OOToLDMLMapper.MapFormatElements(reader.m_FormatElements, reader.m_FormatCodes, reader.m_FormatDefaultNames, formatElements_c, formatCodes_c, formatDefaultNames_c, "CURRENCY", this.m_localeStr, this.m_bConvertDateTime, null);
        data.put("currencyFormats", formatElements_c);
        data.put("currencyFormats pattern", formatCodes_c);
        data.put("currencyFormatsdefaultName", formatDefaultNames_c);
        this.m_LDMLLocaleWriterForOO.writeNumbers(data);
        data.clear();
        Hashtable OOsymbols = new Hashtable();
        OOsymbols = OOToLDMLMapper.MapOOSymbols(reader.m_Separators);
        if (OOsymbols != null) {
            data.put("symbols", OOsymbols);
        }
        if ((forbiddenChars = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_ForbiddenChars)) != null) {
            data.put("forbiddenCharacters", forbiddenChars);
        }
        if ((reservedWords = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_ReservedWords)) != null) {
            data.put("reservedWords", reservedWords);
        }
        if ((numLevels = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_NumberingLevels)) != null) {
            data.put("numberingLevels", numLevels);
        }
        if ((OutlineNumberingLevels = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_OutlineNumberingLevels)) != null) {
            data.put("outLineNumberingLevels", OutlineNumberingLevels);
        }
        if ((translits = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_Transliterations)) != null) {
            data.put("transliterations", translits);
        }
        if (reader.m_SearchOptions != null) {
            data.put("searchOptions", reader.m_SearchOptions);
        }
        if (reader.m_IndexKeys != null) {
            data.put("indexKey", reader.m_IndexKeys);
        }
        if (reader.m_IndexKeysData != null) {
            data.put("index", reader.m_IndexKeysData);
        }
        if (reader.m_UnicodeScript != null) {
            data.put("unicodeScript", reader.m_UnicodeScript);
        }
        if (reader.m_FollowPageWord != null) {
            data.put("followPageWord", reader.m_FollowPageWord);
        }
        if ((collators = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_Collators)) != null) {
            data.put("collator", collators);
        }
        if (reader.m_CollationOptions != null) {
            data.put("collationOptions", reader.m_CollationOptions);
        }
        if ((format = OOToLDMLMapper.MapFirstCharToLowerCase(reader.m_LCFormat)) != null) {
            data.put("format", format);
        }
        if ((localeInfo = OOToLDMLMapper.mapLocaleInfo(reader.m_LocaleInfo)) != null) {
            data.put("locale", localeInfo);
        }
        this.m_LDMLLocaleWriterForOO.writeSpecial(data);
        data.clear();
        this.m_LDMLLocaleWriterForOO.close();
    }

    private void processBulk() {
        File inDir = new File(this.m_inDir);
        String[] fileList = inDir.list();
        for (int j = 0; j < fileList.length; ++j) {
            String file = fileList[j];
            if (!file.endsWith(".xml")) continue;
            this.m_inFile = this.m_inDir + "/" + file;
            this.m_localeStr = Utilities.extractLocaleFromFilename(file);
            this.processSingle();
        }
    }
}

