/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.LDMLLocaleWriter;
import org.unicode.cldr.ooo.Logging;

public class LDMLLocaleWriterForOO
extends LDMLLocaleWriter {
    private Hashtable m_Aliases = null;
    private Vector m_flexDateTimePatterns = null;
    private boolean m_bWriteCLDROnly = false;

    public LDMLLocaleWriterForOO(PrintStream out, boolean bWriteCLDROnly) {
        super(out);
        this.m_bWriteCLDROnly = bWriteCLDROnly;
    }

    public LDMLLocaleWriterForOO(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public void setAliases(Hashtable aliases) {
        if (aliases != null) {
            this.m_Aliases = aliases;
        }
    }

    public void writeLocaleDisplaynames(Hashtable data) {
        Hashtable<String, String> attribs;
        if (this.m_bWriteCLDROnly) {
            return;
        }
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML localeDisplayNames data to write ");
            return;
        }
        String language_type = (String)data.get("language type");
        String defaultName_lang = null;
        if (language_type != null) {
            defaultName_lang = (String)data.get("defaultName " + language_type);
        }
        String territory_type = (String)data.get("territory type");
        String defaultName_terr = null;
        if (territory_type != null) {
            defaultName_terr = (String)data.get("defaultName " + territory_type);
        }
        this.println("<localeDisplayNames>");
        this.indent();
        if (language_type != null && defaultName_lang != null) {
            this.println("<languages>");
            this.indent();
            this.println("<special xmlns:openOffice=\"http://www.openOffice.org\">");
            this.indent();
            attribs = new Hashtable<String, String>();
            attribs.put("type", language_type);
            this.printNS("openOffice", "defaultName", attribs, true, true, false);
            this.print(defaultName_lang);
            this.printlnNS("openOffice", "defaultName", false);
            this.outdent();
            this.println("</special>");
            this.outdent();
            this.println("</languages>");
        } else {
            Logging.Log3("Element localeDisplayNames/languages/special/openOffice:defaultName not written ");
        }
        if (territory_type != null && territory_type.compareTo("") != 0) {
            this.println("<territories>");
            this.indent();
            this.println("<special xmlns:openOffice=\"http://www.openOffice.org\">");
            this.indent();
            attribs = new Hashtable();
            attribs.put("type", territory_type);
            this.printNS("openOffice", "defaultName", attribs, true, true, false);
            this.print(defaultName_terr);
            this.printlnNS("openOffice", "defaultName", false);
            this.outdent();
            this.println("</special>");
            this.outdent();
            this.println("</territories>");
        } else {
            Logging.Log3("Element localeDisplayNames/territories/special/openOffice:defaultName not written ");
        }
        this.outdent();
        this.println("</localeDisplayNames>");
    }

    public void writeDates(Hashtable data) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML calendar data to write ");
            return;
        }
        Vector calendars = (Vector)data.get("calendar type");
        Hashtable abbrDays = (Hashtable)data.get("dayWidth abbreviated");
        Hashtable wideDays = (Hashtable)data.get("dayWidth wide");
        Hashtable abbrMonths = (Hashtable)data.get("monthWidth abbreviated");
        Hashtable wideMonths = (Hashtable)data.get("monthWidth wide");
        Hashtable abbrQuarters = (Hashtable)data.get("quarterWidth abbreviated");
        Hashtable wideQuarters = (Hashtable)data.get("quarterWidth wide");
        Hashtable abbrEras = (Hashtable)data.get("eraAbbr");
        Hashtable wideEras = (Hashtable)data.get("eraNames");
        Hashtable startDaysOfWeek = (Hashtable)data.get("firstDay");
        Hashtable minDayssInFirstWeek = (Hashtable)data.get("minDays");
        String am = (String)data.get("am");
        String pm = (String)data.get("pm");
        Hashtable formatElements_date = (Hashtable)data.get("dateFormat");
        Hashtable formatCodes_date = (Hashtable)data.get("dateFormat pattern");
        Hashtable formatDefaultNames_date = (Hashtable)data.get("dateFormatdefaultName");
        Hashtable formatElements_time = (Hashtable)data.get("timeFormat");
        Hashtable formatCodes_time = (Hashtable)data.get("timeFormat pattern");
        Hashtable formatDefaultNames_time = (Hashtable)data.get("timeFormatdefaultName");
        Hashtable formatElements_date_time = (Hashtable)data.get("dateTimeFormat");
        Hashtable formatCodes_date_time = (Hashtable)data.get("dateTimeFormat pattern");
        Hashtable formatDefaultNames_date_time = (Hashtable)data.get("dateTimeFormatdefaultName");
        this.m_flexDateTimePatterns = (Vector)data.get("availableFormats");
        if (calendars == null && abbrDays == null && wideDays == null && abbrMonths == null && wideMonths == null && abbrEras == null && wideEras == null && startDaysOfWeek == null && minDayssInFirstWeek == null && am == null && pm == null && formatElements_date == null && formatElements_time == null && formatElements_date_time == null && this.m_flexDateTimePatterns == null) {
            Logging.Log1("No LDML calendar data to write ");
            return;
        }
        this.println("<dates>");
        this.indent();
        this.println("<calendars>");
        this.indent();
        String posDefault = (String)calendars.elementAt(calendars.size() - 1);
        int iPosDefault = Integer.parseInt(posDefault);
        if (iPosDefault != -1) {
            String deflt_calendar = (String)calendars.elementAt(iPosDefault);
            if (deflt_calendar != null) {
                this.println("<default type=\"" + deflt_calendar + "\"/>");
            }
        } else {
            Logging.Log3("No default calendar type to write ");
        }
        for (int i = 0; i < calendars.size() - 1; ++i) {
            String calendar = (String)calendars.elementAt(i);
            this.println("<calendar type=\"" + calendar + "\">");
            this.indent();
            Hashtable abbrMonthsI = null;
            if (abbrMonths != null) {
                abbrMonthsI = (Hashtable)abbrMonths.get(calendar);
            }
            Hashtable wideMonthsI = null;
            if (wideMonths != null) {
                wideMonthsI = (Hashtable)wideMonths.get(calendar);
            }
            if (abbrMonthsI != null || wideMonthsI != null) {
                this.println("<months>");
                this.indent();
                this.println("<monthContext type=\"format\">");
                this.indent();
                if (abbrMonthsI != null) {
                    this.writeMonthWidth(abbrMonthsI, "abbreviated");
                } else {
                    Logging.Log3("No abbreviated months to write for calendar : " + calendar);
                }
                if (wideMonthsI != null) {
                    this.writeMonthWidth(wideMonthsI, "wide");
                } else {
                    Logging.Log3("No wide to write for calendar : " + calendar);
                }
                this.outdent();
                this.println("</monthContext>");
                this.outdent();
                this.println("</months>");
            } else {
                Logging.Log3("No abbreviated or wide months to write for calendar : " + calendar);
            }
            Hashtable abbrDaysI = null;
            if (abbrDays != null) {
                abbrDaysI = (Hashtable)abbrDays.get(calendar);
            }
            Hashtable wideDaysI = null;
            if (wideDays != null) {
                wideDaysI = (Hashtable)wideDays.get(calendar);
            }
            if (abbrDaysI != null || wideDaysI != null) {
                this.println("<days>");
                this.indent();
                this.println("<dayContext type=\"format\">");
                this.indent();
                if (abbrDaysI != null) {
                    this.writeDayWidth(abbrDaysI, "abbreviated");
                } else {
                    Logging.Log3("No abbreviated Days to write for calendar : " + calendar);
                }
                if (wideDaysI != null) {
                    this.writeDayWidth(wideDaysI, "wide");
                } else {
                    Logging.Log3("No wide Days to write for calendar : " + calendar);
                }
                this.outdent();
                this.println("</dayContext>");
                this.outdent();
                this.println("</days>");
            } else {
                Logging.Log3("No abbreviated or wide Days to write for calendar : " + calendar);
            }
            Hashtable abbrQuartersI = null;
            if (abbrQuarters != null) {
                abbrQuartersI = (Hashtable)abbrQuarters.get(calendar);
            }
            Hashtable wideQuartersI = null;
            if (wideQuarters != null) {
                wideQuartersI = (Hashtable)wideQuarters.get(calendar);
            }
            if (abbrQuartersI != null || wideQuartersI != null) {
                this.println("<quarters>");
                this.indent();
                this.println("<quarterContext type=\"format\">");
                this.indent();
                if (abbrQuartersI != null) {
                    this.writeQuarterWidth(abbrQuartersI, "abbreviated");
                } else {
                    Logging.Log3("No abbreviated Quarters to write for calendar : " + calendar);
                }
                if (wideQuartersI != null) {
                    this.writeQuarterWidth(wideQuartersI, "wide");
                } else {
                    Logging.Log3("No wide Quarters to write for calendar : " + calendar);
                }
                this.outdent();
                this.println("</quarterContext>");
                this.outdent();
                this.println("</quarters>");
            } else if (calendar.equals("gregorian")) {
                Logging.Log3("No abbreviated or wide Quarters to write for calendar : " + calendar);
            }
            String startDayOfWeek = null;
            if (startDaysOfWeek != null) {
                startDayOfWeek = (String)startDaysOfWeek.get(calendar);
            }
            String minDaysInFirstWeek = null;
            if (minDayssInFirstWeek != null) {
                minDaysInFirstWeek = (String)minDayssInFirstWeek.get(calendar);
            }
            this.writeWeek(minDaysInFirstWeek, startDayOfWeek, null, null, calendar);
            this.writeAmPm(am, pm, calendar);
            Hashtable wideErasI = null;
            if (wideEras != null) {
                wideErasI = (Hashtable)wideEras.get(calendar);
            }
            Hashtable abbrErasI = null;
            if (abbrEras != null) {
                abbrErasI = (Hashtable)abbrEras.get(calendar);
            }
            if (wideErasI != null || abbrErasI != null) {
                this.println("<eras>");
                this.indent();
                if (wideErasI != null) {
                    this.println("<eraNames>");
                    this.indent();
                    this.writeEras(wideErasI);
                    this.outdent();
                    this.println("</eraNames>");
                } else {
                    Logging.Log3("No wide eras to write for calendar : " + calendar);
                }
                if (abbrErasI != null) {
                    this.println("<eraAbbr>");
                    this.indent();
                    this.writeEras(abbrErasI);
                    this.outdent();
                    this.println("</eraAbbr>");
                } else {
                    Logging.Log3("No abbreviated eras to write for calendar : " + calendar);
                }
                this.outdent();
                this.println("</eras>");
            } else {
                Logging.Log3("No eras to write for calendar : " + calendar);
            }
            if (!this.m_bWriteCLDROnly && i == 0) {
                this.writeFormats(formatElements_date, formatCodes_date, formatDefaultNames_date, "dateFormats", "dateFormatLength", "dateFormat", calendar);
                this.writeFormats(formatElements_time, formatCodes_time, formatDefaultNames_time, "timeFormats", "timeFormatLength", "timeFormat", calendar);
                this.writeFormats(formatElements_date_time, formatCodes_date_time, formatDefaultNames_date_time, "dateTimeFormats", "dateTimeFormatLength", "dateTimeFormat", calendar);
            }
            this.outdent();
            this.println("</calendar>");
        }
        this.outdent();
        this.println("</calendars>");
        this.outdent();
        this.println("</dates>");
    }

    public void writeNumbers(Hashtable data) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML numbers data to write ");
            return;
        }
        Hashtable symbols = (Hashtable)data.get("symbols");
        Vector currencies = (Vector)data.get("currencies");
        Hashtable formatElements_fn = (Hashtable)data.get("decimalFormats");
        Hashtable formatCodes_fn = (Hashtable)data.get("decimalFormats pattern");
        Hashtable formatDefaultNames_fn = (Hashtable)data.get("decimalFormatsdefaultName");
        Hashtable formatElements_sn = (Hashtable)data.get("scientificFormats");
        Hashtable formatCodes_sn = (Hashtable)data.get("scientificFormats pattern");
        Hashtable formatDefaultNames_sn = (Hashtable)data.get("scientificFormatsdefaultName");
        Hashtable formatElements_pn = (Hashtable)data.get("percentFormats");
        Hashtable formatCodes_pn = (Hashtable)data.get("percentFormats pattern");
        Hashtable formatDefaultNames_pn = (Hashtable)data.get("percentFormatsdefaultName");
        Hashtable formatElements_c = (Hashtable)data.get("currencyFormats");
        Hashtable formatCodes_c = (Hashtable)data.get("currencyFormats pattern");
        Hashtable formatDefaultNames_c = (Hashtable)data.get("currencyFormatsdefaultName");
        if (symbols == null && currencies == null && formatElements_fn == null && formatElements_sn == null && formatElements_pn == null && formatElements_c == null) {
            Logging.Log1("No LDML numbers data to write ");
            return;
        }
        this.println("<numbers>");
        this.indent();
        this.writeSymbols(symbols);
        if (!this.m_bWriteCLDROnly) {
            this.writeFormats(formatElements_fn, formatCodes_fn, formatDefaultNames_fn, "decimalFormats", "decimalFormatLength", "decimalFormat", null);
            this.writeFormats(formatElements_sn, formatCodes_sn, formatDefaultNames_sn, "scientificFormats", "scientificFormatLength", "scientificFormat", null);
            this.writeFormats(formatElements_pn, formatCodes_pn, formatDefaultNames_pn, "percentFormats", "percentFormatLength", "percentFormat", null);
            this.writeFormats(formatElements_c, formatCodes_c, formatDefaultNames_c, "currencyFormats", "currencyFormatLength", "currencyFormat", null);
        }
        this.writeCurrencies(currencies, symbols);
        this.outdent();
        this.println("</numbers>");
    }

    public void writeSpecial(Hashtable data) {
        if (this.m_bWriteCLDROnly) {
            return;
        }
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML Special data to write ");
            return;
        }
        Hashtable localeInfo = (Hashtable)data.get("locale");
        Hashtable OOsymbols = (Hashtable)data.get("symbols");
        Hashtable forbiddenChars = (Hashtable)data.get("forbiddenCharacters");
        Hashtable reservedWords = (Hashtable)data.get("reservedWords");
        Vector numLevels = (Vector)data.get("numberingLevels");
        Vector outlineNumberingLevels = (Vector)data.get("outLineNumberingLevels");
        Vector translits = (Vector)data.get("transliterations");
        Vector searchOptions = (Vector)data.get("searchOptions");
        Vector indexKeys = (Vector)data.get("indexKey");
        Hashtable indexKeysData = (Hashtable)data.get("index");
        Vector unicodeScript = (Vector)data.get("unicodeScript");
        Vector followPageWord = (Vector)data.get("followPageWord");
        Vector collators = (Vector)data.get("collator");
        Vector collationOptions = (Vector)data.get("collationOptions");
        Vector format = (Vector)data.get("format");
        boolean bFoundAlias = false;
        Vector<String> specials = new Vector<String>();
        specials.add("forbiddenCharacters");
        specials.add("reservedWords");
        specials.add("numberingLevels");
        specials.add("outLineNumberingLevels");
        specials.add("transliterations");
        specials.add("search");
        specials.add("index");
        specials.add("collations");
        specials.add("format");
        specials.add("symbols");
        for (int i = 0; i < specials.size(); ++i) {
            if (!this.m_Aliases.containsKey(specials.elementAt(i))) continue;
            bFoundAlias = true;
            break;
        }
        if (!(localeInfo != null && localeInfo.size() != 0 || OOsymbols != null && OOsymbols.size() != 0 || forbiddenChars != null && forbiddenChars.size() != 0 || reservedWords != null && reservedWords.size() != 0 || numLevels != null && numLevels.size() != 0 || translits != null && translits.size() != 0 || searchOptions != null && searchOptions.size() != 0 || indexKeys != null && indexKeys.size() != 0 || indexKeysData != null && indexKeysData.size() != 0 || unicodeScript != null && unicodeScript.size() != 0 || followPageWord != null && followPageWord.size() != 0 || outlineNumberingLevels != null && outlineNumberingLevels.size() != 0 || collators != null && collators.size() != 0 || collationOptions != null && collationOptions.size() != 0 || format != null && format.size() != 0 || bFoundAlias)) {
            Logging.Log1("No LDML Special data to write ");
            return;
        }
        this.println("<special xmlns:openOffice=\"http://www.openOffice.org\">");
        this.indent();
        this.writeLocale(localeInfo);
        this.writeOOSymbols(OOsymbols);
        this.writeForbiddenChars(forbiddenChars);
        this.writeReservedWords(reservedWords);
        this.writeNumberingLevels(numLevels);
        this.writeOutLineNnumLevels(outlineNumberingLevels);
        this.writeTransliterations(translits);
        this.writeSearchOptions(searchOptions);
        this.writeIndex(indexKeys, indexKeysData, unicodeScript, followPageWord);
        this.writeCollations(collators, collationOptions);
        this.writeSpecialFormat(format);
        this.outdent();
        this.println("</special>");
    }

    public void writeForbiddenChars(Hashtable data) {
        String alias = (String)this.m_Aliases.get("forbiddenCharacters");
        if ((data == null || data.size() == 0) && alias == null) {
            Logging.Log1("No LDML forbiddenCharacters data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "forbiddenCharacters", attribs, true, false, true);
        } else {
            this.printlnNS("openOffice", "forbiddenCharacters", true);
            this.indent();
            String forLineBeginChars = (String)data.get("forbiddenLineBeginCharacters");
            String forLineEndChars = (String)data.get("forbiddenLineEndCharacters");
            if (forLineBeginChars != null) {
                forLineBeginChars = this.escapeXML(forLineBeginChars);
                this.printNS("openOffice", "forbiddenLineBeginCharacters", true);
                this.print(forLineBeginChars);
                this.printlnNS("openOffice", "forbiddenLineBeginCharacters", false);
            } else {
                Logging.Log3("No LDML Special forbiddenLineBeginCharacters to write ");
            }
            if (forLineEndChars != null) {
                forLineEndChars = this.escapeXML(forLineEndChars);
                this.printNS("openOffice", "forbiddenLineEndCharacters", true);
                this.print(forLineEndChars);
                this.printlnNS("openOffice", "forbiddenLineEndCharacters", false);
            } else {
                Logging.Log3("No LDML Special forbiddenLineEndCharacters to write ");
            }
            this.outdent();
            this.printlnNS("openOffice", "forbiddenCharacters", false);
        }
    }

    public void writeReservedWords(Hashtable data) {
        String alias = (String)this.m_Aliases.get("reservedWords");
        if ((data == null || data.size() == 0) && alias == null) {
            Logging.Log1("No LDML reservedWords data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "reservedWords", attribs, true, false, true);
        } else {
            this.printlnNS("openOffice", "reservedWords", true);
            this.indent();
            String trueWord = (String)data.get("trueWord");
            String falseWord = (String)data.get("falseWord");
            String q1Word = (String)data.get("quarter1Word");
            String q2Word = (String)data.get("quarter2Word");
            String q3Word = (String)data.get("quarter3Word");
            String q4Word = (String)data.get("quarter4Word");
            String aboveWord = (String)data.get("aboveWord");
            String belowWord = (String)data.get("belowWord");
            String q1Abbr = (String)data.get("quarter1Abbreviation");
            String q2Abbr = (String)data.get("quarter2Abbreviation");
            String q3Abbr = (String)data.get("quarter3Abbreviation");
            String q4Abbr = (String)data.get("quarter4Abbreviation");
            if (trueWord != null) {
                this.printNS("openOffice", "trueWord", true);
                this.print(trueWord);
                this.printlnNS("openOffice", "trueWord", false);
            } else {
                Logging.Log3("No LDML Special reservedWords:trueWord to write ");
            }
            if (falseWord != null) {
                this.printNS("openOffice", "falseWord", true);
                this.print(falseWord);
                this.printlnNS("openOffice", "falseWord", false);
            } else {
                Logging.Log3("No LDML Special reservedWords:falseWord to write ");
            }
            if (q1Word != null) {
                this.printNS("openOffice", "quarter1Word", true);
                this.print(q1Word);
                this.printlnNS("openOffice", "quarter1Word", false);
            }
            if (q2Word != null) {
                this.printNS("openOffice", "quarter2Word", true);
                this.print(q2Word);
                this.printlnNS("openOffice", "quarter2Word", false);
            }
            if (q3Word != null) {
                this.printNS("openOffice", "quarter3Word", true);
                this.print(q3Word);
                this.printlnNS("openOffice", "quarter3Word", false);
            }
            if (q4Word != null) {
                this.printNS("openOffice", "quarter4Word", true);
                this.print(q4Word);
                this.printlnNS("openOffice", "quarter4Word", false);
            }
            if (aboveWord != null) {
                this.printNS("openOffice", "aboveWord", true);
                this.print(aboveWord);
                this.printlnNS("openOffice", "aboveWord", false);
            } else {
                Logging.Log3("No LDML Special reservedWords:aboveWord to write ");
            }
            if (belowWord != null) {
                this.printNS("openOffice", "belowWord", true);
                this.print(belowWord);
                this.printlnNS("openOffice", "belowWord", false);
            } else {
                Logging.Log3("No LDML Special reservedWords:belowWord to write ");
            }
            if (q1Abbr != null) {
                this.printNS("openOffice", "quarter1Abbreviation", true);
                this.print(q1Abbr);
                this.printlnNS("openOffice", "quarter1Abbreviation", false);
            }
            if (q2Abbr != null) {
                this.printNS("openOffice", "quarter2Abbreviation", true);
                this.print(q2Abbr);
                this.printlnNS("openOffice", "quarter2Abbreviation", false);
            }
            if (q3Abbr != null) {
                this.printNS("openOffice", "quarter3Abbreviation", true);
                this.print(q3Abbr);
                this.printlnNS("openOffice", "quarter3Abbreviation", false);
            }
            if (q4Abbr != null) {
                this.printNS("openOffice", "quarter4Abbreviation", true);
                this.print(q4Abbr);
                this.printlnNS("openOffice", "quarter4Abbreviation", false);
            }
            this.outdent();
            this.printlnNS("openOffice", "reservedWords", false);
        }
    }

    public void writeNumberingLevels(Vector data) {
        String alias = (String)this.m_Aliases.get("numberingLevels");
        if ((data == null || data.size() == 0) && alias == null) {
            Logging.Log1("No LDML numberingLevels data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "numberingLevels", attribs, true, false, true);
        } else {
            this.printlnNS("openOffice", "numberingLevels", true);
            this.indent();
            for (int i = 0; i < data.size(); ++i) {
                this.printNS("openOffice", "numberingLevel", (Hashtable)data.elementAt(i), true, false, true);
            }
            this.outdent();
            this.printlnNS("openOffice", "numberingLevels", false);
        }
    }

    public void writeOutLineNnumLevels(Vector data) {
        String alias = (String)this.m_Aliases.get("outLineNumberingLevels");
        if ((data == null || data.size() == 0) && alias == null) {
            Logging.Log1("No LDML outlineNumberingLevels data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "outLineNumberingLevels", attribs, true, false, true);
        } else {
            this.printlnNS("openOffice", "outLineNumberingLevels", true);
            this.indent();
            for (int i = 0; i < data.size(); ++i) {
                int rem = i % 5;
                if (rem == 0) {
                    this.printlnNS("openOffice", "outlineStyle", true);
                    this.indent();
                }
                this.printNS("openOffice", "outLineNumberingLevel", (Hashtable)data.elementAt(i), true, false, true);
                rem = (i + 1) % 5;
                if (rem != 0) continue;
                this.outdent();
                this.printlnNS("openOffice", "outlineStyle", false);
            }
            this.outdent();
            this.printlnNS("openOffice", "outLineNumberingLevels", false);
        }
    }

    public void writeTransliterations(Vector data) {
        String alias = (String)this.m_Aliases.get("transliterations");
        if ((data == null || data.size() == 0) && alias == null) {
            Logging.Log1("No LDML transliterations data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "transliterations", attribs, true, false, true);
        } else {
            this.printlnNS("openOffice", "transliterations", true);
            this.indent();
            for (int i = 0; i < data.size(); ++i) {
                this.printNS("openOffice", "transliteration", (Hashtable)data.elementAt(i), true, false, true);
            }
            this.outdent();
            this.printlnNS("openOffice", "transliterations", false);
        }
    }

    public void writeSearchOptions(Vector data) {
        String alias = (String)this.m_Aliases.get("search");
        if ((data == null || data.size() == 0) && alias == null) {
            Logging.Log1("No LDML searchOptions data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "search", attribs, true, false, true);
        } else {
            this.printlnNS("openOffice", "search", true);
            this.indent();
            this.printlnNS("openOffice", "searchOptions", true);
            this.indent();
            for (int i = 0; i < data.size(); ++i) {
                this.printNS("openOffice", "transliterationModules", true);
                this.print((String)data.elementAt(i));
                this.printlnNS("openOffice", "transliterationModules", false);
            }
            this.outdent();
            this.printlnNS("openOffice", "searchOptions", false);
            this.outdent();
            this.printlnNS("openOffice", "search", false);
        }
    }

    public void writeIndex(Vector indexKeys, Hashtable indexKeysData, Vector unicodeScript, Vector followPageWord) {
        String alias = (String)this.m_Aliases.get("index");
        if (!(indexKeys != null && indexKeys.size() != 0 || indexKeysData != null && indexKeysData.size() != 0 || unicodeScript != null && unicodeScript.size() != 0 || followPageWord != null && followPageWord.size() != 0 || alias != null)) {
            Logging.Log1("No LDML index data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "index", attribs, true, false, true);
        } else {
            int i;
            this.printlnNS("openOffice", "index", true);
            this.indent();
            if (indexKeys != null) {
                for (i = 0; i < indexKeys.size(); ++i) {
                    Hashtable inner = (Hashtable)indexKeys.elementAt(i);
                    String unoid = (String)inner.get("unoid");
                    String indexKeyValue = null;
                    if (indexKeysData != null) {
                        indexKeyValue = (String)indexKeysData.get(unoid);
                    }
                    boolean bHasSubElementsOrData = false;
                    boolean bNewLine = true;
                    if (indexKeyValue != null) {
                        bHasSubElementsOrData = true;
                        bNewLine = false;
                    }
                    this.printNS("openOffice", "indexKey", inner, true, bHasSubElementsOrData, bNewLine);
                    if (indexKeyValue == null) continue;
                    this.print(indexKeyValue);
                    this.printlnNS("openOffice", "indexKey", false);
                }
            } else {
                Logging.Log3("No LDML Special indexKeys to write ");
            }
            if (unicodeScript != null) {
                for (i = 0; i < unicodeScript.size(); ++i) {
                    this.printNS("openOffice", "unicodeScript", true);
                    this.print((String)unicodeScript.elementAt(i));
                    this.printlnNS("openOffice", "unicodeScript", false);
                }
            } else {
                Logging.Log3("No LDML Special unicodeScript to write ");
            }
            if (followPageWord != null) {
                for (i = 0; i < followPageWord.size(); ++i) {
                    this.printNS("openOffice", "followPageWord", true);
                    this.print((String)followPageWord.elementAt(i));
                    this.printlnNS("openOffice", "followPageWord", false);
                }
            } else {
                Logging.Log3("No LDML Special followPageWord to write ");
            }
            this.outdent();
            this.printlnNS("openOffice", "index", false);
        }
    }

    public void writeCollations(Vector collators, Vector collationOptions) {
        String alias = (String)this.m_Aliases.get("collations");
        if ((collators == null || collators.size() == 0 && collationOptions == null || collationOptions.size() == 0) && alias == null) {
            Logging.Log1("No LDML collations data to write ");
            return;
        }
        if (alias != null) {
            Hashtable<String, String> attribs = new Hashtable<String, String>();
            attribs.put("ref", alias);
            this.printNS("openOffice", "collations", attribs, true, false, true);
        } else {
            int i;
            this.printlnNS("openOffice", "collations", true);
            this.indent();
            if (collators != null) {
                for (i = 0; i < collators.size(); ++i) {
                    this.printNS("openOffice", "collator", (Hashtable)collators.elementAt(i), true, false, true);
                }
            } else {
                Logging.Log3("No LDML Special collators to write ");
            }
            if (collationOptions != null) {
                this.printlnNS("openOffice", "collationOptions", true);
                this.indent();
                for (i = 0; i < collationOptions.size(); ++i) {
                    this.printNS("openOffice", "transliterationModules", true);
                    this.print((String)collationOptions.elementAt(i));
                    this.printlnNS("openOffice", "transliterationModules", false);
                }
                this.outdent();
                this.printlnNS("openOffice", "collationOptions", false);
            } else {
                Logging.Log3("No LDML Special collationOptions to write ");
            }
            this.outdent();
            this.printlnNS("openOffice", "collations", false);
        }
    }

    public void writeCurrencies(Vector data, Hashtable separators) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML currency data to write ");
            return;
        }
        this.println("<currencies>");
        this.indent();
        for (int i = 0; i < data.size(); ++i) {
            Vector inner = (Vector)data.elementAt(i);
            this.println("<currency type=\"" + (String)inner.elementAt(2) + "\">");
            this.indent();
            this.println("<displayName>" + (String)inner.elementAt(3) + "</displayName>");
            this.println("<symbol>" + (String)inner.elementAt(1) + "</symbol>");
            if (!this.m_bWriteCLDROnly) {
                String id = (String)inner.elementAt(0);
                String def = " openOffice:default=\"" + (String)inner.elementAt(5) + "\"";
                String uicfc = " openOffice:usedInCompatibleFormatCodes=\"" + (String)inner.elementAt(6) + "\"";
                String legacy = "";
                if (inner.size() > 7) {
                    legacy = " openOffice:legacyOnly=\"" + (String)inner.elementAt(7) + "\"";
                }
                this.println("<special xmlns:openOffice=\"http://www.openOffice.org\">");
                this.indent();
                this.println("<openOffice:currency" + def + uicfc + legacy + ">");
                this.indent();
                this.printNS("openOffice", "currencyId", true);
                this.print(id);
                this.printlnNS("openOffice", "currencyId", false);
                this.outdent();
                this.printlnNS("openOffice", "currency", false);
                this.outdent();
                this.println("</special>");
            }
            this.outdent();
            this.println("</currency>");
        }
        this.outdent();
        this.println("</currencies>");
    }

    protected void writeSymbols(Hashtable data) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML symbols data to write ");
            return;
        }
        String decimal = (String)data.get("decimal");
        String group = (String)data.get("group");
        String list = (String)data.get("list");
        this.println("<symbols>");
        this.indent();
        if (decimal != null) {
            this.println("<decimal>" + decimal + "</decimal>");
        } else {
            Logging.Log3("No LDML decimal symbol to write ");
        }
        if (group != null) {
            this.println("<group>" + group + "</group>");
        } else {
            Logging.Log3("No LDML group symbol to write ");
        }
        if (list != null) {
            this.println("<list>" + list + "</list>");
        } else {
            Logging.Log3("No LDML list symbol to write ");
        }
        this.outdent();
        this.println("</symbols>");
    }

    protected void writeOOSymbols(Hashtable data) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No OO.o symbols data to write ");
            return;
        }
        this.printlnNS("openOffice", "separators", true);
        this.indent();
        String dateSeparator = (String)data.get("dateSeparator");
        String timeSeparator = (String)data.get("timeSeparator");
        String longDateDayOfWeekSeparator = (String)data.get("longDateDayOfWeekSeparator");
        String longDateDaySeparator = (String)data.get("longDateDaySeparator");
        String longDateMnothSeparator = (String)data.get("longDateMonthSeparator");
        String longDateYearSeparator = (String)data.get("longDateYearSeparator");
        String time100SecSeparator = (String)data.get("time100SecSeparator");
        if (dateSeparator != null) {
            this.print("<openOffice:dateSeparator>");
            this.print(dateSeparator);
            this.println("</openOffice:dateSeparator>");
        } else {
            Logging.Log3("No LDML Special dateSeparator symbol to write ");
        }
        if (timeSeparator != null) {
            this.print("<openOffice:timeSeparator>");
            this.print(timeSeparator);
            this.println("</openOffice:timeSeparator>");
        } else {
            Logging.Log3("No LDML Special timeSeparator symbol to write ");
        }
        if (longDateDayOfWeekSeparator != null) {
            this.print("<openOffice:longDateDayOfWeekSeparator>");
            this.print(longDateDayOfWeekSeparator);
            this.println("</openOffice:longDateDayOfWeekSeparator>");
        } else {
            Logging.Log3("No LDML Special longDateDayOfWeekSeparator symbol to write ");
        }
        if (longDateDaySeparator != null) {
            this.print("<openOffice:longDateDaySeparator>");
            this.print(longDateDaySeparator);
            this.println("</openOffice:longDateDaySeparator>");
        } else {
            Logging.Log3("No LDML Special longDateDaySeparator symbol to write ");
        }
        if (longDateMnothSeparator != null) {
            this.print("<openOffice:longDateMonthSeparator>");
            this.print(longDateMnothSeparator);
            this.println("</openOffice:longDateMonthSeparator>");
        } else {
            Logging.Log3("No LDML Special longDateMnothSeparator symbol to write ");
        }
        if (longDateYearSeparator != null) {
            this.print("<openOffice:longDateYearSeparator>");
            this.print(longDateYearSeparator);
            this.println("</openOffice:longDateYearSeparator>");
        } else {
            Logging.Log3("No LDML Special longDateYearSeparator symbol to write ");
        }
        if (time100SecSeparator != null) {
            this.print("<openOffice:time100SecSeparator>");
            this.print(time100SecSeparator);
            this.println("</openOffice:time100SecSeparator>");
        } else {
            Logging.Log3("No LDML Special time100SecSeparator symbol to write ");
        }
        this.outdent();
        this.printlnNS("openOffice", "separators", false);
    }

    protected void writeFormats(Hashtable formatElements, Hashtable patterns, Hashtable defaultNames, String fmts, String fmtLength, String fmt, String calendar) {
        if ((String)this.m_Aliases.get("format") != null) {
            return;
        }
        if (formatElements == null || formatElements.size() == 0 || patterns == null || patterns.size() == 0 || defaultNames == null || fmts == null || fmtLength == null || fmt == null) {
            Logging.Log1("No LDML " + fmts + " data to write ");
            return;
        }
        this.println("<" + fmts + ">");
        this.indent();
        this.writeFormatLengths(formatElements, patterns, defaultNames, "long", fmtLength, fmt);
        this.writeFormatLengths(formatElements, patterns, defaultNames, "medium", fmtLength, fmt);
        this.writeFormatLengths(formatElements, patterns, defaultNames, "short", fmtLength, fmt);
        if (fmts.compareTo("dateTimeFormats") == 0) {
            this.writeFlexibleDateTime(this.m_flexDateTimePatterns, calendar);
        }
        this.outdent();
        this.println("</" + fmts + ">");
    }

    protected void writeFormatLengths(Hashtable formatElements, Hashtable patterns, Hashtable defaultNames, String type, String fmtLength, String fmt) {
        this.println("<" + fmtLength + " " + "type" + "=\"" + type + "\">");
        this.indent();
        String def = (String)formatElements.get("default " + type);
        if (def != null) {
            this.println("<default type=\"" + def + "\"/>");
        } else {
            Logging.Log4("No LDML Special default to write for " + fmtLength + " " + type);
        }
        Enumeration keys = formatElements.keys();
        Enumeration data = formatElements.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object obj = data.nextElement();
            if (obj instanceof String) continue;
            Hashtable inner = (Hashtable)obj;
            Enumeration keys_inner = inner.keys();
            Enumeration data_inner = inner.elements();
            while (keys_inner.hasMoreElements()) {
                String key_inner = (String)keys_inner.nextElement();
                String datum_inner = (String)data_inner.nextElement();
                if (key_inner.compareTo("type") != 0 || type.compareTo(datum_inner) != 0) continue;
                this.println("<" + fmt + " " + "type" + "=\"" + key + "\">");
                this.indent();
                String pattern = (String)patterns.get(key);
                if (pattern != null) {
                    this.print("<pattern>");
                    this.print(pattern);
                    this.println("</pattern>");
                } else {
                    Logging.Log3("No LDML Special pattern to write for " + fmt + " " + key);
                }
                String defaultName = (String)defaultNames.get(key);
                if (defaultName == null) {
                    this.printSpecial("openOffice", "http://www.openOffice.org", inner, false, true);
                } else {
                    this.printSpecial("openOffice", "http://www.openOffice.org", inner, true, true);
                    this.indent();
                    Hashtable attribs = new Hashtable();
                    this.printNS("openOffice", "defaultName", attribs, true, true, false);
                    this.print(defaultName);
                    this.printlnNS("openOffice", "defaultName", false);
                    this.outdent();
                    this.println("</special>");
                }
                this.outdent();
                this.println("</" + fmt + ">");
            }
        }
        this.outdent();
        this.println("</" + fmtLength + ">");
    }

    protected void writeFlexibleDateTime(Vector patterns, String calendar) {
        if (patterns == null) {
            Logging.Log3("Not writing flexible date time formsts (N.B. this is a CLDR 1.4 feature)");
            return;
        }
        this.println("<availableFormats>");
        this.indent();
        Vector<String> patterns_no_dups = new Vector<String>();
        for (int i = 0; i < patterns.size(); ++i) {
            String pattern = (String)patterns.elementAt(i);
            if (!patterns_no_dups.contains(pattern)) {
                patterns_no_dups.add(pattern);
                continue;
            }
            System.err.println("INFO: Skipping duplicate pattern : " + pattern + " for availableFormats");
        }
        int index = 0;
        for (int i = 0; i < patterns_no_dups.size(); ++i) {
            String pattern = (String)patterns_no_dups.elementAt(i);
            if (pattern == null || pattern.indexOf(91) != -1) continue;
            this.print("<dateFormatItem id=\"" + Integer.toString(++index) + "\">");
            this.print(pattern);
            this.println("</dateFormatItem>");
        }
        this.outdent();
        this.println("</availableFormats>");
    }

    protected void writeSpecialFormat(Vector format) {
        if (format == null || format.size() == 0) {
            Logging.Log1("No LDML Special format replaceTo or replaceFrom data to write ");
            return;
        }
        Hashtable attribs = (Hashtable)format.elementAt(0);
        if ((String)this.m_Aliases.get("format") == null) {
            attribs.remove("ref");
        }
        if (attribs.size() == 0) {
            Logging.Log3("No LDML Special format replaceTo or replaceFrom data to write");
        }
        this.printNS("openOffice", "format", attribs, true, false, true);
    }

    private void writeLocale(Hashtable data) {
        if (data == null || data.size() == 0) {
            Logging.Log1("No LDML openOddice:locale data to write ");
            return;
        }
        this.print("<openOffice:locale");
        String str = (String)data.get("versionDTD");
        if (str != null) {
            this.print(" openOffice:versionDTD=\"" + str + "\"");
        } else {
            Logging.Log1("No openOffice:versionDTD to write");
        }
        str = (String)data.get("allowUpdateFromCLDR");
        if (str != null) {
            this.print(" openOffice:allowUpdateFromCLDR=\"" + str + "\"");
        } else {
            Logging.Log1("No openOffice:allowUpdateFromCLDR to write");
        }
        str = (String)data.get("version");
        if (str != null) {
            this.print(" openOffice:version=\"" + str + "\"");
        } else {
            Logging.Log1("No openOffice:version to write");
        }
        this.println("/>");
    }
}

