/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import com.ibm.icu.dev.tool.UOption;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.LDMLReaderForOO;
import org.unicode.cldr.ooo.LDMLToOOMapper;
import org.unicode.cldr.ooo.Logging;
import org.unicode.cldr.ooo.OOLocaleWriter;
import org.unicode.cldr.ooo.Utilities;
import org.unicode.cldr.ooo.supplementalData;

public class LDMLToOOConverter {
    private double m_cldr_ver = 0.0;
    private supplementalData m_suppData = null;
    private boolean m_bRoundTrip = false;
    private boolean m_bTemplate = false;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int FORCE_OVERWRITE = 2;
    private static final int LOCALE = 3;
    private static final int OOO_LDML_DIR = 4;
    private static final int CLDR_DIR = 5;
    private static final int SUPP_DIR = 6;
    private static final int OUT_DIR = 7;
    private static final int SKIP_IF_NO_CLDR = 8;
    private static final int TEMPLATE = 9;
    private static final UOption[] m_options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create((String)"force_overwrite", (char)'f', (int)0), UOption.create((String)"locale", (char)'l', (int)1).setDefault(null), UOption.create((String)"ooo_ldml_dir", (char)'o', (int)1).setDefault(null), UOption.create((String)"cldr_dir", (char)'c', (int)1).setDefault(null), UOption.create((String)"supp_dir", (char)'s', (int)1).setDefault(null), UOption.create((String)"out_dir", (char)'t', (int)1).setDefault(null), UOption.create((String)"skip_if_no_cldr", (char)'k', (int)0), UOption.create((String)"template", (char)'e', (int)0)};

    public static void main(String[] args) {
        LDMLToOOConverter converter = new LDMLToOOConverter();
        converter.processArgs(args);
    }

    LDMLToOOConverter() {
    }

    private void processArgs(String[] args) {
        UOption.parseArgs((String[])args, (UOption[])m_options);
        if (LDMLToOOConverter.m_options[4].value == null && LDMLToOOConverter.m_options[5].value == null || LDMLToOOConverter.m_options[6].value == null) {
            this.printUsage();
        }
        try {
            String locale = LDMLToOOConverter.m_options[3].value;
            this.m_suppData = new supplementalData(LDMLToOOConverter.m_options[6].value);
            if (locale != null) {
                this.processSingle(locale, "./" + locale + ".xml");
            } else {
                this.processBulk();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processBulk() {
        String ooo_ldml_dir = LDMLToOOConverter.m_options[4].value;
        String cldr_dir = LDMLToOOConverter.m_options[5].value;
        String out_dir = LDMLToOOConverter.m_options[7].value;
        if (ooo_ldml_dir == null && cldr_dir == null || out_dir == null) {
            this.printError("Either input or output diorectories have not been specified");
            return;
        }
        File out = new File(out_dir);
        if (!out.isDirectory()) {
            out.mkdir();
        }
        XMLFileFilter filter = new XMLFileFilter();
        File inDir = null;
        String[] files = null;
        String locale = null;
        String out_file = null;
        if (ooo_ldml_dir != null) {
            inDir = new File(ooo_ldml_dir);
            if (!inDir.exists()) {
                this.printError("the specified OpenOffice.org input dir does not exist");
                return;
            }
        } else if (cldr_dir != null && !(inDir = new File(cldr_dir)).exists()) {
            this.printError("the specified CLDR input dir does not exist");
            return;
        }
        int converted = 0;
        int skippedExisting = 0;
        int filesOverwritten = 0;
        files = inDir.list(filter);
        for (int i = 0; i < files.length; ++i) {
            locale = Utilities.extractLocaleFromFilename(files[i]);
            out_file = out_dir + "/" + locale + ".xml";
            File f = new File(out_file);
            if (f.exists()) {
                if (LDMLToOOConverter.m_options[2].doesOccur) {
                    this.processSingle(locale, out_file);
                    ++filesOverwritten;
                    continue;
                }
                this.printWarning("The file " + out_file + " exists and will not be overwritten.");
                ++skippedExisting;
                continue;
            }
            this.processSingle(locale, out_file);
            ++converted;
        }
        System.err.println("Conversion complete.  Total of " + converted + " file(s) converted.");
        if (skippedExisting > 0) {
            System.err.println(skippedExisting + " file(s) were not converted because the destination files already existed.");
            System.err.println("Use the -help option to learn about forcing overwrite.");
        }
        if (filesOverwritten > 0) {
            System.err.println(filesOverwritten + " file(s) were overwritten in the destination folder.");
        }
    }

    private boolean processSingle(String locale, String out_file) {
        System.err.println("Processing : " + locale);
        String cldr_file = null;
        String ooo_ldml_file = null;
        String cldrLocale = null;
        if (LDMLToOOConverter.m_options[5].value != null) {
            cldrLocale = this.handleNonCLDRLocales(locale);
            cldr_file = LDMLToOOConverter.m_options[5].value + "/" + cldrLocale + ".xml";
        }
        if (LDMLToOOConverter.m_options[4].value != null) {
            ooo_ldml_file = LDMLToOOConverter.m_options[4].value + "/" + locale + ".xml";
        }
        if (cldr_file == null && ooo_ldml_file == null) {
            this.printWarning("Skipping this locale " + locale + " as no input files found");
            return false;
        }
        File cldr_f = null;
        if (cldr_file != null) {
            cldr_f = new File(cldr_file);
        }
        File ooo_ldml_f = null;
        if (ooo_ldml_file != null) {
            ooo_ldml_f = new File(ooo_ldml_file);
        }
        if (!(cldr_f != null && cldr_f.exists() || ooo_ldml_f != null && ooo_ldml_f.exists())) {
            this.printWarning("Skipping this locale " + locale + " as no source OpenOffice.org LDML or CLDR file were not found");
            return false;
        }
        LDMLReaderForOO reader_ooo_ldml = null;
        LDMLReaderForOO reader_cldr = null;
        LDMLReaderForOO reader_cldr_temp = null;
        if (cldr_file != null && cldr_f.exists()) {
            reader_cldr = new LDMLReaderForOO(cldr_file);
            reader_cldr.readDocument(cldrLocale, true);
            this.m_cldr_ver = reader_cldr.getCLDRVersion();
            if (!reader_cldr.readInXML(true)) {
                this.printWarning("Failed to read CLDR file: " + cldr_file);
            }
        } else {
            if (LDMLToOOConverter.m_options[8].doesOccur) {
                this.printWarning("No such CLDR locale, no output written");
                return false;
            }
            this.printWarning("Not using CLDR data, writing back the OO.o data");
            this.m_bRoundTrip = true;
        }
        if (ooo_ldml_file != null && ooo_ldml_f.exists()) {
            reader_ooo_ldml = new LDMLReaderForOO(ooo_ldml_file);
            reader_ooo_ldml.readDocument(locale, false);
            if (!reader_ooo_ldml.readInXML(false)) {
                this.printWarning("Failed to read OpenOffice.org LDML file: " + ooo_ldml_file);
                return false;
            }
        } else {
            reader_ooo_ldml = reader_cldr;
        }
        if (reader_ooo_ldml == null && reader_cldr == null) {
            this.printWarning("Skipping this locale " + locale + " as failed to read OpenOffice.org LDML and CLDR files");
            return false;
        }
        if (this.m_bRoundTrip) {
            reader_cldr = reader_ooo_ldml;
        }
        PrintStream ps = LDMLToOOConverter.setLocaleWriter(locale, null, out_file);
        this.m_bTemplate = LDMLToOOConverter.m_options[9].doesOccur;
        OOLocaleWriter writer = new OOLocaleWriter(ps, this.m_bTemplate);
        Hashtable aliases = new Hashtable();
        writer.setAliases(aliases);
        writer.open(reader_ooo_ldml.m_LocaleInfo);
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        if (reader_ooo_ldml.m_LangDefaultName != null) {
            data.put("Language", reader_ooo_ldml.m_LangDefaultName);
        }
        if (reader_ooo_ldml.m_LangID != null) {
            data.put("LangID", reader_ooo_ldml.m_LangID);
        }
        if (reader_ooo_ldml.m_TerritoryDefaultName != null) {
            data.put("Country", reader_ooo_ldml.m_TerritoryDefaultName);
        }
        if (reader_ooo_ldml.m_TerritoryID != null) {
            data.put("CountryID", reader_ooo_ldml.m_TerritoryID);
        }
        if (reader_ooo_ldml.m_PlatformID != null && reader_ooo_ldml.m_PlatformID.length() > 0) {
            data.put("PlatformID", reader_ooo_ldml.m_PlatformID);
        }
        if (reader_ooo_ldml.m_Variant != null && reader_ooo_ldml.m_Variant.length() > 0) {
            data.put("Variant", reader_ooo_ldml.m_Variant);
        }
        writer.writeLC_INFO(data);
        data.clear();
        Hashtable<String, String> separators = new Hashtable<String, String>();
        if (reader_ooo_ldml.m_DateSeparator != null) {
            separators.put("DateSeparator", reader_ooo_ldml.m_DateSeparator);
        }
        if (reader_cldr.m_ThousandSeparator != null) {
            separators.put("ThousandSeparator", reader_cldr.m_ThousandSeparator);
        }
        if (reader_cldr.m_DecimalSeparator != null) {
            separators.put("DecimalSeparator", reader_cldr.m_DecimalSeparator);
        }
        if (reader_ooo_ldml.m_TimeSeparator != null) {
            separators.put("TimeSeparator", reader_ooo_ldml.m_TimeSeparator);
        }
        if (reader_ooo_ldml.m_Time100SecSeparator != null) {
            separators.put("Time100SecSeparator", reader_ooo_ldml.m_Time100SecSeparator);
        }
        if (reader_cldr.m_ListSeparator != null) {
            separators.put("ListSeparator", reader_cldr.m_ListSeparator);
        }
        if (reader_ooo_ldml.m_LongDateDayOfWeekSeparator != null) {
            separators.put("LongDateDayOfWeekSeparator", reader_ooo_ldml.m_LongDateDayOfWeekSeparator);
        }
        if (reader_ooo_ldml.m_LongDateDaySeparator != null) {
            separators.put("LongDateDaySeparator", reader_ooo_ldml.m_LongDateDaySeparator);
        }
        if (reader_ooo_ldml.m_LongDateMonthSeparator != null) {
            separators.put("LongDateMonthSeparator", reader_ooo_ldml.m_LongDateMonthSeparator);
        }
        if (reader_ooo_ldml.m_LongDateYearSeparator != null) {
            separators.put("LongDateYearSeparator", reader_ooo_ldml.m_LongDateYearSeparator);
        }
        if (separators != null && separators.size() > 0) {
            data.put("Separators", separators);
        }
        Hashtable<String, String> markers = new Hashtable<String, String>();
        LDMLReaderForOO markerReader = null;
        markerReader = this.m_bTemplate ? reader_cldr : reader_ooo_ldml;
        if (markerReader.m_QuotationStart != null) {
            markers.put("QuotationStart", markerReader.m_QuotationStart);
        }
        if (markerReader.m_QuotationEnd != null) {
            markers.put("QuotationEnd", markerReader.m_QuotationEnd);
        }
        if (markerReader.m_DoubleQuotationStart != null) {
            markers.put("DoubleQuotationStart", markerReader.m_DoubleQuotationStart);
        }
        if (markerReader.m_DoubleQuotationEnd != null) {
            markers.put("DoubleQuotationEnd", markerReader.m_DoubleQuotationEnd);
        }
        if (markers.size() > 0) {
            data.put("Markers", markers);
        }
        if (reader_cldr.m_TimeAM != null && reader_cldr.m_TimeAM.length() > 0) {
            data.put("TimeAM", reader_cldr.m_TimeAM);
        }
        if (reader_cldr.m_TimePM != null && reader_cldr.m_TimePM.length() > 0) {
            data.put("TimePM", reader_cldr.m_TimePM);
        }
        String ms = null;
        if (this.m_cldr_ver > 1.399 && !this.m_bRoundTrip) {
            ms = this.m_suppData.getMessSys(reader_ooo_ldml.m_TerritoryID);
        } else if (reader_cldr.m_MeasurementSystem != null) {
            ms = LDMLToOOMapper.MapMeasurementSystem(reader_cldr.m_MeasurementSystem);
        }
        if (ms != null && ms.length() > 0) {
            data.put("MeasurementSystem", ms);
        }
        if (data != null && data.size() > 0) {
            writer.writeLC_CTYPE(data);
        }
        data.clear();
        if (reader_ooo_ldml.m_FormatRefLocale != null) {
            writer.writeLC_FORMATRef(reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo, reader_ooo_ldml.m_FormatRefLocale);
        } else if (this.m_bTemplate) {
            writer.writeLC_FORMAT_template();
        } else {
            boolean lcformatOpened = false;
            Hashtable m_outFormatElements = new Hashtable();
            Hashtable m_outFormatCodes = new Hashtable();
            Hashtable m_outFormatDefaultNames = new Hashtable();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_FixedNFormats, reader_ooo_ldml.m_FixedNPatterns, reader_ooo_ldml.m_FixedNOO, reader_ooo_ldml.m_FixedDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            m_outFormatElements.clear();
            m_outFormatCodes.clear();
            m_outFormatDefaultNames.clear();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_SciNFormats, reader_ooo_ldml.m_SciNPatterns, reader_ooo_ldml.m_SciNOO, reader_ooo_ldml.m_SciDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            m_outFormatElements.clear();
            m_outFormatCodes.clear();
            m_outFormatDefaultNames.clear();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_PercNFormats, reader_ooo_ldml.m_PercNPatterns, reader_ooo_ldml.m_PercNOO, reader_ooo_ldml.m_PercDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            m_outFormatElements.clear();
            m_outFormatCodes.clear();
            m_outFormatDefaultNames.clear();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_CurrNFormats, reader_ooo_ldml.m_CurrNPatterns, reader_ooo_ldml.m_CurrNOO, reader_ooo_ldml.m_CurrNDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            m_outFormatElements.clear();
            m_outFormatCodes.clear();
            m_outFormatDefaultNames.clear();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_DateFormats, reader_ooo_ldml.m_DatePatterns, reader_ooo_ldml.m_DateOO, reader_ooo_ldml.m_DateDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            m_outFormatElements.clear();
            m_outFormatCodes.clear();
            m_outFormatDefaultNames.clear();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_TimeFormats, reader_ooo_ldml.m_TimePatterns, reader_ooo_ldml.m_TimeOO, reader_ooo_ldml.m_TimeDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            m_outFormatElements.clear();
            m_outFormatCodes.clear();
            m_outFormatDefaultNames.clear();
            LDMLToOOMapper.MapFormatElements(reader_ooo_ldml.m_DateTimeFormats, reader_ooo_ldml.m_DateTimePatterns, reader_ooo_ldml.m_DateTimeOO, reader_ooo_ldml.m_DateTimeDefaultName, m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames);
            lcformatOpened = writer.writeLC_FORMAT(m_outFormatElements, m_outFormatCodes, m_outFormatDefaultNames, lcformatOpened, reader_ooo_ldml.m_FormatReplaceFrom, reader_ooo_ldml.m_FormatReplaceTo);
            writer.writeCloseLC_FORMAT(lcformatOpened);
        }
        if (this.m_bTemplate) {
            writer.writeLC_COLLATION_template();
        } else {
            data.clear();
            if (reader_ooo_ldml.m_Collators != null && reader_ooo_ldml.m_Collators.size() > 0) {
                LDMLToOOMapper.MapCollators(reader_ooo_ldml.m_Collators);
                data.put("Collator", reader_ooo_ldml.m_Collators);
            }
            if (reader_ooo_ldml.m_CollationOptions != null && reader_ooo_ldml.m_CollationOptions.size() > 0) {
                data.put("CollationOptions", reader_ooo_ldml.m_CollationOptions);
            }
            writer.writeLC_COLLATION(data, reader_ooo_ldml.m_CollationRefLocale);
        }
        if (this.m_bTemplate) {
            writer.writeLC_SEARCH_template();
        } else {
            writer.writeLC_SEARCH(reader_ooo_ldml.m_SearchOptions, reader_ooo_ldml.m_SearchRefLocale);
        }
        if (this.m_bTemplate) {
            writer.writeLC_INDEX_template();
        } else {
            data.clear();
            if (reader_ooo_ldml.m_IndexKeys != null && reader_ooo_ldml.m_IndexKeys.size() > 0) {
                LDMLToOOMapper.MapIndexKeys(reader_ooo_ldml.m_IndexKeys);
                data.put("IndexKey", reader_ooo_ldml.m_IndexKeys);
            }
            if (reader_ooo_ldml.m_IndexUnicodeScript != null && reader_ooo_ldml.m_IndexUnicodeScript.size() > 0) {
                data.put("UnicodeScript", reader_ooo_ldml.m_IndexUnicodeScript);
            }
            if (reader_ooo_ldml.m_IndexFollowPageWord != null && reader_ooo_ldml.m_IndexFollowPageWord.size() > 0) {
                data.put("FollowPageWord", reader_ooo_ldml.m_IndexFollowPageWord);
            }
            writer.writeLC_INDEX(data, reader_ooo_ldml.m_IndexRefLocale);
        }
        data.clear();
        if (locale.compareTo("ja_JP") == 0 || locale.compareTo("ko_KR") == 0) {
            reader_cldr_temp = reader_cldr;
            reader_cldr = reader_ooo_ldml;
        }
        Vector outCalendarTypes = new Vector();
        LDMLToOOMapper.MapCalendar(reader_cldr.m_CalendarTypes, outCalendarTypes, locale);
        if (outCalendarTypes.size() > 0) {
            data.put("unoid", outCalendarTypes);
        }
        data.put("default", "gregorian");
        if (reader_cldr.m_AbbrDays != null && reader_cldr.m_AbbrDays.size() > 0) {
            Hashtable abbrDays = LDMLToOOMapper.MapDays(reader_cldr.m_AbbrDays, locale);
            data.put("DaysOfWeek.DefaultAbbrvName", abbrDays);
        }
        if (reader_cldr.m_FullDays != null && reader_cldr.m_FullDays.size() > 0) {
            Hashtable fullDays = LDMLToOOMapper.MapDays(reader_cldr.m_FullDays, locale);
            data.put("DaysOfWeek.DefaultFullName", fullDays);
        }
        if (reader_cldr.m_AbbrMonths != null && reader_cldr.m_AbbrMonths.size() > 0) {
            Hashtable abbrMonths = LDMLToOOMapper.MapMonths(reader_cldr.m_AbbrMonths, locale);
            data.put("MonthsOfYear.DefaultAbbrvName", abbrMonths);
        }
        if (reader_cldr.m_FullMonths != null && reader_cldr.m_FullMonths.size() > 0) {
            Hashtable fullMonths = LDMLToOOMapper.MapMonths(reader_cldr.m_FullMonths, locale);
            data.put("MonthsOfYear.DefaultFullName", fullMonths);
        }
        LDMLReaderForOO wideEraReader = null;
        wideEraReader = this.m_bTemplate ? reader_cldr : reader_ooo_ldml;
        if (wideEraReader.m_EraNames != null && reader_ooo_ldml.m_EraNames.size() > 0 || reader_cldr.m_AbbrEras != null && reader_cldr.m_AbbrEras.size() > 0) {
            Hashtable eras = null;
            eras = locale.compareTo("zh_TW") == 0 ? LDMLToOOMapper.MapEras(reader_ooo_ldml.m_EraNames, reader_ooo_ldml.m_AbbrEras, locale) : LDMLToOOMapper.MapEras(wideEraReader.m_EraNames, reader_cldr.m_AbbrEras, locale);
            if (eras != null && eras.size() > 0) {
                data.put("Eras", eras);
            }
        }
        Hashtable<String, String> startOfWeeks = null;
        if (locale.substring(0, 2).equals("eo") || locale.substring(0, 2).equals("ia") || locale.substring(0, 2).equals("eu")) {
            startOfWeeks = LDMLToOOMapper.MapStartOfWeeks(reader_ooo_ldml.m_StartOfWeeks, locale);
        } else if (this.m_cldr_ver > 1.399 && !this.m_bRoundTrip) {
            String firstDay = this.m_suppData.getFirstDay(reader_ooo_ldml.m_TerritoryID);
            startOfWeeks = new Hashtable<String, String>();
            startOfWeeks.put("gregorian", firstDay);
        } else if (reader_cldr.m_StartOfWeeks != null && reader_cldr.m_StartOfWeeks.size() > 0) {
            startOfWeeks = LDMLToOOMapper.MapStartOfWeeks(reader_cldr.m_StartOfWeeks, locale);
        }
        if (startOfWeeks != null) {
            data.put("StartDayOfWeek", startOfWeeks);
        }
        Hashtable<String, String> minDays = null;
        if (locale.substring(0, 2).equals("eo") || locale.substring(0, 2).equals("ia") || locale.substring(0, 2).equals("eu")) {
            minDays = LDMLToOOMapper.MapMinDays(reader_ooo_ldml.m_MinDays, locale);
        } else if (this.m_cldr_ver > 1.399 && !this.m_bRoundTrip) {
            String min = this.m_suppData.getMinDays(reader_ooo_ldml.m_TerritoryID);
            minDays = new Hashtable<String, String>();
            minDays.put("gregorian", min);
        } else if (reader_cldr.m_MinDays != null && reader_cldr.m_MinDays.size() > 0) {
            minDays = LDMLToOOMapper.MapMinDays(reader_cldr.m_MinDays, locale);
        }
        if (minDays != null) {
            data.put("MinimalDaysInFirstWeek", minDays);
        }
        if (data.size() > 0) {
            writer.writeLC_CALENDAR(data);
        }
        if (locale.compareTo("ja_JP") == 0 || locale.compareTo("ko_KR") == 0) {
            reader_cldr = reader_cldr_temp;
        }
        data.clear();
        if (locale.substring(0, 2).equals("eo") || locale.substring(0, 2).equals("ia") || locale.substring(0, 2).equals("eu")) {
            reader_cldr_temp = reader_cldr;
            reader_cldr = reader_ooo_ldml;
            this.m_bRoundTrip = true;
        }
        writer.WriteLC_CURRENCY(reader_cldr.m_CurrencyData_cldr, reader_ooo_ldml.m_CurrencyData_ooo, this.m_suppData, this.m_bRoundTrip, reader_ooo_ldml.m_TerritoryID);
        this.diagnostics(reader_ooo_ldml, reader_cldr, locale);
        if (locale.substring(0, 2).equals("eo") || locale.substring(0, 2).equals("ia") || locale.substring(0, 2).equals("eu")) {
            reader_cldr = reader_cldr_temp;
            this.m_bRoundTrip = false;
        }
        if (this.m_bTemplate) {
            writer.writeLC_TRANSLITERATIONS_template();
        } else {
            Vector transliterations = null;
            if (reader_ooo_ldml.m_TransliterationAtts != null && reader_ooo_ldml.m_TransliterationAtts.size() > 0) {
                transliterations = LDMLToOOMapper.MapTransliterations(reader_ooo_ldml.m_TransliterationAtts);
            }
            writer.WriteLC_TRANSLITERATIONS(transliterations, reader_ooo_ldml.m_TransliterationRefLocale);
        }
        data.clear();
        String ref = null;
        if (reader_ooo_ldml.m_ReservedRefLocale != null && reader_ooo_ldml.m_ReservedRefLocale.length() > 0) {
            ref = reader_ooo_ldml.m_ReservedRefLocale;
        } else if (reader_ooo_ldml.m_ForbiddenRefLocale != null && reader_ooo_ldml.m_ForbiddenRefLocale.length() > 0) {
            ref = reader_ooo_ldml.m_ForbiddenRefLocale;
        }
        if (reader_ooo_ldml.m_ReservedWords != null && reader_ooo_ldml.m_ReservedWords.size() > 0 || this.m_bTemplate) {
            String forbiddenLineEnd;
            String forbiddenLineBeg;
            Hashtable reservedWords = LDMLToOOMapper.MapReservedWords(reader_ooo_ldml.m_ReservedWords);
            if (this.m_bTemplate) {
                reservedWords = new Hashtable();
                LDMLToOOMapper.MapQuarters(reservedWords, reader_cldr.m_AbbrQuarters, reader_cldr.m_WideQuarters);
            } else {
                LDMLToOOMapper.MapQuarters(reservedWords, reader_ooo_ldml.m_AbbrQuarters, reader_ooo_ldml.m_WideQuarters);
            }
            if (reservedWords != null && reservedWords.size() > 0) {
                data.put("ReservedWords", reservedWords);
            }
            if ((forbiddenLineBeg = reader_ooo_ldml.m_ForbiddenLineBeg) != null && forbiddenLineBeg.length() > 0) {
                data.put("ForbiddenLineBeginCharacters", forbiddenLineBeg);
            }
            if ((forbiddenLineEnd = reader_ooo_ldml.m_ForbiddenLineEnd) != null && forbiddenLineEnd.length() > 0) {
                data.put("ForbiddenLineEndCharacters", forbiddenLineEnd);
            }
        }
        writer.WriteLC_MISC(data, ref);
        if (this.m_bTemplate) {
            writer.writeLC_NumberingLevel_template();
        } else {
            Vector numberingLevelsAttsOO = null;
            if (reader_ooo_ldml.m_NumberingLevelAtts != null && reader_ooo_ldml.m_NumberingLevelAtts.size() > 0) {
                numberingLevelsAttsOO = LDMLToOOMapper.MapNumberingLevels(reader_ooo_ldml.m_NumberingLevelAtts);
            }
            writer.WriteLC_NumberingLevel(numberingLevelsAttsOO, reader_ooo_ldml.m_NumberingRefLocale);
        }
        if (this.m_bTemplate) {
            writer.writeLC_OutlineNumberingLevel_template();
        } else {
            Vector outlineNumberingLevelsOO = null;
            if (reader_ooo_ldml.m_OutlineNumberingLevels != null && reader_ooo_ldml.m_OutlineNumberingLevels.size() > 0) {
                outlineNumberingLevelsOO = LDMLToOOMapper.MapOutlineNumberingLevels(reader_ooo_ldml.m_OutlineNumberingLevels);
            }
            writer.WriteLC_OutlineNumberingLevel(outlineNumberingLevelsOO, reader_ooo_ldml.m_OutlineNumberingRefLocale);
        }
        writer.close();
        System.err.println("Writing :  " + out_file);
        return true;
    }

    void printUsage() {
        System.err.println("");
        System.err.println("DESCRIPTION:");
        System.err.println("  LDMLToOOConverter converts LDML XML files to OpenOffice.org XML files.");
        System.err.println("  There are 3 ways to use the tool :");
        System.err.println("  1. Conversion back to OpenOffice.org XML of data which was previously converted to LDML.");
        System.err.println("     this is a simple round trip conversion which is useful for testing the tools");
        System.err.println("     Example : LDMLToOOConverter -s /supplemental_dir -o ooo_dir -t OOO/");
        System.err.println("  2. Conversion to OO XML of OpenOffice.org specific data from 1 above merged with CLDR standard data.");
        System.err.println("     this is the step to perform when it is desired to migrate OpenOffice.org data to CLDR");
        System.err.println("     Example : LDMLToOOConverter -s supplemental_dir -c cldr_dir -o ooo_dir -t OOO/");
        System.err.println("  3. Conversion of CLDR data only to OpenOffice.org format.");
        System.err.println("     this is the step to perform when generating date for a brand new OpenOffice.org locale");
        System.err.println("     Example : LDMLToOOConverter -s supplemental_dir -l ga_IE -c cldr_dir");
        System.err.println("");
        System.err.println("USAGE:");
        System.err.println("  For single file conversion:");
        System.err.println("    LDMLToOOConverter [-f] -l LOCALE_NAME -c CLDR_DIR");
        System.err.println("  For bulk file conversion:");
        System.err.println("    LDMLToOOConverter [-f] -c CLDR_DIR -o OOO_LDML_DIRECTORY -t DESTINATION_DIRECTORY");
        System.err.println("      if the -l option is not specified then a bulk conversion is performed");
        System.err.println("  DESTINATION_DIRECTORY will be created if it does not exist.");
        System.err.println("");
        System.err.println("OPTIONS:");
        System.err.println("  -f         force overwrite of destination file if it already exists");
        System.err.println("  -c         specifies dir containing CLDR data");
        System.err.println("  -l         specifies single locale to be converted to OpenOffice.org format");
        System.err.println("  -o         the folder containing OpenOffice.org data in LDML format");
        System.err.println("  -s         the folder containing CLDR's supplementalData.xml (this is needed)");
        System.err.println("  -t         the folder where output is written for bulk conversion (mandatory)");
        System.err.println("  -k         write no output if this locale does not occur in CLDR");
        System.err.println("  -e         generate OO.o template file for new locales (OO.o specific elements are empty)");
        System.err.println("  -help      (this document) usage of LDMLToOOConverter");
        System.err.println("");
    }

    void printError(String err) {
        System.err.println("Processing was unsuccessful : " + err);
        System.err.println("Use \"LDMLToOOConverter -h\" for usage");
    }

    void printWarning(String warning) {
        System.err.println("(Warning) " + warning);
    }

    public static PrintStream setLocaleWriter(String localeStr, String enc, String in_filename) {
        if (localeStr == null || in_filename == null) {
            return null;
        }
        PrintStream ps = null;
        try {
            String fileName = in_filename;
            if (fileName != null && fileName.compareTo("") != 0) {
                FileOutputStream fos = new FileOutputStream(new File(fileName));
                ps = new PrintStream((OutputStream)fos, true, "UTF8");
                Logging.Log1("Writing to file : " + fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to create output file");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Unsupported encoding");
        }
        return ps;
    }

    private String handleNonCLDRLocales(String localeStr) {
        String cldrLocale = localeStr;
        if (localeStr.compareTo("no_NO") == 0) {
            cldrLocale = "nb_NO";
        }
        return cldrLocale;
    }

    private void diagnostics(LDMLReaderForOO reader_ooo_ldml, LDMLReaderForOO reader_cldr, String locale) {
        if (locale.indexOf("_") < 0) {
            return;
        }
        try {
            Vector v;
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter("currency.txt", true));
            out.write(locale + " :\n");
            String cldr_def_code = (String)this.m_suppData.getCurrencies(reader_ooo_ldml.m_TerritoryID).elementAt(0);
            String ooo_def_code = "";
            for (i = 0; i < reader_ooo_ldml.m_CurrencyData_ooo.size(); ++i) {
                v = (Vector)reader_ooo_ldml.m_CurrencyData_ooo.elementAt(i);
                if (!((String)v.elementAt(5)).equals("true")) continue;
                ooo_def_code = (String)v.elementAt(2);
                break;
            }
            if (!cldr_def_code.equals(ooo_def_code)) {
                out.write("\tDefault=true  :  CLDR = " + cldr_def_code + "    OO.org = " + ooo_def_code + "\n");
                for (i = 0; i < reader_cldr.m_CurrencyData_cldr.size(); ++i) {
                    v = (Vector)reader_cldr.m_CurrencyData_cldr.elementAt(i);
                    if (!((String)v.elementAt(2)).equals(cldr_def_code)) continue;
                    out.write("\t\t CLDR iso4217 code = " + cldr_def_code + "  Symbol = " + (String)v.elementAt(1) + "  Display Name = " + (String)v.elementAt(3) + "\n");
                    break;
                }
            }
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected class XMLFileFilter
    implements FilenameFilter {
        protected XMLFileFilter() {
        }

        public boolean accept(File dir, String filename) {
            boolean accepted = false;
            if (filename != null && filename.length() > 4) {
                accepted = filename.substring(filename.length() - 4).toLowerCase().compareTo(".xml") == 0;
            }
            return accepted;
        }
    }
}

