/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import org.unicode.cldr.ooo.OOLocaleReader;

public class OOComparator {
    private static final String STRING_SEPARATOR = ",";
    private static final int OPT_SINGLE = 1;
    private static final int OPT_BULK = 2;
    private static final int OPT_UNRESOLVED_REFS = 4;
    private static final int OPT_SOLUTIONS = 8;
    private static final int OPT_INVALID = 16384;
    private static final int OPT_UNKNOWN = 32768;
    private static final String OPT_SINGLE_STR = "-single";
    private static final String OPT_BULK_STR = "-bulk";
    private static final String OPT_SHOW_REFS_STR = "-show_refs";
    private static final String OPT_SOLUTIONS_STR = "-solutions";
    private static final String MISSING_ATT = "(missing_att)";
    private static final String MISSING_ELEM = "(missing_element)";
    private int m_iOptions = 0;
    private Calendar cal = Calendar.getInstance();
    private Vector m_XMLfiles = new Vector();
    private Vector m_XMLdirs = new Vector();
    private Vector m_TableInfo = new Vector();
    private int m_ArgsCounter = 0;
    private int m_CurrNumFiles = 0;
    private int m_DiffCounter = 0;
    private int m_CommonCounter = 0;
    private int m_TotalNumLocales = 0;
    private int cntDiff = 0;
    private Hashtable m_DiffsPerLocale = new Hashtable();

    public static void main(String[] args) {
        OOComparator comparator = new OOComparator();
        comparator.processArgs(args);
        System.err.println("INFO: execution complete.");
    }

    private void printUsage() {
        System.err.println("");
        System.err.println("DESCRIPTION:");
        System.err.println("  Compares 2 or more locale files or directories of locale files and writes the differences ");
        System.out.println("  to a HTML file");
        System.err.println("");
        System.err.println("USAGE:");
        System.err.println("  OOComparator [-single / -bulk] file or directory list");
        System.err.println("     compares the contents of 2 or more OO XML: files and writes the ");
        System.err.println("     differences to a HTML file");
        System.err.println("  Each argument can take the folllowing format : \"file or directory,name,url\" ");
        System.err.println("      where the 2nd and 3rd parts are optional  ");
        System.err.println("");
        System.err.println("OPTIONS:");
        System.err.println("  -single    : specifies 2 or more locales in OpenOffice.org format to be compared");
        System.err.println("  -bulk      : specifies 2 or more dirs containing locales in OpenOffice.org format to be compared");
        System.err.println("  -show_refs :");
        System.err.println("  -solutions : adds a solutions column to table");
        System.err.println("");
        System.err.println("EXAMPLES:");
        System.err.println("  OOComparator -solutions -single dir1/it_IT.xml dir2/it_IT.xml dir3/it_IT.xml ....");
        System.err.println("    write the differences to it_IT.html");
        System.err.println("  OOComparator -bulk  dir1 dir2 dir3....");
        System.err.println("    write the differences to Bulk.html");
        System.err.println("  OOComparator -single dir1/it_IT.xml;OOo;http://l10n.openoffice.org/location/it_IT.xml?rev=SRC680_m151 dir2/it_IT.xml dir3/it_IT.xml ....");
        System.err.println("    write the differences to it_IT.html adding the header \"OOo\" and link http://l10n.openoffice.org/location/he_IL.xml?rev=SRC680_m151 to the table");
        System.err.println("  OOComparator -bulk dir1;OOo;http://l10n.openoffice.org/location/LOCALE?rev=SRC680_m151 dir2;CLDR ....");
        System.err.println("    the string \"LOCALE\" will be replaced by the tool with the appropriate locale name");
    }

    private void processArgs(String[] args) {
        this.m_iOptions = this.identifyOptions(args);
        if (args.length < 3 || (this.m_iOptions & 0x8000) != 0) {
            this.printUsage();
            return;
        }
        try {
            if ((this.m_iOptions & 1) != 0) {
                Locale locale = this.extractLocale((String)this.m_XMLfiles.elementAt(0));
                String fileName = this.localeToString(locale);
                OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName + ".html"), "UTF-8");
                System.err.println("INFO: Writing to : " + fileName + ".html");
                PrintWriter writer = new PrintWriter(os);
                this.printHTMLStart(writer);
                this.doSingleComparison(writer, this.m_XMLfiles, locale);
                this.printHTMLEnd(writer);
            } else if ((this.m_iOptions & 2) != 0) {
                String fileName = "./Bulk.html";
                OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
                System.err.println("INFO: Writing to : " + fileName);
                PrintWriter writer = new PrintWriter(os);
                this.printHTMLStart(writer);
                this.doBulkComparison(writer);
                this.printHTMLEnd(writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int identifyOptions(String[] options) {
        int opts = 0;
        if (options.length == 0) {
            opts = 32768;
        } else {
            for (int k = 0; k < options.length; ++k) {
                TableInfo ti;
                String url;
                String name;
                int index;
                File file;
                String[] parts;
                String filename;
                String data;
                int i;
                if (options[k].compareTo(OPT_SINGLE_STR) == 0) {
                    ++opts;
                    for (i = k + 1; i < options.length; ++i) {
                        data = options[i];
                        filename = "";
                        parts = data.split(STRING_SEPARATOR);
                        filename = parts[0];
                        file = new File(filename);
                        if (!file.exists() || !file.isFile()) {
                            this.printWarning("The file " + filename + " could not be found.");
                            continue;
                        }
                        String absfile = file.getAbsolutePath();
                        this.m_XMLfiles.add(absfile);
                        ++this.m_ArgsCounter;
                        index = this.m_XMLfiles.size() - 1;
                        name = "File" + index;
                        url = absfile;
                        ti = null;
                        ti = parts.length == 3 ? new TableInfo(index, parts[1], parts[2]) : (parts.length == 2 ? new TableInfo(index, parts[1], url) : new TableInfo(index, name, url));
                        this.m_TableInfo.add(ti);
                    }
                    continue;
                }
                if (options[k].compareTo(OPT_BULK_STR) == 0) {
                    opts += 2;
                    for (i = 1; i < options.length; ++i) {
                        data = options[i];
                        filename = "";
                        parts = data.split(STRING_SEPARATOR);
                        filename = parts[0];
                        file = new File(filename);
                        if (!file.exists() || !file.isDirectory()) {
                            this.printWarning("The directory " + options[i] + " could not be found.");
                            continue;
                        }
                        String absdir = file.getAbsolutePath();
                        this.m_XMLdirs.add(absdir);
                        ++this.m_ArgsCounter;
                        index = this.m_XMLdirs.size() - 1;
                        name = "File" + index;
                        url = absdir;
                        ti = null;
                        ti = parts.length == 3 ? new TableInfo(index, parts[1], parts[2]) : (parts.length == 2 ? new TableInfo(index, parts[1], url) : new TableInfo(index, name, url));
                        this.m_TableInfo.add(ti);
                    }
                    continue;
                }
                if (options[k].compareTo(OPT_SHOW_REFS_STR) == 0) {
                    opts += 4;
                    continue;
                }
                if (options[k].compareTo(OPT_SOLUTIONS_STR) != 0) continue;
                opts += 8;
            }
        }
        return opts;
    }

    private void printHTMLStart(PrintWriter writer) {
        System.err.println("INFO: Creating the comparison chart ");
        writer.print("<html>\n    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n        <style type=\"text/css\">\n            <!--\n            table        { border-spacing: 0; border-collapse: collapse; width:100%; \n                           border: 1px solid black }\n            td, th       { border-spacing: 0; border-collapse: collapse; color: black; \n                           vertical-align: top; border: 1px solid black }\n            .small       { font-size:75%; } \n            th.file0     { background: #ffcc00 } \n            th.file1     { background: #ffff99 } \n            th.solutions { background: #ffcc99 } \n            -->\n        </style>    </head>\n    <body bgcolor=\"#FFFFFF\"> \n        <p><b>LOCALE DATA AUDIT</b></p>");
        writer.print("        <p>Created on: " + this.cal.getTime() + "</p>\n");
    }

    private void printHTMLEnd(PrintWriter writer) {
        writer.print("<p>&nbsp;</p>");
        writer.print("<p>&nbsp;</p>");
        writer.print("          <p><b>SUMMARY : </b></p>");
        float percent = 0.0f;
        if (this.m_CommonCounter > 0) {
            percent = this.m_DiffCounter * 100 / this.m_CommonCounter;
        }
        writer.print("          <p><b>Total Number of locales audited : " + this.m_TotalNumLocales + "</b></p>" + "           <p><b>Total Number of shared locale data across all locales : " + this.m_CommonCounter + "</b></p>" + "           <p><b>Total Number of conflicting locale data across all locales : " + this.m_DiffCounter + " (" + percent + " %)" + "</b></p>" + "    </body>\n" + "</html>\n");
        writer.flush();
        writer.flush();
    }

    private void printTableStart(PrintWriter writer, Vector XMLfiles, Locale locale) {
        String localeStr = this.localeToString(locale);
        String displayLang = locale.getDisplayLanguage();
        String dispCountry = locale.getDisplayCountry();
        String displayName = "<a name=\"" + localeStr + "\" href=\"#" + localeStr + "\">" + localeStr + "</a>" + " (" + displayLang + (!dispCountry.equals("") ? "_" + dispCountry : "") + ")";
        writer.println("<p><b>" + this.m_TotalNumLocales + "&nbsp;&nbsp;&nbsp;" + displayName + "</b></p>");
        writer.println("<p class=\"small\">");
        writer.println("</p>");
        if (XMLfiles.size() < 2) {
            this.printWarning(XMLfiles.size() + " file was specified for comparison for " + locale.toString() + ".  Minimum of two required.");
            writer.println("Skipped as only " + Integer.toString(XMLfiles.size()) + " file available for comparison");
            return;
        }
        writer.println("<table>");
        writer.print("            <tr>\n                <th width=10%>N.</th>\n                <th width=10%>ParentNode</th>\n                <th width=10%>Name</th>\n                <th width=10%>ID</th>\n");
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            writer.print("                <th class=\"");
            if (i % 2 == 0) {
                writer.print("file0\"");
            } else {
                writer.print("file1\"");
            }
            String column_name = "";
            String href = "";
            int j = 0;
            while (i < this.m_TableInfo.size()) {
                if (((TableInfo)this.m_TableInfo.elementAt((int)j)).index == i) {
                    column_name = ((TableInfo)this.m_TableInfo.elementAt((int)j)).name;
                    href = ((TableInfo)this.m_TableInfo.elementAt((int)j)).url;
                    if ((href = href.replaceAll("LOCALE", localeStr + ".xml")).indexOf(".xml") != -1) break;
                    href = (String)XMLfiles.get(i);
                    break;
                }
                ++j;
            }
            writer.println("\"><a href=\"" + href + "\">" + column_name + "</a></th>");
        }
        if ((this.m_iOptions & 8) != 0) {
            writer.println("                <th class=\"solutions\">Solutions</th>");
        }
        writer.println("            </tr>");
    }

    private void printTableEnd(PrintWriter writer, Locale locale) {
        writer.println("</table>");
    }

    private void doSingleComparison(PrintWriter writer, Vector XMLfiles, Locale locale) {
        this.m_CurrNumFiles = XMLfiles.size();
        ++this.m_TotalNumLocales;
        String loc = this.localeToString(locale);
        System.err.println("INFO: Processing locale : " + loc);
        this.printTableStart(writer, XMLfiles, locale);
        this.compareData(writer, XMLfiles, locale);
        this.printTableEnd(writer, locale);
    }

    private void doBulkComparison(PrintWriter writer) {
        if (this.m_XMLdirs.size() < 2) {
            this.printError(this.m_XMLdirs.size() + " directories were specified for comparison.  Minimum of two required.");
            return;
        }
        TreeMap<String, LocaleFiles> locales = new TreeMap<String, LocaleFiles>();
        XMLFileFilter filter = new XMLFileFilter();
        Enumeration enDirs = this.m_XMLdirs.elements();
        while (enDirs.hasMoreElements()) {
            String dirName = (String)enDirs.nextElement();
            File dir = new File(dirName);
            File[] files = dir.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                Locale locale = this.extractLocale(files[i].getAbsolutePath());
                String localeStr = this.localeToString(locale);
                boolean bFound = false;
                for (int j = 0; j < locales.size(); ++j) {
                    LocaleFiles lf = (LocaleFiles)locales.get(localeStr);
                    if (lf == null || !lf.m_locale.equals(locale)) continue;
                    lf.m_files.add(files[i].getAbsolutePath());
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                LocaleFiles lf = new LocaleFiles();
                lf.m_locale = locale;
                lf.m_files.add(files[i].getAbsolutePath());
                locales.put(localeStr, lf);
            }
        }
        Collection col = locales.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            int diffs_before = this.cntDiff;
            LocaleFiles lf = (LocaleFiles)it.next();
            this.doSingleComparison(writer, lf.m_files, lf.m_locale);
            this.printSummaryPart1(this.cntDiff - diffs_before, this.m_TotalNumLocales, lf.m_locale);
        }
        this.printSummaryPart2();
    }

    private void compareData(PrintWriter writer, Vector XMLfiles, Locale locale) {
        OOLocaleReader[] readers = new OOLocaleReader[this.m_CurrNumFiles];
        boolean cntData = false;
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            readers[i] = new OOLocaleReader((String)XMLfiles.get(i));
            readers[i].readDocument(true);
        }
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "Locale", "Locale", readers, "m_LocaleInfo");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Locale", "versionDTD", "", readers, "m_versionDTD");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Locale", "allowUpdateFromCLDR", "", readers, "m_allowUpdateFromCLDR");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Locale", "version", "", readers, "m_version");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Language", "LangID", "", readers, "m_LangId");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Language", "DefaultName", "", readers, "m_Language_DefaultName");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Country", "CountryID", "", readers, "m_Country_CountryID");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Country", "DefaultName", "", readers, "m_Country_DefaultName");
        this.cntDiff = this.compareString(writer, this.cntDiff, "Platform", "PlatformID", "", readers, "m_PlatformID");
        this.cntDiff = this.compareString(writer, this.cntDiff, "LC_INFO", "Variant", "", readers, "m_Varient");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "LC_CTYPE", "Separators", readers, "m_Separators");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "LC_CTYPE", "Markers", readers, "m_Markers");
        this.cntDiff = this.compareString(writer, this.cntDiff, "LC_CTYPE", "TimeAM", "", readers, "m_TimeAM");
        this.cntDiff = this.compareString(writer, this.cntDiff, "LC_CTYPE", "TimePM", "", readers, "m_TimePM");
        this.cntDiff = this.compareString(writer, this.cntDiff, "LC_CTYPE", "MeasurementSystem", "", readers, "m_MeasurementSystem");
        this.cntDiff = this.compareString(writer, this.cntDiff, "LC_FORMAT", "replaceFrom", "", readers, "m_ReplaceFrom");
        this.cntDiff = this.compareString(writer, this.cntDiff, "LC_FORMAT", "replaceTo", "", readers, "m_ReplaceTo");
        this.cntDiff = this.compareUniqueElemAtts(writer, this.cntDiff, "FormatElement", readers, "m_FormatElements");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "LC_FORMAT", "FormatCode", readers, "m_FormatCodes");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "LC_FORMAT", "FormatCode", readers, "m_FormatDefaultNames");
        this.cntDiff = this.compareUniqueElemAtts(writer, this.cntDiff, "Collator", readers, "m_Collators", "unoid");
        this.cntDiff = this.compareVectorofStrings(writer, this.cntDiff, "CollationOptions", "TransliterationModules", readers, "m_CollationOptions");
        this.cntDiff = this.compareVectorofStrings(writer, this.cntDiff, "SearchOptions", "TransliterationModules", readers, "m_SearchOptions");
        this.cntDiff = this.compareUniqueElemAtts(writer, this.cntDiff, "IndexKey", readers, "m_IndexKeys", "unoid");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "LC_INDEX", "IndexKey", readers, "m_IndexKeysData");
        this.cntDiff = this.compareVectorofStrings(writer, this.cntDiff, "LC_INDEX", "UnicodeScript", readers, "m_UnicodeScript");
        this.cntDiff = this.compareVectorofStrings(writer, this.cntDiff, "LC_INDEX", "FollowPageWord", readers, "m_FollowPageWord");
        this.cntDiff = this.compareUniqueElemAtts(writer, this.cntDiff, "Calendar", readers, "m_Calendars", "unoid");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "StartDayOfWeek", "DayID", readers, "m_StartDayOfWeek");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "Calendar", "MinimalDaysInFirstWeek", readers, "m_MinDaysInFirstweek");
        this.cntDiff = this.compareHashtableOfHashtablesOfStrings(writer, this.cntDiff, "DaysOfWeek.Day.DayID", "DefaultAbbrvName", readers, "m_AbbrDays");
        this.cntDiff = this.compareHashtableOfHashtablesOfStrings(writer, this.cntDiff, "DaysOfWeek.Day.DayID", "DefaultFullName", readers, "m_WideDays");
        this.cntDiff = this.compareHashtableOfHashtablesOfStrings(writer, this.cntDiff, "MonthsOfYear.Month.MonthID", "DefaultAbbrvName", readers, "m_AbbrMonths");
        this.cntDiff = this.compareHashtableOfHashtablesOfStrings(writer, this.cntDiff, "MonthsOfYear.Month.MonthID", "DefaultFullName", readers, "m_WideMonths");
        this.cntDiff = this.compareHashtableOfHashtablesOfStrings(writer, this.cntDiff, "Eras.Era.EraID", "DefaultAbbrvName", readers, "m_AbbrEras");
        this.cntDiff = this.compareHashtableOfHashtablesOfStrings(writer, this.cntDiff, "Eras.Era.EraID", "DefaultFullName", readers, "m_WideEras");
        this.cntDiff = this.compareCurrencies(writer, this.cntDiff, "Currency", readers);
        this.cntDiff = this.compareUniqueElemAtts(writer, this.cntDiff, "Transliteration", readers, "m_Transliterations", "unoid");
        this.cntDiff = this.compareString(writer, this.cntDiff, "ForbiddenCharacters", "ForbiddenLineBeginCharacters", "", readers, "m_ForbiddenBeginChar");
        this.cntDiff = this.compareString(writer, this.cntDiff, "ForbiddenCharacters", "ForbiddenLineEndCharacters", "", readers, "m_ForbiddenEndChar");
        this.cntDiff = this.compareHashtableofStrings(writer, this.cntDiff, "LC_MISC", "ReservedWords", readers, "m_ReservedWords");
        this.cntDiff = this.compareVectorofHashtables(writer, this.cntDiff, "LC_NumberingLevel", "NumberingLevel", readers, "m_NumberingLevels");
        this.cntDiff = this.compareVectorofHashtables(writer, this.cntDiff, "OutlineStyle", "OutLineNumberingLevel", readers, "m_OutlineNumberingLevels");
        if ((this.m_iOptions & 4) != 0) {
            this.cntDiff = this.compareRefs(writer, this.cntDiff, readers, "m_Refs");
        }
    }

    private int compareString(PrintWriter writer, int cntDiff, String parent, String attribute, String id, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        String[] values = new String[this.m_CurrNumFiles];
        boolean diff = false;
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                values[i] = (String)field.get(readers[i]);
                if (i <= 0 || diff) continue;
                diff = this.strDiff(values[0], values[i]);
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (diff) {
            this.printHTMLRow(writer, cntDiff, parent, attribute, id, values);
            ++cntDiff;
        }
        return cntDiff;
    }

    private int compareVectorofStrings(PrintWriter writer, int cntDiff, String parentName, String elementName, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        Vector<String> strValues = new Vector<String>();
        Vector[] vectors = new Vector[this.m_CurrNumFiles];
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                vectors[i] = (Vector)field.get(readers[i]);
                if (vectors[i] == null || vectors[i].size() <= 0) continue;
                Enumeration en = vectors[i].elements();
                while (en.hasMoreElements()) {
                    String value = (String)en.nextElement();
                    if (strValues.contains(value)) continue;
                    strValues.add(value);
                }
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Enumeration en = strValues.elements();
        while (en.hasMoreElements()) {
            String str = (String)en.nextElement();
            String[] output = new String[this.m_CurrNumFiles];
            boolean diff = false;
            for (int i = 0; i < this.m_CurrNumFiles; ++i) {
                if (vectors[i].contains(str)) {
                    output[i] = "";
                    continue;
                }
                diff = true;
                output[i] = MISSING_ELEM;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parentName, elementName, str, output);
            ++cntDiff;
        }
        return cntDiff;
    }

    private int compareRefs(PrintWriter writer, int cntDiff, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        int i;
        Hashtable[] hashtables = new Hashtable[this.m_CurrNumFiles];
        Hashtable[] hashtablesOfStrings = new Hashtable[this.m_CurrNumFiles];
        Hashtable[] daysOfWeek = new Hashtable[this.m_CurrNumFiles];
        Hashtable[] monthsOfYear = new Hashtable[this.m_CurrNumFiles];
        Hashtable[] eras = new Hashtable[this.m_CurrNumFiles];
        for (i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                hashtables[i] = (Hashtable)field.get(readers[i]);
                if (hashtables[i] == null) continue;
                daysOfWeek[i] = (Hashtable)hashtables[i].get("DaysOfWeek");
                monthsOfYear[i] = (Hashtable)hashtables[i].get("MonthsOfYear");
                eras[i] = (Hashtable)hashtables[i].get("Eras");
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < this.m_CurrNumFiles; ++i) {
            Enumeration en = hashtables[i].keys();
            hashtablesOfStrings[i] = new Hashtable();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object obj = hashtables[i].get(key);
                Class<?> objClass = obj.getClass();
                if (objClass.getName().compareTo("java.lang.String") != 0) continue;
                String value = (String)obj;
                hashtablesOfStrings[i].put(key, value);
            }
        }
        cntDiff = this.compareHashtableofStrings(writer, cntDiff, "ref", "ref", hashtablesOfStrings);
        cntDiff = this.compareHashtableofStrings(writer, cntDiff, "Calendar", "DaysOfWeek _ref", daysOfWeek);
        cntDiff = this.compareHashtableofStrings(writer, cntDiff, "Calendar", "MonthsOfYear _ref", monthsOfYear);
        cntDiff = this.compareHashtableofStrings(writer, cntDiff, "Calendar", "Eras _ref", eras);
        return cntDiff;
    }

    private int compareHashtableOfHashtablesOfStrings(PrintWriter writer, int cntDiff, String parent, String element, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        Hashtable[] hashtables = new Hashtable[this.m_CurrNumFiles];
        Vector<String> keys = new Vector<String>();
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                hashtables[i] = (Hashtable)field.get(readers[i]);
                if (hashtables[i] == null || hashtables[i].size() <= 0) continue;
                Enumeration en = hashtables[i].keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Enumeration en = keys.elements();
        while (en.hasMoreElements()) {
            Hashtable[] elements = new Hashtable[this.m_CurrNumFiles];
            String key = (String)en.nextElement();
            for (int i = 0; i < this.m_CurrNumFiles; ++i) {
                if (hashtables[i] == null) continue;
                elements[i] = (Hashtable)hashtables[i].get(key);
            }
            cntDiff = this.compareHashtableofStrings(writer, cntDiff, key + ":" + parent, element, elements);
        }
        return cntDiff;
    }

    private int compareHashtableofStrings(PrintWriter writer, int cntDiff, String parent, String element, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        Vector<String> keys = new Vector<String>();
        Hashtable[] hashtables = new Hashtable[this.m_CurrNumFiles];
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                hashtables[i] = (Hashtable)field.get(readers[i]);
                if (hashtables[i] == null || hashtables[i].size() <= 0) continue;
                Enumeration en = hashtables[i].keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        cntDiff = this.compareHashtables(writer, cntDiff, keys, hashtables, parent, element);
        return cntDiff;
    }

    private int compareHashtableofStrings(PrintWriter writer, int cntDiff, String parent, String element, Hashtable[] elements) {
        Vector<String> keys = new Vector<String>();
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            if (elements[i] == null) continue;
            Enumeration en = elements[i].keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        cntDiff = this.compareHashtables(writer, cntDiff, keys, elements, parent, element);
        return cntDiff;
    }

    private int compareHashtables(PrintWriter writer, int cntDiff, Vector keys, Hashtable[] hashtables, String parent, String element) {
        Enumeration en = keys.elements();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String[] values = new String[this.m_CurrNumFiles];
            boolean diff = false;
            for (int i = 0; i < this.m_CurrNumFiles; ++i) {
                if (hashtables[i] != null) {
                    values[i] = (String)hashtables[i].get(key);
                    if (values[i] == null) {
                        values[i] = MISSING_ELEM;
                    }
                } else {
                    values[i] = MISSING_ELEM;
                }
                if (i <= 0 || diff) continue;
                diff = this.strDiff(values[0], values[i]);
            }
            if (diff) {
                this.printHTMLRow(writer, cntDiff, parent, element, key, values);
                ++cntDiff;
                continue;
            }
            ++this.m_CommonCounter;
        }
        return cntDiff;
    }

    private void parseElementHashtables(Hashtable hashtable, Vector keys, Vector attributes) {
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration en = hashtable.keys();
            while (en.hasMoreElements()) {
                Hashtable elementTab;
                String key = (String)en.nextElement();
                if (!keys.contains(key)) {
                    keys.add(key);
                }
                if (key == null || key.length() <= 0 || (elementTab = (Hashtable)hashtable.get(key)) == null || elementTab.size() <= 0) continue;
                Enumeration subEn = elementTab.keys();
                while (subEn.hasMoreElements()) {
                    String subKey = (String)subEn.nextElement();
                    if (subKey == null || subKey.length() <= 0 || attributes.contains(subKey)) continue;
                    attributes.add(subKey);
                }
            }
        }
    }

    private Hashtable convertElemVectorToHashtable(Vector data, String uniqueAttName) {
        Hashtable<String, Hashtable> dataOut = new Hashtable<String, Hashtable>();
        Enumeration en = data.elements();
        while (en.hasMoreElements()) {
            Hashtable element = (Hashtable)en.nextElement();
            String attVal = (String)element.get(uniqueAttName);
            if (attVal == null || attVal.length() <= 0) continue;
            dataOut.put(attVal, element);
        }
        return dataOut;
    }

    private int compareUniqueElemAtts(PrintWriter writer, int cntDiff, String parent, OOLocaleReader[] readers, String OOLocaleReaderVarName, String uniqueAttName) {
        Hashtable[] hashtables = new Hashtable[this.m_CurrNumFiles];
        Vector keys = new Vector();
        Vector attributes = new Vector();
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                Vector fileElements = (Vector)field.get(readers[i]);
                hashtables[i] = this.convertElemVectorToHashtable(fileElements, uniqueAttName);
                this.parseElementHashtables(hashtables[i], keys, attributes);
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        cntDiff = this.compareAttValues(writer, cntDiff, parent, hashtables, keys, attributes);
        return cntDiff;
    }

    private int compareUniqueElemAtts(PrintWriter writer, int cntDiff, String parent, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        Hashtable[] hashtables = new Hashtable[this.m_CurrNumFiles];
        Vector keys = new Vector();
        Vector attributes = new Vector();
        for (int i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                hashtables[i] = (Hashtable)field.get(readers[i]);
                this.parseElementHashtables(hashtables[i], keys, attributes);
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        cntDiff = this.compareAttValues(writer, cntDiff, parent, hashtables, keys, attributes);
        return cntDiff;
    }

    private int compareAttValues(PrintWriter writer, int cntDiff, String parent, Hashtable[] hashtables, Vector keys, Vector attributes) {
        Enumeration en = keys.elements();
        while (en.hasMoreElements()) {
            String[] output = new String[this.m_CurrNumFiles];
            boolean diff = false;
            String key = (String)en.nextElement();
            for (int i = 0; i < this.m_CurrNumFiles; ++i) {
                Hashtable elementTable = (Hashtable)hashtables[i].get(key);
                if (elementTable == null) {
                    output[i] = MISSING_ELEM;
                    diff = true;
                    continue;
                }
                output[i] = "";
            }
            if (diff) {
                this.printHTMLRow(writer, cntDiff, parent, "", key, output);
                ++cntDiff;
                continue;
            }
            ++this.m_CommonCounter;
        }
        en = keys.elements();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Hashtable[] elementInstances = new Hashtable[this.m_CurrNumFiles];
            for (int i = 0; i < this.m_CurrNumFiles; ++i) {
                elementInstances[i] = (Hashtable)hashtables[i].get(key);
            }
            Enumeration enAtt = attributes.elements();
            while (enAtt.hasMoreElements()) {
                String[] values = new String[this.m_CurrNumFiles];
                String attName = (String)enAtt.nextElement();
                boolean diff = false;
                boolean valueFound = false;
                String value = null;
                for (int i = 0; i < this.m_CurrNumFiles; ++i) {
                    if (elementInstances[i] == null) {
                        values[i] = MISSING_ELEM;
                        continue;
                    }
                    values[i] = (String)elementInstances[i].get(attName);
                    if (values[i] == null) {
                        values[i] = MISSING_ELEM;
                        continue;
                    }
                    if (!valueFound) {
                        valueFound = true;
                        value = values[i];
                        continue;
                    }
                    if (i <= 0 || diff) continue;
                    diff = this.strDiff(value, values[i]);
                }
                if (diff) {
                    this.printHTMLRow(writer, cntDiff, parent, "_" + attName, key, values);
                    ++cntDiff;
                    continue;
                }
                ++this.m_CommonCounter;
            }
        }
        return cntDiff;
    }

    private int compareVectorofHashtables(PrintWriter writer, int cntDiff, String parentName, String elementName, OOLocaleReader[] readers, String OOLocaleReaderVarName) {
        int i;
        Vector[] vectors = new Vector[this.m_CurrNumFiles];
        Vector<Hashtable> hashtables = new Vector<Hashtable>();
        for (i = 0; i < this.m_CurrNumFiles; ++i) {
            Class<?> readerClass = readers[i].getClass();
            try {
                Field field = readerClass.getDeclaredField(OOLocaleReaderVarName);
                vectors[i] = (Vector)field.get(readers[i]);
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < this.m_CurrNumFiles; ++i) {
            Enumeration en = vectors[i].elements();
            while (en.hasMoreElements()) {
                Hashtable hashtable = (Hashtable)en.nextElement();
                boolean containsTable = false;
                Enumeration enTabs = hashtables.elements();
                while (enTabs.hasMoreElements() && !containsTable) {
                    Hashtable tab = (Hashtable)enTabs.nextElement();
                    if (!tab.equals(hashtable)) continue;
                    containsTable = true;
                }
                if (containsTable) continue;
                hashtables.add(hashtable);
            }
        }
        Enumeration en = hashtables.elements();
        while (en.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)en.nextElement();
            boolean diff = false;
            String[] output = new String[this.m_CurrNumFiles];
            for (int i2 = 0; i2 < this.m_CurrNumFiles; ++i2) {
                boolean foundTable = false;
                Enumeration enTabs = vectors[i2].elements();
                while (enTabs.hasMoreElements() && !foundTable) {
                    Hashtable element = (Hashtable)enTabs.nextElement();
                    if (!element.equals(hashtable)) continue;
                    foundTable = true;
                }
                if (foundTable) {
                    output[i2] = "";
                    continue;
                }
                diff = true;
                output[i2] = MISSING_ELEM;
            }
            if (diff) {
                StringBuffer id = new StringBuffer();
                Enumeration enTab = hashtable.keys();
                while (enTab.hasMoreElements()) {
                    String key = (String)enTab.nextElement();
                    String value = (String)hashtable.get(key);
                    id.append(" _" + key + "=\"" + value + "\"");
                }
                this.printHTMLRow(writer, cntDiff, parentName, elementName, id.toString(), output);
                ++cntDiff;
                continue;
            }
            ++this.m_CommonCounter;
        }
        return cntDiff;
    }

    private int compareCurrencies(PrintWriter writer, int cntDiff, String parent, OOLocaleReader[] readers) {
        int i;
        String code;
        int j;
        boolean diff = false;
        int max = 0;
        for (int i2 = 0; i2 < this.m_CurrNumFiles; ++i2) {
            if (readers[i2].m_CurrencyData.size() <= max) continue;
            max = readers[i2].m_CurrencyData.size();
        }
        String[] values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                code = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                values[i] = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(0);
                diff = this.strDiff(values[0], values[i]);
                if (diff) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "CurrencyID", code, values);
            ++cntDiff;
        }
        values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                code = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                values[i] = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(1);
                diff = this.strDiff(values[0], values[i]);
                if (diff) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "CurrencySymbol", code, values);
            ++cntDiff;
        }
        values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                code = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                values[i] = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                diff = this.strDiff(values[0], values[i]);
                if (diff) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "Currency", code, values);
            ++cntDiff;
        }
        values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                code = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                values[i] = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(3);
                diff = this.strDiff(values[0], values[i]);
                if (diff) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "CurrencyName", code, values);
            ++cntDiff;
        }
        values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                code = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                values[i] = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(5);
                diff = this.strDiff(values[0], values[i]);
                if (diff) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "default", code, values);
            ++cntDiff;
        }
        values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                code = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(2);
                values[i] = (String)((Vector)readers[i].m_CurrencyData.elementAt(j)).elementAt(6);
                diff = this.strDiff(values[0], values[i]);
                if (diff) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "usedInCompatibleFormatCodes", code, values);
            ++cntDiff;
        }
        values = new String[this.m_CurrNumFiles];
        for (j = 0; j < max; ++j) {
            code = "";
            for (i = 0; i < this.m_CurrNumFiles; ++i) {
                Vector v = (Vector)readers[i].m_CurrencyData.elementAt(j);
                code = (String)v.elementAt(2);
                if (v.size() > 7) {
                    values[i] = (String)v.elementAt(7);
                }
                if (diff = this.strDiff(values[0], values[i])) break;
            }
            if (!diff) continue;
            this.printHTMLRow(writer, cntDiff, parent, "legacyOnly", code, values);
            ++cntDiff;
        }
        return cntDiff;
    }

    private boolean nullDiff(Object obj0, Object obj1) {
        boolean null0 = obj0 == null;
        boolean null1 = obj1 == null;
        return null0 != null1;
    }

    private boolean strDiff(String str0, String str1) {
        boolean diff = false;
        boolean nullDiff = this.nullDiff(str0, str1);
        diff = nullDiff ? nullDiff : (str0 == null ? false : str0.compareTo(str1) != 0);
        return diff;
    }

    private void printHTMLRow(PrintWriter writer, int number, String parentNode, String name, String id, String[] values) {
        ++this.m_DiffCounter;
        writer.println("<tr>");
        writer.println("<td><a name=\"" + number + "\" href=\"#" + number + "\">" + number + "</a></td>");
        writer.println("<td>" + parentNode + "</td>");
        writer.println("<td>" + name + "</td>");
        writer.println("<td>" + id + "</td>");
        for (int i = 0; i < values.length; ++i) {
            writer.println("<td>" + values[i] + "</td>");
        }
        writer.println("</tr>");
    }

    private void printWarning(String str) {
        System.err.println("Warning: " + str);
    }

    private void printError(String str) {
        System.err.println("Error: " + str);
    }

    private Locale extractLocale(String filename) {
        if (filename == null) {
            return null;
        }
        Locale locale = null;
        int iLastSlash = filename.lastIndexOf(47);
        int iLastPeriod = filename.lastIndexOf(46);
        String loc = filename.substring(iLastSlash + 1, iLastPeriod);
        String lang = null;
        String country = null;
        if (loc.indexOf(95) >= 0) {
            lang = loc.substring(0, loc.indexOf(95));
            country = loc.substring(loc.indexOf(95) + 1, loc.length());
            locale = new Locale(lang, country);
        } else {
            lang = loc.substring(0, loc.length());
            locale = new Locale(lang);
        }
        return locale;
    }

    private String localeToString(Locale locale) {
        if (locale == null) {
            return "";
        }
        String loc = locale.getLanguage();
        if (loc.equals("in")) {
            loc = "id";
        }
        if (loc.equals("iw")) {
            loc = "he";
        }
        if (loc.equals("ji")) {
            loc = "yi";
        }
        if (loc.equals("jw")) {
            loc = "jv";
        }
        String country = locale.getCountry();
        loc = loc + (!locale.getCountry().equals("") ? "_" + country : "");
        return loc;
    }

    private void printSummaryPart1(int diffs, int counter, Locale locale) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("summary.txt", true));
            out.write(Integer.toString(counter) + "  " + this.localeToString(locale) + "  Conflicts = " + Integer.toString(diffs) + "\n");
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        Integer key = new Integer(diffs);
        if (this.m_DiffsPerLocale.get(key) != null) {
            Integer val = (Integer)this.m_DiffsPerLocale.get(key);
            this.m_DiffsPerLocale.remove(key);
            int v = val;
            this.m_DiffsPerLocale.put(key, new Integer(++v));
        } else {
            this.m_DiffsPerLocale.put(key, new Integer(1));
        }
    }

    private void printSummaryPart2() {
        try {
            int total_locales = 0;
            int total_conflicts = 0;
            BufferedWriter out = new BufferedWriter(new FileWriter("summary.txt", true));
            out.write("\n\n# Conflicts  # Locales\n");
            Enumeration en = this.m_DiffsPerLocale.keys();
            while (en.hasMoreElements()) {
                Integer num_conflicts = (Integer)en.nextElement();
                Integer num_locales = (Integer)this.m_DiffsPerLocale.get(num_conflicts);
                out.write("  " + num_conflicts.toString() + "          " + num_locales.toString() + "\n");
                total_conflicts += num_conflicts * num_locales;
                total_locales += num_locales.intValue();
            }
            out.write("\nTOTAL CONFLICTS = " + Integer.toString(total_conflicts));
            out.write("\nTOTAL LOCALES   = " + Integer.toString(total_locales));
            out.write("\nCreated on: " + this.cal.getTime());
            out.write("\n===================================================\n");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected class XMLFileFilter
    implements FileFilter {
        protected XMLFileFilter() {
        }

        public boolean accept(File pathname) {
            boolean accepted = false;
            String filename = pathname.getPath();
            if (filename != null && filename.length() > 4) {
                accepted = filename.substring(filename.length() - 4).toLowerCase().compareTo(".xml") == 0;
            }
            return accepted;
        }
    }

    private class TableInfo {
        public int index;
        public String name;
        public String url;

        TableInfo(int index, String name, String url) {
            this.index = index;
            this.name = name;
            this.url = url;
        }
    }

    private class LocaleFiles {
        public Locale m_locale;
        public Vector m_files = new Vector();

        private LocaleFiles() {
        }
    }
}

