/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.DOMWrapper;
import org.unicode.cldr.ooo.Logging;
import org.unicode.cldr.ooo.OOToLDMLMapper;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class OOLocaleReader {
    private String m_filename = null;
    private Document m_doc = null;
    private DOMWrapper m_domWrapper = null;
    public Hashtable m_LocaleInfo = new Hashtable();
    private Hashtable m_Refs = new Hashtable();
    public Hashtable m_Refs2 = new Hashtable();
    public static String m_LangId = null;
    public String m_Language_DefaultName = null;
    public static String m_Country_CountryID = null;
    public String m_Country_DefaultName = null;
    public String m_PlatformID = null;
    public String m_Varient = null;
    public String m_version = null;
    public String m_allowUpdateFromCLDR = null;
    public String m_versionDTD = null;
    public Hashtable m_Separators = new Hashtable();
    public Hashtable m_Markers = new Hashtable();
    public String m_TimeAM = null;
    public String m_TimePM = null;
    public String m_MeasurementSystem = null;
    public Vector m_LCFormat = null;
    public Hashtable m_FormatElements = null;
    public Hashtable m_FormatCodes = null;
    public Hashtable m_FormatDefaultNames = null;
    public String m_ReplaceFrom = null;
    public String m_ReplaceTo = null;
    public Vector m_Collators = null;
    public Vector m_CollationOptions = null;
    public Vector m_SearchOptions = null;
    public Vector m_IndexKeys = null;
    public Hashtable m_IndexKeysData = null;
    public Vector m_UnicodeScript = null;
    public Vector m_FollowPageWord = null;
    public Vector m_Calendars = null;
    public Hashtable m_AbbrMonths = null;
    public Hashtable m_WideMonths = null;
    public Hashtable m_AbbrDays = null;
    public Hashtable m_WideDays = null;
    public Hashtable m_AbbrEras = null;
    public Hashtable m_WideEras = null;
    public Hashtable m_StartDayOfWeek = null;
    public Hashtable m_MinDaysInFirstweek = null;
    public Vector m_CurrencyData = new Vector();
    public Vector m_Transliterations = null;
    public Hashtable m_ForbiddenChars = new Hashtable();
    public String m_ForbiddenBeginChar = null;
    public String m_ForbiddenEndChar = null;
    public Hashtable m_ReservedWords = new Hashtable();
    public Vector m_NumberingLevels = null;
    public Vector m_OutlineNumberingLevels = null;

    public OOLocaleReader(String filename) {
        this.m_filename = filename;
    }

    public boolean readDocument(boolean bResolveRefs) {
        String miscData;
        String doubleQuotationEnd;
        String doubleQuotationStart;
        String quotationEnd;
        String quotationStart;
        String longDateYearSeparator;
        String longDateMnothSeparator;
        String longDateDaySeparator;
        String longDateDayOfWeekSeparator;
        String listSeparator;
        String time100SecSeparator;
        String timeSeparator;
        String decimalSeparator;
        String thousandSeparator;
        if (this.m_filename == null) {
            return false;
        }
        boolean bRc = false;
        this.m_doc = LDMLUtilities.parse(this.m_filename, true);
        this.m_domWrapper = new DOMWrapper(this.m_doc);
        this.m_version = this.m_domWrapper.getAttributeFromElement("Locale", "version");
        if (this.m_version != null) {
            this.m_LocaleInfo.put("version", this.m_version);
        }
        this.m_allowUpdateFromCLDR = this.m_domWrapper.getAttributeFromElement("Locale", "allowUpdateFromCLDR");
        if (this.m_allowUpdateFromCLDR != null) {
            this.m_LocaleInfo.put("allowUpdateFromCLDR", this.m_allowUpdateFromCLDR);
        }
        this.m_versionDTD = this.m_domWrapper.getAttributeFromElement("Locale", "versionDTD");
        if (this.m_versionDTD != null) {
            this.m_LocaleInfo.put("versionDTD", this.m_versionDTD);
        }
        m_LangId = this.m_domWrapper.getTextFromElement("Language", "LangID");
        this.m_Language_DefaultName = this.m_domWrapper.getTextFromElement("Language", "DefaultName");
        m_Country_CountryID = this.m_domWrapper.getTextFromElement("Country", "CountryID");
        this.m_Country_DefaultName = this.m_domWrapper.getTextFromElement("Country", "DefaultName");
        this.m_PlatformID = this.m_domWrapper.getTextFromElement("Platform", "PlatformID");
        this.m_Varient = this.m_domWrapper.getTextFromElement("LC_INFO", "Varient");
        String locale = "unknown";
        if (m_LangId != null) {
            locale = m_LangId;
        }
        if (m_Country_CountryID != null) {
            locale = locale + "_" + m_Country_CountryID;
        }
        Logging.Log1("\nLocale : " + locale);
        this.readRefs(bResolveRefs);
        this.checkForRef("LC_CTYPE");
        String dateSeparator = this.m_domWrapper.getTextFromElement("Separators", "DateSeparator");
        if (dateSeparator != null) {
            this.m_Separators.put("DateSeparator", dateSeparator);
        }
        if ((thousandSeparator = this.m_domWrapper.getTextFromElement("Separators", "ThousandSeparator")) != null) {
            this.m_Separators.put("ThousandSeparator", thousandSeparator);
        }
        if ((decimalSeparator = this.m_domWrapper.getTextFromElement("Separators", "DecimalSeparator")) != null) {
            this.m_Separators.put("DecimalSeparator", decimalSeparator);
        }
        if ((timeSeparator = this.m_domWrapper.getTextFromElement("Separators", "TimeSeparator")) != null) {
            this.m_Separators.put("TimeSeparator", timeSeparator);
        }
        if ((time100SecSeparator = this.m_domWrapper.getTextFromElement("Separators", "Time100SecSeparator")) != null) {
            this.m_Separators.put("Time100SecSeparator", time100SecSeparator);
        }
        if ((listSeparator = this.m_domWrapper.getTextFromElement("Separators", "ListSeparator")) != null) {
            this.m_Separators.put("ListSeparator", listSeparator);
        }
        if ((longDateDayOfWeekSeparator = this.m_domWrapper.getTextFromElement("Separators", "LongDateDayOfWeekSeparator")) != null) {
            this.m_Separators.put("LongDateDayOfWeekSeparator", longDateDayOfWeekSeparator);
        }
        if ((longDateDaySeparator = this.m_domWrapper.getTextFromElement("Separators", "LongDateDaySeparator")) != null) {
            this.m_Separators.put("LongDateDaySeparator", longDateDaySeparator);
        }
        if ((longDateMnothSeparator = this.m_domWrapper.getTextFromElement("Separators", "LongDateMonthSeparator")) != null) {
            this.m_Separators.put("LongDateMonthSeparator", longDateMnothSeparator);
        }
        if ((longDateYearSeparator = this.m_domWrapper.getTextFromElement("Separators", "LongDateYearSeparator")) != null) {
            this.m_Separators.put("LongDateYearSeparator", longDateYearSeparator);
        }
        if ((quotationStart = this.m_domWrapper.getTextFromElement("Markers", "QuotationStart")) != null) {
            this.m_Markers.put("QuotationStart", quotationStart);
        }
        if ((quotationEnd = this.m_domWrapper.getTextFromElement("Markers", "QuotationEnd")) != null) {
            this.m_Markers.put("QuotationEnd", quotationEnd);
        }
        if ((doubleQuotationStart = this.m_domWrapper.getTextFromElement("Markers", "DoubleQuotationStart")) != null) {
            this.m_Markers.put("DoubleQuotationStart", doubleQuotationStart);
        }
        if ((doubleQuotationEnd = this.m_domWrapper.getTextFromElement("Markers", "DoubleQuotationEnd")) != null) {
            this.m_Markers.put("DoubleQuotationEnd", doubleQuotationEnd);
        }
        this.m_TimeAM = this.m_domWrapper.getTextFromElement("LC_CTYPE", "TimeAM");
        this.m_TimePM = this.m_domWrapper.getTextFromElement("LC_CTYPE", "TimePM");
        this.m_MeasurementSystem = this.m_domWrapper.getTextFromElement("LC_CTYPE", "MeasurementSystem");
        this.m_domWrapper.resetDoc(this.m_doc);
        this.m_ReplaceTo = this.m_domWrapper.getAttributeFromElement("Locale", "LC_FORMAT", "replaceTo");
        this.m_ReplaceFrom = this.m_domWrapper.getAttributeFromElement("Locale", "LC_FORMAT", "replaceFrom");
        if (bResolveRefs) {
            this.checkForRef("LC_FORMAT");
        }
        this.m_LCFormat = this.m_domWrapper.getAttributesFromElement("Locale", "LC_FORMAT");
        this.checkReplacements();
        this.m_FormatElements = this.m_domWrapper.getAttributesFromElement("LC_FORMAT", "FormatElement", "msgid");
        this.m_FormatCodes = this.m_domWrapper.getTextFromElementsAndParentAttrib("FormatElement", "FormatCode", "msgid");
        this.m_FormatDefaultNames = this.m_domWrapper.getTextFromElementsAndParentAttrib("FormatElement", "DefaultName", "msgid");
        this.m_domWrapper.resetDoc(this.m_doc);
        if (bResolveRefs) {
            this.checkForRef("LC_COLLATION");
        }
        this.m_Collators = this.m_domWrapper.getAttributesFromElement("LC_COLLATION", "Collator");
        this.m_CollationOptions = this.m_domWrapper.getTextFromAllElements("CollationOptions", "TransliterationModules");
        this.m_domWrapper.resetDoc(this.m_doc);
        if (bResolveRefs) {
            this.checkForRef("LC_SEARCH");
        }
        this.m_SearchOptions = this.m_domWrapper.getTextFromAllElements("SearchOptions", "TransliterationModules");
        this.m_domWrapper.resetDoc(this.m_doc);
        if (bResolveRefs) {
            this.checkForRef("LC_INDEX");
        }
        this.m_IndexKeys = this.m_domWrapper.getAttributesFromElement("LC_INDEX", "IndexKey");
        this.m_IndexKeysData = this.m_domWrapper.getTextFromElementsAndElementAttrib("LC_INDEX", "IndexKey", "unoid");
        this.m_UnicodeScript = this.m_domWrapper.getTextFromAllElements("LC_INDEX", "UnicodeScript");
        this.m_FollowPageWord = this.m_domWrapper.getTextFromAllElements("LC_INDEX", "FollowPageWord");
        this.m_domWrapper.resetDoc(this.m_doc);
        this.checkForRef("LC_CALENDAR");
        this.m_Calendars = this.m_domWrapper.getAttributesFromElement("LC_CALENDAR", "Calendar");
        this.m_StartDayOfWeek = this.m_domWrapper.getTextFromElementsAndGPAttrib("StartDayOfWeek", "DayID", "unoid");
        this.m_MinDaysInFirstweek = this.m_domWrapper.getTextFromElementsAndParentAttrib("Calendar", "MinimalDaysInFirstWeek", "unoid");
        this.m_AbbrDays = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Day", "DayID", "DefaultAbbrvName", "unoid");
        this.m_WideDays = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Day", "DayID", "DefaultFullName", "unoid");
        this.m_AbbrMonths = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Month", "MonthID", "DefaultAbbrvName", "unoid");
        this.m_WideMonths = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Month", "MonthID", "DefaultFullName", "unoid");
        this.m_AbbrEras = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Era", "EraID", "DefaultAbbrvName", "unoid");
        this.m_WideEras = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Era", "EraID", "DefaultFullName", "unoid");
        this.getRefs("DaysOfWeek");
        this.getRefs("MonthsOfYear");
        this.getRefs("Eras");
        this.m_domWrapper.resetDoc(this.m_doc);
        Document doc = this.m_doc;
        String refFilename = this.getRef("LC_CURRENCY");
        if (refFilename != null) {
            doc = LDMLUtilities.parse(refFilename, true);
        }
        String SearchLocation = "//Locale/LC_CURRENCY/Currency";
        NodeList nl = LDMLUtilities.getNodeList(doc, SearchLocation);
        NodeList nl_id = LDMLUtilities.getNodeList(doc, "//Locale/LC_CURRENCY/Currency/CurrencyID");
        NodeList nl_symbol = LDMLUtilities.getNodeList(doc, "//Locale/LC_CURRENCY/Currency/CurrencySymbol");
        NodeList nl_code = LDMLUtilities.getNodeList(doc, "//Locale/LC_CURRENCY/Currency/BankSymbol");
        NodeList nl_name = LDMLUtilities.getNodeList(doc, "//Locale/LC_CURRENCY/Currency/CurrencyName");
        NodeList nl_decimal = LDMLUtilities.getNodeList(doc, "//Locale/LC_CURRENCY/Currency/DecimalPlaces");
        for (int i = 0; i < nl.getLength(); ++i) {
            Vector<String> inner = new Vector<String>();
            String id = LDMLUtilities.getNodeValue(nl_id.item(i));
            inner.add(0, id);
            String symbol = LDMLUtilities.getNodeValue(nl_symbol.item(i));
            inner.add(1, symbol);
            String code = LDMLUtilities.getNodeValue(nl_code.item(i));
            inner.add(2, code);
            String name = LDMLUtilities.getNodeValue(nl_name.item(i));
            inner.add(3, name);
            String decimal = LDMLUtilities.getNodeValue(nl_decimal.item(i));
            inner.add(4, decimal);
            String def = LDMLUtilities.getAttributeValue(nl.item(i), "default");
            inner.add(5, def);
            String uicfc = LDMLUtilities.getAttributeValue(nl.item(i), "usedInCompatibleFormatCodes");
            inner.add(6, uicfc);
            String legacyOnly = LDMLUtilities.getAttributeValue(nl.item(i), "legacyOnly");
            if (legacyOnly != null) {
                inner.add(7, legacyOnly);
            }
            this.m_CurrencyData.add(inner);
        }
        if (bResolveRefs) {
            this.checkForRef("LC_TRANSLITERATION");
        }
        this.m_Transliterations = this.m_domWrapper.getAttributesFromElement("LC_TRANSLITERATION", "Transliteration");
        this.m_domWrapper.resetDoc(this.m_doc);
        if (bResolveRefs) {
            this.checkForRef("LC_MISC");
        }
        this.m_ForbiddenBeginChar = miscData = this.m_domWrapper.getTextFromElement("ForbiddenCharacters", "ForbiddenLineBeginCharacters");
        if (miscData != null) {
            this.m_ForbiddenChars.put("ForbiddenLineBeginCharacters", miscData);
        }
        this.m_ForbiddenEndChar = miscData = this.m_domWrapper.getTextFromElement("ForbiddenCharacters", "ForbiddenLineEndCharacters");
        if (miscData != null) {
            this.m_ForbiddenChars.put("ForbiddenLineEndCharacters", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "trueWord")) != null) {
            this.m_ReservedWords.put("trueWord", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "falseWord")) != null) {
            this.m_ReservedWords.put("falseWord", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "aboveWord")) != null) {
            this.m_ReservedWords.put("aboveWord", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "belowWord")) != null) {
            this.m_ReservedWords.put("belowWord", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter1Word")) != null) {
            this.m_ReservedWords.put("quarter1Word", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter2Word")) != null) {
            this.m_ReservedWords.put("quarter2Word", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter3Word")) != null) {
            this.m_ReservedWords.put("quarter3Word", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter4Word")) != null) {
            this.m_ReservedWords.put("quarter4Word", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter1Abbreviation")) != null) {
            this.m_ReservedWords.put("quarter1Abbreviation", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter2Abbreviation")) != null) {
            this.m_ReservedWords.put("quarter2Abbreviation", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter3Abbreviation")) != null) {
            this.m_ReservedWords.put("quarter3Abbreviation", miscData);
        }
        if ((miscData = this.m_domWrapper.getTextFromElement("ReservedWords", "quarter4Abbreviation")) != null) {
            this.m_ReservedWords.put("quarter4Abbreviation", miscData);
        }
        this.m_domWrapper.resetDoc(this.m_doc);
        if (bResolveRefs) {
            this.checkForRef("LC_NumberingLevel");
        }
        this.m_NumberingLevels = this.m_domWrapper.getAttributesFromElement("LC_NumberingLevel", "NumberingLevel");
        this.m_domWrapper.resetDoc(this.m_doc);
        if (bResolveRefs) {
            this.checkForRef("LC_OutLineNumberingLevel");
        }
        this.m_OutlineNumberingLevels = this.m_domWrapper.getAttributesFromElement("OutlineStyle", "OutLineNumberingLevel");
        this.m_domWrapper.resetDoc(this.m_doc);
        bRc = true;
        return bRc;
    }

    private void readRefs(boolean bResolveRefs) {
        Hashtable table;
        boolean bLC_CALENDAR_Has_Ref = false;
        String refFilename = null;
        String ref = this.getFullyResulvedRef("LC_CALENDAR");
        if (ref != null) {
            this.m_Refs.put("LC_CALENDAR", ref);
            bLC_CALENDAR_Has_Ref = true;
            refFilename = this.m_filename.substring(0, this.m_filename.lastIndexOf(47)) + "/";
            refFilename = refFilename + ref;
            refFilename = refFilename + ".xml";
        }
        if (bLC_CALENDAR_Has_Ref) {
            this.resetDoc(refFilename);
        }
        if ((table = this.getFullyResulvedRef("DaysOfWeek", "Calendar", "unoid")).size() > 0) {
            this.m_Refs.put("DaysOfWeek", table);
        }
        if (bLC_CALENDAR_Has_Ref) {
            this.resetDoc(refFilename);
        }
        if ((table = this.getFullyResulvedRef("MonthsOfYear", "Calendar", "unoid")).size() > 0) {
            this.m_Refs.put("MonthsOfYear", table);
        }
        if (bLC_CALENDAR_Has_Ref) {
            this.resetDoc(refFilename);
        }
        if ((table = this.getFullyResulvedRef("Eras", "Calendar", "unoid")).size() > 0) {
            this.m_Refs.put("Eras", table);
        }
        if ((ref = this.getFullyResulvedRef("LC_CURRENCY")) != null) {
            this.m_Refs.put("LC_CURRENCY", ref);
        }
        if ((ref = this.getFullyResulvedRef("LC_CTYPE")) != null) {
            this.m_Refs.put("LC_CTYPE", ref);
        }
        if (bResolveRefs) {
            ref = this.getFullyResulvedRef("LC_FORMAT");
            if (ref != null) {
                this.m_Refs.put("LC_FORMAT", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_COLLATION")) != null) {
                this.m_Refs.put("LC_COLLATION", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_SEARCH")) != null) {
                this.m_Refs.put("LC_SEARCH", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_INDEX")) != null) {
                this.m_Refs.put("LC_INDEX", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_TRANSLITERATION")) != null) {
                this.m_Refs.put("LC_TRANSLITERATION", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_MISC")) != null) {
                this.m_Refs.put("LC_MISC", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_NumberingLevel")) != null) {
                this.m_Refs.put("LC_NumberingLevel", ref);
            }
            if ((ref = this.getFullyResulvedRef("LC_OutLineNumberingLevel")) != null) {
                this.m_Refs.put("LC_OutLineNumberingLevel", ref);
            }
        } else {
            ref = this.m_domWrapper.getAttributeValue("LC_FORMAT", "ref");
            if (ref != null) {
                this.m_Refs2.put("LC_FORMAT", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_COLLATION", "ref")) != null) {
                this.m_Refs2.put("LC_COLLATION", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_SEARCH", "ref")) != null) {
                this.m_Refs2.put("LC_SEARCH", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_INDEX", "ref")) != null) {
                this.m_Refs2.put("LC_INDEX", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_TRANSLITERATION", "ref")) != null) {
                this.m_Refs2.put("LC_TRANSLITERATION", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_MISC", "ref")) != null) {
                this.m_Refs2.put("LC_MISC", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_NumberingLevel", "ref")) != null) {
                this.m_Refs2.put("LC_NumberingLevel", ref);
            }
            if ((ref = this.m_domWrapper.getAttributeValue("LC_OutLineNumberingLevel", "ref")) != null) {
                this.m_Refs2.put("LC_OutLineNumberingLevel", ref);
            }
        }
    }

    private String getFullyResulvedRef(String element) {
        if (element == null) {
            return null;
        }
        String ref = this.m_domWrapper.getAttributeValue(element, "ref");
        String fullyResulvedRef = null;
        String logStr = "";
        while (ref != null) {
            logStr = logStr + " -> " + ref;
            fullyResulvedRef = ref;
            String refFilename = this.m_filename.substring(0, this.m_filename.lastIndexOf(47)) + "/";
            refFilename = refFilename + ref;
            refFilename = refFilename + ".xml";
            this.resetDoc(refFilename);
            ref = this.m_domWrapper.getAttributeValue(element, "ref");
        }
        if (fullyResulvedRef != null) {
            Logging.Log2("Fully resolved Ref for : " + element + " = " + logStr);
        }
        this.resetDoc(this.m_filename);
        return fullyResulvedRef;
    }

    private Hashtable getFullyResulvedRef(String element, String parentElement, String elementAttrib) {
        if (element == null || parentElement == null || elementAttrib == null) {
            return null;
        }
        Hashtable<String, String> fullyResolvedTable = new Hashtable<String, String>();
        Hashtable table = this.m_domWrapper.getAttributeValues(element, "ref", parentElement, elementAttrib);
        String fullyResulvedRef = null;
        String logStr = "";
        Enumeration data = table.elements();
        Enumeration keys = table.keys();
        String refFilename = this.m_filename;
        while (data.hasMoreElements()) {
            String ref = (String)data.nextElement();
            String key = (String)keys.nextElement();
            Vector localeAndType = null;
            while (ref != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(refFilename, ref)) != null && localeAndType.size() != 0) {
                String type = null;
                type = localeAndType.size() > 1 ? (String)localeAndType.elementAt(1) : key;
                logStr = logStr + " -> " + ref;
                fullyResulvedRef = ref;
                refFilename = this.m_filename.substring(0, this.m_filename.lastIndexOf(47)) + "/";
                refFilename = refFilename + localeAndType.elementAt(0);
                refFilename = refFilename + ".xml";
                this.resetDoc(refFilename);
                ref = this.m_domWrapper.getAttributesFromElement(parentElement, element, "ref", elementAttrib, type);
            }
            if (fullyResulvedRef.indexOf(95) == -1) {
                fullyResulvedRef = (String)localeAndType.elementAt(0) + "_" + fullyResulvedRef;
                logStr = logStr + " -> " + fullyResulvedRef;
            }
            if (fullyResulvedRef != null) {
                Logging.Log2("Fully resolved Ref for : " + key + " " + element + " = " + logStr);
            }
            logStr = "";
            fullyResolvedTable.put(key, fullyResulvedRef);
        }
        this.resetDoc(this.m_filename);
        return fullyResolvedTable;
    }

    private void checkForRef(String element) {
        if (element == null) {
            return;
        }
        String refFilename = this.getRef(element);
        if (refFilename != null) {
            Logging.Log2("Reading referenced data from : " + refFilename + " for " + element);
        }
        this.resetDoc(refFilename);
    }

    private String getRef(String element) {
        String ref;
        Vector localeAndType;
        if (element == null) {
            return null;
        }
        String refFilename = null;
        Object obj = this.m_Refs.get(element);
        if (obj != null && obj instanceof String && (localeAndType = OOToLDMLMapper.getLocaleAndType(this.m_filename, ref = (String)obj)) != null && localeAndType.size() > 0) {
            refFilename = this.m_filename.substring(0, this.m_filename.lastIndexOf(47)) + "/";
            refFilename = refFilename + (String)localeAndType.elementAt(0);
            refFilename = refFilename + ".xml";
        }
        return refFilename;
    }

    private void getRefs(String element) {
        if (element == null) {
            return;
        }
        Object obj = this.m_Refs.get(element);
        if (obj != null && obj instanceof Hashtable) {
            Hashtable refs = (Hashtable)obj;
            Enumeration keys = refs.keys();
            Enumeration data = refs.elements();
            while (keys.hasMoreElements()) {
                Hashtable WideOfInterest;
                Hashtable AbbrOfInterest;
                Hashtable Wides;
                Hashtable Abbrs;
                String ref = (String)data.nextElement();
                String key = (String)keys.nextElement();
                String refFilename = null;
                Vector localeAndType = OOToLDMLMapper.getLocaleAndType(this.m_filename, ref);
                if (localeAndType != null && localeAndType.size() > 0) {
                    refFilename = this.m_filename.substring(0, this.m_filename.lastIndexOf(47)) + "/";
                    refFilename = refFilename + (String)localeAndType.elementAt(0);
                    refFilename = refFilename + ".xml";
                }
                if (refFilename == null) continue;
                String type = null;
                type = localeAndType.size() > 1 ? (String)localeAndType.elementAt(1) : key;
                this.resetDoc(refFilename);
                if (element.compareTo("DaysOfWeek") == 0) {
                    Abbrs = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Day", "DayID", "DefaultAbbrvName", "unoid");
                    Wides = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Day", "DayID", "DefaultFullName", "unoid");
                    AbbrOfInterest = (Hashtable)Abbrs.get(type);
                    if (AbbrOfInterest != null) {
                        this.m_AbbrDays.put(key, AbbrOfInterest);
                    }
                    if ((WideOfInterest = (Hashtable)Wides.get(type)) == null) continue;
                    this.m_WideDays.put(key, WideOfInterest);
                    continue;
                }
                if (element.compareTo("MonthsOfYear") == 0) {
                    Abbrs = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Month", "MonthID", "DefaultAbbrvName", "unoid");
                    Wides = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Month", "MonthID", "DefaultFullName", "unoid");
                    AbbrOfInterest = (Hashtable)Abbrs.get(type);
                    if (AbbrOfInterest != null) {
                        this.m_AbbrMonths.put(key, AbbrOfInterest);
                    }
                    if ((WideOfInterest = (Hashtable)Wides.get(type)) == null) continue;
                    this.m_WideMonths.put(key, WideOfInterest);
                    continue;
                }
                if (element.compareTo("Eras") != 0) continue;
                Abbrs = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Era", "EraID", "DefaultAbbrvName", "unoid");
                Wides = this.m_domWrapper.getTextFromElementsAndGGPAttrib("Era", "EraID", "DefaultFullName", "unoid");
                AbbrOfInterest = (Hashtable)Abbrs.get(type);
                if (AbbrOfInterest != null) {
                    this.m_AbbrEras.put(key, AbbrOfInterest);
                }
                if ((WideOfInterest = (Hashtable)Wides.get(type)) == null) continue;
                this.m_WideEras.put(key, WideOfInterest);
            }
        }
    }

    private void resetDoc(String refFilename) {
        if (refFilename != null) {
            Document doc = LDMLUtilities.parse(refFilename, true);
            this.m_domWrapper.resetDoc(doc);
        }
    }

    private void checkReplacements() {
        Hashtable t = (Hashtable)this.m_LCFormat.elementAt(0);
        if (t != null) {
            if (this.m_ReplaceTo != null && t.containsKey("replaceTo")) {
                t.remove("replaceTo");
                t.put("replaceTo", this.m_ReplaceTo);
            }
            if (this.m_ReplaceFrom == null && t.containsKey("replaceFrom")) {
                this.m_ReplaceFrom = (String)t.get("replaceFrom");
            }
        }
    }
}

