/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.OOToLDMLPattern;

public class OOToLDMLMapper {
    public static Vector MapCalendar(Vector OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Vector<String> LDMLData = new Vector<String>();
        String defaultPos = "-1";
        for (int i = 0; i < OOData.size(); ++i) {
            String type;
            String calTypeLDML;
            Hashtable attributes = (Hashtable)OOData.elementAt(i);
            String deflt = (String)attributes.get("default");
            if (deflt != null && deflt.compareTo("true") == 0) {
                defaultPos = Integer.toString(i);
            }
            if ((calTypeLDML = OOToLDMLMapper.MapCalendarType(type = (String)attributes.get("unoid"))) == null) continue;
            LDMLData.add(calTypeLDML);
        }
        if (defaultPos.compareTo("-1") != 0) {
            LDMLData.add(defaultPos);
        }
        return LDMLData;
    }

    public static Hashtable MapDays(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable LDMLData = new Hashtable();
        Enumeration enDays = OOData.elements();
        Enumeration enCalType = OOData.keys();
        while (enDays.hasMoreElements()) {
            Hashtable<String, String> innerLDMLData = new Hashtable<String, String>();
            Hashtable OODataI = (Hashtable)enDays.nextElement();
            String calTypeI = (String)enCalType.nextElement();
            String calTypeLDML = OOToLDMLMapper.MapCalendarType(calTypeI);
            String day = (String)OODataI.get("sun");
            if (day != null) {
                innerLDMLData.put("sun", day);
            }
            if ((day = (String)OODataI.get("mon")) != null) {
                innerLDMLData.put("mon", day);
            }
            if ((day = (String)OODataI.get("tue")) != null) {
                innerLDMLData.put("tue", day);
            }
            if ((day = (String)OODataI.get("wed")) != null) {
                innerLDMLData.put("wed", day);
            }
            if ((day = (String)OODataI.get("thu")) != null) {
                innerLDMLData.put("thu", day);
            }
            if ((day = (String)OODataI.get("fri")) != null) {
                innerLDMLData.put("fri", day);
            }
            if ((day = (String)OODataI.get("sat")) != null) {
                innerLDMLData.put("sat", day);
            }
            if (calTypeLDML == null || innerLDMLData.size() <= 0) continue;
            LDMLData.put(calTypeLDML, innerLDMLData);
        }
        return LDMLData;
    }

    public static Hashtable MapWideQuarters(Hashtable OOData) {
        String q4Word;
        String q3Word;
        String q2Word;
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable LDMLData = new Hashtable();
        Hashtable<String, String> innerLDMLData = new Hashtable<String, String>();
        String q1Word = (String)OOData.get("quarter1Word");
        if (q1Word != null) {
            innerLDMLData.put("1", q1Word);
        }
        if ((q2Word = (String)OOData.get("quarter2Word")) != null) {
            innerLDMLData.put("2", q2Word);
        }
        if ((q3Word = (String)OOData.get("quarter3Word")) != null) {
            innerLDMLData.put("3", q3Word);
        }
        if ((q4Word = (String)OOData.get("quarter4Word")) != null) {
            innerLDMLData.put("4", q4Word);
        }
        if (innerLDMLData.size() > 0) {
            LDMLData.put("gregorian", innerLDMLData);
        }
        return LDMLData;
    }

    public static Hashtable MapAbbrQuarters(Hashtable OOData) {
        String q4Abbr;
        String q3Abbr;
        String q2Abbr;
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable LDMLData = new Hashtable();
        Hashtable<String, String> innerLDMLData = new Hashtable<String, String>();
        String q1Abbr = (String)OOData.get("quarter1Abbreviation");
        if (q1Abbr != null) {
            innerLDMLData.put("1", q1Abbr);
        }
        if ((q2Abbr = (String)OOData.get("quarter2Abbreviation")) != null) {
            innerLDMLData.put("2", q2Abbr);
        }
        if ((q3Abbr = (String)OOData.get("quarter3Abbreviation")) != null) {
            innerLDMLData.put("3", q3Abbr);
        }
        if ((q4Abbr = (String)OOData.get("quarter4Abbreviation")) != null) {
            innerLDMLData.put("4", q4Abbr);
        }
        if (innerLDMLData.size() > 0) {
            LDMLData.put("gregorian", innerLDMLData);
        }
        return LDMLData;
    }

    public static Hashtable MapMonths(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable LDMLData = new Hashtable();
        Enumeration enMonths = OOData.elements();
        Enumeration enCalType = OOData.keys();
        while (enMonths.hasMoreElements()) {
            Hashtable<String, String> innerLDMLData = new Hashtable<String, String>();
            Hashtable OODataI = (Hashtable)enMonths.nextElement();
            String calTypeI = (String)enCalType.nextElement();
            String calTypeLDML = OOToLDMLMapper.MapCalendarType(calTypeI);
            String month = (String)OODataI.get("jan");
            if (month == null) {
                month = (String)OODataI.get("Nissan");
            }
            if (month != null) {
                innerLDMLData.put("1", month);
            }
            if ((month = (String)OODataI.get("feb")) == null) {
                month = (String)OODataI.get("Iyar");
            }
            if (month != null) {
                innerLDMLData.put("2", month);
            }
            if ((month = (String)OODataI.get("mar")) == null) {
                month = (String)OODataI.get("Sivan");
            }
            if (month != null) {
                innerLDMLData.put("3", month);
            }
            if ((month = (String)OODataI.get("apr")) == null) {
                month = (String)OODataI.get("Tammuz");
            }
            if (month != null) {
                innerLDMLData.put("4", month);
            }
            if ((month = (String)OODataI.get("may")) == null) {
                month = (String)OODataI.get("Av");
            }
            if (month != null) {
                innerLDMLData.put("5", month);
            }
            if ((month = (String)OODataI.get("jun")) == null) {
                month = (String)OODataI.get("Elul");
            }
            if (month != null) {
                innerLDMLData.put("6", month);
            }
            if ((month = (String)OODataI.get("jul")) == null) {
                month = (String)OODataI.get("Tishri");
            }
            if (month != null) {
                innerLDMLData.put("7", month);
            }
            if ((month = (String)OODataI.get("aug")) == null) {
                month = (String)OODataI.get("Heshvan");
            }
            if (month != null) {
                innerLDMLData.put("8", month);
            }
            if ((month = (String)OODataI.get("sep")) == null) {
                month = (String)OODataI.get("Kislev");
            }
            if (month != null) {
                innerLDMLData.put("9", month);
            }
            if ((month = (String)OODataI.get("oct")) == null) {
                month = (String)OODataI.get("Tevet");
            }
            if (month != null) {
                innerLDMLData.put("10", month);
            }
            if ((month = (String)OODataI.get("nov")) == null) {
                month = (String)OODataI.get("Shevat");
            }
            if (month != null) {
                innerLDMLData.put("11", month);
            }
            if ((month = (String)OODataI.get("dec")) == null) {
                month = (String)OODataI.get("Adar");
            }
            if (month != null) {
                innerLDMLData.put("12", month);
            }
            if ((month = (String)OODataI.get("ve-Adar")) != null) {
                innerLDMLData.put("13", month);
            }
            if (calTypeLDML == null || innerLDMLData.size() <= 0) continue;
            LDMLData.put(calTypeLDML, innerLDMLData);
        }
        return LDMLData;
    }

    public static Hashtable MapEras(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable LDMLData = new Hashtable();
        Enumeration enMonths = OOData.elements();
        Enumeration enCalType = OOData.keys();
        while (enMonths.hasMoreElements()) {
            String era;
            Hashtable<String, String> innerLDMLData = new Hashtable<String, String>();
            Hashtable OODataI = (Hashtable)enMonths.nextElement();
            String calTypeI = (String)enCalType.nextElement();
            String calTypeLDML = OOToLDMLMapper.MapCalendarType(calTypeI);
            if (calTypeI.compareTo("gregorian") == 0) {
                era = (String)OODataI.get("bc");
                if (era != null) {
                    innerLDMLData.put("0", era);
                } else {
                    era = (String)OODataI.get("BC");
                    if (era != null) {
                        innerLDMLData.put("0", era);
                    }
                }
                era = (String)OODataI.get("ad");
                if (era != null) {
                    innerLDMLData.put("1", era);
                } else {
                    era = (String)OODataI.get("AD");
                    if (era != null) {
                        innerLDMLData.put("1", era);
                    }
                }
            } else if (calTypeI.compareTo("hanja") == 0) {
                era = (String)OODataI.get("bc");
                if (era != null) {
                    innerLDMLData.put("0", era);
                }
                if ((era = (String)OODataI.get("ad")) != null) {
                    innerLDMLData.put("1", era);
                }
            } else if (calTypeI.compareTo("hijri") == 0) {
                era = (String)OODataI.get("BeforeHijra");
                if (era != null) {
                    innerLDMLData.put("0", era);
                }
                if ((era = (String)OODataI.get("AfterHijra")) != null) {
                    innerLDMLData.put("1", era);
                }
            } else if (calTypeI.compareTo("jewish") == 0) {
                era = (String)OODataI.get("before");
                if (era != null) {
                    innerLDMLData.put("0", era);
                }
                if ((era = (String)OODataI.get("after")) != null) {
                    innerLDMLData.put("1", era);
                }
            } else if (calTypeI.compareTo("buddhist") == 0) {
                era = (String)OODataI.get("before");
                if (era != null) {
                    innerLDMLData.put("0", era);
                }
                if ((era = (String)OODataI.get("after")) != null) {
                    innerLDMLData.put("1", era);
                }
            } else if (calTypeI.compareTo("ROC") == 0) {
                era = (String)OODataI.get("before");
                if (era != null) {
                    innerLDMLData.put("0", era);
                }
                if ((era = (String)OODataI.get("MINGUO")) != null) {
                    innerLDMLData.put("1", era);
                }
            } else if (calTypeI.compareTo("gengou") == 0) {
                era = (String)OODataI.get("Dummy");
                if (era != null) {
                    innerLDMLData.put("-1", era);
                }
                if ((era = (String)OODataI.get("Meiji")) != null) {
                    innerLDMLData.put("232", era);
                }
                if ((era = (String)OODataI.get("Taisho")) != null) {
                    innerLDMLData.put("233", era);
                }
                if ((era = (String)OODataI.get("Showa")) != null) {
                    innerLDMLData.put("234", era);
                }
                if ((era = (String)OODataI.get("Heisei")) != null) {
                    innerLDMLData.put("235", era);
                }
            }
            if (calTypeLDML == null || innerLDMLData.size() <= 0) continue;
            LDMLData.put(calTypeLDML, innerLDMLData);
        }
        return LDMLData;
    }

    public static Hashtable MapStartDayOfWeek(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable<String, String> LDMLData = new Hashtable<String, String>();
        Enumeration enDays = OOData.elements();
        Enumeration enCalType = OOData.keys();
        while (enDays.hasMoreElements()) {
            String calTypeI = (String)enCalType.nextElement();
            String calTypeLDML = OOToLDMLMapper.MapCalendarType(calTypeI);
            String day = (String)enDays.nextElement();
            if (day.compareTo("sun") == 0) {
                LDMLData.put(calTypeLDML, "sun");
                continue;
            }
            if (day.compareTo("mon") == 0) {
                LDMLData.put(calTypeLDML, "mon");
                continue;
            }
            if (day.compareTo("tue") == 0) {
                LDMLData.put(calTypeLDML, "tue");
                continue;
            }
            if (day.compareTo("wed") == 0) {
                LDMLData.put(calTypeLDML, "wed");
                continue;
            }
            if (day.compareTo("thu") == 0) {
                LDMLData.put(calTypeLDML, "thu");
                continue;
            }
            if (day.compareTo("fri") == 0) {
                LDMLData.put(calTypeLDML, "fri");
                continue;
            }
            if (day.compareTo("sat") != 0) continue;
            LDMLData.put(calTypeLDML, "sat");
        }
        return LDMLData;
    }

    public static Hashtable MapMinDaysInFirstWeek(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable<String, String> LDMLData = new Hashtable<String, String>();
        Enumeration enDays = OOData.elements();
        Enumeration enCalType = OOData.keys();
        while (enDays.hasMoreElements()) {
            String calTypeI = (String)enCalType.nextElement();
            String calTypeLDML = OOToLDMLMapper.MapCalendarType(calTypeI);
            String numDays = (String)enDays.nextElement();
            LDMLData.put(calTypeLDML, numDays);
        }
        return LDMLData;
    }

    private static String MapCalendarType(String OOCalendar) {
        if (OOCalendar == null) {
            return null;
        }
        String LDMLCalendar = null;
        if (OOCalendar.compareTo("gregorian") == 0) {
            LDMLCalendar = "gregorian";
        } else if (OOCalendar.compareTo("hanja") == 0) {
            LDMLCalendar = "hanja";
        } else if (OOCalendar.compareTo("hijri") == 0) {
            LDMLCalendar = "islamic-civil";
        } else if (OOCalendar.compareTo("jewish") == 0) {
            LDMLCalendar = "hebrew";
        } else if (OOCalendar.compareTo("buddhist") == 0) {
            LDMLCalendar = "buddhist";
        } else if (OOCalendar.compareTo("ROC") == 0) {
            LDMLCalendar = "chinese";
        } else if (OOCalendar.compareTo("gengou") == 0) {
            LDMLCalendar = "japanese";
        }
        return LDMLCalendar;
    }

    public static String MapMeasurementSystem(String OO_MS) {
        if (OO_MS == null) {
            return null;
        }
        String LDML_MS = null;
        if (OO_MS.compareTo("Metric") == 0 || OO_MS.compareTo("metric") == 0) {
            LDML_MS = "metric";
        } else if (OO_MS.compareTo("US") == 0) {
            LDML_MS = "US";
        }
        return LDML_MS;
    }

    public static Hashtable MapCurrency(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable currency = OOToLDMLMapper.MapFirstCharToLowerCase2(OOData);
        return currency;
    }

    public static Hashtable MapSymbols(Hashtable OOData) {
        String listSeparator;
        String decimalSeparator;
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable<String, String> LDMLData = new Hashtable<String, String>();
        String thousandSeparator = (String)OOData.get("ThousandSeparator");
        if (thousandSeparator != null) {
            LDMLData.put("group", thousandSeparator);
        }
        if ((decimalSeparator = (String)OOData.get("DecimalSeparator")) != null) {
            LDMLData.put("decimal", decimalSeparator);
        }
        if ((listSeparator = (String)OOData.get("ListSeparator")) != null) {
            LDMLData.put("list", listSeparator);
        }
        return LDMLData;
    }

    public static Hashtable MapOOSymbols(Hashtable OOData) {
        String longDateYearSeparator;
        String longDateMnothSeparator;
        String longDateDaySeparator;
        String longDateDayOfWeekSeparator;
        String time100SecSeparator;
        String timeSeparator;
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable<String, String> LDMLData = new Hashtable<String, String>();
        String dateSeparator = (String)OOData.get("DateSeparator");
        if (dateSeparator != null) {
            LDMLData.put("dateSeparator", dateSeparator);
        }
        if ((timeSeparator = (String)OOData.get("TimeSeparator")) != null) {
            LDMLData.put("timeSeparator", timeSeparator);
        }
        if ((time100SecSeparator = (String)OOData.get("Time100SecSeparator")) != null) {
            LDMLData.put("time100SecSeparator", time100SecSeparator);
        }
        if ((longDateDayOfWeekSeparator = (String)OOData.get("LongDateDayOfWeekSeparator")) != null) {
            LDMLData.put("longDateDayOfWeekSeparator", longDateDayOfWeekSeparator);
        }
        if ((longDateDaySeparator = (String)OOData.get("LongDateDaySeparator")) != null) {
            LDMLData.put("longDateDaySeparator", longDateDaySeparator);
        }
        if ((longDateMnothSeparator = (String)OOData.get("LongDateMonthSeparator")) != null) {
            LDMLData.put("longDateMonthSeparator", longDateMnothSeparator);
        }
        if ((longDateYearSeparator = (String)OOData.get("LongDateYearSeparator")) != null) {
            LDMLData.put("longDateYearSeparator", longDateYearSeparator);
        }
        return LDMLData;
    }

    public static Hashtable MapDelimiters(Hashtable OOData) {
        String doubleQuotationEnd;
        String doubleQuotationStart;
        String quotationEnd;
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable<String, String> LDMLData = new Hashtable<String, String>();
        String quotationStart = (String)OOData.get("QuotationStart");
        if (quotationStart != null) {
            LDMLData.put("quotationStart", quotationStart);
        }
        if ((quotationEnd = (String)OOData.get("QuotationEnd")) != null) {
            LDMLData.put("quotationEnd", quotationEnd);
        }
        if ((doubleQuotationStart = (String)OOData.get("DoubleQuotationStart")) != null) {
            LDMLData.put("alternateQuotationStart", doubleQuotationStart);
        }
        if ((doubleQuotationEnd = (String)OOData.get("DoubleQuotationEnd")) != null) {
            LDMLData.put("alternateQuotationEnd", doubleQuotationEnd);
        }
        return LDMLData;
    }

    public static void MapFormatElements(Hashtable inFormatElements, Hashtable inFormatCodes, Hashtable inFormatDefaultNames, Hashtable outFormatElements, Hashtable outFormatCodes, Hashtable outFormatDefaultNames, String fmtElementUsage, String localeStr, boolean bConvertDateTime, Hashtable outFlexDateTime) {
        if (inFormatElements == null || inFormatCodes == null || inFormatDefaultNames == null) {
            return;
        }
        String defaultKey = null;
        String type = null;
        Hashtable LDMLData_outer = new Hashtable();
        Enumeration data = inFormatElements.elements();
        Enumeration keys = inFormatElements.keys();
        while (keys.hasMoreElements()) {
            boolean bMatchedMsgId = false;
            boolean bIsDefault = false;
            Hashtable<String, String> LDMLData_inner = new Hashtable<String, String>();
            String key = (String)keys.nextElement();
            Hashtable inner = (Hashtable)data.nextElement();
            Enumeration keys_inner = inner.keys();
            Enumeration data_inner = inner.elements();
            while (keys_inner.hasMoreElements()) {
                String key_inner = (String)keys_inner.nextElement();
                String datum_inner = (String)data_inner.nextElement();
                if (key_inner.compareTo("default") == 0 && datum_inner.compareTo("true") == 0) {
                    bIsDefault = true;
                }
                if (key_inner.compareTo("usage") == 0 && datum_inner.compareTo(fmtElementUsage) == 0) {
                    bMatchedMsgId = true;
                }
                if (key_inner.compareTo("type") == 0) {
                    type = datum_inner;
                }
                String ldml_key = null;
                ldml_key = key_inner.compareTo("msgid") == 0 ? "msgtype" : OOToLDMLMapper.makeFirstCharLowerCase(key_inner);
                LDMLData_inner.put(ldml_key, datum_inner);
            }
            if (!bMatchedMsgId) continue;
            if (bIsDefault) {
                defaultKey = key;
            }
            outFormatElements.put(key, LDMLData_inner);
            String fmtCode = (String)inFormatCodes.get(key);
            String LDMLPattern = null;
            String outPattern = null;
            OOToLDMLPattern mapper = new OOToLDMLPattern(localeStr);
            String buff = "";
            for (int ii = 0; ii < 50 - fmtCode.length(); ++ii) {
                buff = buff + " ";
            }
            if (fmtElementUsage.compareTo("DATE") == 0) {
                LDMLPattern = mapper.map(fmtCode, "DATE");
                if (LDMLPattern != null) {
                    outFlexDateTime.put(key, LDMLPattern);
                }
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter("date_time", true));
                    if (LDMLPattern.indexOf(91) == -1) {
                        out.write(fmtCode + buff + " " + LDMLPattern + "\n");
                    } else {
                        out.write(fmtCode + buff + " " + "SKIPPED" + "\n");
                    }
                    out.close();
                }
                catch (IOException e) {}
            } else if (fmtElementUsage.compareTo("TIME") == 0) {
                LDMLPattern = mapper.map(fmtCode, "TIME");
                if (LDMLPattern != null) {
                    outFlexDateTime.put(key, LDMLPattern);
                }
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter("date_time", true));
                    if (LDMLPattern.indexOf(91) == -1) {
                        out.write(fmtCode + buff + " " + LDMLPattern + "\n");
                    } else {
                        out.write(fmtCode + buff + " " + "SKIPPED" + "\n");
                    }
                    out.close();
                }
                catch (IOException e) {}
            } else if (fmtElementUsage.compareTo("DATE_TIME") == 0) {
                LDMLPattern = mapper.map(fmtCode, "DATE_TIME");
                if (LDMLPattern != null) {
                    outFlexDateTime.put(key, LDMLPattern);
                }
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter("date_time", true));
                    if (LDMLPattern.indexOf(91) == -1) {
                        out.write(fmtCode + buff + " " + LDMLPattern + "\n");
                    } else {
                        out.write(fmtCode + buff + " " + "SKIPPED" + "\n");
                    }
                    out.close();
                }
                catch (IOException e) {}
            } else {
                LDMLPattern = fmtCode;
            }
            if ((outPattern = bConvertDateTime ? LDMLPattern : fmtCode) != null) {
                outFormatCodes.put(key, outPattern);
            } else {
                System.err.println("WARNING : pattern " + fmtCode + " not written");
            }
            String fmtName = (String)inFormatDefaultNames.get(key);
            if (fmtName != null) {
                outFormatDefaultNames.put(key, fmtName);
            }
            if (defaultKey == null || type == null) continue;
            outFormatElements.put("default " + type, defaultKey);
        }
    }

    public static Hashtable MapFirstCharToLowerCase(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable<String, String> LDMLData = new Hashtable<String, String>();
        Enumeration data = OOData.elements();
        Enumeration keys = OOData.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String datum = (String)data.nextElement();
            if (key == null) continue;
            String key_lowerCase = OOToLDMLMapper.makeFirstCharLowerCase(key);
            LDMLData.put(key_lowerCase, datum);
        }
        return LDMLData;
    }

    public static Hashtable MapFirstCharToLowerCase2(Hashtable OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Hashtable LDMLData_outer = new Hashtable();
        Enumeration data = OOData.elements();
        Enumeration keys = OOData.keys();
        while (keys.hasMoreElements()) {
            Hashtable<String, String> LDMLData_inner = new Hashtable<String, String>();
            String key = (String)keys.nextElement();
            Hashtable inner = (Hashtable)data.nextElement();
            Enumeration keys_inner = inner.keys();
            Enumeration data_inner = inner.elements();
            while (keys_inner.hasMoreElements()) {
                String key_inner = (String)keys_inner.nextElement();
                String datum_inner = (String)data_inner.nextElement();
                String key_lowerCase = OOToLDMLMapper.makeFirstCharLowerCase(key_inner);
                LDMLData_inner.put(key_lowerCase, datum_inner);
            }
            LDMLData_outer.put(key, LDMLData_inner);
        }
        return LDMLData_outer;
    }

    public static Vector MapFirstCharToLowerCase(Vector OOData) {
        if (OOData == null || OOData.size() == 0) {
            return null;
        }
        Vector LDMLData = new Vector();
        for (int i = 0; i < OOData.size(); ++i) {
            Hashtable<String, String> inner = new Hashtable<String, String>();
            Enumeration data = ((Hashtable)OOData.elementAt(i)).elements();
            Enumeration keys = ((Hashtable)OOData.elementAt(i)).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String datum = (String)data.nextElement();
                if (key == null) continue;
                String key_lowerCase = OOToLDMLMapper.makeFirstCharLowerCase(key);
                inner.put(key_lowerCase, datum);
            }
            LDMLData.add(inner);
        }
        return LDMLData;
    }

    public static Hashtable MapRefsToAlias(String filename, Hashtable refs) {
        String LDMLCal;
        Enumeration data;
        Enumeration keys;
        Hashtable<String, Vector> alias;
        Hashtable refTable;
        if (refs == null || refs.size() == 0) {
            return null;
        }
        Hashtable<String, Cloneable> Aliases = new Hashtable<String, Cloneable>();
        Vector localeAndType = null;
        String ref = (String)refs.get("LC_FORMAT");
        if (ref != null) {
            localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref);
        }
        ref = (String)refs.get("LC_CALENDAR");
        localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref);
        if (ref != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("calendars", localeAndType);
        }
        if ((refTable = (Hashtable)refs.get("DaysOfWeek")) != null) {
            alias = new Hashtable<String, Vector>();
            keys = refTable.keys();
            data = refTable.elements();
            while (keys.hasMoreElements()) {
                LDMLCal = OOToLDMLMapper.MapCalendarType((String)keys.nextElement());
                localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref);
                if (localeAndType == null) continue;
                alias.put(LDMLCal, localeAndType);
            }
            Aliases.put("days", alias);
        }
        if ((refTable = (Hashtable)refs.get("MonthsOfYear")) != null) {
            alias = new Hashtable();
            keys = refTable.keys();
            data = refTable.elements();
            while (keys.hasMoreElements()) {
                LDMLCal = OOToLDMLMapper.MapCalendarType((String)keys.nextElement());
                localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref);
                if (localeAndType == null) continue;
                alias.put(LDMLCal, localeAndType);
            }
            Aliases.put("months", alias);
        }
        if ((refTable = (Hashtable)refs.get("Eras")) != null) {
            alias = new Hashtable();
            keys = refTable.keys();
            data = refTable.elements();
            while (keys.hasMoreElements()) {
                LDMLCal = OOToLDMLMapper.MapCalendarType((String)keys.nextElement());
                localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref);
                if (localeAndType == null) continue;
                alias.put(LDMLCal, localeAndType);
            }
            Aliases.put("eras", alias);
        }
        if ((ref = (String)refs.get("LC_CURRENCY")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("currency", localeAndType);
            Aliases.put("currencies", localeAndType);
        }
        if ((ref = (String)refs.get("LC_COLLATION")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("collations", localeAndType);
        }
        if ((ref = (String)refs.get("LC_SEARCH")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("search", localeAndType);
        }
        if ((ref = (String)refs.get("LC_INDEX")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("index", localeAndType);
        }
        if ((ref = (String)refs.get("LC_TRANSLITERATION")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("transliterations", localeAndType);
        }
        if ((ref = (String)refs.get("LC_MISC")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("forbiddenCharacters", localeAndType);
            Aliases.put("reservedWords", localeAndType);
        }
        if ((ref = (String)refs.get("LC_NumberingLevel")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("numberingLevels", localeAndType);
        }
        if ((ref = (String)refs.get("LC_OutLineNumberingLevel")) != null && (localeAndType = OOToLDMLMapper.getLocaleAndType(filename, ref)) != null) {
            Aliases.put("outLineNumberingLevels", localeAndType);
        }
        return Aliases;
    }

    public static Vector getLocaleAndType(String filename, String reference) {
        if (reference == null) {
            return null;
        }
        Vector<String> vect = new Vector<String>();
        if (reference.compareTo("gregorian") == 0 || reference.compareTo("hijri") == 0 || reference.compareTo("jewish") == 0 || reference.compareTo("gengou") == 0 || reference.compareTo("hanja") == 0 || reference.compareTo("buddhist") == 0 || reference.compareTo("ROC") == 0) {
            int lastSlash = filename.lastIndexOf(47);
            int lastDot = filename.lastIndexOf(46);
            String locale = filename.substring(lastSlash + 1, lastDot);
            vect.add(locale);
            vect.add(reference);
        } else {
            int first = reference.indexOf(95);
            int second = reference.indexOf(95, first + 1);
            if (second == -1) {
                vect.add(reference);
            } else {
                vect.add(reference.substring(0, second));
                vect.add(reference.substring(second + 1, reference.length()));
            }
        }
        return vect;
    }

    private static String makeFirstCharLowerCase(String inStr) {
        String outStr = "";
        String firstChar = inStr.substring(0, 1);
        String theRest = inStr.substring(1, inStr.length());
        firstChar = firstChar.toLowerCase();
        outStr = firstChar + theRest;
        return outStr;
    }

    public static Hashtable mapRefs(Hashtable refs) {
        Hashtable<String, String> LDMLRefs = new Hashtable<String, String>();
        String ref = (String)refs.get("LC_FORMAT");
        if (ref != null) {
            LDMLRefs.put("format", ref);
        }
        if ((ref = (String)refs.get("LC_COLLATION")) != null) {
            LDMLRefs.put("collations", ref);
        }
        if ((ref = (String)refs.get("LC_SEARCH")) != null) {
            LDMLRefs.put("search", ref);
        }
        if ((ref = (String)refs.get("LC_INDEX")) != null) {
            LDMLRefs.put("index", ref);
        }
        if ((ref = (String)refs.get("LC_TRANSLITERATION")) != null) {
            LDMLRefs.put("transliterations", ref);
        }
        if ((ref = (String)refs.get("LC_MISC")) != null) {
            LDMLRefs.put("reservedWords", ref);
            LDMLRefs.put("forbiddenCharacters", ref);
        }
        if ((ref = (String)refs.get("LC_NumberingLevel")) != null) {
            LDMLRefs.put("numberingLevels", ref);
        }
        if ((ref = (String)refs.get("LC_OutLineNumberingLevel")) != null) {
            LDMLRefs.put("outLineNumberingLevels", ref);
        }
        return LDMLRefs;
    }

    public static Hashtable mapLocaleInfo(Hashtable localeInfo) {
        Hashtable<String, String> info = new Hashtable<String, String>();
        String data = (String)localeInfo.get("versionDTD");
        if (data != null) {
            info.put("versionDTD", data);
        }
        if ((data = (String)localeInfo.get("allowUpdateFromCLDR")) != null) {
            info.put("allowUpdateFromCLDR", data);
        }
        if ((data = (String)localeInfo.get("version")) != null) {
            info.put("version", data);
        }
        return info;
    }
}

