/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

public class OOToLDMLPattern {
    private String m_localeStr = null;
    private String m_type = null;
    private boolean m_bIsAmPM = false;

    OOToLDMLPattern(String localeStr) {
        this.m_localeStr = localeStr;
    }

    public String map(String OOPattern, String type) {
        if (OOPattern == null) {
            return null;
        }
        this.m_type = type;
        String LDMLPattern = OOPattern;
        if (this.translate(LDMLPattern, "AM/PM")) {
            LDMLPattern = LDMLPattern.replaceAll("AM/PM", "a");
            this.m_bIsAmPM = true;
        }
        LDMLPattern = this.deLocalisePattern(LDMLPattern);
        if (this.m_type.compareTo("DATE") == 0) {
            LDMLPattern = this.mapDate(LDMLPattern);
        } else if (this.m_type.compareTo("TIME") == 0) {
            LDMLPattern = this.mapTime(LDMLPattern);
        } else if (this.m_type.compareTo("DATE_TIME") == 0) {
            LDMLPattern = this.mapDateTime(LDMLPattern);
        }
        LDMLPattern = LDMLPattern.replaceAll("\"", "'");
        LDMLPattern = this.quoteIt(LDMLPattern);
        return LDMLPattern;
    }

    private String quoteIt(String LDMLPattern) {
        String temp = LDMLPattern;
        StringBuffer sb = new StringBuffer();
        boolean bStartedQuotes = false;
        for (int i = 0; i < LDMLPattern.length(); ++i) {
            if (LDMLPattern.charAt(i) > '\u00ff') {
                int quotes = 0;
                for (int j = 0; j < i; ++j) {
                    if (LDMLPattern.charAt(j) != '\'') continue;
                    ++quotes;
                }
                if (quotes % 2 == 0 && !bStartedQuotes) {
                    sb.append('\'');
                    bStartedQuotes = true;
                }
                sb.append(LDMLPattern.charAt(i));
                continue;
            }
            if (bStartedQuotes) {
                sb.append('\'');
                bStartedQuotes = false;
            }
            sb.append(LDMLPattern.charAt(i));
        }
        if (bStartedQuotes) {
            sb.append('\'');
            bStartedQuotes = false;
        }
        if (temp.compareTo(LDMLPattern = sb.toString()) != 0) {
            System.err.println("replacing :" + temp + "   with :" + LDMLPattern);
        }
        return LDMLPattern;
    }

    private String mapDate(String LDMLPattern) {
        if (this.translate(LDMLPattern, "GGG")) {
            LDMLPattern = LDMLPattern.replaceAll("GGG", "%%%%");
        } else if (this.translate(LDMLPattern, "GG")) {
            LDMLPattern = LDMLPattern.replaceAll("GG", "&");
        } else if (this.translate(LDMLPattern, "G")) {
            LDMLPattern = LDMLPattern.replaceAll("G", "MTSH");
        } else if (this.translate(LDMLPattern, "RR")) {
            LDMLPattern = LDMLPattern.replaceAll("RR", "GGGGyy");
        }
        if (this.translate(LDMLPattern, "%%%%")) {
            LDMLPattern = LDMLPattern.replaceAll("%%%%", "GGGG");
        } else if (this.translate(LDMLPattern, "&")) {
            LDMLPattern = LDMLPattern.replaceAll("&", "G");
        }
        if (this.translate(LDMLPattern, "EE")) {
            LDMLPattern = LDMLPattern.replaceAll("EE", "yy");
        } else if (this.translate(LDMLPattern, "R")) {
            LDMLPattern = LDMLPattern.replaceAll("R", "yy");
        } else if (this.translate(LDMLPattern, "E")) {
            LDMLPattern = LDMLPattern.replaceAll("E", "y");
        } else if (this.translate(LDMLPattern, "YYYY")) {
            LDMLPattern = LDMLPattern.replaceAll("YYYY", "yyyy");
        } else if (this.translate(LDMLPattern, "YY")) {
            LDMLPattern = LDMLPattern.replaceAll("YY", "yy");
        }
        if (this.translate(LDMLPattern, "NNNN")) {
            LDMLPattern = LDMLPattern.replaceAll("NNNN", "EEEE,");
        } else if (this.translate(LDMLPattern, "DDDD")) {
            LDMLPattern = LDMLPattern.replaceAll("DDDD", "EEEE");
        } else if (this.translate(LDMLPattern, "NNN")) {
            LDMLPattern = LDMLPattern.replaceAll("NNN", "EEEE");
        } else if (this.translate(LDMLPattern, "DDD")) {
            LDMLPattern = LDMLPattern.replaceAll("DDD", "EEE");
        } else if (this.translate(LDMLPattern, "NN")) {
            LDMLPattern = LDMLPattern.replaceAll("NN", "EEE");
        }
        if (this.translate(LDMLPattern, "DD")) {
            LDMLPattern = LDMLPattern.replaceAll("DD", "dd");
        } else if (this.translate(LDMLPattern, "D")) {
            LDMLPattern = LDMLPattern.replaceAll("D", "d");
        }
        if (this.translate(LDMLPattern, "WW")) {
            LDMLPattern = LDMLPattern.replaceAll("WW", "ww");
        }
        if (this.translate(LDMLPattern, "QQ")) {
            LDMLPattern = LDMLPattern.replaceAll("QQ", "QQQQ");
        } else if (this.translate(LDMLPattern, "Q")) {
            LDMLPattern = LDMLPattern.replaceAll("Q", "QQQ");
        }
        return LDMLPattern;
    }

    private String mapTime(String LDMLPattern) {
        if (this.m_type.compareTo("DATE_TIME") == 0) {
            LDMLPattern = this.doMinutes(LDMLPattern);
        } else if (this.m_type.compareTo("TIME") == 0 && this.translate(LDMLPattern, "M")) {
            LDMLPattern = LDMLPattern.replace('M', 'm');
        }
        if (this.translate(LDMLPattern, "h")) {
            LDMLPattern = this.m_bIsAmPM ? LDMLPattern.replace('h', 'K') : LDMLPattern.replace('h', 'H');
        } else if (this.translate(LDMLPattern, "H") && this.m_bIsAmPM) {
            LDMLPattern = LDMLPattern.replace('H', 'K');
        }
        if (this.translate(LDMLPattern, "S")) {
            LDMLPattern = LDMLPattern.replace('S', 's');
        }
        if (this.translate(LDMLPattern, "0")) {
            LDMLPattern = LDMLPattern.replace('0', 'S');
        }
        return LDMLPattern;
    }

    private String mapDateTime(String LDMLPattern) {
        LDMLPattern = this.mapTime(LDMLPattern);
        LDMLPattern = this.mapDate(LDMLPattern);
        return LDMLPattern;
    }

    private boolean translate(String pattern, String str) {
        boolean doTranslation = false;
        int index = pattern.indexOf(str);
        if (index == -1) {
            return false;
        }
        int QuoteCounter = 0;
        for (int i = 0; i < index; ++i) {
            if (pattern.charAt(i) != '\"') continue;
            ++QuoteCounter;
        }
        if (QuoteCounter % 2 == 0) {
            doTranslation = true;
        }
        return doTranslation;
    }

    private String deLocalisePattern(String OOPattern) {
        if (this.m_localeStr == null) {
            return OOPattern;
        }
        if (this.m_localeStr.startsWith("de")) {
            OOPattern = OOPattern.replace('J', 'Y');
            OOPattern = OOPattern.replace('T', 'D');
        } else if (this.m_localeStr.startsWith("nl")) {
            OOPattern = OOPattern.replace('J', 'Y');
            OOPattern = OOPattern.replace('U', 'H');
        } else if (this.m_localeStr.startsWith("fr")) {
            OOPattern = OOPattern.replace('A', 'Y');
            OOPattern = OOPattern.replace('J', 'D');
        } else if (this.m_localeStr.startsWith("it")) {
            OOPattern = OOPattern.replace('A', 'Y');
            OOPattern = OOPattern.replace('G', 'D');
        } else if (this.m_localeStr.startsWith("pt") || this.m_localeStr.startsWith("es") || this.m_localeStr.startsWith("ja")) {
            OOPattern = OOPattern.replace('A', 'Y');
        } else if (this.m_localeStr.startsWith("da") || this.m_localeStr.startsWith("nb") || this.m_localeStr.startsWith("nn") || this.m_localeStr.startsWith("no") || this.m_localeStr.startsWith("sv")) {
            OOPattern = OOPattern.replace('T', 'H');
        } else if (this.m_localeStr.startsWith("fi")) {
            OOPattern = OOPattern.replace('V', 'Y');
            OOPattern = OOPattern.replace('K', 'M');
            OOPattern = OOPattern.replace('P', 'D');
            OOPattern = OOPattern.replace('T', 'H');
        }
        return OOPattern;
    }

    private String doMinutes(String pattern) {
        String dateChars = "DNYWQGERA";
        boolean bIsTime = false;
        boolean bInQuotes = false;
        int i = 0;
        int start = 0;
        int pos_M = 0;
        while ((pos_M = pattern.indexOf(77, start)) != -1) {
            for (i = pos_M; i > 0; --i) {
                if (pattern.charAt(i) == '\"') {
                    if (!bInQuotes) {
                        bInQuotes = true;
                        continue;
                    }
                    bInQuotes = false;
                    continue;
                }
                if (dateChars.indexOf(pattern.charAt(i)) != -1) break;
                if (pattern.charAt(i) != 'H' && pattern.charAt(i) != 'S' && pattern.charAt(i) != 'h' && pattern.charAt(i) != 's') continue;
                bIsTime = true;
                break;
            }
            if (!bIsTime) {
                bInQuotes = false;
                for (i = pos_M; i < pattern.length(); ++i) {
                    if (pattern.charAt(i) == '\"') {
                        bInQuotes = !bInQuotes;
                        continue;
                    }
                    if (dateChars.indexOf(pattern.charAt(i)) != -1) break;
                    if (pattern.charAt(i) != 'H' && pattern.charAt(i) != 'S' && pattern.charAt(i) != 'h' && pattern.charAt(i) != 's') continue;
                    bIsTime = true;
                    break;
                }
            }
            if (bIsTime) break;
            start = pos_M + 1;
            if (pattern.charAt(pos_M + 1) != 'M') continue;
            ++start;
        }
        if (bIsTime) {
            char[] ca = pattern.toCharArray();
            ca[pos_M] = 109;
            if (pos_M < pattern.length() - 1 && pattern.charAt(pos_M + 1) == 'M') {
                ca[pos_M + 1] = 109;
            }
            pattern = String.copyValueOf(ca);
        }
        return pattern;
    }
}

