/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.File;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.unicode.cldr.ooo.supplementalMetadata;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class supplementalData {
    private Hashtable m_fractionsData = new Hashtable();
    private Hashtable m_currencuiesInRegion = new Hashtable();
    private Hashtable m_minDays = new Hashtable();
    private Hashtable m_firstDay = new Hashtable();
    private Hashtable m_measSys = new Hashtable();
    private Document m_doc = null;
    private supplementalMetadata m_supplementalMetadata = null;

    public supplementalData(String dir) {
        String filename = dir + "/" + "supplementalData.xml";
        File file = new File(filename);
        if (file.exists()) {
            System.err.println("INFO: reading " + filename + "   this may take a couple of minutes.....");
            this.m_doc = LDMLUtilities.parse(filename, true);
            this.readFractions();
            this.readCurrencies();
            this.readMinDays();
            this.readFirstDay();
            this.readMeasSys();
            System.err.println("INFO: finished reading " + filename);
        } else {
            System.err.println("WARNING: " + filename + " not found");
        }
        this.m_supplementalMetadata = new supplementalMetadata(dir);
    }

    private void readCurrencies() {
        String SearchLocation = "//supplementalData/currencyData/region";
        NodeList nl = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl.getLength(); ++i) {
            String country = LDMLUtilities.getAttributeValue(nl.item(i), "iso3166");
            SearchLocation = "//supplementalData/currencyData/region[@iso3166=\"" + country + "\"]/currency";
            NodeList nl2 = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
            Vector<String> currs = new Vector<String>();
            for (int j = 0; j < nl2.getLength(); ++j) {
                String curr = LDMLUtilities.getAttributeValue(nl2.item(j), "iso4217");
                if (curr.equals("XXX")) continue;
                String from = LDMLUtilities.getAttributeValue(nl2.item(j), "from");
                String to = LDMLUtilities.getAttributeValue(nl2.item(j), "to");
                Calendar today = Calendar.getInstance();
                Calendar cal_from = Calendar.getInstance();
                String[] ymd = from.split("-");
                String y = ymd[0];
                String m = ymd.length > 1 ? ymd[1] : "1";
                String d = ymd.length > 2 ? ymd[2] : "1";
                cal_from.set(Integer.parseInt(y), Integer.parseInt(m), Integer.parseInt(d));
                Calendar cal_to = null;
                if (to != null) {
                    cal_to = Calendar.getInstance();
                    ymd = to.split("-");
                    y = ymd[0];
                    m = ymd.length > 1 ? ymd[1] : "12";
                    d = ymd.length > 2 ? ymd[2] : "31";
                    cal_to.set(Integer.parseInt(y), Integer.parseInt(m), Integer.parseInt(d));
                }
                if (cal_from.before(today) && (cal_to == null || cal_to.after(today)) && currs.size() == 0) {
                    if (country.equals("CS") && curr.equals("EUR")) continue;
                    currs.add(0, curr);
                    continue;
                }
                if (currs.size() < 1) continue;
                currs.add(curr);
            }
            this.m_currencuiesInRegion.put(country, currs);
        }
    }

    private void readFractions() {
        String SearchLocation = "//supplementalData/currencyData/fractions/info";
        NodeList nl = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl.getLength(); ++i) {
            String currency = LDMLUtilities.getAttributeValue(nl.item(i), "iso4217");
            String digits = LDMLUtilities.getAttributeValue(nl.item(i), "digits");
            this.m_fractionsData.put(currency, digits);
        }
    }

    private void readMinDays() {
        String SearchLocation = "//supplementalData/weekData/minDays";
        NodeList nl = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl.getLength(); ++i) {
            String count = LDMLUtilities.getAttributeValue(nl.item(i), "count");
            String terrs = LDMLUtilities.getAttributeValue(nl.item(i), "territories");
            String s = (String)this.m_minDays.get(count);
            if (s == null) {
                this.m_minDays.put(count, terrs);
                continue;
            }
            s = s + " " + terrs;
            this.m_minDays.put(count, s);
        }
    }

    private void readFirstDay() {
        String SearchLocation = "//supplementalData/weekData/firstDay";
        NodeList nl = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl.getLength(); ++i) {
            String first = LDMLUtilities.getAttributeValue(nl.item(i), "day");
            String terrs = LDMLUtilities.getAttributeValue(nl.item(i), "territories");
            String s = (String)this.m_firstDay.get(first);
            if (s == null) {
                this.m_firstDay.put(first, terrs);
                continue;
            }
            s = s + " " + terrs;
            this.m_firstDay.put(first, s);
        }
    }

    private void readMeasSys() {
        String SearchLocation = "//supplementalData/measurementData/measurementSystem";
        NodeList nl = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl.getLength(); ++i) {
            String type = LDMLUtilities.getAttributeValue(nl.item(i), "type");
            String terrs = LDMLUtilities.getAttributeValue(nl.item(i), "territories");
            String s = (String)this.m_measSys.get(type);
            if (s == null) {
                this.m_measSys.put(type, terrs);
                continue;
            }
            s = s + " " + terrs;
            this.m_measSys.put(type, s);
        }
    }

    public int getDigits(String iso4217Code) {
        int digits = 2;
        if (iso4217Code == null) {
            return digits;
        }
        Object obj = this.m_fractionsData.get(iso4217Code);
        if (obj != null) {
            digits = Integer.parseInt((String)obj);
        }
        return digits;
    }

    public Vector getCurrencies(String region) {
        if (region == null) {
            return null;
        }
        region = this.m_supplementalMetadata.getCurrentTerritory(region);
        Vector currs = null;
        Object obj = this.m_currencuiesInRegion.get(region);
        if (obj != null) {
            currs = (Vector)obj;
        }
        return currs;
    }

    public boolean isValidCurrency(String region, String currency) {
        if (region == null | currency == null) {
            return false;
        }
        region = this.m_supplementalMetadata.getCurrentTerritory(region);
        boolean bIsValid = false;
        Vector currs = this.getCurrencies(region);
        if (currs != null && currs.size() > 0 && currs.contains(currency)) {
            bIsValid = true;
        }
        return bIsValid;
    }

    private String getTerritory(Hashtable table, String region) {
        if (table == null) {
            return null;
        }
        if (region == null) {
            region = "";
        }
        region = this.m_supplementalMetadata.getCurrentTerritory(region);
        Object key = null;
        String row = null;
        Set s = table.keySet();
        Object[] keys = s.toArray();
        for (int i = 0; i < keys.length; ++i) {
            String terrs = (String)table.get(keys[i]);
            if (terrs.indexOf(region) > -1) {
                return (String)keys[i];
            }
            if (!terrs.equals("001")) continue;
            row = (String)keys[i];
        }
        return row;
    }

    public String getMinDays(String region) {
        return this.getTerritory(this.m_minDays, region);
    }

    public String getFirstDay(String region) {
        return this.getTerritory(this.m_firstDay, region);
    }

    public String getMessSys(String region) {
        return this.getTerritory(this.m_measSys, region);
    }
}

