/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.io.File;
import java.util.Hashtable;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class supplementalMetadata {
    private Hashtable m_LegacyTerritories = new Hashtable();
    private Document m_doc = null;

    public supplementalMetadata(String dir) {
        String filename = dir + "/" + "supplementalMetadata.xml";
        File file = new File(filename);
        if (file.exists()) {
            System.err.println("INFO: reading " + filename + "   this may take a couple of minutes.....");
            this.m_doc = LDMLUtilities.parse(filename, true);
            this.readLegacyTerritories();
            System.err.println("INFO: finished reading " + filename);
        } else {
            System.err.println("WARNING: " + filename + " not found");
        }
    }

    private void readLegacyTerritories() {
        String SearchLocation = "//supplementalData/metadata/alias/territoryAlias";
        NodeList nl = LDMLUtilities.getNodeList(this.m_doc, SearchLocation);
        for (int i = 0; i < nl.getLength(); ++i) {
            String old_terr = LDMLUtilities.getAttributeValue(nl.item(i), "type");
            String new_terr = LDMLUtilities.getAttributeValue(nl.item(i), "replacement");
            if (old_terr == null || new_terr == null) continue;
            this.m_LegacyTerritories.put(old_terr, new_terr);
        }
    }

    public String getCurrentTerritory(String territory) {
        String latest = territory;
        if (this.m_LegacyTerritories.get(territory) != null) {
            latest = (String)this.m_LegacyTerritories.get(territory);
        }
        return latest;
    }
}

