/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.unicode.cldr.icu.SimpleConverter;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.posix.POSIXVariant;
import org.unicode.cldr.posix.POSIX_LCCollate;
import org.unicode.cldr.posix.POSIX_LCCtype;
import org.unicode.cldr.posix.POSIX_LCMessages;
import org.unicode.cldr.posix.POSIX_LCMonetary;
import org.unicode.cldr.posix.POSIX_LCNumeric;
import org.unicode.cldr.posix.POSIX_LCTime;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class POSIXLocale {
    String locale_name;
    String codeset;
    Document doc;
    Document supp;
    Document collrules;
    Document char_fallbk;
    POSIX_LCCtype lc_ctype;
    POSIX_LCCollate lc_collate;
    POSIX_LCNumeric lc_numeric;
    POSIX_LCMonetary lc_monetary;
    POSIX_LCTime lc_time;
    POSIX_LCMessages lc_messages;
    POSIXVariant variant;

    public POSIXLocale(String locale_name, String cldr_data_location, UnicodeSet repertoire, Charset cs, String codeset, UnicodeSet collateset, POSIXVariant variant) throws Exception {
        this.locale_name = locale_name;
        this.codeset = codeset;
        this.variant = variant;
        boolean ignoreDraft = true;
        this.doc = LDMLUtilities.getFullyResolvedLDML(cldr_data_location + File.separator + "main", locale_name, false, false, false, ignoreDraft);
        this.supp = LDMLUtilities.parse(cldr_data_location + File.separator + "supplemental" + File.separator + "supplementalData.xml", true);
        this.char_fallbk = LDMLUtilities.parse(cldr_data_location + File.separator + "supplemental" + File.separator + "characters.xml", true);
        this.collrules = LDMLUtilities.getFullyResolvedLDML(cldr_data_location + File.separator + "collation", locale_name, true, true, true, ignoreDraft);
        if (repertoire.isEmpty() && codeset.equals("UTF-8")) {
            String SearchLocation = "//ldml/characters/exemplarCharacters";
            Node n = LDMLUtilities.getNode(this.doc, SearchLocation);
            UnicodeSet ExemplarCharacters = new UnicodeSet(LDMLUtilities.getNodeValue(n));
            UnicodeSetIterator ec = new UnicodeSetIterator(ExemplarCharacters);
            while (ec.next()) {
                if (ec.codepoint == UnicodeSetIterator.IS_STRING || ec.codepoint > 65535) continue;
                repertoire.add(ec.codepoint);
            }
            UnicodeSet CaseFoldedExemplars = new UnicodeSet(ExemplarCharacters.closeOver(2));
            UnicodeSetIterator cf = new UnicodeSetIterator(CaseFoldedExemplars);
            while (cf.next()) {
                if (cf.codepoint == UnicodeSetIterator.IS_STRING || cf.codepoint > 65535) continue;
                repertoire.add(cf.codepoint);
            }
            UnicodeSetIterator it = new UnicodeSetIterator(repertoire);
            int PreviousScript = -1;
            while (it.next()) {
                int Script;
                if (it.codepoint == UnicodeSetIterator.IS_STRING || it.codepoint > 65535 || (Script = UScript.getScript((int)it.codepoint)) == 0 || Script == 1 || Script == -1 || Script == 17 || Script == PreviousScript) continue;
                UnicodeSet ThisScript = new UnicodeSet().applyIntPropertyValue(4106, Script);
                UnicodeSetIterator ts = new UnicodeSetIterator(ThisScript);
                while (ts.next()) {
                    if (ts.codepoint == UnicodeSetIterator.IS_STRING || ts.codepoint > 65535) continue;
                    repertoire.add(ts.codepoint);
                }
                PreviousScript = Script;
            }
            repertoire.add(0, 127);
        } else if (!codeset.equals("UTF-8")) {
            UnicodeSet csset = new SimpleConverter(cs).getCharset();
            repertoire = new UnicodeSet(0, 0x10FFFF).retainAll(csset);
            POSIXUtilities.setRepertoire(repertoire);
        }
        UnicodeSetIterator rep = new UnicodeSetIterator(repertoire);
        while (rep.next()) {
            if (UCharacter.isDefined((int)rep.codepoint) || rep.codepoint == UnicodeSetIterator.IS_STRING) continue;
            repertoire.remove(rep.codepoint);
        }
        POSIXUtilities.setCharFallback(this.char_fallbk);
        this.lc_collate = new POSIX_LCCollate(this.doc, repertoire, this.collrules, collateset, codeset, variant);
        if (codeset.equals("UTF-8")) {
            UnicodeSet tailored = this.lc_collate.col.getTailoredSet();
            UnicodeSetIterator it = new UnicodeSetIterator(tailored);
            int PreviousScript = -1;
            while (it.next()) {
                int Script;
                if (it.codepoint == UnicodeSetIterator.IS_STRING || (Script = UScript.getScript((int)it.codepoint)) == 0 || Script == 1 || Script == -1 || Script == 17 || Script == PreviousScript) continue;
                UnicodeSet ThisScript = new UnicodeSet().applyIntPropertyValue(4106, Script);
                repertoire.addAll(ThisScript);
                PreviousScript = Script;
            }
        }
        this.lc_ctype = new POSIX_LCCtype(this.doc, repertoire);
        this.lc_numeric = new POSIX_LCNumeric(this.doc);
        this.lc_monetary = new POSIX_LCMonetary(this.doc, this.supp, variant);
        this.lc_time = new POSIX_LCTime(this.doc, variant);
        this.lc_messages = new POSIX_LCMessages(this.doc, locale_name, variant);
    }

    public void write(PrintWriter out) {
        out.println("comment_char *");
        out.println("escape_char /");
        out.println("");
        out.println("*************************************************************************************************");
        out.println("* POSIX Locale                                                                                  *");
        out.println("* Generated automatically from the Unicode Character Database and Common Locale Data Repository *");
        out.println("* see http://www.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap07.html                    *");
        out.println("* Locale Name : " + this.locale_name + "   Codeset : " + this.codeset);
        out.println("*************************************************************************************************");
        out.println("");
        this.lc_ctype.write(out);
        this.lc_collate.write(out);
        this.lc_numeric.write(out);
        this.lc_monetary.write(out);
        this.lc_time.write(out, this.variant);
        this.lc_messages.write(out);
    }
}

