/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.text.StringCharacterIterator;
import org.unicode.cldr.posix.POSIXVariant;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class POSIXUtilities {
    private static UnicodeSet repertoire = new UnicodeSet(0, 0x10FFFF);
    private static Document char_fallbk;

    public static void setRepertoire(UnicodeSet rep) {
        repertoire = rep;
    }

    public static void setCharFallback(Document fallbk) {
        char_fallbk = fallbk;
    }

    public static String POSIXContraction(String s) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            result.append(POSIXUtilities.POSIXCharName(cp));
        }
        return result.toString().replaceAll("><", "-");
    }

    public static String POSIXCharName(String s) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            result.append(POSIXUtilities.POSIXCharName(cp));
        }
        return result.toString();
    }

    public static String POSIXCharName(int cp) {
        String n;
        StringBuffer result = new StringBuffer();
        result.append("<");
        if (cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122) {
            result.append((char)cp);
        } else if (cp >= 48 && cp <= 57) {
            n = UCharacter.getExtendedName((int)cp);
            result.append(n.replaceAll(" ", "_").replaceAll("DIGIT_", "").toLowerCase());
        } else if (cp == 9) {
            result.append("tab");
        } else if (cp == 10) {
            result.append("newline");
        } else if (cp == 11) {
            result.append("vertical-tab");
        } else if (cp == 12) {
            result.append("form-feed");
        } else if (cp == 13) {
            result.append("carriage-return");
        } else if (cp == 32) {
            result.append("space");
        } else {
            n = UCharacter.getExtendedName((int)cp);
            result.append(n.replaceAll(" ", "_").replaceAll("<", "").replaceAll(">", "").toUpperCase());
        }
        int i = result.indexOf("_(");
        if (i >= 0) {
            result.setLength(i);
        }
        result.append(">");
        if (!repertoire.contains(cp)) {
            Node n2;
            System.out.println("WARNING: character " + result.toString() + " is not in the target codeset.");
            String substituteString = "";
            boolean SubFound = false;
            String SearchLocation = "//supplementalData/characters/character-fallback/character[@value='" + UCharacter.toString((int)cp) + "']/substitute";
            while (!SubFound && (n2 = LDMLUtilities.getNode(char_fallbk, SearchLocation)) != null) {
                substituteString = LDMLUtilities.getNodeValue(n2);
                if (!repertoire.containsAll(substituteString)) continue;
                SubFound = true;
            }
            if (SubFound) {
                System.out.println("\tSubstituted: " + POSIXUtilities.POSIXCharName(substituteString));
                result = new StringBuffer(POSIXUtilities.POSIXCharName(substituteString));
            } else {
                System.out.println("\tNo acceptable substitute found. The resulting locale source may not compile.");
            }
        }
        return result.toString();
    }

    public static String POSIXCharFullName(String s) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            result.append(POSIXUtilities.POSIXCharFullName(cp));
        }
        return result.toString();
    }

    public static String POSIXCharFullName(int cp) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        String n = UCharacter.getExtendedName((int)cp);
        result.append(n.replaceAll(" ", "_").replaceAll("<", "").replaceAll(">", "").toUpperCase());
        int i = result.indexOf("_(");
        if (i >= 0) {
            result.setLength(i);
        }
        result.append(">");
        return result.toString();
    }

    public static String POSIXCharNameNP(String s) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (cp <= 127) {
                result.append((char)cp);
                continue;
            }
            result.append(POSIXUtilities.POSIXCharName(cp));
        }
        return result.toString();
    }

    public static String POSIXDateTimeFormat(String s, boolean UseAltDigits, POSIXVariant variant) {
        String[][] FieldDescriptors = new String[][]{{"/", "<SOLIDUS>", "<SOLIDUS>", "<SOLIDUS>"}, {"DDD", "%j", "%j", "%j"}, {"EEEE", "%A", "%A", "%A"}, {"EEE", "%a", "%a", "%a"}, {"G", "%N", "%N", "%N"}, {"HH", "%H", "%OH", "%H"}, {"H", "%H", "%OH", "%k"}, {"KK", "%I", "%OI", "%I"}, {"K", "%I", "%OI", "%l"}, {"MMMM", "%B", "%B", "%B"}, {"MMM", "%b", "%b", "%b"}, {"MM", "%m", "%Om", "%m"}, {"M", "%m", "%Om", "%m"}, {"a", "%p", "%p", "%p"}, {"dd", "%d", "%Od", "%d"}, {"d", "%e", "%Oe", "%e"}, {"hh", "%I", "%OI", "%I"}, {"h", "%I", "%OI", "%l"}, {"kk", "%H", "%OH", "%H"}, {"k", "%H", "%OH", "%k"}, {"mm", "%M", "%OM", "%M"}, {"m", "%M", "%OM", "%M"}, {"yyyy", "%Y", "%Oy", "%Y"}, {"yy", "%y", "%Oy", "%y"}, {"zzzz", "%Z", "%Z", "%Z"}, {"zzz", "%Z", "%Z", "%Z"}, {"zz", "%Z", "%Z", "%Z"}, {"z", "%Z", "%Z", "%Z"}, {"ss", "%S", "%OS", "%S"}, {"s", "%S", "%OS", "%S"}};
        boolean inquotes = false;
        StringBuffer result = new StringBuffer("");
        int pos = 0;
        while (pos < s.length()) {
            boolean replaced = false;
            for (int i = 0; i < FieldDescriptors.length && !replaced && !inquotes; ++i) {
                if (s.indexOf(FieldDescriptors[i][0], pos) != pos) continue;
                if (UseAltDigits) {
                    result.append(FieldDescriptors[i][2]);
                } else if (variant.platform.equals("solaris")) {
                    result.append(FieldDescriptors[i][3]);
                } else {
                    result.append(FieldDescriptors[i][1]);
                }
                replaced = true;
                pos += FieldDescriptors[i][0].length();
            }
            if (replaced) continue;
            if (s.charAt(pos) == '\'') {
                if (pos < s.length() - 1 && s.charAt(pos + 1) == '\'') {
                    result.append('\'');
                    ++pos;
                } else {
                    inquotes = !inquotes;
                }
            } else {
                result.append(s.charAt(pos));
            }
            ++pos;
        }
        return result.toString();
    }

    public static String POSIXGrouping(String grouping_pattern) {
        String result;
        int i = grouping_pattern.indexOf(".");
        boolean first_grouping = true;
        if (i < 0) {
            result = "-1";
        } else {
            int j;
            result = new String();
            while ((j = grouping_pattern.lastIndexOf(",", i - 1)) > 0) {
                if (!first_grouping) {
                    result = result.concat(";");
                }
                Integer num_digits = new Integer(i - j - 1);
                result = result.concat(num_digits.toString());
                first_grouping = false;
                i = j;
            }
        }
        if (result.length() == 0) {
            result = "-1";
        }
        return result;
    }

    public static boolean isBetween(int a, int b, int c) {
        return a < b && b < c || c < b && b < a;
    }

    public static String CollationSettingString(Node node) {
        StringBuffer result = new StringBuffer("");
        NamedNodeMap settings = node.getAttributes();
        String[] Strengths = new String[]{"primary", "secondary", "tertiary", "quarternary", "identical"};
        Node s = settings.getNamedItem("strength");
        if (s != null) {
            for (int i = 0; i < Strengths.length; ++i) {
                if (!s.getNodeValue().equals(Strengths[i])) continue;
                result.append("[strength ");
                result.append(i + 1);
                result.append("]");
            }
        }
        if ((s = settings.getNamedItem("alternate")) != null && s.getNodeValue().matches("non\\x2dignorable|shifted")) {
            result.append("[alternate " + s.getNodeValue() + "]");
        }
        if ((s = settings.getNamedItem("backwards")) != null && s.getNodeValue().matches("on")) {
            result.append("[backwards 2]");
        }
        if ((s = settings.getNamedItem("caseFirst")) != null && s.getNodeValue().matches("upper|lower|off")) {
            result.append("[caseFirst " + s.getNodeValue() + "]");
        }
        if ((s = settings.getNamedItem("normalization")) != null && s.getNodeValue().matches("on|off")) {
            result.append("[normalization " + s.getNodeValue() + "]");
        }
        if ((s = settings.getNamedItem("caseLevel")) != null && s.getNodeValue().matches("on|off")) {
            result.append("[caseLevel " + s.getNodeValue() + "]");
        }
        if ((s = settings.getNamedItem("hiraganaQuarternary")) != null && s.getNodeValue().matches("on|off")) {
            result.append("[hiraganaQ " + s.getNodeValue() + "]");
        }
        if ((s = settings.getNamedItem("numeric")) != null && s.getNodeValue().matches("on|off")) {
            result.append("[numeric " + s.getNodeValue() + "]");
        }
        return result.toString();
    }

    public static String CollationRuleString(Node node) {
        StringBuffer result = new StringBuffer("");
        String PreviousContext = new String("");
        NodeList rules = node.getChildNodes();
        for (int i = 0; i < rules.getLength(); ++i) {
            String rule_name;
            Node rule = rules.item(i);
            if (rule.getNodeType() != 1 || (rule_name = POSIXUtilities.XML2ICURuleString(rule, PreviousContext)).length() <= 0) continue;
            if (rule_name.startsWith("|")) {
                PreviousContext = rule_name.substring(1);
                continue;
            }
            result.append(rule_name);
            PreviousContext = "";
        }
        return result.toString();
    }

    public static String XML2ICURuleString(Node rule, String PreviousContext) {
        StringBuffer result;
        block22: {
            String s;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                block21: {
                                                    s = rule.getNodeName();
                                                    result = new StringBuffer("");
                                                    if (!s.equals("p")) break block21;
                                                    result.append("<");
                                                    if (PreviousContext.length() > 0) {
                                                        result.append(PreviousContext + "|");
                                                    }
                                                    result.append(POSIXUtilities.RuleData(LDMLUtilities.getNodeValue(rule)));
                                                    break block22;
                                                }
                                                if (!s.equals("s")) break block23;
                                                result.append("<<");
                                                if (PreviousContext.length() > 0) {
                                                    result.append(PreviousContext + "|");
                                                }
                                                result.append(POSIXUtilities.RuleData(LDMLUtilities.getNodeValue(rule)));
                                                break block22;
                                            }
                                            if (!s.equals("t")) break block24;
                                            result.append("<<<");
                                            if (PreviousContext.length() > 0) {
                                                result.append(PreviousContext + "|");
                                            }
                                            result.append(POSIXUtilities.RuleData(LDMLUtilities.getNodeValue(rule)));
                                            break block22;
                                        }
                                        if (!s.equals("i")) break block25;
                                        result.append("=");
                                        if (PreviousContext.length() > 0) {
                                            result.append(PreviousContext + "|");
                                        }
                                        result.append(POSIXUtilities.RuleData(LDMLUtilities.getNodeValue(rule)));
                                        break block22;
                                    }
                                    if (s.equals("x")) {
                                        return POSIXUtilities.CollationRuleString(rule);
                                    }
                                    if (!s.equals("extend")) break block26;
                                    result.append("/");
                                    if (PreviousContext.length() > 0) {
                                        result.append(PreviousContext + "|");
                                    }
                                    result.append(POSIXUtilities.RuleData(LDMLUtilities.getNodeValue(rule)));
                                    break block22;
                                }
                                if (!s.equals("context")) break block27;
                                result.append("|");
                                result.append(POSIXUtilities.RuleData(LDMLUtilities.getNodeValue(rule)));
                                break block22;
                            }
                            if (!s.equals("pc")) break block28;
                            String chars = LDMLUtilities.getNodeValue(rule);
                            for (int i = 0; i < chars.length(); ++i) {
                                result.append("<");
                                result.append(POSIXUtilities.RuleData(chars.substring(i, i + 1)));
                            }
                            break block22;
                        }
                        if (!s.equals("sc")) break block29;
                        String chars = LDMLUtilities.getNodeValue(rule);
                        for (int i = 0; i < chars.length(); ++i) {
                            result.append("<<");
                            result.append(POSIXUtilities.RuleData(chars.substring(i, i + 1)));
                        }
                        break block22;
                    }
                    if (!s.equals("tc")) break block30;
                    String chars = LDMLUtilities.getNodeValue(rule);
                    for (int i = 0; i < chars.length(); ++i) {
                        result.append("<<<");
                        result.append(POSIXUtilities.RuleData(chars.substring(i, i + 1)));
                    }
                    break block22;
                }
                if (!s.equals("ic")) break block31;
                String chars = LDMLUtilities.getNodeValue(rule);
                for (int i = 0; i < chars.length(); ++i) {
                    result.append("=");
                    result.append(POSIXUtilities.RuleData(chars.substring(i, i + 1)));
                }
                break block22;
            }
            if (!s.equals("reset")) break block22;
            result.append("&");
            String WeightType = LDMLUtilities.getAttributeValue(rule, "before");
            if (WeightType != null) {
                if (WeightType.equals("primary")) {
                    result.append("[before 1]");
                } else if (WeightType.equals("secondary")) {
                    result.append("[before 2]");
                } else if (WeightType.equals("tertiary")) {
                    result.append("[before 3]");
                }
            }
            for (Node child = rule.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() == 3) {
                    result.append(POSIXUtilities.RuleData(child.getNodeValue()));
                    continue;
                }
                if (child.getNodeType() != 1) continue;
                String[] LogicalPositions = new String[]{"first_variable", "first_trailing", "first_tertiary_ignorable", "first_secondary_ignorable", "first_primary_ignorable", "first_non_ignorable", "last_variable", "last_trailing", "last_tertiary_ignorable", "last_secondary_ignorable", "last_primary_ignorable", "last_non_ignorable"};
                s = child.getNodeName();
                if (s.equals("cp")) {
                    String Codepoint = LDMLUtilities.getAttributeValue(child, "hex");
                    char CodepointValue = '\u0000';
                    for (int i = 0; i < Codepoint.length(); ++i) {
                        CodepointValue = (char)(CodepointValue * 16);
                        CodepointValue = (char)(CodepointValue + Character.digit(Codepoint.charAt(i), 16));
                    }
                    result.append(CodepointValue);
                    continue;
                }
                boolean found = false;
                for (int i = 0; i < LogicalPositions.length && !found; ++i) {
                    if (!s.equals(LogicalPositions[i])) continue;
                    result.append("[" + s.replaceAll("non_ignorable", "regular").replaceAll("_", " ") + "]");
                    found = true;
                }
            }
        }
        return result.toString();
    }

    public static String RuleData(String DataString) {
        StringBuffer result = new StringBuffer(DataString);
        for (int i = 0; i < result.length(); ++i) {
            String Current = result.substring(i, i + 1);
            if (!Current.matches("[\\ \\p{Punct}]")) continue;
            result.insert(i, "\\");
            ++i;
        }
        return result.toString().replaceAll("&quot;", "''").replaceAll("&amp;", "\\\\&").replaceAll("&lt;", "\\\\<").replaceAll("&gt;", "\\\\>");
    }

    public static String POSIXYesNoExpr(String s) {
        StringBuffer result = new StringBuffer();
        String[] YesNoElements = s.split(":");
        for (int i = 0; i < YesNoElements.length; ++i) {
            String cur = YesNoElements[i];
            if (cur.length() <= 1 || !cur.toLowerCase().equals(cur)) continue;
            if (result.length() > 0) {
                result.append(")|(");
            } else {
                result.append("^((");
            }
            StringCharacterIterator si = new StringCharacterIterator(cur);
            boolean OptLastChars = false;
            char c = si.first();
            while (c != '\uffff') {
                if (c != Character.toUpperCase(c)) {
                    if (si.getIndex() == 1) {
                        result.append("(");
                        OptLastChars = true;
                    }
                    result.append("[");
                    result.append(c);
                    result.append(Character.toUpperCase(c));
                    result.append("]");
                } else {
                    result.append(c);
                }
                c = si.next();
            }
            if (!OptLastChars) continue;
            result.append(")?");
        }
        result.append("))");
        return POSIXUtilities.POSIXCharNameNP(result.toString());
    }
}

