/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.CollectionUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.XPathParts;

public class CheckAttributeValues
extends CheckCLDR {
    static LinkedHashSet elementOrder = new LinkedHashSet();
    static LinkedHashSet attributeOrder = new LinkedHashSet();
    static LinkedHashSet serialElements = new LinkedHashSet();
    static Map element_attribute_validity = new TreeMap();
    static Map common_attribute_validity = new TreeMap();
    static Map variables = new TreeMap();
    static boolean initialized = false;
    static LocaleMatcher localeMatcher;
    static Map code_type_replacement;
    boolean isEnglish;
    XPathParts parts = new XPathParts(null, null);
    LocaleIDParser localeIDParser = new LocaleIDParser();
    static Set missing;

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        this.parts.set(fullPath);
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.parts.getAttributeCount(i) == 0) continue;
            Map attributes = this.parts.getAttributes(i);
            String element = this.parts.getElement(i);
            Map attribute_validity = (Map)element_attribute_validity.get(element);
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                String attribute = (String)it.next();
                String attributeValue = (String)attributes.get(attribute);
                this.check(common_attribute_validity, attribute, attributeValue, result);
                this.check(attribute_validity, attribute, attributeValue, result);
            }
        }
        return this;
    }

    private void check(Map attribute_validity, String attribute, String attributeValue, List result) {
        if (attribute_validity == null) {
            return;
        }
        MatcherPattern matcherPattern = (MatcherPattern)attribute_validity.get(attribute);
        if (matcherPattern == null) {
            return;
        }
        if (matcherPattern.matcher.matches((Object)attributeValue)) {
            return;
        }
        String replacement = this.getReplacement(matcherPattern.value, attributeValue);
        if (replacement != null) {
            if (this.isEnglish) {
                return;
            }
            if (replacement.length() == 0) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Warning").setMessage("Deprecated Attribute Value {0}={1}. Consider removing.", new Object[]{attribute, attributeValue}));
            } else {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Warning").setMessage("Deprecated Attribute Value {0}={1}. Consider removing, and possibly modifying the related value for {2}.", new Object[]{attribute, attributeValue, replacement}));
            }
        } else {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Unexpected Attribute Value {0}={1}: expected: {2}", new Object[]{attribute, attributeValue, matcherPattern.pattern}));
        }
    }

    String getReplacement(String value, String attributeValue) {
        Map type_replacement = (Map)code_type_replacement.get(value);
        if (type_replacement == null) {
            return null;
        }
        String result = (String)type_replacement.get(attributeValue);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.isEnglish = "en".equals(this.localeIDParser.set(cldrFileToCheck.getLocaleID()).getLanguage());
        LinkedHashSet linkedHashSet = elementOrder;
        synchronized (linkedHashSet) {
            if (!initialized) {
                CLDRFile metadata = cldrFileToCheck.make("supplementalMetadata", false);
                this.getMetadata(metadata);
                initialized = true;
                Iterator it = missing.iterator();
                while (it.hasNext()) {
                    System.out.println("\t\t\t<variable id=\"" + it.next() + "\" type=\"list\">stuff</variable>");
                }
                localeMatcher = LocaleMatcher.make();
            }
        }
        if (!localeMatcher.matches(cldrFileToCheck.getLocaleID())) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Invalid Locale {0}", new Object[]{cldrFileToCheck.getLocaleID()}));
        }
        return this;
    }

    private void getMetadata(CLDRFile metadata) {
        String lastPath = "//ldml";
        Iterator it = metadata.iterator(null, CLDRFile.ldmlComparator);
        while (it.hasNext()) {
            String path = (String)it.next();
            String value = metadata.getStringValue(path);
            path = metadata.getFullXPath(path);
            this.parts.set(path);
            String lastElement = this.parts.getElement(-1);
            if (lastElement.equals("elementOrder")) {
                elementOrder.addAll(Arrays.asList(value.split("\\s+")));
                continue;
            }
            if (lastElement.equals("attributeOrder")) {
                attributeOrder.addAll(Arrays.asList(value.split("\\s+")));
                continue;
            }
            if (lastElement.equals("suppress") || lastElement.equals("serialElements") || lastElement.equals("attributes")) continue;
            if (lastElement.equals("variable")) {
                Map attributes = this.parts.getAttributes(-1);
                MatcherPattern mp = this.getMatcherPattern(value, attributes, path);
                if (mp == null) continue;
                String id = (String)attributes.get("id");
                variables.put(id, mp);
                continue;
            }
            if (lastElement.equals("attributeValues")) {
                try {
                    String originalValue = value;
                    Map attributes = this.parts.getAttributes(-1);
                    MatcherPattern mp = this.getMatcherPattern(value, attributes, path);
                    if (mp == null) continue;
                    String[] attributeList = ((String)attributes.get("attributes")).split("\\s+");
                    String elementsString = (String)attributes.get("elements");
                    if (elementsString == null) {
                        this.addAttributes(attributeList, common_attribute_validity, mp);
                        continue;
                    }
                    String[] elementList = elementsString.split("\\s+");
                    for (int i = 0; i < elementList.length; ++i) {
                        String element = elementList[i];
                        TreeMap attribute_validity = (TreeMap)element_attribute_validity.get(element);
                        if (attribute_validity == null) {
                            attribute_validity = new TreeMap();
                            element_attribute_validity.put(element, attribute_validity);
                        }
                        this.addAttributes(attributeList, attribute_validity, mp);
                    }
                    continue;
                }
                catch (RuntimeException e) {
                    System.err.println("Problem with: " + path + ", \t" + value);
                    e.printStackTrace();
                    continue;
                }
            }
            if (lastElement.equals("version") || lastElement.equals("generation")) continue;
            if (lastElement.endsWith("Alias")) {
                String code = "$" + lastElement.substring(0, lastElement.length() - 5);
                TreeMap<String, String> type_replacement = (TreeMap<String, String>)code_type_replacement.get(code);
                if (type_replacement == null) {
                    type_replacement = new TreeMap<String, String>();
                    code_type_replacement.put(code, type_replacement);
                }
                Map attributes = this.parts.getAttributes(-1);
                String type = (String)attributes.get("type");
                String replacement = (String)attributes.get("replacement");
                if (replacement == null) {
                    replacement = "";
                }
                type_replacement.put(type, replacement);
                continue;
            }
            if (lastElement.equals("territoryAlias") || lastElement.equals("deprecatedItems") || lastElement.endsWith("Coverage")) continue;
            System.out.println("Unknown final element: " + path);
        }
    }

    private void checkTransitivity(Iterator iterator, Comparator ldmlComparator) {
        String b;
        String a;
        TreeSet set1 = new TreeSet();
        CollectionUtilities.addAll((Iterator)iterator, set1);
        Iterator it = set1.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.flush();
        TreeSet set = new TreeSet(ldmlComparator);
        set.addAll(set1);
        ArrayList l = new ArrayList(set);
        for (int i = 1; i < l.size(); ++i) {
            a = (String)l.get(i - 1);
            b = (String)l.get(i);
            int comp = ldmlComparator.compare(a, b);
            System.out.println(comp + "\t" + b);
            if (comp <= 0) continue;
            System.out.println("FAILED");
            ldmlComparator.compare(a, b);
        }
        System.out.flush();
        Random r = new Random();
        a = (String)l.get(r.nextInt(l.size()));
        b = (String)l.get(r.nextInt(l.size()));
        for (int i = 0; i < 1000000; ++i) {
            String c = b;
            b = a;
            a = (String)l.get(r.nextInt(l.size()));
            if (ldmlComparator.compare(a, b) > 0 || ldmlComparator.compare(b, c) > 0 || ldmlComparator.compare(a, c) <= 0) continue;
            System.out.println("FAILED");
            System.out.println(a);
            System.out.println(b);
            System.out.println(c);
            ldmlComparator.compare(a, b);
            ldmlComparator.compare(b, c);
            ldmlComparator.compare(a, c);
        }
        System.out.flush();
    }

    private MatcherPattern getMatcherPattern(String value, Map attributes, String path) {
        String typeAttribute = (String)attributes.get("type");
        MatcherPattern result = (MatcherPattern)variables.get(value);
        if (result != null) {
            MatcherPattern temp = new MatcherPattern();
            temp.pattern = result.pattern;
            temp.matcher = result.matcher;
            temp.type = typeAttribute;
            temp.value = value;
            result = temp;
            if ("list".equals(typeAttribute)) {
                temp.matcher = new ListMatcher().set(result.matcher);
            }
            return result;
        }
        result = new MatcherPattern();
        result.pattern = value;
        result.type = typeAttribute;
        result.value = value;
        if ("choice".equals(typeAttribute) || "given".equals(attributes.get("order"))) {
            result.matcher = new CollectionMatcher().set(new HashSet<String>(Arrays.asList(value.split(" "))));
        } else if ("regex".equals(typeAttribute)) {
            result.matcher = new RegexMatcher().set(value, 4);
        } else if ("locale".equals(typeAttribute)) {
            result.matcher = LocaleMatcher.make();
        } else if ("notDoneYet".equals(typeAttribute) || "notDoneYet".equals(value)) {
            result.matcher = new RegexMatcher().set(".*", 4);
        } else {
            System.out.println("unknown type; value: <" + value + ">,\t" + attributes + ",\t" + path);
            return null;
        }
        return result;
    }

    private void addAttributes(String[] attributes, Map attribute_validity, MatcherPattern mp) {
        for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            MatcherPattern old = (MatcherPattern)attribute_validity.get(attribute);
            if (old != null) {
                mp.matcher = new OrMatcher().set(old.matcher, mp.matcher);
                mp.pattern = old.pattern + " OR " + mp.pattern;
            }
            attribute_validity.put(attribute, mp);
        }
    }

    static {
        code_type_replacement = new TreeMap();
        missing = new TreeSet();
    }

    public static class LocaleMatcher
    implements CollectionUtilities.ObjectMatcher {
        CollectionUtilities.ObjectMatcher grandfathered;
        CollectionUtilities.ObjectMatcher language;
        CollectionUtilities.ObjectMatcher script;
        CollectionUtilities.ObjectMatcher territory;
        CollectionUtilities.ObjectMatcher variant;
        LocaleIDParser lip;
        static LocaleMatcher singleton = null;
        static Object sync = new Object();

        private LocaleMatcher(boolean b) {
            this.grandfathered = ((MatcherPattern)CheckAttributeValues.variables.get((Object)"$grandfathered")).matcher;
            this.language = ((MatcherPattern)CheckAttributeValues.variables.get((Object)"$language")).matcher;
            this.script = ((MatcherPattern)CheckAttributeValues.variables.get((Object)"$script")).matcher;
            this.territory = ((MatcherPattern)CheckAttributeValues.variables.get((Object)"$territory")).matcher;
            this.variant = ((MatcherPattern)CheckAttributeValues.variables.get((Object)"$variant")).matcher;
            this.lip = new LocaleIDParser();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LocaleMatcher make() {
            Object object = sync;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new LocaleMatcher(true);
                }
            }
            return singleton;
        }

        public boolean matches(Object value) {
            if (this.grandfathered.matches(value)) {
                return true;
            }
            this.lip.set((String)value);
            String field = this.lip.getLanguage();
            if (!this.language.matches((Object)field)) {
                return false;
            }
            field = this.lip.getScript();
            if (field.length() != 0 && !this.script.matches((Object)field)) {
                return false;
            }
            field = this.lip.getRegion();
            if (field.length() != 0 && !this.territory.matches((Object)field)) {
                return false;
            }
            String[] fields = this.lip.getVariants();
            for (int i = 0; i < fields.length; ++i) {
                if (this.variant.matches((Object)fields[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class ListMatcher
    implements CollectionUtilities.ObjectMatcher {
        private CollectionUtilities.ObjectMatcher other;

        public CollectionUtilities.ObjectMatcher set(CollectionUtilities.ObjectMatcher other) {
            this.other = other;
            return this;
        }

        public boolean matches(Object value) {
            String[] values = ((String)value).split("\\s+");
            if (values.length == 1 && values[0].length() == 0) {
                return true;
            }
            for (int i = 0; i < values.length; ++i) {
                if (this.other.matches((Object)values[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class OrMatcher
    implements CollectionUtilities.ObjectMatcher {
        private CollectionUtilities.ObjectMatcher a;
        private CollectionUtilities.ObjectMatcher b;

        public CollectionUtilities.ObjectMatcher set(CollectionUtilities.ObjectMatcher a, CollectionUtilities.ObjectMatcher b) {
            this.a = a;
            this.b = b;
            return this;
        }

        public boolean matches(Object value) {
            return this.a.matches(value) || this.b.matches(value);
        }
    }

    public static class CollectionMatcher
    implements CollectionUtilities.ObjectMatcher {
        private Collection collection;

        public CollectionUtilities.ObjectMatcher set(Collection collection) {
            this.collection = collection;
            return this;
        }

        public boolean matches(Object value) {
            return this.collection.contains(value);
        }
    }

    public static class RegexMatcher
    implements CollectionUtilities.ObjectMatcher {
        private Matcher matcher;

        public CollectionUtilities.ObjectMatcher set(String pattern) {
            this.matcher = Pattern.compile(pattern).matcher("");
            return this;
        }

        public CollectionUtilities.ObjectMatcher set(String pattern, int flags) {
            this.matcher = Pattern.compile(pattern, flags).matcher("");
            return this;
        }

        public boolean matches(Object value) {
            this.matcher.reset(value.toString());
            return this.matcher.matches();
        }
    }

    private static class MatcherPattern {
        public String value;
        CollectionUtilities.ObjectMatcher matcher;
        String pattern;
        String type;

        private MatcherPattern() {
        }

        public String toString() {
            return this.matcher.getClass().getName() + "\t" + this.pattern;
        }
    }
}

