/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;

public class CheckChildren
extends CheckCLDR {
    CLDRFile[] immediateChildren;
    Map tempSet = new HashMap();

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (this.immediateChildren == null) {
            return this;
        }
        if (options.get("submission") == null) {
            return this;
        }
        String current = this.getResolvedCldrFileToCheck().getStringValue(path);
        this.tempSet.clear();
        for (int i = 0; i < this.immediateChildren.length; ++i) {
            String otherValue = this.immediateChildren[i].getStringValue(path);
            this.tempSet.put(this.immediateChildren[i].getLocaleID(), otherValue);
        }
        if (this.tempSet.values().contains(current)) {
            return this;
        }
        CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Value always overridden in children: {0}", new Object[]{this.tempSet.keySet().toString()});
        result.add(item);
        this.tempSet.clear();
        return this;
    }

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        Matcher myLocalePlus = Pattern.compile(cldrFileToCheck.getLocaleID() + "_[^_]*").matcher("");
        Set children = cldrFileToCheck.getAvailableLocales();
        ArrayList<CLDRFile> iChildren = new ArrayList<CLDRFile>();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            if (!myLocalePlus.reset(locale).matches()) continue;
            CLDRFile child = cldrFileToCheck.make(locale, true);
            if (child == null) {
                CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Null file from: {0}", new Object[]{locale});
                possibleErrors.add(item);
                continue;
            }
            iChildren.add(child);
        }
        if (iChildren.size() == 0) {
            this.immediateChildren = null;
        } else {
            this.immediateChildren = new CLDRFile[iChildren.size()];
            this.immediateChildren = iChildren.toArray(this.immediateChildren);
        }
        return this;
    }
}

