/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.util.XEquivalenceMap;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class CheckDisplayCollisions
extends CheckCLDR {
    String[] typesICareAbout = new String[]{"//ldml/localeDisplayNames/languages/language[@type=\"", "//ldml/localeDisplayNames/scripts/script[@type=\"", "//ldml/localeDisplayNames/territories/territory[@type=\"", "//ldml/localeDisplayNames/variants/variant[@type=\"", "//ldml/numbers/currencies/currency[@type=\"", "\"]/displayName", "currency", "//ldml/dates/timeZoneNames/zone[@type=\""};
    boolean[] builtCollisions;
    private transient XEquivalenceMap[] collisions = new XEquivalenceMap[13];
    private Map hasCollisions = new HashMap();
    static final transient int[] pathOffsets = new int[2];
    static final transient int[] otherOffsets = new int[2];
    private XPathParts parts1;
    private XPathParts parts2;
    static long year = 31556952000L;
    static long startDate = new Date(95, 0, 15).getTime();
    static long endDate = new Date(111, 0, 15).getTime();

    public CheckDisplayCollisions() {
        for (int i = 0; i < this.collisions.length; ++i) {
            this.collisions[i] = new XEquivalenceMap();
        }
        this.clear();
        this.parts1 = new XPathParts(null, null);
        this.parts2 = new XPathParts(null, null);
    }

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        for (int i = 0; i < this.typesICareAbout.length; ++i) {
            Set codes;
            if (!path.startsWith(this.typesICareAbout[i])) continue;
            if (!this.builtCollisions[i]) {
                this.buildCollisions(i);
            }
            if ((codes = (Set)this.hasCollisions.get(path)) == null) break;
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Can't have same translation as {0}", new Object[]{codes.toString()});
            result.add(item);
            break;
        }
        return this;
    }

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        cldrFileToCheck = cldrFileToCheck.getResolved();
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.clear();
        return this;
    }

    private void clear() {
        this.hasCollisions.clear();
        this.builtCollisions = new boolean[this.typesICareAbout.length];
        for (int itemType = 0; itemType < this.collisions.length; ++itemType) {
            this.collisions[itemType].clear();
        }
    }

    private void buildCollisions(int ii) {
        this.builtCollisions[ii] = true;
        CLDRFile cldrFileToCheck = this.getCldrFileToCheck();
        Iterator it2 = cldrFileToCheck.iterator(this.typesICareAbout[ii]);
        while (it2.hasNext()) {
            String xpath = (String)it2.next();
            int nameType = CLDRFile.getNameType(xpath);
            if (nameType < 0) continue;
            if (nameType == 4) {
                nameType = 5;
            } else if (nameType >= 6 && nameType < 13) {
                nameType = 6;
            }
            String value = cldrFileToCheck.getStringValue(xpath);
            this.collisions[nameType].add((Object)xpath, (Object)value);
        }
        HashMap mapItems = new HashMap();
        for (int itemType = 0; itemType < this.collisions.length; ++itemType) {
            mapItems.clear();
            Iterator it = this.collisions[itemType].iterator();
            while (it.hasNext()) {
                Set pathSet;
                String path;
                Set equivalence = (Set)it.next();
                if (equivalence.size() == 1) continue;
                Iterator<Object> it22 = equivalence.iterator();
                while (it22.hasNext()) {
                    path = (String)it22.next();
                    HashSet s = new HashSet(equivalence);
                    s.remove(path);
                    mapItems.put(path, s);
                }
                it22 = mapItems.keySet().iterator();
                while (it22.hasNext()) {
                    path = (String)it22.next();
                    pathSet = (Set)mapItems.get(path);
                    Iterator it3 = pathSet.iterator();
                    while (it3.hasNext()) {
                        String otherPath = (String)it3.next();
                        if (!this.isEquivalent(itemType, path, otherPath)) continue;
                        it3.remove();
                    }
                    if (pathSet.size() != 0) continue;
                    it22.remove();
                }
                it22 = mapItems.keySet().iterator();
                while (it22.hasNext()) {
                    path = (String)it22.next();
                    pathSet = (Set)mapItems.get(path);
                    TreeSet<String> colliding = new TreeSet<String>();
                    this.hasCollisions.put(path, colliding);
                    Iterator it3 = pathSet.iterator();
                    while (it3.hasNext()) {
                        String otherPath = (String)it3.next();
                        String codeName = CLDRFile.getCode(otherPath);
                        if (itemType == 6) {
                            int type = CLDRFile.getNameType(path);
                            codeName = codeName + " (" + CLDRFile.getNameName(type) + ")";
                        }
                        colliding.add(codeName);
                    }
                }
            }
        }
        for (int i = 0; i < this.collisions.length; ++i) {
            this.collisions[i].clear();
        }
    }

    private boolean isEquivalent(int itemType, String path, String otherPath) {
        if (path.equals(otherPath)) {
            return true;
        }
        if (this.sameExceptProposed(path, otherPath)) {
            return true;
        }
        switch (itemType) {
            case 5: {
                return CLDRFile.getCode(path).equals(CLDRFile.getCode(otherPath));
            }
            case 6: {
                this.getOffset(path, pathOffsets);
                this.getOffset(otherPath, otherOffsets);
                if (pathOffsets[0] == otherOffsets[0] && pathOffsets[0] == pathOffsets[1] && otherOffsets[0] == otherOffsets[1]) {
                    return true;
                }
                if (!CLDRFile.getCode(path).equals(CLDRFile.getCode(otherPath))) break;
                int nameType = CLDRFile.getNameType(path);
                int otherType = CLDRFile.getNameType(otherPath);
                switch (nameType) {
                    case 7: {
                        return otherType == 8;
                    }
                    case 8: {
                        return otherType == 7;
                    }
                }
            }
        }
        return false;
    }

    private boolean sameExceptProposed(String path, String otherPath) {
        this.parts1.set(path);
        this.parts2.set(otherPath);
        if (this.parts1.size() != this.parts2.size()) {
            return false;
        }
        for (int i = 0; i < this.parts1.size(); ++i) {
            if (!this.parts1.getElement(i).equals(this.parts2.getElement(i))) {
                return false;
            }
            if (this.parts1.getAttributeCount(i) == 0 && this.parts2.getAttributeCount(i) == 0) continue;
            Map attributes1 = this.parts1.getAttributes(i);
            Map attributes2 = this.parts2.getAttributes(i);
            Set s1 = attributes1.keySet();
            Set s2 = attributes2.keySet();
            if (s1.contains("alt")) {
                s1 = new HashSet(s1);
                s1.remove("alt");
            }
            if (s2.contains("alt")) {
                s2 = new HashSet(s2);
                s2.remove("alt");
            }
            if (!((Object)s1).equals(s2)) {
                return false;
            }
            Iterator it = s1.iterator();
            while (it.hasNext()) {
                Object v2;
                Object key = it.next();
                Object v1 = attributes1.get(key);
                if (v1.equals(v2 = attributes2.get(key))) continue;
                return false;
            }
        }
        return true;
    }

    private void getOffset(String path, int[] standardAndDaylight) {
        String code = CLDRFile.getCode(path);
        TimeZone tz = TimeZone.getTimeZone((String)code);
        int daylight = Integer.MIN_VALUE;
        int standard = Integer.MAX_VALUE;
        for (long date = startDate; date < endDate; date += year / 2L) {
            int offset = tz.getOffset(date);
            if (daylight < offset) {
                daylight = offset;
            }
            if (standard <= offset) continue;
            standard = offset;
        }
        if (path.indexOf("/daylight") >= 0) {
            standard = daylight;
        } else if (path.indexOf("/standard") >= 0) {
            daylight = standard;
        }
        standardAndDaylight[0] = standard;
        standardAndDaylight[1] = daylight;
    }

    private boolean isFixedTZ(String xpath) {
        return xpath.indexOf("/standard") >= 0 || xpath.indexOf("/daylight") >= 0;
    }
}

