/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;

public class CheckExemplars
extends CheckCLDR {
    Collator col;
    Collator spaceCol;
    boolean isRoot;
    static final UnicodeSet HangulSyllables = new UnicodeSet("[[:Hangul_Syllable_Type=LVT:][:Hangul_Syllable_Type=LV:]]");
    static final UnicodeSet AlwaysOK = new UnicodeSet("[[:script=common:][:script=inherited:]-[:Default_Ignorable_Code_Point:]]");
    static final UnicodeSet AllowedInExemplars = new UnicodeSet(AlwaysOK).complement().removeAll(new UnicodeSet("[[:Uppercase:]-[\u0130]]")).addAll(new UnicodeSet("[[:Mn:][:word_break=Katakana:][:word_break=ALetter:][:word_break=MidLetter:]]"));

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        String locale = cldrFileToCheck.getLocaleID();
        this.col = Collator.getInstance((ULocale)new ULocale(locale));
        this.spaceCol = Collator.getInstance((ULocale)new ULocale(locale));
        this.spaceCol.setStrength(0);
        this.isRoot = cldrFileToCheck.getLocaleID().equals("root");
        return this;
    }

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("/exemplarCharacters") < 0) {
            return this;
        }
        boolean isAuxiliary = path.indexOf("auxiliary") >= 0;
        this.checkExemplar(value, result, isAuxiliary);
        if (options.get("submission") == null) {
            return this;
        }
        try {
            if (path.indexOf("auxiliary") < 0) {
                UnicodeSet auxiliarySet = this.getResolvedCldrFileToCheck().getExemplarSet("auxiliary");
                if (auxiliarySet == null) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Missing Auxiliary Set").setHTMLMessage("Missing Auxiliary Set: see <a href='http://www.unicode.org/cldr/data_formats.html#Exemplar'>Exemplars</a>"));
                }
            } else {
                UnicodeSet overlap;
                UnicodeSet auxiliarySet = new UnicodeSet(value);
                UnicodeSet mainSet = this.getResolvedCldrFileToCheck().getExemplarSet("");
                if (auxiliarySet.containsSome(mainSet) && (overlap = new UnicodeSet(mainSet).retainAll(auxiliarySet).removeAll(HangulSyllables)).size() != 0) {
                    String fixedExemplar1 = CollectionUtilities.prettyPrint((UnicodeSet)overlap, (boolean)true, null, null, (Comparator)this.col, (Comparator)this.col);
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Warning").setMessage("Auxilliary overlaps with main \u200e{0}\u200e", new Object[]{fixedExemplar1}));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this;
    }

    private void checkExemplar(String v, List result, boolean isAuxiliary) {
        UnicodeSet exemplar1;
        if (v == null) {
            return;
        }
        try {
            exemplar1 = new UnicodeSet(v);
        }
        catch (Exception e) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("This field must be a set of the form [a b c-d ...]: ", new Object[]{e.getMessage()}));
            return;
        }
        String fixedExemplar1 = CollectionUtilities.prettyPrint((UnicodeSet)exemplar1, (boolean)true, null, null, (Comparator)this.col, (Comparator)this.col);
        UnicodeSet doubleCheck = new UnicodeSet(fixedExemplar1);
        if (!doubleCheck.equals((Object)exemplar1)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Internal Error: formatting not working for {0}", new Object[]{exemplar1}));
        }
        if (!AllowedInExemplars.containsAll(exemplar1)) {
            if ((exemplar1 = CollectionUtilities.flatten((UnicodeSet)exemplar1).removeAll(AllowedInExemplars)).size() != 0) {
                fixedExemplar1 = CollectionUtilities.prettyPrint((UnicodeSet)exemplar1, (boolean)true, null, null, (Comparator)this.col, (Comparator)this.col);
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Warning").setMessage("Should be limited to (specific-script - uppercase - invisibles + \u0130); thus not contain: \u200e{0}\u200e", new Object[]{fixedExemplar1}));
            }
        } else if (!this.isRoot && exemplar1.size() == 0) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType(isAuxiliary ? CheckCLDR.finalErrorType : "Error").setMessage("Exemplar set must not be empty.").setHTMLMessage("Exemplar set must not be empty: see <a href='http://www.unicode.org/cldr/data_formats.html#Exemplar'>Exemplars</a>"));
        }
    }
}

