/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckExemplars;
import org.unicode.cldr.util.CLDRFile;

public class CheckForExemplars
extends CheckCLDR {
    static String[] EXEMPLAR_SKIPS = new String[]{"/currencySpacing", "/hourFormat", "/exemplarCharacters", "/pattern", "/localizedPatternChars", "/segmentations", "/dateFormatItem", "/references"};
    UnicodeSet exemplars;
    boolean skip;
    Collator col;
    Collator spaceCol;

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFile, Map options, List possibleErrors) {
        if (cldrFile == null) {
            return this;
        }
        this.skip = true;
        super.setCldrFileToCheck(cldrFile, options, possibleErrors);
        if (cldrFile.getLocaleID().equals("root")) {
            return this;
        }
        String locale = cldrFile.getLocaleID();
        this.col = Collator.getInstance((ULocale)new ULocale(locale));
        this.spaceCol = Collator.getInstance((ULocale)new ULocale(locale));
        this.spaceCol.setStrength(0);
        CLDRFile resolvedFile = cldrFile.getResolved();
        this.exemplars = resolvedFile.getExemplarSet("");
        if (this.exemplars == null) {
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("No Exemplar Characters: {0}", new Object[]{this.getClass().getName()});
            possibleErrors.add(item);
            return this;
        }
        UnicodeSet auxiliary = resolvedFile.getExemplarSet("auxiliary");
        if (auxiliary != null) {
            this.exemplars.addAll(auxiliary);
        }
        this.exemplars.addAll(CheckExemplars.AlwaysOK);
        this.skip = false;
        return this;
    }

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (this.skip) {
            return this;
        }
        if (path == null) {
            throw new InternalError("Empty path!");
        }
        if (this.getCldrFileToCheck() == null) {
            throw new InternalError("no file to check!");
        }
        String sourceLocale = this.getCldrFileToCheck().getSourceLocaleID(path, null);
        if ("code-fallback".equals(sourceLocale)) {
            return this;
        }
        if ("root".equals(sourceLocale) && path.indexOf("/calendar") >= 0 && path.indexOf("gregorian") <= 0) {
            return this;
        }
        for (int i = 0; i < EXEMPLAR_SKIPS.length; ++i) {
            if (path.indexOf(EXEMPLAR_SKIPS[i]) <= 0) continue;
            return this;
        }
        if (path.startsWith("//ldml/posix/messages")) {
            return this;
        }
        if (this.exemplars.containsAll(value)) {
            return this;
        }
        UnicodeSet missing = new UnicodeSet().addAll(value).removeAll(this.exemplars);
        String fixedMissing = CollectionUtilities.prettyPrint((UnicodeSet)missing, (boolean)true, null, null, (Comparator)this.col, (Comparator)this.col);
        CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType(CheckCLDR.finalErrorType).setMessage("Not in exemplars: \u200e{0}\u200e", new Object[]{fixedMissing});
        result.add(item);
        return this;
    }
}

