/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.XPathParts;

class FlexibleDateFromCLDR {
    DateTimePatternGenerator gen = DateTimePatternGenerator.newInstance();
    transient XPathParts parts = new XPathParts(null, null);
    private transient ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    static List tests = Arrays.asList("HHmmssSSSvvvv", "HHmm", "HHmmvvvv", "HHmmss", "HHmmssSSSSS", "HHmmssvvvv", "MMMd", "Md", "YYYYD", "yyyyww", "yyyywwEEE", "yyyyQQQQ", "yyyyMM", "yyyyMd", "yyyyMMMd", "yyyyMMMEEEd", "GyyyyMMMd", "GyyyyMMMEEEd", "YYYYwEEE", "yyyyDD", "yyyyMMFE", "eG", "dMMy", "GHHmm", "yyyyHHmm", "Kmm", "kmm", "MMdd", "ddHH", "yyyyMMMd", "yyyyMMddHHmmss", "GEEEEyyyyMMddHHmmss", "GuuuuQMMMMwwWddDDDFEEEEaHHmmssSSSvvvv");
    Map failureMap = new TreeMap();
    DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
    boolean isPreferred12Hour = false;
    private static String[] DISPLAY_NAME_MAP = new String[]{"era", "year", "quarter", "month", "week", "week_in_month", "weekday", "day", "day_of_year", "day_of_week_in_month", "dayperiod", "hour", "minute", "second", "fractional_second", "zone"};
    private static String[] APPEND_ITEM_NAME_MAP = new String[]{"G", "y", "Q", "M", "w", "W", "e", "d", "D", "F", "a", "h", "m", "s", "S", "v"};
    DateTimePatternGenerator.PatternInfo patternInfo = new DateTimePatternGenerator.PatternInfo();

    FlexibleDateFromCLDR() {
    }

    public void set(CLDRFile cldrFile) {
        this.icuServiceBuilder.setCldrFile(cldrFile);
        this.gen = DateTimePatternGenerator.newInstance();
        this.failureMap.clear();
    }

    public void showFlexibles() {
        Object item;
        Map items = this.gen.getSkeletons(new LinkedHashMap());
        System.out.println("ERRORS");
        Iterator it = this.failureMap.keySet().iterator();
        while (it.hasNext()) {
            Object item2 = it.next();
            Object value = this.failureMap.get(item2);
            System.out.println("\t" + value);
        }
        for (int i = 0; i < 16; ++i) {
            String name;
            String format = this.gen.getAppendItemFormats(i);
            if (format.indexOf(9500) >= 0) {
                System.out.println("\tMissing AppendItem format:\t" + DISPLAY_NAME_MAP[i]);
            }
            if (i == 14 || !(name = this.gen.getAppendItemNames(i)).matches("F[0-9]+")) continue;
            System.out.println("\tMissing Field Name:\t" + DISPLAY_NAME_MAP[i]);
        }
        System.out.println("SKELETON\t=> PATTERN LIST");
        it = items.keySet().iterator();
        while (it.hasNext()) {
            Object skeleton = it.next();
            System.out.println("\t\"" + skeleton + "\"\t=>\t\"" + items.get(skeleton) + "\"");
        }
        System.out.println("REDUNDANTS");
        Collection redundants = this.gen.getRedundants(new ArrayList());
        Iterator it2 = redundants.iterator();
        while (it2.hasNext()) {
            item = it2.next();
            System.out.println("\t" + item);
        }
        System.out.println("TESTS");
        it2 = tests.iterator();
        while (it2.hasNext()) {
            item = (String)it2.next();
            try {
                String pat = this.gen.getBestPattern(item);
                String sample = "<can't format>";
                try {
                    SimpleDateFormat df = this.icuServiceBuilder.getDateFormat("gregorian", pat);
                    sample = df.format(new Date());
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                System.out.println("\t\"" + item + "\"\t=>\t\"" + pat + "\"\t=>\t\"" + sample + "\"");
            }
            catch (RuntimeException e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("END");
    }

    public void checkFlexibles(String path, String value, String fullPath) {
        if (path.indexOf("numbers/symbols/decimal") >= 0) {
            this.gen.setDecimal(value);
            return;
        }
        if (path.indexOf("gregorian") < 0) {
            return;
        }
        if (path.indexOf("/appendItem") >= 0) {
            String key = this.parts.set(path).getAttributeValue(-1, "request");
            try {
                this.gen.setAppendItemFormats(this.getIndex(key, APPEND_ITEM_NAME_MAP), value);
            }
            catch (RuntimeException e) {
                this.failureMap.put(path, "\tWarning: can't set AppendItemFormat:\t" + key + ":\t" + value);
            }
            return;
        }
        if (path.indexOf("/fields") >= 0) {
            String key = this.parts.set(path).getAttributeValue(-2, "type");
            try {
                this.gen.setAppendItemNames(this.getIndex(key, DISPLAY_NAME_MAP), value);
            }
            catch (RuntimeException e) {
                this.failureMap.put(path, "\tWarning: can't set AppendItemName:\t" + key + ":\t" + value);
            }
            return;
        }
        if (path.indexOf("pattern") < 0 && path.indexOf("dateFormatItem") < 0) {
            return;
        }
        if (path.indexOf("timeFormatLength[@type=\"short\"]") >= 0) {
            this.fp.set(value);
            Iterator it = this.fp.getItems().iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (!(item instanceof DateTimePatternGenerator.VariableField) || item.toString().charAt(0) != 'h') continue;
                this.isPreferred12Hour = true;
            }
        }
        if (path.indexOf("dateTimeFormatLength") > 0) {
            return;
        }
        try {
            this.gen.add(value, false, this.patternInfo);
            switch (this.patternInfo.status) {
                case 2: {
                    this.failureMap.put(path, "Conflicting Patterns: \"" + value + "\"\t&\t\"" + this.patternInfo.conflictingPattern + "\"");
                }
            }
        }
        catch (RuntimeException e) {
            this.failureMap.put(path, e.getMessage());
        }
    }

    int getIndex(String s, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!s.equals(strings[i])) continue;
            return i;
        }
        return -1;
    }

    public Collection getRedundants(Collection output) {
        return this.gen.getRedundants(output);
    }

    public Object getFailurePath(Object path) {
        return this.failureMap.get(path);
    }

    public boolean preferred12Hour() {
        return this.isPreferred12Hour;
    }
}

