/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.XPathParts;

public class FlexibleDateTime {
    static final boolean DEBUG = false;
    static final boolean SHOW_MATCHING = false;
    static final boolean SHOW2 = false;
    static final boolean SHOW_OO = false;
    static final String SEPARATOR = "\r\n\t";
    public static PrintWriter log;
    static Date TEST_DATE;
    static Comparator VariableFieldComparator;
    public static UnicodeSet allowedDateTimeCharacters;

    public static void main(String[] args) throws IOException {
        FlexibleDateTime.generate(args);
    }

    private static void generate(String[] args) throws IOException {
        log = BagFormatter.openUTF8Writer((String)"../../dropbox/gen//flex/", (String)"log.txt");
        String filter = ".*";
        if (args.length > 0) {
            filter = args[0];
        }
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../open_office/main/", filter);
        CLDRFile.Factory mainCLDRFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
        LinkedHashSet ooLocales = new LinkedHashSet(cldrFactory.getAvailable());
        ooLocales.remove("nb_NO");
        Map localeMap = new LocaleIDFixer().fixLocales(ooLocales, new TreeMap());
        Iterator it = localeMap.keySet().iterator();
        while (it.hasNext()) {
            String sourceLocale = (String)it.next();
            String targetLocale = (String)localeMap.get(sourceLocale);
            ULocale uSourceLocale = new ULocale(sourceLocale);
            ULocale uTargetLocale = new ULocale(targetLocale);
            log.println();
            log.println(uTargetLocale.getDisplayName(ULocale.ENGLISH) + " (" + uTargetLocale + ")");
            System.out.println(sourceLocale + "\t\u2192" + uTargetLocale.getDisplayName(ULocale.ENGLISH) + " (" + uTargetLocale + ")");
            if (!sourceLocale.equals(targetLocale)) {
                log.println("[oo: " + uSourceLocale.getDisplayName(ULocale.ENGLISH) + " (" + sourceLocale + ")]");
            }
            Collection list = FlexibleDateTime.getOOData(cldrFactory, sourceLocale);
            try {
                Collection currentList = FlexibleDateTime.getDateFormats(mainCLDRFactory, targetLocale);
                list.removeAll(currentList);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (list.size() == 0) {
                log.println(sourceLocale + "\tEMPTY!");
                continue;
            }
            CLDRFile temp = CLDRFile.make(targetLocale);
            String prefix = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@_q=\"";
            int count = 0;
            HashMap<String, String> previousID = new HashMap<String, String>();
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                String pattern = (String)it2.next();
                new SimpleDateFormat(pattern);
                fp.set(pattern);
                String id = fp.getVariableFieldString();
                if (!allowedDateTimeCharacters.containsAll(id)) {
                    throw new IllegalArgumentException("Illegal characters in: " + pattern);
                }
                if (id.length() == 0) {
                    throw new IllegalArgumentException("Empty id for: " + pattern);
                }
                String previous = (String)previousID.get(id);
                if (previous != null) {
                    log.println("Skipping Duplicate pattern: " + pattern + " (already have " + previous + ")");
                    continue;
                }
                previousID.put(id, pattern);
                String path = prefix + count++ + "\"]";
                temp.add(path, pattern);
            }
            PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen//flex/", (String)(targetLocale + ".xml"));
            temp.write(pw);
            pw.close();
            log.flush();
        }
        System.out.println("done");
        log.close();
    }

    private static Collection getDateFormats(CLDRFile.Factory mainCLDRFactory, String targetLocale) {
        ArrayList<String> result = new ArrayList<String>();
        XPathParts parts = new XPathParts(null, null);
        CLDRFile currentFile = null;
        String oldTargetLocale = targetLocale;
        do {
            try {
                currentFile = mainCLDRFactory.make(targetLocale, true);
            }
            catch (RuntimeException e) {
                targetLocale = LocaleIDParser.getParent(targetLocale);
                if (targetLocale == null) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Couldn't open " + oldTargetLocale).initCause(e);
                }
                log.println("FALLING BACK TO " + targetLocale + " from " + oldTargetLocale);
            }
        } while (currentFile == null);
        Iterator it = currentFile.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (!FlexibleDateTime.isGregorianPattern(path, parts)) continue;
            String value = currentFile.getStringValue(path);
            result.add(value);
        }
        return result;
    }

    public static boolean isGregorianPattern(String path, XPathParts parts) {
        if (path.indexOf("Formats") < 0) {
            return false;
        }
        parts.set(path);
        if (parts.size() < 8 || !parts.getElement(7).equals("pattern")) {
            return false;
        }
        return parts.containsAttributeValue("type", "gregorian");
    }

    private static void test(String[] args) {
        String filter = "en_US";
        if (args.length > 0) {
            filter = args[0];
        }
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../open_office/main/", filter);
        Iterator it = cldrFactory.getAvailable().iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            ULocale ulocale = new ULocale(locale);
            System.out.println(ulocale.getDisplayName(ULocale.ENGLISH) + " (" + locale + ")");
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)ulocale);
            Collection list = FlexibleDateTime.getOOData(cldrFactory, locale);
            String[] testData = new String[]{"YwE", "yD", "yMFE", "eG", "dMMy", "kh", "GHHmm", "yyyyHHmm", "Kmm", "kmm", "MMdd", "ddHH", "yyyyMMMd", "yyyyMMddHHmmss", "GEEEEyyyyMMddHHmmss", "GuuuuMMMMwwWddDDDFEEEEaHHmmssSSSvvvv"};
            DateTimePatternGenerator fdt = DateTimePatternGenerator.newInstance();
            FlexibleDateTime.add(fdt, list);
            Date now = new Date(99, 11, 23, 1, 2, 3);
            System.out.println("Sample Input: " + now);
            for (int i = 0; i < testData.length; ++i) {
                String dfpattern;
                System.out.print("Input request: \t" + testData[i]);
                System.out.print("\r\n\tFields: \t" + fdt.getFields(testData[i]));
                try {
                    dfpattern = fdt.getBestPattern(testData[i]);
                }
                catch (Exception e) {
                    System.out.println(SEPARATOR + e.getMessage());
                    continue;
                }
                System.out.print("\r\n\tLocalized Pattern: \t" + dfpattern);
                df.applyPattern(dfpattern);
                System.out.println("\r\n\tSample Results: \t?" + df.format(now) + "?");
            }
        }
    }

    public static void add(DateTimePatternGenerator generator, Collection list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            generator.add((String)it.next(), false, null);
        }
    }

    static Collection getOOData(CLDRFile.Factory cldrFactory, String locale) {
        ArrayList<String> result = new ArrayList<String>();
        XPathParts parts = new XPathParts(null, null);
        OOConverter ooConverter = new OOConverter();
        CLDRFile item = cldrFactory.make(locale, false);
        Iterator it2 = item.iterator();
        while (it2.hasNext()) {
            String xpath = (String)it2.next();
            if (!FlexibleDateTime.isGregorianPattern(xpath, parts)) continue;
            boolean isDate = parts.getElement(4).equals("dateFormats");
            boolean isTime = parts.getElement(4).equals("timeFormats");
            String value = item.getStringValue(xpath);
            if (isDate || isTime) {
                String pattern = value;
                String oldPattern = pattern;
                if (oldPattern.indexOf(91) >= 0) {
                    log.println(locale + "\tSkipping [:\t" + xpath + "\t" + value);
                    continue;
                }
                try {
                    pattern = isDate ? ooConverter.convertOODate(pattern, locale) : ooConverter.convertOOTime(pattern, locale);
                }
                catch (RuntimeException e1) {
                    log.println(locale + "\tSkipping unknown char:\t" + xpath + "\t" + value);
                    continue;
                }
                try {
                    SimpleDateFormat d = new SimpleDateFormat(pattern);
                    result.add(d.toPattern());
                }
                catch (Exception e) {}
                continue;
            }
            log.println(locale + "\tSkipping datetime:\t" + xpath + "\t" + value);
        }
        return result;
    }

    private static Object putNoReplace(Map m, Object key, Object value) {
        Object current = m.get(key);
        if (current != null) {
            return current;
        }
        m.put(key, value);
        return null;
    }

    static {
        TEST_DATE = new Date(104, 8, 13, 23, 58, 59);
        VariableFieldComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Collection a = (Collection)o1;
                Collection b = (Collection)o2;
                if (a.size() != b.size()) {
                    if (a.size() < b.size()) {
                        return 1;
                    }
                    return -1;
                }
                Iterator itb = b.iterator();
                Iterator ita = a.iterator();
                while (ita.hasNext()) {
                    String bb;
                    String aa = (String)ita.next();
                    int result = -aa.compareTo(bb = (String)itb.next());
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
        allowedDateTimeCharacters = new UnicodeSet("[A a c D d E e F G g h H K k L m M q Q s S u v W w Y y z Z]");
    }

    static class OOConverter {
        DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();

        OOConverter() {
        }

        public String convertOODate(String source, String locale) {
            if (source.length() == 0) {
                return "";
            }
            source = source.replace('\"', '\'');
            StringBuffer buffer = new StringBuffer();
            this.fp.set(source);
            Iterator it = this.fp.getItems().iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    buffer.append(this.handleOODate(item.toString(), locale));
                    continue;
                }
                buffer.append(item);
            }
            return buffer.toString();
        }

        private String handleOODate(String string, String locale) {
            if (locale.startsWith("de")) {
                if (string.startsWith("T")) {
                    string = string.replace('T', 'D');
                }
                if (string.startsWith("J")) {
                    string = string.replace('J', 'Y');
                }
            } else if (locale.startsWith("nl")) {
                if (string.startsWith("J")) {
                    string = string.replace('J', 'Y');
                }
            } else if (locale.startsWith("fi")) {
                if (string.startsWith("K")) {
                    string = string.replace('K', 'M');
                }
                if (string.startsWith("V")) {
                    string = string.replace('V', 'Y');
                }
                if (string.startsWith("P")) {
                    string = string.replace('P', 'D');
                }
            } else if (locale.startsWith("fr")) {
                if (string.startsWith("J")) {
                    string = string.replace('J', 'D');
                }
                if (string.startsWith("A")) {
                    string = string.replace('A', 'Y');
                }
            } else if (locale.startsWith("es") || locale.startsWith("pt")) {
                if (string.startsWith("A")) {
                    string = string.replace('A', 'Y');
                }
            } else if (locale.startsWith("it")) {
                if (string.startsWith("A")) {
                    string = string.replace('A', 'Y');
                }
                if (string.startsWith("G")) {
                    string = string.replace('G', 'D');
                }
            }
            if (string.startsWith("A")) {
                string = string.replace('A', 'y');
            } else if (string.startsWith("Y") || string.startsWith("W") || string.equals("D") || string.equals("DD")) {
                string = string.toLowerCase();
            } else if (string.equals("DDD") || string.equals("NN")) {
                string = "EEE";
            } else if (string.equals("DDDD") || string.equals("NNN")) {
                string = "EEEE";
            } else {
                if (string.equals("NNNN")) {
                    return "EEEE, ";
                }
                if (string.equals("G")) {
                    string = "G";
                } else if (string.equals("GG")) {
                    string = "G";
                } else if (string.equals("GGG")) {
                    string = "G";
                } else if (string.equals("E")) {
                    string = "y";
                } else if (string.equals("EE") || string.equals("R")) {
                    string = "yy";
                } else if (string.equals("RR")) {
                    string = "Gyy";
                }
            }
            if (!allowedDateTimeCharacters.containsAll(string)) {
                throw new IllegalArgumentException("bad char in: " + string);
            }
            return string;
        }

        public String convertOOTime(String source, String locale) {
            if (source.length() == 0) {
                return "";
            }
            int isAM = (source = source.replace('\"', '\'')).indexOf("AM/PM");
            if (isAM >= 0) {
                source = source.substring(0, isAM) + "a" + source.substring(isAM + 5);
            }
            StringBuffer buffer = new StringBuffer();
            this.fp.set(source);
            Iterator it = this.fp.getItems().iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    buffer.append(this.handleOOTime(item.toString(), locale, isAM >= 0));
                    continue;
                }
                buffer.append(item);
            }
            return buffer.toString();
        }

        private String handleOOTime(String string, String locale, boolean isAM) {
            char c = string.charAt(0);
            switch (c) {
                case 'H': 
                case 'T': 
                case 'U': 
                case 'h': 
                case 't': 
                case 'u': {
                    string = string.replace(c, isAM ? (char)'h' : 'H');
                    break;
                }
                case 'M': 
                case 'S': {
                    string = string.toLowerCase();
                    break;
                }
                case '0': {
                    string = string.replace('0', 'S');
                }
            }
            if (!allowedDateTimeCharacters.containsAll(string)) {
                throw new IllegalArgumentException("bad char in: " + string);
            }
            return string;
        }

        private String convertToRule(String string) {
            this.fp.set(string);
            StringBuffer buffer = new StringBuffer();
            HashSet additions = new HashSet();
            Iterator it = this.fp.getItems().iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    String s = item.toString();
                    if (s.startsWith("a")) {
                        buffer.append(s);
                        continue;
                    }
                    buffer.append('{' + s + '}');
                    continue;
                }
                buffer.append(item);
            }
            it = additions.iterator();
            while (it.hasNext()) {
                buffer.insert(0, it.next());
            }
            return buffer.toString();
        }
    }

    static class DeprecatedCodeFixer {
        Map languageAlias = new HashMap();
        Map territoryAlias = new HashMap();
        LocaleIDParser lip;

        DeprecatedCodeFixer() {
            CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
            CLDRFile supp = cldrFactory.make("supplementalData", false);
            XPathParts parts = new XPathParts(null, null);
            Iterator it = supp.iterator("//supplementalData/metadata/alias/");
            while (it.hasNext()) {
                String path = (String)it.next();
                parts.set(supp.getFullXPath(path));
                String type = parts.getAttributeValue(3, "type");
                String replacement = parts.getAttributeValue(3, "replacement");
                if (parts.getElement(3).equals("languageAlias")) {
                    this.languageAlias.put(type, replacement);
                    continue;
                }
                if (parts.getElement(3).equals("territoryAlias")) {
                    this.territoryAlias.put(type, replacement);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type: " + path);
            }
            this.territoryAlias.put("CB", "029");
            this.languageAlias.put("no", "nb");
            this.lip = new LocaleIDParser();
        }

        String fixLocale(String locale) {
            String oldLocale = locale;
            this.lip.set(locale);
            String territory = this.lip.getRegion();
            String replacement = (String)this.territoryAlias.get(territory);
            if (replacement != null) {
                this.lip.setRegion(replacement);
            }
            locale = this.lip.toString();
            Iterator it = this.languageAlias.keySet().iterator();
            while (it.hasNext()) {
                String old = (String)it.next();
                if (!locale.startsWith(old)) continue;
                if (locale.length() == old.length()) {
                    locale = (String)this.languageAlias.get(old);
                    break;
                }
                if (locale.charAt(old.length()) != '_') continue;
                locale = (String)this.languageAlias.get(old) + locale.substring(old.length());
                break;
            }
            return locale;
        }
    }

    static class LocaleIDFixer {
        LocaleIDParser lip = new LocaleIDParser();
        static final Set mainLocales = new HashSet<String>(Arrays.asList("ar_EG", "bn_IN", "de_DE", "en_US", "es_ES", "fr_FR", "it_IT", "nl_NL", "pt_BR", "sv_SE", "zh_TW"));
        DeprecatedCodeFixer dcf = new DeprecatedCodeFixer();

        LocaleIDFixer() {
        }

        Map fixLocales(Collection available, Map result) {
            HashMap<String, HashSet<String>> language_locales = new HashMap<String, HashSet<String>>();
            Iterator<Object> it = available.iterator();
            while (it.hasNext()) {
                String locale = (String)it.next();
                String fixedLocale = this.dcf.fixLocale(locale);
                result.put(locale, fixedLocale);
                String language = this.lip.set(fixedLocale).getLanguageScript();
                HashSet<String> locales = (HashSet<String>)language_locales.get(language);
                if (locales == null) {
                    locales = new HashSet<String>();
                    language_locales.put(language, locales);
                }
                locales.add(locale);
            }
            it = language_locales.keySet().iterator();
            while (it.hasNext()) {
                String language = (String)it.next();
                Set locales = (Set)language_locales.get(language);
                if (locales.size() == 1) {
                    result.put(locales.iterator().next(), language);
                    continue;
                }
                HashSet intersect = new HashSet(mainLocales);
                intersect.retainAll(locales);
                if (intersect.size() == 1) {
                    result.put(intersect.iterator().next(), language);
                    continue;
                }
                if (locales.contains("zh_CN")) {
                    result.put("zh_CN", "zh");
                    continue;
                }
                throw new IllegalArgumentException("Need parent locale: " + locales);
            }
            return result;
        }
    }
}

