/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.util.Differ;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XMLFileReader;

public class TestMetadata {
    public static void main(String[] args) {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        CLDRFile metadata = cldrFactory.make("supplementalMetadata", false);
        TreeSet elements = new TreeSet();
        TreeSet attributes = new TreeSet();
        LinkedHashSet elementOrderingLists = new LinkedHashSet();
        TestMetadata.getElementsAndAttributes("../../common/main/root.xml", elements, attributes, elementOrderingLists);
        TreeSet suppElements = new TreeSet();
        TreeSet suppAttributes = new TreeSet();
        LinkedHashSet suppElementOrderingLists = new LinkedHashSet();
        TestMetadata.getElementsAndAttributes("../../common/supplemental/characters.xml", suppElements, suppAttributes, suppElementOrderingLists);
        TreeSet allElements = new TreeSet();
        allElements.addAll(elements);
        allElements.addAll(suppElements);
        TreeSet allAttributes = new TreeSet();
        allAttributes.addAll(attributes);
        allAttributes.addAll(suppAttributes);
        List<String> attributeOrder = Arrays.asList(metadata.getStringValue("//supplementalData/metadata/attributeOrder").split("\\s+"));
        Collection programAttributeOrder = CLDRFile.getAttributeOrder();
        TreeSet<String> allAttributeOrder = new TreeSet<String>();
        allAttributeOrder.addAll(attributeOrder);
        allAttributeOrder.addAll(programAttributeOrder);
        allAttributeOrder.remove("_q");
        if (TestMetadata.showSetDifferences("dtd attributes", allAttributes, "attributeOrder+programAttributeOrder", allAttributeOrder)) {
            System.out.println("ERROR: differences in sets!");
        }
        if (!((Object)attributeOrder).equals(programAttributeOrder)) {
            System.out.println("ElementOrderDifference: ");
            System.out.println(TestMetadata.showDifference(programAttributeOrder, attributeOrder, ", "));
            System.out.println("metadata: " + attributeOrder);
            System.out.println("program: " + programAttributeOrder);
            System.out.println("ERROR: differences in sets!");
        }
        List<String> elementOrder = Arrays.asList(metadata.getStringValue("//supplementalData/metadata/elementOrder").split("\\s+"));
        List programElementOrder = (List)CLDRFile.getElementOrder();
        TestMetadata.sublistCheck(elementOrderingLists, programElementOrder);
        TestMetadata.sublistCheck(suppElementOrderingLists, programElementOrder);
        TreeSet<String> allElementOrder = new TreeSet<String>();
        allElementOrder.addAll(elementOrder);
        allElementOrder.addAll(programElementOrder);
        if (TestMetadata.showSetDifferences("dtd elements", allElements, "elementOrder+programElementOrder", allElementOrder)) {
            System.out.println("ERROR: differences in sets!");
        }
        if (!((Object)elementOrder).equals(programElementOrder)) {
            System.out.println("ElementOrderDifference: ");
            System.out.println(TestMetadata.showDifference(programElementOrder, elementOrder, ", "));
            System.out.println("metadata: " + elementOrder);
            System.out.println("program: " + programElementOrder);
            System.out.println("ERROR: differences in sets!");
        }
        TestMetadata.testZones(metadata);
        System.out.println("Done");
    }

    private static void sublistCheck(Set elementOrderingLists, List elementOrder) {
        Iterator it = elementOrderingLists.iterator();
        while (it.hasNext()) {
            LinkedHashSet sublist = (LinkedHashSet)it.next();
            int lastPosition = -1;
            Iterator it2 = sublist.iterator();
            while (it2.hasNext()) {
                String item = (String)it2.next();
                int position = elementOrder.indexOf(item);
                if (position > lastPosition) continue;
                System.out.println("ERROR: elements out of order for: " + item + " in " + sublist);
                return;
            }
            System.out.println("Elements in order for: " + sublist);
        }
    }

    private static boolean showSetDifferences(String name1, Collection set1, String name2, Collection set2) {
        boolean hasDifference = false;
        TreeSet temp = new TreeSet();
        temp.addAll(set1);
        temp.removeAll(set2);
        if (temp.size() != 0) {
            System.out.println(name1 + " minus " + name2 + ":\t" + temp);
            hasDifference |= true;
        }
        temp.clear();
        temp.addAll(set2);
        temp.removeAll(set1);
        if (temp.size() != 0) {
            System.out.println(name2 + " minus " + name1 + ":\t" + temp);
            hasDifference |= true;
        }
        return hasDifference;
    }

    private static void getElementsAndAttributes(String fileWithDTD, Collection elements, Collection attributes, Collection elementOrderingLists) {
        XMLFileReader xfr = new XMLFileReader().setHandler(new MyHandler(elements, attributes, elementOrderingLists));
        xfr.read(fileWithDTD, -1, true);
    }

    private static String showDifference(Collection a, Collection b, String separator) {
        boolean done;
        Differ differ = new Differ(300, 3);
        StringBuffer out = new StringBuffer();
        Iterator ai = a.iterator();
        Iterator bi = b.iterator();
        boolean first = true;
        do {
            int i;
            done = true;
            if (ai.hasNext()) {
                differ.addA(ai.next());
                done = false;
            }
            if (bi.hasNext()) {
                differ.addB(bi.next());
                done = false;
            }
            differ.checkMatch(done);
            if (differ.getACount() == 0 && differ.getBCount() == 0) continue;
            if (first) {
                first = false;
            } else {
                out.append(separator);
            }
            out.append("...");
            out.append(separator).append(differ.getA(-1));
            if (differ.getACount() != 0) {
                for (i = 0; i < differ.getACount(); ++i) {
                    out.append(separator).append('-');
                    out.append(differ.getA(i));
                }
            }
            if (differ.getBCount() != 0) {
                for (i = 0; i < differ.getBCount(); ++i) {
                    out.append(separator).append('+');
                    out.append(differ.getB(i));
                }
            }
            out.append(separator).append(differ.getA(differ.getACount()));
        } while (!done);
        return out.toString();
    }

    private static void testZones(CLDRFile metadata) {
        String zoneList = null;
        Iterator it = metadata.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.indexOf("\"$tzid\"") < 0) continue;
            zoneList = metadata.getStringValue(key);
            break;
        }
        String[] zones = zoneList.split("\\s+");
        TreeSet<String> metaZoneSet = new TreeSet<String>();
        metaZoneSet.addAll(Arrays.asList(zones));
        StandardCodes sc = StandardCodes.make();
        Map new_oldZones = sc.getZoneData();
        TreeSet stdZoneSet = new TreeSet();
        stdZoneSet.addAll(new_oldZones.keySet());
        if (((Object)metaZoneSet).equals(stdZoneSet)) {
            System.out.println("Zone Set is up-to-date");
        } else {
            TreeSet<String> diff = new TreeSet<String>();
            diff.addAll(metaZoneSet);
            diff.removeAll(stdZoneSet);
            System.out.println("Meta Zones - Std Zones: " + diff);
            diff.clear();
            diff.addAll(stdZoneSet);
            diff.removeAll(metaZoneSet);
            System.out.println("Std Zones - Meta Zones: " + diff);
            System.out.println("Meta Zones: " + metaZoneSet);
            System.out.println("Std Zones: " + stdZoneSet);
        }
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        Collection elements;
        Collection attributes;
        Collection elementOrderingLists;

        public MyHandler(Collection elements, Collection attributes, Collection elementOrderingLists) {
            this.elements = elements;
            this.attributes = attributes;
            this.elementOrderingLists = elementOrderingLists;
        }

        public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
            this.attributes.add(aName);
        }

        public void handleElementDecl(String name, String model) {
            this.elements.add(name);
            LinkedHashSet<String> ordering = new LinkedHashSet<String>(Arrays.asList(model.split("[^-_a-zA-Z0-9]+")));
            ordering.remove("");
            ordering.remove("PCDATA");
            ordering.remove("EMPTY");
            if (ordering.size() <= 1 || this.elementOrderingLists.add(ordering)) {
                // empty if block
            }
        }
    }
}

