/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.dev.test.util.ICUPropertyFactory;
import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.RandomStringGenerator;
import org.unicode.cldr.util.Segmenter;

public class TestSegments {
    private static final boolean TESTING = true;
    static String indent = "\t\t";
    private static final boolean DEBUG_SHOW_MATCHES = false;
    private static final boolean SHOW_RULE_LIST = false;
    private static final int monkeyLimit = 1000;
    private static final int monkeyStringCount = 10;
    private static final Matcher flagItems = Pattern.compile("[$](BK|CR|LF|CM|NL|WJ|ZW|GL|SP|CB)").matcher("");
    static final String[][] tests = new String[][]{{"QuickCheck", "1) \u00f7 b", "2) \u00d7 .", "0.5) a \u00d7", "test", "abcbdb"}, {"QuickCheck2", "$Letter=\\p{Alphabetic}", "$Digit=\\p{Digit}", "1) $Digit \u00d7 $Digit", "2) $Letter \u00d7 $Letter", "test", "The quick 100 brown foxes."}, {"GraphemeClusterBreak", "test", "The qui\u0300ck 100 brown foxes.", "compareGrapheme"}, {"LineBreak", "test", "\ucd40\u1185", "http://www.cs.tut.fi/%7Ejkorpela/html/nobr.html?abcd=high&hijk=low#anchor", "T\u0300he qui\u0300ck 100.1 brown\r\n\u0300foxes. And the beginning. \"Hi?\" Nope! or not.", "compareLine"}, {"SentenceBreak", "test", "T\u0300he qui\u0300ck 100.1 brown\r\n\u0300foxes. And the beginning. \"Hi?\" Nope! or not.", "compareSentence"}, {"WordBreak", "test", "T\u0300he qui\u0300ck 100.1 brown\r\n\u0300foxes.", "compareWord"}};

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"GraphemeClusterBreak", "LineBreak", "SentenceBreak", "WordBreak"};
        }
        List<String> testChoice = Arrays.asList(args);
        ICUPropertyFactory propFactory = ICUPropertyFactory.make();
        block0: for (int i = 0; i < tests.length; ++i) {
            String line;
            String testName = tests[i][0];
            if (!testChoice.contains(testName)) continue;
            int j = 1;
            Segmenter.Builder rb = Segmenter.make((UnicodeProperty.Factory)propFactory, testName);
            if (rb != null) {
                System.out.println("Found: " + testName);
            } else {
                rb = new Segmenter.Builder((UnicodeProperty.Factory)propFactory);
            }
            System.out.println();
            System.out.println();
            System.out.println("Building: " + testName);
            while (j < tests[i].length && !(line = tests[i][j]).equals("test")) {
                rb.addLine(line);
                ++j;
            }
            System.out.print(rb.toString(testName, indent));
            System.out.println();
            System.out.println("Testing");
            Segmenter rl = rb.make();
            Collection values = rl.getSamples().getAvailableValues();
            System.out.println("Value Partition: " + values);
            ++j;
            while (j < tests[i].length) {
                System.out.println();
                String line2 = tests[i][j];
                if (line2.startsWith("compare")) {
                    TestSegments.doCompare((UnicodeProperty.Factory)propFactory, rl, line2);
                    continue block0;
                }
                String showingBreaks = "";
                for (int k = 0; k <= line2.length(); ++k) {
                    if (rl.breaksAt(line2, k)) {
                        showingBreaks = showingBreaks + '|';
                    }
                    if (k >= line2.length()) continue;
                    showingBreaks = showingBreaks + line2.charAt(k);
                }
                System.out.println(showingBreaks);
                ++j;
            }
        }
        System.out.println();
        System.out.println("Done");
    }

    private static void debugRule(Segmenter.Builder rb) {
        Segmenter.Rule rule = rb.make().get(16.01);
        String oldAL = (String)rb.getVariables().get("$oldAL");
        UnicodeSet oldALSet = new UnicodeSet(oldAL);
        String testStr = "\ua80d/\u0745\u2026";
        for (int k = 0; k < testStr.length(); ++k) {
            boolean inside = oldALSet.contains((int)testStr.charAt(k));
            System.out.println(k + ": " + inside + Utility.escape((String)("" + testStr.charAt(k))));
        }
        byte m = rule.matches(testStr, 3);
    }

    /*
     * WARNING - void declaration
     */
    private static void doCompare(UnicodeProperty.Factory factory, Segmenter rl, String line) {
        RuleBasedBreakIterator icuBreak;
        RandomStringGenerator rsg;
        if (line.equals("compareGrapheme")) {
            rsg = new RandomStringGenerator(factory, "GraphemeClusterBreak");
            icuBreak = (RuleBasedBreakIterator)BreakIterator.getCharacterInstance();
        } else if (line.equals("compareWord")) {
            rsg = new RandomStringGenerator(factory, "WordBreak", false, true);
            icuBreak = (RuleBasedBreakIterator)BreakIterator.getWordInstance();
        } else if (line.equals("compareSentence")) {
            rsg = new RandomStringGenerator(factory, "SentenceBreak", false, true);
            icuBreak = (RuleBasedBreakIterator)BreakIterator.getSentenceInstance();
        } else if (line.equals("compareLine")) {
            rsg = new RandomStringGenerator(factory, "LineBreak", true, false);
            icuBreak = (RuleBasedBreakIterator)BreakIterator.getLineInstance();
        } else {
            throw new IllegalArgumentException("Bad tag: " + line);
        }
        System.out.println("Monkey Test: " + line + "\t icuBreaks = $\t ruleBreaks =@");
        boolean gotDot = false;
        int limit = 100;
        for (int i = 0; i < limit; ++i) {
            void var4_4;
            void var3_3;
            if (i % 100 == 0) {
                System.out.println();
                System.out.flush();
                System.out.print(i * 10);
            }
            System.out.print('.');
            gotDot = true;
            String test = var3_3.next(10);
            var4_4.setText(test);
            int[] icuStatus = new int[20];
            int[] ruleStatus = new int[20];
            for (int j = 0; j <= test.length(); ++j) {
                boolean ruleListResults;
                boolean icuBreakResults = var4_4.isBoundary(j);
                if (icuBreakResults == (ruleListResults = rl.breaksAt(test, j))) continue;
                if (gotDot) {
                    System.out.println();
                    gotDot = false;
                }
                System.out.println(line + "\tMismatch at Line\t" + i + ",\toffset\t" + j + ",\twith Rule\t" + rl.getBreakRule() + ":\t" + (icuBreakResults ? "ICU Breaks, CLDR Doesn't" : "ICU Doesn't, CLDR Breaks"));
                System.out.println(TestSegments.showResults(test, j, (RandomStringGenerator)var3_3, icuBreakResults));
                rl.breaksAt(test, j);
            }
        }
    }

    private static String showStatus(int[] icuStatus, int icuStatusLen) {
        String result = "";
        for (int i = 0; i < icuStatusLen; ++i) {
            if (result.length() != 0) {
                result = result + ", ";
            }
            result = result + icuStatus[i];
        }
        return "[" + result + "]";
    }

    static boolean equalStatus(int[] status1, int len1, int[] status2, int len2) {
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (status1[i] == status2[i]) continue;
            return false;
        }
        return true;
    }

    private static String showResults(String test, int j, RandomStringGenerator rsg, boolean icuBreakResults) {
        int cp;
        StringBuffer results = new StringBuffer();
        for (int i = 0; i < test.length(); i += UTF16.getCharCount((int)cp)) {
            if (i == j) {
                results.append(icuBreakResults ? "<\r\n$ >" : "<\r\n@ >");
            }
            cp = UTF16.charAt((String)test, (int)i);
            results.append("[" + rsg.getValue(cp) + ":" + Utility.escape((String)UTF16.valueOf((int)cp)) + "]");
        }
        if (test.length() == j) {
            results.append(icuBreakResults ? "<\r\n$ >" : "<\r\n@ >");
        }
        return results.toString();
    }

    private static boolean quickCheck() {
        String[][] rtests = new String[][]{{".*" + new UnicodeSet("[\\p{Grapheme_Cluster_Break=LVT}]").complement().complement(), "\u001e\uc237\u1123\n\uc91b"}, {"(?<=a)b", "ab"}, {"[$]\\p{Alpha}\\p{Alnum}*", "$Letter"}};
        for (int i = 0; i < rtests.length; ++i) {
            Matcher m = Pattern.compile(rtests[i][0], 44).matcher("");
            m.reset(rtests[i][1]);
            boolean matches = m.matches();
            System.out.println(rtests[i][0] + ",\t" + rtests[i][1] + ",\t" + matches);
        }
        return false;
    }
}

