/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import [Ljava.lang.String;;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.RuleBasedTransliterator;
import com.ibm.icu.text.Transliterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Utility;

public class TestTransforms {
    static String target = "C:\\work\\cldr\\dropbox\\gen\\transforms\\";
    static Matcher getId = Pattern.compile("\\s*(\\S*)\\s*\\{\\s*").matcher("");
    static Matcher getSource = Pattern.compile("\\s*(\\S*)\\s*\\{\\s*\\\"(.*)\\\".*").matcher("");
    static Matcher translitID = Pattern.compile("([^-]+)-([^/]+)+(?:[/](.+))?").matcher("");
    static Map fixedIDs = new TreeMap();
    static Set oddIDs = new TreeSet();

    public static void main(String[] args) throws IOException {
        String id2;
        String line;
        File dir = new File(target);
        BufferedReader input = BagFormatter.openUTF8Reader((String)target, (String)"root.txt");
        String id = null;
        String filename = null;
        String lastId = null;
        String lastFilename = null;
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        Utility.registerTransliteratorFromFile("Latin-ConjoiningJamo", target, null);
        Utility.registerTransliteratorFromFile("Pinyin-NumericPinyin", target, null);
        while ((line = input.readLine()) != null && !(line = line.trim()).startsWith("TransliteratorNamePattern")) {
            if (line.indexOf("Ethiopic") >= 0) {
                System.out.println("Skipping Ethiopic");
                continue;
            }
            if (getId.reset(line).matches()) {
                String temp = getId.group(1);
                if (temp.equals("file") || temp.equals("internal")) continue;
                id = temp;
                continue;
            }
            if (getSource.reset(line).matches()) {
                String operation = getSource.group(1);
                String source = getSource.group(2);
                if (operation.equals("alias")) {
                    aliasMap.put(id, source);
                    TestTransforms.checkIdFix(id);
                    lastId = id;
                    id = null;
                    continue;
                }
                if (operation.equals("resource:process(transliterator)")) {
                    filename = source;
                    continue;
                }
                if (operation.equals("direction")) {
                    try {
                        if (id == null || filename == null) {
                            System.out.println("skipping: " + line);
                            continue;
                        }
                        if (filename.indexOf("InterIndic") >= 0 && filename.indexOf("Latin") >= 0) {
                            System.out.print("**" + id);
                        }
                        TestTransforms.checkIdFix(id);
                        if (source.equals("FORWARD")) {
                            Utility.registerTransliteratorFromFile(id, target, filename, 0, false);
                        } else {
                            Utility.registerTransliteratorFromFile(id, target, filename, 1, false);
                        }
                        lastId = id;
                        id = null;
                        lastFilename = filename;
                        filename = null;
                        continue;
                    }
                    catch (RuntimeException e) {
                        throw (RuntimeException)new IllegalArgumentException("Failed with " + filename + ", " + source).initCause(e);
                    }
                }
                System.out.println("Unhandled:" + line);
                continue;
            }
            String trimmed = line.trim();
            if (trimmed.equals("") || trimmed.equals("}") || trimmed.startsWith("//")) continue;
            System.out.println("Unhandled:" + line);
        }
        Iterator<Object> it = aliasMap.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            String source = (String)aliasMap.get(id);
            Transliterator.unregister((String)id);
            Transliterator t = Transliterator.createFromRules((String)id, (String)("::" + source + ";"), (int)0);
            Transliterator.registerInstance((Transliterator)t);
            System.out.println("Registered new Transliterator Alias: " + id);
        }
        System.out.println("Fixed IDs");
        it = fixedIDs.keySet().iterator();
        while (it.hasNext()) {
            id2 = (String)it.next();
            System.out.println("\t" + id2 + "\t" + fixedIDs.get(id2));
        }
        System.out.println("Odd IDs");
        it = oddIDs.iterator();
        while (it.hasNext()) {
            id2 = (String)it.next();
            System.out.println("\t" + id2);
        }
        TestTransforms.checkScript("Latin", "Devanagari", "abcd", 20);
        TestTransforms.checkScript("Latin", "Greek", "abcd", 20);
        TestTransforms.checkScript("Latin", "Cyrillic", "abcd", 20);
        TestTransforms.checkScript("Hiragana", "Katakana", "\u3041\u308f\u3099\u306e\u304b\u3092\u3099", 20);
        TestTransforms.checkScript("Katakana", "Hiragana", "\u30a1\u30f7\u30ce\u30f5\u30f6", 20);
        try {
            Class<?> ta = Class.forName("com.ibm.icu.dev.test.translit.TestAll");
            Object testAll = ta.newInstance();
            String[] params = new String[]{"-n"};
            Method m = ta.getDeclaredMethod("main", String;.class);
            System.out.println("here");
            m.invoke(ta, new Object[]{params});
        }
        catch (Exception ex) {
            System.err.println("Could not load TestAll. Encountered exception: " + ex.toString());
        }
    }

    private static void checkIdFix(String id) {
        if (fixedIDs.containsKey(id)) {
            return;
        }
        if (!translitID.reset(id).matches()) {
            System.out.println("Can't fix: " + id);
            fixedIDs.put(id, "?" + id);
            return;
        }
        String source1 = translitID.group(1);
        String target1 = translitID.group(2);
        String variant = translitID.group(3);
        String source = TestTransforms.fixID(source1);
        String target = TestTransforms.fixID(target1);
        fixedIDs.put(source1, source);
        fixedIDs.put(target1, target);
        if (variant != null) {
            oddIDs.add("variant: " + variant);
        }
    }

    private static String fixID(String source) {
        if (source.equals("Any")) {
            return "und";
        }
        if (source.equals("el")) {
            return source;
        }
        int[] scriptCodes = UScript.getCode((String)source);
        if (scriptCodes != null && scriptCodes.length == 1) {
            return "und_" + UScript.getShortName((int)scriptCodes[0]);
        }
        source = "x-" + source;
        oddIDs.add(source);
        return source;
    }

    private static void checkScript(String script1, String script2, String test, int limit) {
        Transliterator toLatin = Transliterator.getInstance((String)(script1 + "-" + script2));
        Transliterator fromLatin = Transliterator.getInstance((String)(script2 + "-" + script1));
        System.out.println(test);
        String nativeString = toLatin.transliterate(test);
        System.out.println("from " + script1 + " to " + script2 + ": " + nativeString);
        String back = fromLatin.transliterate(nativeString);
        System.out.println("from " + script2 + " to " + script1 + ": " + back);
        TestTransforms.showTransliterator("", fromLatin, limit);
    }

    static void showTransliterator(String prefix, Transliterator t, int limit) {
        System.out.println(prefix + "ID:\t" + t.getID());
        System.out.println(prefix + "Class:\t" + t.getClass().getName());
        if (t.getFilter() != null) {
            System.out.println(prefix + "Filter:\t" + t.getFilter());
        }
        prefix = prefix + "\t";
        if (t instanceof RuleBasedTransliterator) {
            RuleBasedTransliterator rbt = (RuleBasedTransliterator)t;
            String[] rules = rbt.toRules(true).split("\n");
            int length = rules.length;
            if (limit >= 0 && limit < length) {
                length = limit;
            }
            for (int i = 0; i < length; ++i) {
                System.out.println(prefix + rules[i]);
            }
        } else {
            Transliterator[] elements = t.getElements();
            if (elements[0] == t) {
                System.out.println(prefix + "Other type.");
                return;
            }
            for (int i = 0; i < elements.length; ++i) {
                TestTransforms.showTransliterator(prefix, elements[i], limit);
            }
        }
    }

    private static void testString(String id) {
        int dir1 = 0;
        int dir2 = 1;
        if (!id.startsWith("Latin")) {
            if (id.endsWith("Latin")) {
                dir2 = 0;
                dir1 = 1;
            } else {
                return;
            }
        }
        Transliterator t = Transliterator.getInstance((String)id, (int)dir1);
        String test = t.transliterate("abcde");
        System.out.println("Test\t" + id + "\t" + dir1 + "\t" + test);
        Transliterator t2 = Transliterator.getInstance((String)id, (int)dir2);
        String test2 = t2.transliterate(test);
        System.out.println("Test\t" + id + "\t" + dir2 + "\t" + test2);
    }
}

