/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.test.CLDRTest;
import org.unicode.cldr.tool.VettingAdder;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;

public class CLDRModify {
    static final String DEBUG_PATHS = null;
    static final boolean COMMENT_REMOVALS = false;
    static FixList fixList = new FixList();
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int JOIN = 5;
    private static final int MINIMIZE = 6;
    private static final int FIX = 7;
    private static final int JOIN_ARGS = 8;
    private static final int VET_ADD = 9;
    private static final int RESOLVE = 10;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/main/"), UOption.DESTDIR().setDefault("../../dropbox/gen/main/"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"join", (char)'j', (int)2), UOption.create((String)"minimize", (char)'r', (int)0), UOption.create((String)"fix", (char)'f', (int)2), UOption.create((String)"join-args", (char)'i', (int)2), UOption.create((String)"vet", (char)'v', (int)2).setDefault("C:\\vetweb"), UOption.create((String)"resolve", (char)'z', (int)2)};
    private static final UnicodeSet allMergeOptions = new UnicodeSet("[rc]");
    static final String HELP_TEXT1 = "Use the following options\n-h or -?\t for this message\n-" + CLDRModify.options[2].shortName + "\t source directory. Default = -s" + Utility.getCanonicalName("../../common/main/") + "\n" + "\tExample:-sC:\\Unicode-CVS2\\cldr\\common\\gen\\source\\" + "\n" + "-" + CLDRModify.options[3].shortName + "\t destination directory. Default = -d" + Utility.getCanonicalName("../../dropbox/gen/main/") + "\n" + "-m<regex>\t to restrict the locales to what matches <regex>" + "\n" + "-j<merge_dir>/X'\t to merge two sets of files together (from <source_dir>/X and <merge_dir>/X', " + "\n" + "\twhere * in X' is replaced by X)." + "\n" + "\tExample:-jC:\\Unicode-CVS2\\cldr\\dropbox\\to_be_merged\\missing\\missing_*" + "\n" + "-i\t merge arguments:" + "\n" + "\tr\t replace contents (otherwise new data will be draft=\"unconfirmed\")" + "\n" + "\tc\t ignore comments in <merge_dir> files" + "\n" + "-r\t to minimize the results (removing items that inherit from parent)." + "\n" + "-v\t incorporate vetting information, and generate diff files." + "\n" + "-z\t generate resolved files" + "\n" + "-f\t to perform various fixes on the files (add following arguments to specify which ones, eg -fxi)" + "\n";
    static final String HELP_TEXT2 = "Note: A set of bat files are also generated in <dest_dir>/diff. They will invoke a comparison program on the results.\n";
    static HashSet totalSkeletons = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        long startTime;
        block24: {
            block23: {
                startTime = System.currentTimeMillis();
                UOption.parseArgs((String[])args, (UOption[])options);
                if (CLDRModify.options[0].doesOccur || CLDRModify.options[1].doesOccur) {
                    System.out.println(HELP_TEXT1 + fixList.showHelp() + HELP_TEXT2);
                    return;
                }
                CLDRModify.checkSuboptions(options[7], fixList.getOptions());
                CLDRModify.checkSuboptions(options[8], allMergeOptions);
                String mergeDir = CLDRModify.options[5].value;
                String sourceDir = CLDRModify.options[2].value;
                String targetDir = CLDRModify.options[3].value;
                boolean makeResolved = CLDRModify.options[10].doesOccur;
                Log.setLog(targetDir + "log.txt");
                try {
                    Utility.SimpleLineComparator lineComparer = new Utility.SimpleLineComparator(13);
                    CLDRFile.Factory cldrFactory = CLDRFile.Factory.make(sourceDir, ".*");
                    if (CLDRModify.options[9].doesOccur) {
                        VettingAdder va = new VettingAdder(CLDRModify.options[9].value);
                        va.showFiles(cldrFactory, targetDir);
                        Object var19_10 = null;
                        break block23;
                    }
                    CLDRFile.Factory mergeFactory = null;
                    String join_prefix = "";
                    String join_postfix = "";
                    if (CLDRModify.options[5].doesOccur) {
                        File temp = new File(mergeDir);
                        mergeDir = temp.getParent() + File.separator;
                        String filename = temp.getName();
                        join_postfix = "";
                        join_prefix = "";
                        int pos = filename.indexOf("*");
                        if (pos >= 0) {
                            join_prefix = filename.substring(0, pos);
                            join_postfix = filename.substring(pos + 1);
                        }
                        mergeFactory = CLDRFile.Factory.make(mergeDir, ".*");
                    }
                    TreeSet locales = new TreeSet(cldrFactory.getAvailable());
                    if (mergeFactory != null) {
                        TreeSet temp = new TreeSet(mergeFactory.getAvailable());
                        TreeSet<String> locales3 = new TreeSet<String>();
                        Iterator it = temp.iterator();
                        while (it.hasNext()) {
                            String locale = (String)it.next();
                            if (!locale.startsWith(join_prefix) || !locale.endsWith(join_postfix)) continue;
                            locales3.add(locale.substring(join_prefix.length(), locale.length() - join_postfix.length()));
                        }
                        locales.retainAll(locales3);
                        System.out.println("Merging: " + locales3);
                    }
                    new Utility.MatcherFilter(CLDRModify.options[4].value).retainAll(locales);
                    Iterator it = locales.iterator();
                    while (it.hasNext()) {
                        String parent;
                        String test = (String)it.next();
                        CLDRFile k = (CLDRFile)cldrFactory.make(test, makeResolved).cloneAsThawed();
                        if (DEBUG_PATHS != null) {
                            System.out.println("Debug1 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                        }
                        if (mergeFactory != null) {
                            int mergeOption = 2;
                            CLDRFile toMergeIn = (CLDRFile)mergeFactory.make(join_prefix + test + join_postfix, false).cloneAsThawed();
                            if (toMergeIn != null) {
                                if (CLDRModify.options[8].doesOccur) {
                                    if (CLDRModify.options[8].value.indexOf("r") >= 0) {
                                        mergeOption = 3;
                                    }
                                    if (CLDRModify.options[8].value.indexOf("c") >= 0) {
                                        toMergeIn.clearComments();
                                    }
                                    if (CLDRModify.options[8].value.indexOf("x") >= 0) {
                                        CLDRModify.removePosix(toMergeIn);
                                    }
                                }
                                if (mergeOption == 2) {
                                    toMergeIn.makeDraft();
                                }
                                k.putAll(toMergeIn, mergeOption);
                            }
                            k.removeComment(" The following are strings that are not found in the locale (currently), but need valid translations for localizing timezones. ");
                        }
                        if (DEBUG_PATHS != null) {
                            System.out.println("Debug2 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                        }
                        if (CLDRModify.options[7].doesOccur) {
                            CLDRModify.fix(k, CLDRModify.options[7].value, cldrFactory);
                        }
                        if (DEBUG_PATHS != null) {
                            System.out.println("Debug3 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                        }
                        if (CLDRModify.options[6].doesOccur && (parent = CLDRFile.getParent(test)) != null) {
                            CLDRFile toRemove = cldrFactory.make(parent, true);
                            k.removeDuplicates(toRemove, false, XMLSource.getPathsAllowingDuplicates());
                        }
                        if (DEBUG_PATHS != null) {
                            System.out.println("Debug4 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                        }
                        PrintWriter pw = BagFormatter.openUTF8Writer((String)targetDir, (String)(test + ".xml"));
                        String testPath = "//ldml/dates/calendars/calendar[@type=\"persian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"1\"]";
                        k.write(pw);
                        pw.println();
                        pw.close();
                        Utility.generateBat(sourceDir, test + ".xml", targetDir, test + ".xml", lineComparer);
                    }
                    if (totalSkeletons.size() != 0) {
                        System.out.println("Total Skeletons" + totalSkeletons);
                    }
                    break block24;
                }
                catch (Throwable throwable) {
                    Object var19_12 = null;
                    Log.close();
                    System.out.println("Done -- Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " minutes");
                    throw throwable;
                }
            }
            Log.close();
            System.out.println("Done -- Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " minutes");
            return;
        }
        Object var19_11 = null;
        Log.close();
        System.out.println("Done -- Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " minutes");
    }

    private static void checkSuboptions(UOption givenOptions, UnicodeSet allowedOptions) {
        if (givenOptions.doesOccur && !allowedOptions.containsAll(givenOptions.value)) {
            throw new IllegalArgumentException("Illegal sub-options for " + givenOptions.shortName + ": " + new UnicodeSet().addAll(givenOptions.value).removeAll(allowedOptions) + "\r\nUse -? for help.");
        }
    }

    private static void removePosix(CLDRFile toMergeIn) {
        HashSet<String> toRemove = new HashSet<String>();
        Iterator it = toMergeIn.iterator();
        while (it.hasNext()) {
            String xpath = (String)it.next();
            if (!xpath.startsWith("//ldml/posix")) continue;
            toRemove.add(xpath);
        }
        toMergeIn.removeAll(toRemove, false);
    }

    static void fixIdenticalChildren(CLDRFile.Factory cldrFactory, CLDRFile k, CLDRFile replacements) {
        String key = k.getLocaleID();
        if (key.equals("root")) {
            return;
        }
        Set availableChildren = cldrFactory.getAvailableWithParent(key, true);
        if (availableChildren.size() == 0) {
            return;
        }
        HashSet<String> skipPaths = new HashSet<String>();
        TreeMap<String, ValuePair> haveSameValues = new TreeMap<String, ValuePair>();
        CLDRFile resolvedFile = cldrFactory.make(key, true);
        CollectionUtilities.addAll((Iterator)resolvedFile.iterator(), skipPaths);
        Iterator it1 = availableChildren.iterator();
        while (it1.hasNext()) {
            String locale = (String)it1.next();
            if (locale.indexOf("POSIX") >= 0) continue;
            CLDRFile item = cldrFactory.make(locale, false);
            Iterator it2 = item.iterator();
            while (it2.hasNext()) {
                String xpath = (String)it2.next();
                if (skipPaths.contains(xpath) || xpath.indexOf("/identity") >= 0 || xpath.startsWith("//ldml/numbers/currencies/currency") || xpath.indexOf("[@alt") >= 0 || xpath.indexOf("/alias") >= 0) continue;
                ValuePair v1 = new ValuePair();
                v1.value = item.getStringValue(xpath);
                v1.fullxpath = item.getFullXPath(xpath);
                ValuePair vAlready = (ValuePair)haveSameValues.get(xpath);
                if (vAlready == null) {
                    haveSameValues.put(xpath, v1);
                    continue;
                }
                if (v1.value.equals(vAlready.value) && v1.fullxpath.equals(vAlready.fullxpath)) continue;
                skipPaths.add(xpath);
                haveSameValues.remove(xpath);
            }
        }
        Iterator it = haveSameValues.keySet().iterator();
        while (it.hasNext()) {
            String xpath = (String)it.next();
            ValuePair v = (ValuePair)haveSameValues.get(xpath);
            replacements.add(v.fullxpath, v.value);
        }
    }

    static void fixAltProposed() {
        throw new IllegalArgumentException();
    }

    private static void fix(CLDRFile k, String options, CLDRFile.Factory cldrFactory) {
        TreeSet removal = new TreeSet(CLDRFile.ldmlComparator);
        CLDRFile replacements = CLDRFile.make("temp");
        fixList.setFile(k, removal, replacements);
        Iterator it2 = k.iterator();
        while (it2.hasNext()) {
            String xpath = (String)it2.next();
            fixList.handlePath(options, xpath);
        }
        fixList.handleEnd();
        if (options.indexOf(118) >= 0) {
            CLDRTest.checkAttributeValidity(k, null, removal);
        }
        if (options.indexOf(105) >= 0) {
            CLDRModify.fixIdenticalChildren(cldrFactory, k, replacements);
        }
        if (removal.size() != 0 || !replacements.isEmpty()) {
            System.out.println("Removals:");
            Iterator it3 = removal.iterator();
            while (it3.hasNext()) {
                String path = (String)it3.next();
                System.out.println(path + " =\t " + k.getStringValue(path));
            }
            System.out.println("Additions/Replacements:");
            System.out.println(replacements);
        }
        if (removal.size() != 0) {
            k.removeAll(removal, false);
        }
        k.putAll(replacements, 1);
    }

    private static void testMinimize(CLDRFile.Factory cldrFactory) {
        CLDRFile test2 = cldrFactory.make("root", true);
        System.out.println();
        System.out.println();
        PrintWriter xxx = new PrintWriter(System.out);
        test2.write(xxx);
        xxx.flush();
    }

    private static Utility.SimpleLineComparator testLineComparator(String sourceDir, String targetDir) {
        Utility.SimpleLineComparator lineComparer = new Utility.SimpleLineComparator(6);
        return lineComparer;
    }

    public static void testJavaSemantics() {
        Collator caseInsensitive = Collator.getInstance((ULocale)ULocale.ROOT);
        caseInsensitive.setStrength(1);
        TreeSet<String> setWithCaseInsensitive = new TreeSet<String>((Comparator<String>)caseInsensitive);
        setWithCaseInsensitive.addAll(Arrays.asList("a", "b", "c"));
        TreeSet<String> plainSet = new TreeSet<String>();
        plainSet.addAll(Arrays.asList("a", "b", "B"));
        System.out.println("S1 equals S2?\t" + ((Object)setWithCaseInsensitive).equals(plainSet));
        System.out.println("S2 equals S1?\t" + ((Object)plainSet).equals(setWithCaseInsensitive));
        setWithCaseInsensitive.removeAll(plainSet);
        System.out.println("S1 removeAll S2 is empty?\t" + setWithCaseInsensitive.isEmpty());
    }

    static {
        fixList.add('y', "remove deprecated", new CLDRFilter(){
            Map remapAppend = CollectionUtilities.asMap((Object[][])new String[][]{{"G", "Era"}, {"y", "Year"}, {"Q", "Quarter"}, {"M", "Month"}, {"w", "Week"}, {"E", "Day-Of-Week"}, {"d", "Day"}, {"H", "Hour"}, {"m", "Minute"}, {"s", "Second"}, {"v", "Timezone"}});

            public void handlePath(String xpath) {
                if (xpath.startsWith("//ldml/measurement/measurementSystem") || xpath.startsWith("//ldml/measurement/paperSize")) {
                    this.remove(xpath, "Removing deprecated");
                }
                if (xpath.indexOf("/week/") >= 0) {
                    this.remove(xpath, "Removing deprecated");
                }
            }
        });
        fixList.add('e', "fix Interindic", new CLDRFilter(){

            public void handlePath(String xpath) {
                if (xpath.indexOf("=\"InterIndic\"") < 0) {
                    return;
                }
                String v = this.cldrFileToFilter.getStringValue(xpath);
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.fullparts.set(fullXPath);
                Map attributes = this.fullparts.findAttributes("transform");
                String oldValue = (String)attributes.get("direction");
                if ("both".equals(oldValue)) {
                    attributes.put("direction", "forward");
                    this.replace(xpath, this.fullparts.toString(), v);
                }
            }
        });
        fixList.add('n', "fix numbers", new CLDRFilter(){

            public void handlePath(String xpath) {
                boolean isPOSIX;
                byte type = CLDRTest.getNumericType(xpath);
                if (type == -1) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String pattern = CLDRTest.getCanonicalPattern(value, type, isPOSIX = this.cldrFileToFilter.getLocaleID().indexOf("POSIX") >= 0);
                if (pattern.equals(value)) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, pattern);
            }
        });
        fixList.add('f', "NFC (all but transforms, exemplarCharacters, pc, sc, tc, qc, ic)", new CLDRFilter(){

            public void handlePath(String xpath) {
                String nfcValue;
                if (xpath.indexOf("/segmentation") >= 0 || xpath.indexOf("/transforms") >= 0 || xpath.indexOf("/exemplarCharacters") >= 0 || xpath.indexOf("/pc") >= 0 || xpath.indexOf("/sc") >= 0 || xpath.indexOf("/tc") >= 0 || xpath.indexOf("/qc") >= 0 || xpath.indexOf("/ic") >= 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value.equals(nfcValue = Normalizer.compose((String)value, (boolean)false))) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, nfcValue);
            }
        });
        fixList.add('v', "remove illegal codes", new CLDRFilter(){
            StandardCodes sc = StandardCodes.make();
            String[] codeTypes = new String[]{"language", "script", "territory", "currency"};

            public void handlePath(String xpath) {
                String code;
                if (xpath.indexOf("/currency") < 0 && xpath.indexOf("/timeZoneNames") < 0 && xpath.indexOf("/localeDisplayNames") < 0) {
                    return;
                }
                this.parts.set(xpath);
                for (int i = 0; i < this.codeTypes.length; ++i) {
                    code = this.parts.findAttributeValue(this.codeTypes[i], "type");
                    if (code == null) continue;
                    if (!this.sc.getGoodAvailableCodes(this.codeTypes[i]).contains(code)) {
                        this.remove(xpath);
                    }
                    return;
                }
                code = this.parts.findAttributeValue("zone", "type");
                if (code != null && code.indexOf("/GMT") >= 0) {
                    this.remove(xpath);
                }
            }
        });
        fixList.add('q', "fix exemplars", new CLDRFilter(){
            Collator col;
            Collator spaceCol;
            UnicodeSet uppercase = new UnicodeSet("[[:Uppercase:]-[\u0130]]");
            UnicodeSetIterator usi = new UnicodeSetIterator();

            public void handleStart() {
                String locale = this.cldrFileToFilter.getLocaleID();
                this.col = Collator.getInstance((ULocale)new ULocale(locale));
                this.spaceCol = Collator.getInstance((ULocale)new ULocale(locale));
                this.spaceCol.setStrength(0);
            }

            public void handlePath(String xpath) {
                if (xpath.indexOf("/exemplarCharacters") < 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                try {
                    String fixedValue = value.replaceAll("- ", "-");
                    if (!fixedValue.equals(value)) {
                        System.out.println("Changing: " + value);
                    }
                    fixedValue = "[" + fixedValue + "]";
                    UnicodeSet s1 = new UnicodeSet(fixedValue).removeAll(this.uppercase);
                    UnicodeSet s = new UnicodeSet();
                    this.usi.reset(s1);
                    while (this.usi.next()) {
                        s.add(Normalizer.compose((String)this.usi.getString(), (boolean)false));
                    }
                    String fixedExemplar1 = CollectionUtilities.prettyPrint((UnicodeSet)s, (boolean)true, null, null, (Comparator)this.col, (Comparator)this.col);
                    if (!value.equals(fixedExemplar1)) {
                        String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                        this.replace(fullXPath, fullXPath, fixedExemplar1);
                    }
                }
                catch (RuntimeException e) {
                    System.out.println("Illegal UnicodeSet: " + this.cldrFileToFilter.getLocaleID() + "\t" + value);
                }
            }
        });
        fixList.add('w', "fix alt='...proposed' when there is no alternative", new CLDRFilter(){
            private XPathParts parts = new XPathParts();

            public void handlePath(String xpath) {
                if (xpath.indexOf("proposed") < 0) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                String newFullXPath = this.parts.set(fullXPath).removeProposed().toString();
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String baseValue = this.cldrFileToFilter.getStringValue(newFullXPath);
                if (baseValue != null) {
                    String baseFullXPath;
                    if (value.equals(baseValue) && (baseFullXPath = this.cldrFileToFilter.getFullXPath(newFullXPath)).equals(newFullXPath)) {
                        this.remove(xpath, "alt=base");
                    }
                    return;
                }
                this.replace(fullXPath, newFullXPath, value);
            }
        });
        fixList.add('k', "fix kk/KK", new CLDRFilter(){
            DateTimePatternGenerator dtpg;
            DateTimePatternGenerator.PatternInfo patternInfo = new DateTimePatternGenerator.PatternInfo();
            DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
            Set dateFormatItems = new TreeSet();
            Set standardFormats = new TreeSet();

            public void handleStart() {
                this.dtpg = DateTimePatternGenerator.newInstance();
                this.dateFormatItems.clear();
                this.standardFormats.clear();
            }

            public void handlePath(String xpath) {
                if (xpath.indexOf("/dateFormatItem") >= 0) {
                    System.out.println(this.cldrFileToFilter.getStringValue(xpath) + "\t" + xpath);
                    this.dateFormatItems.add(xpath);
                }
                if (xpath.indexOf("gregorian") >= 0 && xpath.indexOf("pattern") >= 0 && (xpath.indexOf("dateFormat") >= 0 || xpath.indexOf("timeFormat") >= 0)) {
                    this.standardFormats.add(xpath);
                }
            }

            public void handleEnd() {
                String skeleton;
                String value;
                String xpath;
                HashSet<String> standardSkeletons = new HashSet<String>();
                ArrayList items = new ArrayList();
                Iterator it = this.standardFormats.iterator();
                while (it.hasNext()) {
                    xpath = (String)it.next();
                    value = this.cldrFileToFilter.getStringValue(xpath);
                    this.dtpg.add(value, false, this.patternInfo);
                    standardSkeletons.add(this.dtpg.getSkeleton(value));
                    this.retain(xpath, "-(std)");
                }
                it = this.dateFormatItems.iterator();
                while (it.hasNext()) {
                    xpath = (String)it.next();
                    String oldValue = value = this.cldrFileToFilter.getStringValue(xpath);
                    skeleton = this.dtpg.getSkeleton(value);
                    if (DateTimePatternGenerator.isSingleField((String)skeleton)) {
                        this.remove(xpath, "Single Field");
                        continue;
                    }
                    this.fp.set(value);
                    if (this.fp.hasDateAndTimeFields()) {
                        this.remove(xpath, "Date + Time");
                        continue;
                    }
                    if (this.containsSS()) {
                        this.remove(xpath, "SS");
                        continue;
                    }
                    value = this.fixKk(xpath, value);
                    this.dtpg.add(value, false, this.patternInfo);
                }
                Map skeleton_patterns = this.dtpg.getSkeletons(null);
                Collection redundants = this.dtpg.getRedundants(null);
                Iterator it2 = redundants.iterator();
                while (it2.hasNext()) {
                    String skeleton2 = this.dtpg.getSkeleton((String)it2.next());
                    skeleton_patterns.remove(skeleton2);
                }
                it2 = standardSkeletons.iterator();
                while (it2.hasNext()) {
                    String standardSkeleton = (String)it2.next();
                    skeleton_patterns.remove(standardSkeleton);
                }
                it2 = this.dateFormatItems.iterator();
                while (it2.hasNext()) {
                    String oldFullPath;
                    String xpath2 = (String)it2.next();
                    String oldValue = this.cldrFileToFilter.getStringValue(xpath2);
                    String newFullPath = oldFullPath = this.cldrFileToFilter.getFullXPath(xpath2);
                    this.parts.set(newFullPath);
                    Map attributes = this.parts.getAttributes(-1);
                    String id = (String)attributes.get("id");
                    String newValue = (String)skeleton_patterns.get(id);
                    if (newValue == null) {
                        this.remove(xpath2, "redundant");
                        continue;
                    }
                    String draft = (String)attributes.get("draft");
                    if (draft == null || draft.equals("approved")) {
                        attributes.put("draft", "provisional");
                        newFullPath = this.parts.toString();
                    }
                    if (oldValue.equals(newValue) && newFullPath.equals(oldFullPath)) {
                        this.retain(xpath2, "-");
                        skeleton_patterns.remove(id);
                        continue;
                    }
                    this.replace(oldFullPath, newFullPath, newValue, "fixed");
                    skeleton_patterns.remove(id);
                }
                this.parts.set("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem");
                Map attributes = this.parts.getAttributes(-1);
                attributes.put("draft", "provisional");
                Iterator it3 = skeleton_patterns.keySet().iterator();
                while (it3.hasNext()) {
                    skeleton = (String)it3.next();
                    String pattern = (String)skeleton_patterns.get(skeleton);
                    attributes.put("id", skeleton);
                    String fullPath = this.parts.toString();
                    this.replace(fullPath, fullPath, pattern);
                }
            }

            private String fixKk(String xpath, String value) {
                List fields = this.fp.getItems();
                for (int i = 0; i < fields.size(); ++i) {
                    Object field = fields.get(i);
                    if (!(field instanceof DateTimePatternGenerator.VariableField)) continue;
                    char first = field.toString().charAt(0);
                    String replacement = null;
                    if (first == 'k') {
                        replacement = "H";
                    } else if (first == 'K') {
                        replacement = "h";
                    }
                    if (replacement == null) continue;
                    field = new DateTimePatternGenerator.VariableField(Utility.repeat(replacement, field.toString().length()));
                    fields.set(i, field);
                }
                String newValue = this.fp.toString();
                if (!value.equals(newValue)) {
                    this.remove(xpath, value + " => " + newValue);
                }
                return newValue;
            }

            private boolean containsSS() {
                List fields = this.fp.getItems();
                for (int i = 0; i < fields.size(); ++i) {
                    char first;
                    Object field = fields.get(i);
                    if (!(field instanceof DateTimePatternGenerator.VariableField) || (first = field.toString().charAt(0)) != 'S') continue;
                    return true;
                }
                return false;
            }
        });
        fixList.add('d', "fix dates", new CLDRFilter(){
            DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.newInstance();
            HashMap seenSoFar = new HashMap();

            public void handleStart() {
                this.seenSoFar.clear();
            }

            public void handlePath(String xpath) {
                String alt;
                String id;
                if (xpath.indexOf("/availableFormats") < 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value == null) {
                    return;
                }
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                this.fullparts.set(fullpath);
                Map attributes = this.fullparts.findAttributes("dateFormatItem");
                String oldID = id = (String)attributes.get("id");
                try {
                    id = this.dateTimePatternGenerator.getSkeleton(value);
                }
                catch (RuntimeException e) {
                    id = "[error]";
                }
                String draft = (String)attributes.get("draft");
                if (draft == null) {
                    draft = "approved";
                }
                if ((alt = (String)attributes.get("alt")) == null) {
                    alt = "proposed";
                }
                alt = this.fixAlt(alt, id);
                attributes.put("draft", draft);
                attributes.put("alt", alt);
                attributes.put("id", id);
                attributes.remove("_q");
                totalSkeletons.add(id);
                this.replace(xpath, this.fullparts.toString(), value);
            }

            private String fixAlt(String alt, String id) {
                HashSet<String> soFar = (HashSet<String>)this.seenSoFar.get(id);
                if (soFar == null) {
                    soFar = new HashSet<String>();
                    this.seenSoFar.put(id, soFar);
                } else {
                    int i = 1;
                    while (true) {
                        String newAlt = alt + "-" + i;
                        if (!soFar.contains(alt = alt + "-" + i)) break;
                        ++i;
                    }
                }
                soFar.add(alt);
                return alt;
            }
        });
        fixList.add('r', "fix references and standards", new CLDRFilter(){
            References standards = new References(true);
            References references = new References(false);

            public void handleStart() {
                this.standards.reset(this.cldrFileToFilter);
                this.references.reset(this.cldrFileToFilter);
            }

            public void handlePath(String xpath) {
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                if (fullpath.indexOf("[@references=\"") < 0 && fullpath.indexOf("[@standard=\"") < 0) {
                    return;
                }
                if (fullpath.indexOf("/references") >= 0) {
                    return;
                }
                this.fullparts.set(fullpath);
                int fixCount = 0;
                for (int i = 0; i < this.fullparts.size(); ++i) {
                    Map attributes = this.fullparts.getAttributes(i);
                    fixCount += this.standards.fix(attributes, this.getReplacementFile());
                    fixCount += this.references.fix(attributes, this.getReplacementFile());
                }
                if (fixCount >= 0) {
                    this.getReplacementFile().add(this.fullparts.toString(), value);
                }
            }
        });
        fixList.add('i', "fix Identical Children");
        fixList.add('o', "check attribute validity");
    }

    private static class ValuePair {
        String value;
        String fullxpath;

        private ValuePair() {
        }
    }

    static class FixList {
        CLDRFilter[] filters = new CLDRFilter[128];
        String[] helps = new String[128];
        UnicodeSet options = new UnicodeSet();

        FixList() {
        }

        void add(char letter, String help) {
            this.add(letter, help, null);
        }

        public UnicodeSet getOptions() {
            return this.options;
        }

        void add(char letter, String help, CLDRFilter filter) {
            if (this.helps[letter] != null) {
                throw new IllegalArgumentException("Duplicate letter: " + letter);
            }
            this.filters[letter] = filter;
            this.helps[letter] = help;
            this.options.add((int)letter);
        }

        void setFile(CLDRFile file, Set removal, CLDRFile replacements) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                this.filters[i].setFile(file, removal, replacements);
            }
        }

        void handleStart() {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                this.filters[i].handleStart();
            }
        }

        void handlePath(String options, String xpath) {
            options = options.toLowerCase();
            for (int i = 0; i < options.length(); ++i) {
                char c = options.charAt(i);
                if (this.filters[c] == null) continue;
                this.filters[c].handlePath(xpath);
            }
        }

        void handleEnd() {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                this.filters[i].handleEnd();
            }
        }

        String showHelp() {
            String result = "";
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.helps[i] == null) continue;
                result = result + "\t" + (char)i + "\t " + this.helps[i] + "\n";
            }
            return result;
        }
    }

    static abstract class CLDRFilter {
        protected CLDRFile cldrFileToFilter;
        private String localeID;
        protected Set availableChildren;
        private Set toBeRemoved;
        private CLDRFile toBeReplaced;
        protected XPathParts parts = new XPathParts(null, null);
        protected XPathParts fullparts = new XPathParts(null, null);

        CLDRFilter() {
        }

        public final void setFile(CLDRFile k, Set removal, CLDRFile replacements) {
            this.cldrFileToFilter = k;
            this.localeID = k.getLocaleID();
            this.toBeRemoved = removal;
            this.toBeReplaced = replacements;
            this.handleStart();
        }

        public void handleStart() {
        }

        public abstract void handlePath(String var1);

        public void handleEnd() {
        }

        public void show(String reason, String detail) {
            System.out.println("%" + this.localeID + "\t" + reason + "\tConsidering " + detail);
        }

        public void retain(String path, String reason) {
            System.out.println("%" + this.localeID + "\t" + reason + "\tRetaining: " + this.cldrFileToFilter.getStringValue(path) + "\t at: " + path);
        }

        public void remove(String path) {
            this.remove(path, "-");
        }

        public void remove(String path, String reason) {
            if (this.toBeRemoved.contains(path)) {
                return;
            }
            this.toBeRemoved.add(path);
            System.out.println("%" + this.localeID + "\t" + reason + "\tRemoving: " + this.cldrFileToFilter.getStringValue(path) + "\t at: " + path);
        }

        public void replace(String oldFullPath, String newFullPath, String newValue) {
            this.replace(oldFullPath, newFullPath, newValue, "-");
        }

        public void replace(String oldFullPath, String newFullPath, String newValue, String reason) {
            if (!oldFullPath.equals(newFullPath)) {
                this.remove(oldFullPath);
            }
            this.toBeReplaced.add(newFullPath, newValue);
            System.out.println("%" + this.localeID + "\t" + reason + "\tAdding/Replacing: " + newValue + "\t at: " + newFullPath);
        }

        public CLDRFile getReplacementFile() {
            return this.toBeReplaced;
        }
    }

    private static class References {
        static String[][] keys = new String[][]{{"standard", "S", "[@standard=\"true\"]"}, {"references", "R", ""}};
        UnicodeSet digits = new UnicodeSet("[0-9]");
        int referenceCounter = 0;
        Map references_token = new TreeMap();
        Set tokenSet = new HashSet();
        String[] keys2;
        boolean isStandard;

        References(boolean standard) {
            this.isStandard = standard;
            this.keys2 = standard ? keys[0] : keys[1];
        }

        public void reset(CLDRFile k) {
            this.clear();
            XPathParts parts = new XPathParts(null, null);
            Iterator it = k.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path.indexOf("/reference") < 0) continue;
                parts.set(k.getFullXPath(path));
                if (!parts.getElement(2).equals("reference")) continue;
                String token = parts.getAttributeValue(2, "type");
                boolean refIsStandard = "true".equals(parts.getAttributeValue(2, "standard"));
                if (refIsStandard != this.isStandard) continue;
                String references = k.getStringValue(path);
                this.tokenSet.add(token);
                this.references_token.put(references, token);
            }
        }

        public void clear() {
            this.referenceCounter = 0;
            this.references_token.clear();
        }

        private int fix(Map attributes, CLDRFile replacements) {
            String references = (String)attributes.get(this.keys2[0]);
            int result = 0;
            if (references != null) {
                if (((references = references.trim()).startsWith("S") || references.startsWith("R")) && this.digits.containsAll(references.substring(1))) {
                    return 0;
                }
                String token = (String)this.references_token.get(references);
                if (token == null) {
                    while (this.tokenSet.contains(token = this.keys2[1] + ++this.referenceCounter)) {
                    }
                    this.references_token.put(references, token);
                    System.out.println("Adding: " + token + "\t" + references);
                    replacements.add("//ldml/references/reference[@type=\"" + token + "\"]" + this.keys2[2], references);
                    result = 1;
                }
                attributes.put(this.keys2[0], token);
            }
            return result;
        }
    }
}

