/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.icu.ICUResourceWriter;
import org.unicode.cldr.icu.LDML2ICUConverter;
import org.unicode.cldr.tool.GenerateCldrTests;
import org.unicode.cldr.util.LDMLUtilities;
import org.unicode.cldr.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GenerateCldrCollationTests {
    String sourceDir;
    Set validLocales = new TreeSet();
    Map ulocale_rules = new TreeMap(GenerateCldrTests.ULocaleComparator);
    Map locale_types_rules = new TreeMap();
    Map collation_collation = new HashMap();
    RuleBasedCollator emptyCollator = (RuleBasedCollator)Collator.getInstance((ULocale)new ULocale(""));
    static Transliterator fromHex = Transliterator.getInstance((String)"hex-any");

    public Set getAvailableSet() {
        return this.ulocale_rules.keySet();
    }

    public RuleBasedCollator getInstance(ULocale locale) {
        return (RuleBasedCollator)this.ulocale_rules.get(locale);
    }

    void show() {
        Log.logln("Showing Locales");
        Log.logln("Unique Collators: " + this.collation_collation.size());
        Iterator it2 = this.ulocale_rules.keySet().iterator();
        while (it2.hasNext()) {
            ULocale locale = (ULocale)it2.next();
            RuleBasedCollator col = (RuleBasedCollator)this.ulocale_rules.get(locale);
            Log.logln("\t" + locale + ", " + col.getRules());
        }
    }

    GenerateCldrCollationTests(String sourceDir, String localeRegex, Set locales) throws Exception {
        Map types_rules;
        String locale;
        this.sourceDir = sourceDir;
        Set s = GenerateCldrTests.getMatchingXMLFiles(sourceDir, localeRegex);
        Iterator<Object> it = s.iterator();
        while (it.hasNext()) {
            this.getCollationRules((String)it.next());
        }
        it = this.validLocales.iterator();
        block3: while (it.hasNext()) {
            locale = (String)it.next();
            types_rules = (Map)this.locale_types_rules.get(locale);
            if (types_rules != null) {
                Log.logln("Weird: overlap in validLocales: " + locale);
                continue;
            }
            String parentlocale = GenerateCldrTests.getParent(locale);
            while (parentlocale != null) {
                types_rules = (Map)this.locale_types_rules.get(parentlocale);
                if (types_rules != null) {
                    this.locale_types_rules.put(locale, types_rules);
                    continue block3;
                }
                locale = GenerateCldrTests.getParent(parentlocale);
            }
        }
        this.ulocale_rules.put(ULocale.ROOT, Collator.getInstance((ULocale)ULocale.ROOT));
        it = this.locale_types_rules.keySet().iterator();
        while (it.hasNext()) {
            locale = (String)it.next();
            types_rules = (Map)this.locale_types_rules.get(locale);
            Iterator it2 = types_rules.keySet().iterator();
            while (it2.hasNext()) {
                String type = (String)it2.next();
                if (type.equals("unihan") && !locale.startsWith("zh")) continue;
                RuleBasedCollator col = (RuleBasedCollator)types_rules.get(type);
                String name = type.equals("standard") ? locale : locale + "@collation=" + type;
                this.ulocale_rules.put(new ULocale(name), col);
            }
        }
        it = locales.iterator();
        while (it.hasNext()) {
            String parent;
            locale = (String)it.next();
            if (this.ulocale_rules.get(locale) != null || (parent = GenerateCldrTests.getParent(locale)) == null) continue;
            this.ulocale_rules.put(locale, this.ulocale_rules.get(parent));
        }
    }

    private void getCollationRules(String locale) throws Exception {
        System.out.println(locale);
        Document doc = LDMLUtilities.getFullyResolvedLDML(this.sourceDir, locale, false, false, false, false);
        Node node = LDMLUtilities.getNode(doc, "//ldml/collations");
        LDML2ICUConverter cnv = new LDML2ICUConverter();
        StringBuffer stringBuffer = new StringBuffer();
        ICUResourceWriter.ResourceTable resource = (ICUResourceWriter.ResourceTable)cnv.parseCollations(node, stringBuffer, false);
        TreeMap<String, RuleBasedCollator> types_rules = new TreeMap<String, RuleBasedCollator>();
        this.locale_types_rules.put(locale, types_rules);
        ICUResourceWriter.Resource current = resource.first;
        while (current != null) {
            if (current.name == null) {
                Log.logln("Collation: null name found in " + locale);
            } else if (current instanceof ICUResourceWriter.ResourceTable) {
                ICUResourceWriter.ResourceTable table = (ICUResourceWriter.ResourceTable)current;
                ICUResourceWriter.Resource current2 = table.first;
                while (current2 != null) {
                    if (current2 instanceof ICUResourceWriter.ResourceString) {
                        String rules;
                        RuleBasedCollator fixed;
                        ICUResourceWriter.ResourceString foo = (ICUResourceWriter.ResourceString)current2;
                        if (foo.name.equals("Sequence") && (fixed = this.generateCollator(locale, current.name, foo.name, rules = fromHex.transliterate(foo.val))) != null) {
                            Log.logln("Rules for: " + locale + ", " + current.name);
                            Log.logln(rules);
                            if (!rules.equals(foo.val)) {
                                Log.logln("Original Rules from Ram: ");
                                Log.logln(foo.val);
                            }
                            types_rules.put(current.name, fixed);
                        }
                    }
                    current2 = current2.next;
                }
            }
            current = current.next;
        }
        Document doc2 = LDMLUtilities.parse(this.sourceDir + locale + ".xml", false);
        Node colls = LDMLUtilities.getNode(doc2, "//ldml/collations");
        String validSubLocales = LDMLUtilities.getAttributeValue(colls, "validSubLocales");
        if (validSubLocales != null) {
            String[] items = new String[100];
            Utility.split((String)validSubLocales, (char)' ', (String[])items);
            int i = 0;
            while (items[i].length() != 0) {
                Log.logln("Valid Sub Locale: " + items[i]);
                this.validLocales.add(items[i]);
                ++i;
            }
        }
    }

    private RuleBasedCollator generateCollator(String locale, String current, String foo, String rules) {
        RuleBasedCollator fixed = null;
        try {
            if (rules.equals("")) {
                fixed = this.emptyCollator;
            } else {
                rules = GenerateCldrTests.replace(rules, "[optimize[", "[optimize [");
                RuleBasedCollator col = new RuleBasedCollator(rules = GenerateCldrTests.replace(rules, "[suppressContractions[", "[suppressContractions ["));
                fixed = (RuleBasedCollator)this.collation_collation.get(col);
                if (fixed == null) {
                    this.collation_collation.put(col, col);
                    fixed = col;
                }
            }
        }
        catch (Exception e) {
            Log.logln("***Cannot create collator from: " + locale + ", " + current + ", " + foo + ", " + rules);
            e.printStackTrace(Log.getLog());
            RuleBasedCollator coll = (RuleBasedCollator)Collator.getInstance((ULocale)new ULocale(locale));
            String oldrules = coll.getRules();
            Log.logln("Old ICU4J: " + oldrules);
            Log.logln("Equal?: " + oldrules.equals(rules));
        }
        return fixed;
    }
}

