/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.Relation;
import com.ibm.icu.dev.test.util.SortedBag;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.GenerateCldrCollationTests;
import org.unicode.cldr.tool.GenerateStatistics;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.Utility;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GenerateCldrTests {
    PrintWriter out;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int LOGDIR = 4;
    private static final int MATCH = 5;
    private static final int NOT_RESOLVED = 6;
    private static final int LANGUAGES = 7;
    private static final int TZADIR = 8;
    private static final int SHOW = 9;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/"), UOption.DESTDIR().setDefault("../../dropbox/gen/test/"), UOption.create((String)"log", (char)'l', (int)1).setDefault("../../dropbox/gen/test/"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"notresolved", (char)'n', (int)0), UOption.create((String)"languages", (char)'g', (int)0), UOption.create((String)"tzadir", (char)'t', (int)1).setDefault("./org/unicode/cldr/util/data/"), UOption.create((String)"show", (char)'s', (int)0)};
    GenerateCldrCollationTests cldrCollations;
    static String logDir = null;
    static String destDir = null;
    LanguageTagParser ltp = new LanguageTagParser();
    Set collationLocales = new TreeSet(ULocaleComparator);
    Set allLocales = new TreeSet(ULocaleComparator);
    Map localesToRules = new HashMap();
    Relation.CollectionFactory cm = new Relation.CollectionMaker(ULocaleComparator);
    Relation rulesToLocales = new Relation(new TreeMap(), this.cm);
    Relation parentToLocales = new Relation(new TreeMap(ULocaleComparator), this.cm);
    CLDRFile.Factory mainCldrFactory;
    ICUServiceBuilder icuServiceBuilder;
    public static final Comparator ULocaleComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    DataShower ZoneFieldShower = new DataShower(){
        StandardCodes sc = StandardCodes.make();
        List zones = Arrays.asList("America/Los_Angeles", "America/Argentina/Buenos_Aires", "America/Buenos_Aires", "America/Havana", "Australia/ACT", "Australia/Sydney", "Europe/London", "Europe/Moscow", "Etc/GMT+3");
        String[] perZoneSamples = new String[]{"Z", "ZZZZ", "z", "zzzz", "v", "vvvv"};
        String[] dates = new String[]{"2004-01-15T12:00:00Z", "2004-07-15T12:00:00Z"};

        public ResultsPrinter show(ULocale first, boolean includeDraft) throws Exception {
            TimezoneFormatter tzf = new TimezoneFormatter(GenerateCldrTests.this.mainCldrFactory, first.toString(), includeDraft);
            ResultsPrinter rp = new ResultsPrinter();
            ParsePosition parsePosition = new ParsePosition(0);
            Iterator it = this.zones.iterator();
            while (it.hasNext()) {
                String tzid = (String)it.next();
                rp.set("zone", tzid);
                for (int j = 0; j < this.dates.length; ++j) {
                    String date = this.dates[j];
                    Date datetime = ICUServiceBuilder.isoDateParse(date);
                    rp.set("date", this.dates[j]);
                    for (int i = 0; i < this.perZoneSamples.length; ++i) {
                        String field = this.perZoneSamples[i];
                        rp.set("field", field);
                        String formatted = tzf.getFormattedZone(tzid, field, datetime.getTime(), false);
                        parsePosition.setIndex(0);
                        String parsed = tzf.parse(formatted, parsePosition);
                        rp.set("parse", parsed);
                        rp.setResult(formatted);
                    }
                }
            }
            return rp;
        }

        public String getElement() {
            return "zoneFields";
        }
    };
    DataShower DateShower = new DataShower(){

        public ResultsPrinter show(ULocale locale, boolean includeDraft) throws ParseException {
            String[] samples = new String[]{"1900-01-31T00:00:00Z", "1909-02-28T00:00:01Z", "1918-03-26T00:59:59Z", "1932-04-24T01:00:00Z", "1945-05-20T01:00:01Z", "1952-06-18T11:59:59Z", "1973-07-16T12:00:00Z", "1999-08-14T12:00:01Z", "2000-09-12T22:59:59Z", "2001-10-08T23:00:00Z", "2004-11-04T23:00:01Z", "2010-12-01T23:59:59Z"};
            CLDRFile cldrFile = GenerateCldrTests.this.mainCldrFactory.make(locale.toString(), true, includeDraft);
            GenerateCldrTests.this.icuServiceBuilder.setCldrFile(cldrFile);
            ResultsPrinter rp = new ResultsPrinter();
            for (int j = 0; j < samples.length; ++j) {
                Date datetime = ICUServiceBuilder.isoDateParse(samples[j]);
                rp.set("input", ICUServiceBuilder.isoDateFormat(datetime));
                for (int i = 0; i < ICUServiceBuilder.LIMIT_DATE_FORMAT_INDEX; ++i) {
                    ICUServiceBuilder cfr_ignored_0 = GenerateCldrTests.this.icuServiceBuilder;
                    rp.set("dateType", ICUServiceBuilder.getDateNames(i));
                    for (int k = 0; k < ICUServiceBuilder.LIMIT_DATE_FORMAT_INDEX; ++k) {
                        if (i == 0 && k == 0) continue;
                        ICUServiceBuilder cfr_ignored_1 = GenerateCldrTests.this.icuServiceBuilder;
                        rp.set("timeType", ICUServiceBuilder.getDateNames(k));
                        SimpleDateFormat df = GenerateCldrTests.this.icuServiceBuilder.getDateFormat("gregorian", i, k);
                        rp.setResult(df.format(datetime));
                    }
                }
            }
            return rp;
        }

        public String getElement() {
            return "date";
        }
    };
    DataShower NumberShower = new DataShower(){

        public ResultsPrinter show(ULocale locale, boolean includeDraft) throws ParseException {
            CLDRFile cldrFile = GenerateCldrTests.this.mainCldrFactory.make(locale.toString(), true, includeDraft);
            GenerateCldrTests.this.icuServiceBuilder.setCldrFile(cldrFile);
            double[] samples = new double[]{0.0, 0.01, -0.01, 1.0, -1.0, 123.456, -123.456, 123456.78, -123456.78, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN};
            ResultsPrinter rp = new ResultsPrinter();
            for (int j = 0; j < samples.length; ++j) {
                double sample = samples[j];
                rp.set("input", String.valueOf(sample));
                for (int i = 0; i < ICUServiceBuilder.LIMIT_NUMBER_INDEX; ++i) {
                    rp.set("numberType", GenerateCldrTests.this.icuServiceBuilder.getNumberNames(i));
                    DecimalFormat nf = GenerateCldrTests.this.icuServiceBuilder.getNumberFormat(i);
                    String formatted = nf.format(sample);
                    if (formatted.indexOf("NaNNaN") >= 0) {
                        formatted = nf.format(sample);
                    }
                    rp.setResult(formatted);
                }
            }
            return rp;
        }

        public String getElement() {
            return "number";
        }
    };
    static ULocale zhHack = new ULocale("zh");
    DataShower CollationShower = new DataShower(){

        public ResultsPrinter show(ULocale locale, boolean includeDraft) {
            RuleBasedCollator col = GenerateCldrTests.this.cldrCollations.getInstance(locale);
            UnicodeSet tailored = new UnicodeSet();
            if (col != null) {
                tailored = col.getTailoredSet();
                if (locale.getLanguage().equals("zh")) {
                    tailored.addAll(new UnicodeSet("[[a-z]-[v]]"));
                    Log.logln("HACK for Pinyin");
                }
                tailored = GenerateCldrTests.createCaseClosure(tailored);
                tailored = GenerateCldrTests.nfc(tailored);
            } else {
                System.out.println("No collation for: " + locale);
                col = GenerateCldrTests.this.cldrCollations.getInstance(ULocale.ROOT);
            }
            UnicodeSet exemplars = GenerateCldrTests.this.getExemplarSet(locale, 2, includeDraft);
            exemplars = GenerateCldrTests.createCaseClosure(exemplars);
            exemplars = GenerateCldrTests.nfc(exemplars);
            tailored.addAll(exemplars);
            if (!exemplars.containsAll(tailored)) {
                Log.logln("In Tailored, but not Exemplar; Locale: " + locale + "\t" + locale.getDisplayName());
                Log.logln(new UnicodeSet(tailored).removeAll(exemplars).toPattern(false));
                Log.getLog().flush();
            }
            tailored.addAll(new UnicodeSet("[\\ .02{12}]"));
            tailored.removeAll(SKIP_COLLATION_SET);
            SortedBag bag = new SortedBag((Comparator)col);
            return GenerateCldrTests.this.doCollationResult((Collator)col, tailored, bag);
        }

        public String getElement() {
            return "collation";
        }
    };
    static final UnicodeSet SKIP_COLLATION_SET = new UnicodeSet("[[:script=han:][:script=hangul:]-[\u4e00-\u4eff \u9f00-\u9fff \uac00-\uacff \ud700-\ud7ff]]");
    public static final CloseCodePoint CCCP = new CloseCodePoint(){
        Locale locale = Locale.ENGLISH;
        UnicodeSet NONE = new UnicodeSet();
        UnicodeMap map = new UnicodeMap();

        public UnicodeSet close(int cp, UnicodeSet toAddTo) {
            UnicodeSet result = (UnicodeSet)this.map.getValue(cp);
            if (result == null) {
                result = new UnicodeSet();
                result.add(cp);
                String s = UCharacter.toLowerCase((Locale)this.locale, (String)UTF16.valueOf((int)cp));
                result.add(s);
                s = UCharacter.toUpperCase((Locale)this.locale, (String)UTF16.valueOf((int)cp));
                result.add(s);
                s = UCharacter.toTitleCase((Locale)this.locale, (String)UTF16.valueOf((int)cp), null);
                result.add(s);
                if (result.contains("SS")) {
                    result.add("sS").add("ss");
                }
                if (result.size() == 1) {
                    result = this.NONE;
                }
                this.map.put(cp, (Object)result);
            }
            if (result != this.NONE) {
                toAddTo.addAll(result);
            } else {
                toAddTo.add(cp);
            }
            return toAddTo;
        }
    };

    public static boolean hasLocalizedLanguageFor(ULocale locale, ULocale otherLocale) {
        String localizedVersion;
        String lang = otherLocale.getLanguage();
        return !lang.equals(localizedVersion = otherLocale.getDisplayLanguage(locale));
    }

    public static boolean hasLocalizedCountryFor(ULocale locale, ULocale otherLocale) {
        String country = otherLocale.getCountry();
        if (country.equals("")) {
            return true;
        }
        String localizedVersion = otherLocale.getDisplayCountry(locale);
        return !country.equals(localizedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        double deltaTime;
        block4: {
            block3: {
                deltaTime = System.currentTimeMillis();
                UOption.parseArgs((String[])args, (UOption[])options);
                Log.setLog(GenerateCldrTests.options[4].value + "log.txt");
                try {
                    if (GenerateCldrTests.options[7].doesOccur) {
                        GenerateStatistics.generateSize(GenerateCldrTests.options[2].value + "main/", GenerateCldrTests.options[4].value, GenerateCldrTests.options[8].value, GenerateCldrTests.options[5].value, true);
                        Object var5_2 = null;
                        break block3;
                    }
                    GenerateCldrTests t = new GenerateCldrTests();
                    t.generate(GenerateCldrTests.options[5].value);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    Log.close();
                    deltaTime = (double)System.currentTimeMillis() - deltaTime;
                    System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
                    System.out.println("Done");
                    throw throwable;
                }
            }
            Log.close();
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
            return;
        }
        Object var5_3 = null;
        Log.close();
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
        System.out.println("Done");
    }

    private static void showLocales(Set sLocs) {
        Iterator it = sLocs.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            Log.logln(s + "\t" + ULocale.getDisplayLanguage((String)s, (String)"en"));
        }
    }

    private static Set filter(Object[] cols) {
        TreeSet<String> result = new TreeSet<String>();
        for (int i = 0; i < cols.length; ++i) {
            String s = cols[i].toString();
            if (s.indexOf(95) >= 0) continue;
            result.add(s);
        }
        return result;
    }

    Set addULocales(Object[] objects, Set target) {
        for (int i = 0; i < objects.length; ++i) {
            target.add(new ULocale(objects[i].toString()));
        }
        return target;
    }

    private void addLocale(String locale) {
        String lang;
        try {
            lang = this.ltp.set(locale).getLanguage();
            if (lang.length() == 0) {
                return;
            }
        }
        catch (RuntimeException e) {
            return;
        }
        this.parentToLocales.add((Object)new ULocale(lang), (Object)new ULocale(locale));
    }

    void generate(String pat) throws Exception {
        this.mainCldrFactory = CLDRFile.Factory.make(GenerateCldrTests.options[2].value + "main" + File.separator, pat);
        CLDRFile.Factory collationCldrFactory = CLDRFile.Factory.make(GenerateCldrTests.options[2].value + "collation" + File.separator, pat);
        CLDRFile.Factory supplementalCldrFactory = CLDRFile.Factory.make(GenerateCldrTests.options[2].value + "supplemental" + File.separator, ".*");
        this.allLocales.addAll(this.mainCldrFactory.getAvailable());
        this.allLocales.addAll(collationCldrFactory.getAvailable());
        this.cldrCollations = new GenerateCldrCollationTests(GenerateCldrTests.options[2].value + "collation" + File.separator, pat, this.allLocales);
        if (GenerateCldrTests.options[9].doesOccur) {
            this.cldrCollations.show();
        }
        this.collationLocales.addAll(this.allLocales);
        Iterator it = this.cldrCollations.getAvailableSet().iterator();
        while (it.hasNext()) {
            this.collationLocales.add(it.next().toString());
        }
        this.icuServiceBuilder = new ICUServiceBuilder();
        it = this.collationLocales.iterator();
        while (it.hasNext()) {
            this.addLocale((String)it.next());
        }
        Matcher m = Pattern.compile(pat).matcher("");
        Iterator it2 = this.parentToLocales.keySet().iterator();
        while (it2.hasNext()) {
            String p = it2.next().toString();
            if (!m.reset(p).matches()) continue;
            this.generate(new ULocale(p));
        }
    }

    private void generate(ULocale locale) throws Exception {
        this.out = BagFormatter.openUTF8Writer((String)GenerateCldrTests.options[3].value, (String)(locale + ".xml"));
        this.out.println("<?xml version='1.0' encoding='UTF-8' ?>");
        this.out.println("<!DOCTYPE ldml SYSTEM 'http://www.unicode.org/cldr/dtd/1.4/cldrTest.dtd'>");
        this.out.println("<!-- For information, see readme.html -->");
        this.out.println(" <cldrTest version='1.4' base='" + locale + "'>");
        this.out.println(" <!-- " + TransliteratorUtilities.toXML.transliterate(locale.getDisplayName(ULocale.ENGLISH) + " [" + locale.getDisplayName(locale)) + "] -->");
        this.generateItems(locale, this.allLocales, this.NumberShower);
        this.generateItems(locale, this.allLocales, this.DateShower);
        this.generateItems(locale, this.allLocales, this.ZoneFieldShower);
        this.generateItems(locale, this.collationLocales, this.CollationShower);
        this.out.println(" </cldrTest>");
        this.out.close();
        Utility.generateBat(GenerateCldrTests.options[2].value + "test" + File.separator, locale + ".xml", GenerateCldrTests.options[3].value, locale + ".xml", new Utility.SimpleLineComparator(0));
    }

    void add(ULocale locale, Map uniqueLocales) {
        try {
            RuleBasedCollator col = this.cldrCollations.getInstance(locale);
            String key = col.getRules() + "\uffff" + this.getExemplarSet(locale, 0, true);
            TreeSet<ULocale> s = (TreeSet<ULocale>)uniqueLocales.get(key);
            if (s == null) {
                s = new TreeSet<ULocale>(ULocaleComparator);
                uniqueLocales.put(key, s);
            }
            System.out.println("Adding " + locale);
            s.add(locale);
        }
        catch (Throwable e) {
            System.out.println("skipped " + locale);
        }
    }

    public UnicodeSet getExemplarSet(ULocale locale, int options, boolean includeDraft) {
        String n = locale.toString();
        int pos = n.indexOf(64);
        if (pos >= 0) {
            locale = new ULocale(n.substring(0, pos));
        }
        CLDRFile cldrFile = this.mainCldrFactory.make(locale.toString(), true, includeDraft);
        String v = cldrFile.getStringValue("//ldml/characters/exemplarCharacters");
        UnicodeSet result = new UnicodeSet(v);
        v = cldrFile.getStringValue("//ldml/characters/exemplarCharacters[@type=\"auxiliary\"]");
        if (v != null) {
            result.addAll(new UnicodeSet(v));
        }
        if (options == 0) {
            result.closeOver(2);
        }
        return result;
    }

    static boolean intersects(Collection a, Collection b) {
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (!b.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    private void generateItems(ULocale locale, Collection onlyLocales, DataShower generator) throws Exception {
        TreeSet<ULocale> sublocales = new TreeSet<ULocale>(ULocaleComparator);
        sublocales.add(locale);
        this.parentToLocales.get((Object)locale, sublocales);
        sublocales.retainAll(onlyLocales);
        TreeMap<ULocale, ResultsPrinter> locale_results = new TreeMap<ULocale, ResultsPrinter>(ULocaleComparator);
        Iterator it = sublocales.iterator();
        while (it.hasNext()) {
            ULocale current = (ULocale)it.next();
            locale_results.put(current, generator.show(current));
        }
        TreeSet<ULocale> matchingLocales = new TreeSet<ULocale>(ULocaleComparator);
        while (sublocales.size() != 0) {
            ULocale first = (ULocale)sublocales.iterator().next();
            ResultsPrinter r = (ResultsPrinter)locale_results.get(first);
            Iterator it2 = sublocales.iterator();
            while (it2.hasNext()) {
                ULocale other = (ULocale)it2.next();
                ResultsPrinter r2 = (ResultsPrinter)locale_results.get(other);
                if (!r2.equals(r)) continue;
                matchingLocales.add(other);
            }
            this.showLocales(generator.getElement(), matchingLocales);
            r.print();
            this.out.println("  </" + generator.getElement() + ">");
            sublocales.removeAll(matchingLocales);
            matchingLocales.clear();
        }
    }

    public void showLocales(String elementName, Collection others) {
        this.out.println("  <" + elementName + " ");
        StringBuffer comment = new StringBuffer();
        if (others != null && others.size() != 0) {
            this.out.print("locales='");
            boolean first = true;
            Iterator it = others.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    this.out.print(" ");
                    comment.append("; ");
                }
                ULocale loc = (ULocale)it.next();
                this.out.print(loc);
                comment.append(loc.getDisplayName(ULocale.ENGLISH) + " [" + loc.getDisplayName(loc) + "]");
            }
            this.out.print("'");
        }
        this.out.println(">");
        this.out.println("<!-- " + TransliteratorUtilities.toXML.transliterate(comment.toString()) + " -->");
    }

    private ResultsPrinter doCollationResult(Collator col, UnicodeSet tailored, SortedBag bag) {
        UnicodeSetIterator usi = new UnicodeSetIterator(tailored);
        while (usi.next()) {
            String s = usi.getString();
            bag.add((Object)('x' + s));
            bag.add((Object)('X' + s));
            bag.add((Object)('x' + s + 'x'));
        }
        String last = "";
        boolean needEquals = false;
        StringBuffer tempResult = new StringBuffer("\r\n");
        Iterator it = bag.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (col.compare(s, last) != 0) {
                if (needEquals) {
                    tempResult.append(last).append("\r\n");
                }
                needEquals = false;
                last = s;
            } else {
                needEquals = true;
            }
            tempResult.append(TransliteratorUtilities.toXML.transliterate(s)).append("\r\n");
        }
        ResultsPrinter result = new ResultsPrinter();
        result.setResult(tempResult.toString());
        return result;
    }

    public static Set getMatchingXMLFiles(String dir, String localeRegex) {
        Matcher m = Pattern.compile(localeRegex).matcher("");
        TreeSet<String> s = new TreeSet<String>();
        File[] files = new File(dir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            String locale;
            String name = files[i].getName();
            if (!name.endsWith(".xml") || name.startsWith("supplementalData") || !(locale = name.substring(0, name.length() - 4)).equals("root") && !m.reset(locale).matches()) continue;
            s.add(locale);
        }
        return s;
    }

    public static String getXPath(Node node) {
        StringBuffer xpathFragment = new StringBuffer();
        StringBuffer xpath = new StringBuffer();
        while (node.getNodeType() != 9) {
            xpathFragment.setLength(0);
            xpathFragment.append('/').append(node.getNodeName());
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    xpathFragment.append("[@").append(attribute.getNodeName()).append('=').append(attribute.getNodeValue()).append(']');
                }
            }
            xpath.insert(0, (Object)xpathFragment);
            node = node.getParentNode();
        }
        xpath.insert(0, '/');
        return xpath.toString();
    }

    public static String getParent(String locale) {
        int pos = locale.lastIndexOf(95);
        if (pos >= 0) {
            return locale.substring(0, pos);
        }
        if (!locale.equals("root")) {
            return "root";
        }
        return null;
    }

    public static String replace(String source, String pattern, String replacement) {
        int pos = source.indexOf(pattern, 0);
        while (pos >= 0) {
            source = source.substring(0, pos) + replacement + source.substring(pos + pattern.length());
            pos = source.indexOf(pattern, pos + 1);
        }
        return source;
    }

    static UnicodeSet apply(UnicodeSet source, Apply apply) {
        UnicodeSet target = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(source);
        while (usi.next()) {
            String s = usi.getString();
            target.add(apply.apply(s));
        }
        return target;
    }

    static UnicodeSet nfc(UnicodeSet source) {
        return GenerateCldrTests.apply(source, new Apply(){

            public String apply(String source) {
                return Normalizer.compose((String)source, (boolean)false);
            }
        });
    }

    public static UnicodeSet createCaseClosure(UnicodeSet source) {
        UnicodeSet target = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(source);
        while (usi.next()) {
            String s = usi.getString();
            UnicodeSet temp = GenerateCldrTests.createClosure(s, CCCP);
            if (temp == null) {
                target.add(s);
                continue;
            }
            target.addAll(temp);
        }
        return target;
    }

    public static UnicodeSet createClosure(String source, CloseCodePoint closer) {
        return GenerateCldrTests.createClosure(source, 0, closer);
    }

    public static UnicodeSet createClosure(String source, int position, CloseCodePoint closer) {
        UnicodeSet result = new UnicodeSet();
        if (position >= source.length()) {
            return result;
        }
        int cp = UTF16.charAt((String)source, (int)position);
        int endPosition = position + UTF16.getCharCount((int)cp);
        if (endPosition >= source.length()) {
            return closer.close(cp, result);
        }
        UnicodeSet remainder = GenerateCldrTests.createClosure(source, endPosition, closer);
        return GenerateCldrTests.createAppend(closer.close(cp, result), remainder);
    }

    public static UnicodeSet createAppend(UnicodeSet a, UnicodeSet b) {
        UnicodeSet target = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(a);
        while (usi.next()) {
            String s = usi.getString();
            UnicodeSetIterator usi2 = new UnicodeSetIterator(b);
            while (usi2.next()) {
                String s2 = usi2.getString();
                target.add(s + s2);
            }
        }
        return target;
    }

    static class UnicodeSetComparator
    implements Comparator {
        UnicodeSetIterator ait = new UnicodeSetIterator();
        UnicodeSetIterator bit = new UnicodeSetIterator();

        UnicodeSetComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            UnicodeSet a = (UnicodeSet)o1;
            UnicodeSet b = (UnicodeSet)o2;
            if (a.size() != b.size()) {
                return a.size() < b.size() ? -1 : 1;
            }
            this.ait.reset(a);
            this.bit.reset(b);
            while (this.ait.nextRange()) {
                this.bit.nextRange();
                if (this.ait.codepoint != this.bit.codepoint) {
                    return this.ait.codepoint < this.bit.codepoint ? -1 : 1;
                }
                if (this.ait.codepoint == UnicodeSetIterator.IS_STRING) {
                    int result = this.ait.string.compareTo(this.bit.string);
                    if (result == 0) continue;
                    return result;
                }
                if (this.ait.codepointEnd == this.bit.codepointEnd) continue;
                return this.ait.codepointEnd < this.bit.codepointEnd ? -1 : 1;
            }
            return 0;
        }
    }

    public static interface CloseCodePoint {
        public UnicodeSet close(int var1, UnicodeSet var2);
    }

    public static interface Apply {
        public String apply(String var1);
    }

    static interface DataShower2 {
        public void show(ULocale var1, Collection var2) throws Exception;
    }

    abstract class DataShower {
        DataShower() {
        }

        abstract ResultsPrinter show(ULocale var1, boolean var2) throws Exception;

        ResultsPrinter show(ULocale first) throws Exception {
            ResultsPrinter rpIncludeDraft = this.show(first, true);
            ResultsPrinter rpNoDraft = this.show(first, false);
            return new ResultsPrinter(rpIncludeDraft, rpNoDraft);
        }

        abstract String getElement();
    }

    class ResultsPrinter {
        private Set listOfSettings = new LinkedHashSet();
        private transient LinkedHashMap settings = new LinkedHashMap();

        ResultsPrinter() {
        }

        ResultsPrinter(ResultsPrinter rpIncludeDraft, ResultsPrinter rpNoDraft) {
            Set listOfSettings1 = rpIncludeDraft.listOfSettings;
            Set listOfSettings2 = rpNoDraft.listOfSettings;
            if (listOfSettings1.size() != listOfSettings2.size()) {
                throw new InternalError("can't combine");
            }
            Iterator it1 = listOfSettings1.iterator();
            Iterator it2 = listOfSettings2.iterator();
            while (it1.hasNext()) {
                Map settings2;
                Map settings1 = (Map)it1.next();
                if (((Object)settings1).equals(settings2 = (Map)it2.next())) {
                    settings1.put("draft", "either");
                    this.listOfSettings.add(settings1);
                    continue;
                }
                settings1.put("draft", "true");
                this.listOfSettings.add(settings1);
                settings2.put("draft", "false");
                this.listOfSettings.add(settings2);
            }
        }

        void set(String name, String value) {
            this.settings.put(name, value);
        }

        void setResult(String result) {
            this.settings.put("result", result);
            this.listOfSettings.add(this.settings.clone());
        }

        void print() {
            Map oldSettings = new TreeMap();
            Iterator it2 = this.listOfSettings.iterator();
            while (it2.hasNext()) {
                Map settings = (Map)it2.next();
                String result = (String)settings.get("result");
                GenerateCldrTests.this.out.print("   <result");
                Iterator it = settings.keySet().iterator();
                while (it.hasNext()) {
                    Object value;
                    Object key = it.next();
                    if (key.equals("result") || (value = settings.get(key)).equals(oldSettings.get(key))) continue;
                    GenerateCldrTests.this.out.print(" " + key + "='" + TransliteratorUtilities.toXML.transliterate(value.toString()) + "'");
                }
                GenerateCldrTests.this.out.println(">" + TransliteratorUtilities.toXML.transliterate(result) + "</result>");
                oldSettings = settings;
            }
        }

        public boolean equals(Object other) {
            try {
                ResultsPrinter that = (ResultsPrinter)other;
                return ((Object)this.listOfSettings).equals(that.listOfSettings);
            }
            catch (Exception e) {
                return false;
            }
        }

        public int hashCode() {
            throw new IllegalArgumentException();
        }
    }
}

