/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.CollectionUtilities;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class GenerateEnums {
    private StandardCodes sc = StandardCodes.make();
    private CLDRFile.Factory factory = CLDRFile.Factory.make("../../common/main/", ".*");
    private CLDRFile.Factory supplementalFactory = CLDRFile.Factory.make("../../common/supplemental/", ".*");
    private Set cldrCodes = new TreeSet();
    private Map enum_alpha3 = new TreeMap();
    private Map enum_UN = new TreeMap();
    private Map enum_FIPS10 = new TreeMap();
    private Map enum_TLD = new TreeMap();
    private CLDRFile english = this.factory.make("en", false);
    private CLDRFile supplementalMetadata = this.factory.make("supplementalMetadata", false);
    private CLDRFile supplementalData = this.factory.make("supplementalData", false);
    private TreeSet unlimitedCurrencyCodes;
    private Set scripts = new TreeSet();
    private Set languages = new TreeSet();
    static NumberFormat threeDigit = new DecimalFormat("000");
    Map containment = new TreeMap();
    Set corrigendum = new TreeSet<String>(Arrays.asList("QE", "833", "830", "172"));
    private Map extraNames = CollectionUtilities.asMap((Object[][])new String[][]{{"BU", "Burma"}, {"TP", "East Timor"}, {"YU", "Yugoslavia"}, {"ZR", "Zaire"}, {"CD", "Congo (Kinshasa, Democratic Republic)"}, {"CI", "Ivory Coast (Cote d'Ivoire)"}, {"FM", "Micronesia (Federated States)"}, {"TL", "East Timor (Timor-Leste)"}});
    private Set currencyCodes;
    private Set validCurrencyCodes;

    public static void main(String[] args) throws IOException {
        GenerateEnums gen = new GenerateEnums();
        gen.loadCLDRData();
        gen.showCurrencies();
        gen.showLanguages();
        gen.showScripts();
        gen.printInfo();
        gen.printAdditionalInfo();
    }

    private void showCurrencies() {
        System.out.println();
        System.out.println("Currency Data");
        System.out.println();
        this.compareSets("currencies from sup.data", this.currencyCodes, "valid currencies", this.validCurrencyCodes);
        TreeSet both = new TreeSet(this.currencyCodes);
        both.addAll(this.validCurrencyCodes);
        Iterator it = both.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            String englishName = this.english.getName(4, code, false);
            System.out.println(code + "\t" + englishName + "\t" + (this.validCurrencyCodes.contains(code) ? (this.currencyCodes.contains(code) ? "" : "valid-only") : "supp-only") + "\t" + (this.unlimitedCurrencyCodes.contains(code) ? "" : "unused"));
        }
    }

    private void showScripts() {
        System.out.println();
        System.out.println("Script Data");
        System.out.println();
        Iterator it = this.scripts.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            String englishName = this.english.getName(1, code, false);
            if (englishName == null) continue;
            System.out.println("     /**" + englishName + "*/    " + code + ",");
        }
    }

    private void showLanguages() {
        System.out.println();
        System.out.println("Language Data");
        System.out.println();
        Iterator it = this.languages.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            String englishName = this.english.getName(0, code, false);
            if (englishName == null) continue;
            System.out.println("     /**" + englishName + "*/    " + code + ",");
        }
    }

    private void printAdditionalInfo() {
        String cldrName;
        String region;
        System.out.println();
        System.out.println("Data for ISO Region Codes");
        System.out.println();
        TreeSet reordered = new TreeSet(new LengthFirstComparator());
        reordered.addAll(this.enum_UN.keySet());
        Iterator it = reordered.iterator();
        while (it.hasNext()) {
            region = (String)it.next();
            cldrName = region.length() < 5 ? region : region.substring(2);
            int un = Integer.parseInt((String)this.enum_UN.get(region));
            String isoCode = (String)this.enum_alpha3.get(region);
            if (isoCode == null) continue;
            System.out.println("  add(" + GenerateEnums.quote(isoCode) + ", " + "RegionCode." + region + ");");
        }
        System.out.println();
        System.out.println("Data for M.49 Region Codes");
        System.out.println();
        it = reordered.iterator();
        while (it.hasNext()) {
            region = (String)it.next();
            cldrName = region.length() < 5 ? region : region.substring(2);
            String un = GenerateEnums.quote((String)this.enum_UN.get(region));
            System.out.println("  add(" + un + ", " + "RegionCode." + region + ");");
        }
    }

    private Object join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    public void loadCLDRData() throws IOException {
        String line;
        String line2;
        BufferedReader codes = Utility.getUTF8Data("territory_codes.txt");
        while ((line2 = codes.readLine()) != null) {
            if ((line2 = line2.split("#")[0].trim()).length() == 0) continue;
            String[] sourceValues = line2.split("\\s+");
            String[] values = new String[5];
            for (int i = 0; i < values.length; ++i) {
                values[i] = i >= sourceValues.length || sourceValues[i].equals("-") ? null : sourceValues[i];
            }
            String alpha2 = values[0];
            this.cldrCodes.add(alpha2);
            if (GenerateEnums.isPrivateUseRegion(alpha2)) continue;
            String numeric = values[1];
            String alpha3 = values[2];
            String internet = values[3];
            if (internet != null) {
                internet = internet.toUpperCase();
            }
            String fips10 = values[4];
            String enumValue = this.enumName(alpha2);
            this.enum_alpha3.put(enumValue, alpha3);
            this.enum_UN.put(enumValue, numeric);
            this.enum_FIPS10.put(enumValue, fips10);
            this.enum_TLD.put(enumValue, internet);
        }
        codes.close();
        codes = Utility.getUTF8Data("UnMacroRegions.txt");
        TreeMap<String, String> macro_name = new TreeMap<String, String>();
        while ((line = codes.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.charAt(0) < '0' || line.charAt(0) > '9') {
                System.out.println("Skipping: " + line);
                continue;
            }
            String[] sourceValues = line.split("\\s+");
            int code = Integer.parseInt(sourceValues[0]);
            String codeName = threeDigit.format((long)code);
            macro_name.put(codeName, line);
        }
        codes.close();
        String values = this.supplementalMetadata.getStringValue("//supplementalData/metadata/validity/variable[@id=\"$territory\"]", true).trim();
        String[] validTerritories = values.split("\\s+");
        for (int i = 0; i < validTerritories.length; ++i) {
            if (this.corrigendum.contains(validTerritories[i])) {
                System.out.println("Skipping " + validTerritories[i] + "\t\t" + this.getEnglishName(validTerritories[i]));
                continue;
            }
            if (GenerateEnums.isPrivateUseRegion(validTerritories[i])) continue;
            if (validTerritories[i].charAt(0) < 'A') {
                this.enum_UN.put(this.enumName(validTerritories[i]), validTerritories[i]);
                this.cldrCodes.add(validTerritories[i]);
                continue;
            }
            if (this.enum_alpha3.get(validTerritories[i]) != null) continue;
            System.out.println("Missing alpha3 for: " + validTerritories[i]);
        }
        this.checkDuplicates(this.enum_UN);
        this.checkDuplicates(this.enum_alpha3);
        TreeSet availableCodes = new TreeSet(this.sc.getAvailableCodes("territory"));
        this.compareSets("RFC", availableCodes, "CLDR", this.cldrCodes);
        TreeSet UNValues = new TreeSet(this.enum_UN.values());
        Iterator it = macro_name.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = macro_name.get(key);
            if (UNValues.contains(key)) continue;
            System.out.println("Macro " + key + "\t" + value);
        }
        it = this.enum_UN.keySet().iterator();
        while (it.hasNext()) {
            String rfcName;
            String region = (String)it.next();
            String englishName = this.getEnglishName(region);
            if (englishName.equals(rfcName = this.getRFC3066Name(region))) continue;
            System.out.println("Different names: {\"" + region + "\",\t\"" + englishName + " (" + rfcName + ")\"},");
        }
        XPathParts parts = new XPathParts();
        Iterator it2 = this.supplementalData.iterator("//supplementalData/territoryContainment/group");
        while (it2.hasNext()) {
            String path = (String)it2.next();
            parts.set(path);
            String container = parts.getAttributeValue(parts.size() - 1, "type");
            List<String> contained = Arrays.asList(parts.getAttributeValue(parts.size() - 1, "contains").trim().split("\\s+"));
            this.containment.put(container, contained);
        }
        TreeSet startingFromWorld = new TreeSet();
        this.addContains("001", startingFromWorld);
        this.compareSets("World", startingFromWorld, "CLDR", this.cldrCodes);
        DateFormat[] simpleFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM"), new SimpleDateFormat("yyyy")};
        Date today = new Date();
        Date longAgo = new Date(-900, 1, 1);
        this.currencyCodes = new TreeSet();
        this.unlimitedCurrencyCodes = new TreeSet();
        Iterator it3 = this.supplementalData.iterator("//supplementalData/currencyData/region");
        while (it3.hasNext()) {
            String code;
            block22: {
                String path = (String)it3.next();
                parts.set(path);
                code = parts.findAttributeValue("currency", "iso4217");
                String to = parts.findAttributeValue("currency", "to");
                if (to == null) {
                    this.unlimitedCurrencyCodes.add(code);
                } else {
                    for (int i = 0; i < simpleFormats.length; ++i) {
                        try {
                            Date foo = simpleFormats[i].parse(to);
                            if (foo.compareTo(longAgo) < 0) {
                                System.out.println("Date Error: can't parse " + to);
                            } else if (foo.compareTo(today) >= 0) {
                                this.unlimitedCurrencyCodes.add(code);
                            }
                            break block22;
                        }
                        catch (ParseException e) {
                            continue;
                        }
                    }
                    System.out.println("Date Error: can't parse " + to);
                }
            }
            this.currencyCodes.add(code);
        }
        String validCurrencies = this.supplementalMetadata.getStringValue("//supplementalData/metadata/validity/variable[@id=\"$currency\"]", true).trim();
        this.validCurrencyCodes = new TreeSet<String>(Arrays.asList(validCurrencies.split("\\s+")));
        values = this.supplementalMetadata.getStringValue("//supplementalData/metadata/validity/variable[@id=\"$script\"]", true).trim();
        String[] validScripts = values.split("\\s+");
        for (int i = 0; i < validScripts.length; ++i) {
            this.scripts.add(validScripts[i]);
        }
        values = this.supplementalMetadata.getStringValue("//supplementalData/metadata/validity/variable[@id=\"$language\"]", true).trim();
        String[] validLanguages = values.split("\\s+");
        for (int i = 0; i < validLanguages.length; ++i) {
            this.languages.add(validLanguages[i]);
        }
    }

    private void compareSets(String name, Set availableCodes, String name2, Set cldrCodes) {
        TreeSet temp = new TreeSet();
        temp.addAll(availableCodes);
        temp.removeAll(cldrCodes);
        System.out.println("In " + name + " but not in " + name2 + ": " + temp);
        temp.clear();
        temp.addAll(cldrCodes);
        temp.removeAll(availableCodes);
        System.out.println("Not in " + name + " but in " + name2 + ": " + temp);
    }

    private void addContains(String string, Set startingFromWorld) {
        startingFromWorld.add(string);
        List contained = (List)this.containment.get(string);
        if (contained == null) {
            return;
        }
        Iterator it = contained.iterator();
        while (it.hasNext()) {
            this.addContains((String)it.next(), startingFromWorld);
        }
    }

    private void checkDuplicates(Map m) {
        HashMap backMap = new HashMap();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object o = m.get(key);
            Object otherKey = backMap.get(o);
            if (otherKey != null) {
                System.out.println("Collision with: " + key + ",\t" + otherKey + ",\t" + o);
                continue;
            }
            backMap.put(o, key);
        }
    }

    private void printInfo() {
        System.out.println();
        System.out.println("Data for RegionCode");
        System.out.println();
        TreeSet reordered = new TreeSet(new LengthFirstComparator());
        reordered.addAll(this.enum_UN.keySet());
        Iterator it = reordered.iterator();
        while (it.hasNext()) {
            String region = (String)it.next();
            this.printRow(region);
        }
    }

    private void printRow(String codeName) {
        int numeric = Integer.parseInt((String)this.enum_UN.get(codeName));
        String alpha3 = (String)this.enum_alpha3.get(codeName);
        String deprecated = "";
        String cldrName = codeName.length() < 5 ? codeName : codeName.substring(2);
        String path = this.supplementalMetadata.getFullXPath("//supplementalData/metadata/alias/territoryAlias[@type=\"" + cldrName + "\"]", true);
        String prefix = "  /** " + this.getEnglishName(codeName);
        String printedCodeName = codeName;
        if (path != null) {
            String replacement = new XPathParts().set(path).findAttributeValue("territoryAlias", "replacement");
            System.out.println(prefix);
            prefix = "   * @deprecated" + (replacement == null ? "" : " see " + replacement);
            printedCodeName = "@Deprecated " + printedCodeName;
        }
        prefix = prefix + " */";
        if (codeName.equals("UN001")) {
            System.out.println();
        }
        System.out.print(prefix);
        System.out.print("                                                           ".substring(prefix.length() + printedCodeName.length()));
        System.out.println(printedCodeName + ",");
    }

    private String getEnglishName(String codeName) {
        String name;
        if (codeName.length() > 3) {
            codeName = codeName.substring(2);
        }
        if ((name = (String)this.extraNames.get(codeName)) != null) {
            return name;
        }
        name = this.english.getName(2, codeName, false);
        return name;
    }

    private String getRFC3066Name(String codeName) {
        List list;
        if (codeName.length() > 2) {
            codeName = codeName.substring(2);
        }
        if ((list = this.sc.getFullData("territory", codeName)) == null) {
            return null;
        }
        return (String)list.get(0);
    }

    private String enumName(String codeName) {
        return codeName.charAt(0) < 'A' ? "UN" + codeName : codeName;
    }

    static String quote(Object input) {
        if (input != null) {
            return '\"' + input.toString().trim() + '\"';
        }
        return null;
    }

    static boolean isPrivateUseRegion(String codeName) {
        if (codeName.equals("QU") || codeName.equals("QO") || codeName.equals("ZZ")) {
            return false;
        }
        if (codeName.equals("AA") || codeName.equals("ZZ")) {
            return true;
        }
        if (codeName.compareTo("QM") >= 0 && codeName.compareTo("QZ") <= 0) {
            return true;
        }
        return codeName.compareTo("XA") >= 0 && codeName.compareTo("XZ") <= 0;
    }

    public static final class LengthFirstComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            String as = a.toString();
            String bs = b.toString();
            if (as.length() < bs.length()) {
                return -1;
            }
            if (as.length() > bs.length()) {
                return 1;
            }
            return as.compareTo(bs);
        }
    }
}

