/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.ArrayComparator;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class GenerateG2xG2 {
    static CLDRFile english;
    static CLDRFile root;
    static Map priorityMap;
    static Map totalMap;
    static Map territory_currency;

    public static void main(String[] args) throws Exception {
        if (GenerateG2xG2.showLocales(-1)) {
            return;
        }
        String sourceLanguage = "G5";
        String targetLanguage = "G5";
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        english = cldrFactory.make("en", true);
        root = cldrFactory.make("root", true);
        StandardCodes sc = StandardCodes.make();
        Map type_code_value = sc.getLocaleTypes();
        TreeSet<String> sourceSet = new TreeSet<String>();
        TreeSet<String> targetLanguageSet = new TreeSet<String>();
        targetLanguageSet.add("no");
        GenerateG2xG2.addPriority("G2", "nn");
        GenerateG2xG2.addPriority("G2", "no");
        targetLanguageSet.add("nn");
        TreeSet<String> targetScriptSet = new TreeSet<String>();
        TreeSet<String> targetRegionSet = new TreeSet<String>();
        TreeSet<String> targetTZSet = new TreeSet<String>();
        TreeSet<String> targetCurrencySet = new TreeSet<String>();
        Iterator it = type_code_value.keySet().iterator();
        while (it.hasNext()) {
            Object type = it.next();
            Map code_value = (Map)type_code_value.get(type);
            if (!type.equals("IBM")) continue;
            Iterator it2 = code_value.keySet().iterator();
            while (it2.hasNext()) {
                String locale = (String)it2.next();
                if (locale.equals("no")) continue;
                String priority = (String)code_value.get(locale);
                ULocale ulocale = new ULocale(locale);
                String language = ulocale.getLanguage();
                String script = ulocale.getScript();
                String territory = ulocale.getCountry();
                if (sourceLanguage.compareTo(priority) >= 0) {
                    if (language.equals("no")) {
                        language = "nn";
                    }
                    locale = new ULocale(language, script).toString();
                    sourceSet.add(locale);
                    GenerateG2xG2.addPriority(priority, locale);
                }
                if (targetLanguage.compareTo(priority) < 0) continue;
                targetLanguageSet.add(language);
                targetScriptSet.add(script);
                targetRegionSet.add(territory);
                GenerateG2xG2.addPriority(priority, language);
                GenerateG2xG2.addPriority(priority, script);
                GenerateG2xG2.addPriority("G4", territory);
            }
        }
        Map worldBankInfo = sc.getWorldBankInfo();
        HashSet<String> euCodes = new HashSet<String>(Arrays.asList("AT", "BE", "CY", "CZ", "DK", "EE", "FI", "FR", "DE", "GR", "HU", "IT", "LV", "LT", "LU", "MT", "NL", "PL", "PT", "SI", "ES", "SE", "GB"));
        Iterator it2 = worldBankInfo.keySet().iterator();
        while (it2.hasNext()) {
            String countryCode = (String)it2.next();
            if (priorityMap.get(countryCode) == null) continue;
            List values = (List)worldBankInfo.get(countryCode);
            double gdp = Double.parseDouble((String)values.get(1));
            if (gdp >= 1.0E13) {
                GenerateG2xG2.addPriority("G0", countryCode);
                continue;
            }
            if (gdp >= 1.0E12) {
                GenerateG2xG2.addPriority("G1", countryCode);
                continue;
            }
            if (gdp >= 1.0E11) {
                GenerateG2xG2.addPriority("G2", countryCode);
                continue;
            }
            if (!euCodes.contains(countryCode)) continue;
            GenerateG2xG2.addPriority("G3", countryCode);
        }
        Map c2z = sc.getCountryToZoneSet();
        Set mainTimeZones = sc.getMainTimeZones();
        Iterator it3 = targetRegionSet.iterator();
        while (it3.hasNext()) {
            String country = (String)it3.next();
            String priority = (String)priorityMap.get(country);
            Iterator it22 = GenerateG2xG2.getCurrency(country).iterator();
            while (it22.hasNext()) {
                String currency = (String)it22.next();
                targetCurrencySet.add(currency);
                GenerateG2xG2.addPriority(priority, currency);
            }
            Set s = (Set)c2z.get(country);
            if (s.size() == 1) continue;
            Iterator it23 = s.iterator();
            while (it23.hasNext()) {
                String tzid = (String)it23.next();
                if (!mainTimeZones.contains(tzid)) continue;
                targetTZSet.add(tzid);
                GenerateG2xG2.addPriority(priority, tzid);
            }
        }
        PrintWriter pw = BagFormatter.openUTF8Writer((String)"c:/", (String)"G2xG2.txt");
        UTF16.StringComparator comp = new UTF16.StringComparator();
        TreeSet<String[]> priority_set = new TreeSet<String[]>((Comparator<String[]>)new ArrayComparator(new Comparator[]{comp, comp, comp}));
        Iterator it4 = priorityMap.keySet().iterator();
        while (it4.hasNext()) {
            String code = (String)it4.next();
            String priority = (String)priorityMap.get(code);
            if (priority == null) continue;
            int type = GenerateG2xG2.getType(code);
            priority_set.add(new String[]{priority, type + "", code});
        }
        String lastPriority = "";
        String lastType = "";
        Iterator it5 = priority_set.iterator();
        while (it5.hasNext()) {
            String[] items = (String[])it5.next();
            if (!lastPriority.equals(items[0])) {
                lastPriority = items[0];
                pw.println();
            }
            String typeName = GenerateG2xG2.getTypeName(items[2]);
            pw.println(lastPriority + "\t" + typeName + "\t" + items[2] + "\t(" + GenerateG2xG2.getItemName(english, items[2]) + ")");
        }
        pw.flush();
        it5 = sourceSet.iterator();
        while (it5.hasNext()) {
            String sourceLocale = (String)it5.next();
            System.out.print(sourceLocale + ", ");
            CLDRFile sourceData = cldrFactory.make(sourceLocale, true);
            pw.println();
            String title = sourceLocale;
            GenerateG2xG2.checkItems(pw, title, sourceData, 0, targetLanguageSet);
            GenerateG2xG2.checkItems(pw, title, sourceData, 1, targetScriptSet);
            GenerateG2xG2.checkItems(pw, title, sourceData, 2, targetRegionSet);
            GenerateG2xG2.checkItems(pw, title, sourceData, 4, targetCurrencySet);
            String v = sourceData.getStringValue("//ldml/characters/exemplarCharacters");
            UnicodeSet exemplars = new UnicodeSet(v);
            if (exemplars.contains(97, 122)) continue;
            GenerateG2xG2.checkItems(pw, title, sourceData, 6, targetTZSet);
        }
        pw.println();
        pw.println("Sizes - incremental");
        pw.println();
        int runningTotalCount = 0;
        int runningMissingCount = 0;
        NumberFormat percent = NumberFormat.getPercentInstance();
        percent.setMinimumFractionDigits(1);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        nf.setMinimumFractionDigits(0);
        Iterator it6 = totalMap.keySet().iterator();
        while (it6.hasNext()) {
            String key = (String)it6.next();
            Totals t = (Totals)totalMap.get(key);
            runningTotalCount = t.totalCount;
            runningMissingCount = t.missingCount;
            pw.println(key.substring(0, 2) + "\t" + key.substring(2) + "\t" + runningMissingCount + "\t" + runningTotalCount + "\t" + percent.format((double)runningMissingCount / (0.0 + (double)runningTotalCount)));
        }
        pw.close();
        System.out.println();
        System.out.println("Done");
    }

    private static boolean showLocales(int choice) throws Exception {
        ULocale desiredDisplayLocale = ULocale.ENGLISH;
        TreeSet testSet = new TreeSet();
        StandardCodes sc = StandardCodes.make();
        Set countries = sc.getGoodAvailableCodes("territory");
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        english = cldrFactory.make("en", true);
        Iterator it = countries.iterator();
        while (it.hasNext()) {
            String territory = (String)it.next();
            if (territory.charAt(0) < 'A') continue;
            String locale = "haw-" + territory;
            System.out.print(locale + ": " + english.getName(locale, false) + ", ");
        }
        return true;
    }

    private static void showCollator() throws Exception {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance((ULocale)new ULocale("zh"));
        GenerateG2xG2.showExample(col);
        String rules = col.getRules(false);
        rules = rules + "& \u93ca < A <<< a & \u7c3f < B <<< b";
        RuleBasedCollator col2 = new RuleBasedCollator(rules);
        GenerateG2xG2.showExample(col2);
    }

    private static void showExample(RuleBasedCollator col) {
        String samples = "a A b B \u5416 \u93ca \u516b \u7c3f";
        TreeSet<String> s = new TreeSet<String>((Comparator<String>)col);
        s.addAll(Arrays.asList(samples.split(" ")));
        System.out.println(Utility.escape((String)((Object)s).toString()));
    }

    static void addPriority(String priority, String code) {
        if (code.length() == 0) {
            return;
        }
        String oldPriority = (String)priorityMap.get(code);
        if (oldPriority == null || priority.compareTo(oldPriority) < 0) {
            priorityMap.put(code, priority);
        }
        System.out.println(code + ": " + priority);
    }

    static void checkItems(PrintWriter pw, String sourceLocale, CLDRFile sourceData, int type, Set targetItemSet) {
        Iterator it2 = targetItemSet.iterator();
        while (it2.hasNext()) {
            String item = (String)it2.next();
            if (item.length() == 0) continue;
            String key = priorityMap.get(sourceLocale) + "" + priorityMap.get(item);
            Totals t = (Totals)totalMap.get(key);
            if (t == null) {
                t = new Totals();
                totalMap.put(key, t);
            }
            ++t.totalCount;
            String translation = GenerateG2xG2.getItemName(sourceData, type, item);
            String rootName = GenerateG2xG2.getItemName(root, type, item);
            if (!rootName.equals(translation)) continue;
            ++t.missingCount;
            pw.println(priorityMap.get(sourceLocale) + "\t" + sourceLocale + "\t(" + english.getName(sourceLocale, false) + ": " + sourceData.getName(sourceLocale, false) + ")" + "\t" + priorityMap.get(item) + "\t" + item + "\t(" + GenerateG2xG2.getItemName(english, type, item) + ")");
        }
    }

    private static String getItemName(CLDRFile data, String item) {
        return GenerateG2xG2.getItemName(data, GenerateG2xG2.getType(item), item);
    }

    private static int getType(String item) {
        int type = 0;
        if (item.indexOf(47) >= 0) {
            type = 6;
        } else if (item.length() == 4) {
            type = 1;
        } else if (item.charAt(0) <= '9') {
            type = 2;
        } else if (item.charAt(0) < 'a') {
            type = item.length() == 3 ? 4 : 2;
        }
        return type;
    }

    private static String getTypeName(String item) {
        switch (GenerateG2xG2.getType(item)) {
            case 0: {
                return "Lang";
            }
            case 6: {
                return "Zone";
            }
            case 1: {
                return "Script";
            }
            case 2: {
                return "Region";
            }
            case 4: {
                return "Curr.";
            }
        }
        return "?";
    }

    private static String getItemName(CLDRFile data, int type, String item) {
        String result;
        if (type == 0) {
            result = data.getName(item, false);
        } else if (type != 6) {
            result = data.getName(type, item, false);
        } else {
            String prefix = "//ldml/dates/timeZoneNames/zone[@type=\"" + item + "\"]/exemplarCity";
            result = data.getStringValue(prefix);
        }
        return result == null ? item : result;
    }

    private static Collection getCurrency(String territory) {
        if (territory_currency == null) {
            territory_currency = new TreeMap();
            CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
            CLDRFile supp = cldrFactory.make("supplementalData", false);
            XPathParts parts = new XPathParts((Comparator)new UTF16.StringComparator(), null);
            Iterator it = supp.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path.indexOf("/currencyData") < 0 || path.indexOf("/region") < 0) continue;
                parts.set(supp.getFullXPath(path));
                Map attributes = parts.getAttributes(parts.size() - 2);
                String iso3166 = (String)attributes.get("iso3166");
                attributes = parts.getAttributes(parts.size() - 1);
                String iso4217 = (String)attributes.get("iso4217");
                String to = (String)attributes.get("to");
                if (to != null) continue;
                ArrayList<String> info = (ArrayList<String>)territory_currency.get(iso3166);
                if (info == null) {
                    info = new ArrayList<String>();
                    territory_currency.put(iso3166, info);
                }
                info.add(iso4217);
            }
        }
        return (Collection)territory_currency.get(territory);
    }

    static {
        priorityMap = new TreeMap();
        totalMap = new TreeMap();
        territory_currency = null;
    }

    static class Totals {
        int totalCount;
        int missingCount;

        Totals() {
        }
    }
}

