/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.SortedBag;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.icu.SimpleConverter;

public class GeneratePOSIX {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int UNICODESET = 5;
    private static final int CHARSET = 6;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/"), UOption.DESTDIR().setDefault("../../dropbox/gen/"), UOption.create((String)"match", (char)'m', (int)1).setDefault("hu"), UOption.create((String)"unicodeset", (char)'u', (int)1).setDefault("[\\u0000-\\U0010FFFF]"), UOption.create((String)"charset", (char)'c', (int)1).setDefault("iso8859-2")};
    SortedBag allItems;
    SortedBag contractions;
    RuleBasedCollator col;
    UnicodeSet chars;
    Charset cs;
    IntList needToWritePrimary = new IntList();
    Set nonUniqueWeights = new HashSet();
    Set allWeights = new HashSet();
    Map stringToWeights = new HashMap();
    UnicodeSet uca_contractions = new UnicodeSet("[{\u0406\u0308}{\u0410\u0306}{\u0410\u0308}{\u0413\u0301}{\u0413\u0341}{\u0415\u0306}{\u0416\u0308}{\u0417\u0308}{\u0418\u0306}{\u0418\u0308}{\u041a\u0301}{\u041a\u0341}{\u041e\u0308}{\u0423\u0306}{\u0423\u0308}{\u0423\u030b}{\u0427\u0308}{\u042b\u0308}{\u042d\u0308}{\u0430\u0306}{\u0430\u0308}{\u0433\u0301}{\u0433\u0341}{\u0435\u0306}{\u0436\u0308}{\u0437\u0308}{\u0438\u0306}{\u0438\u0308}{\u043a\u0301}{\u043a\u0341}{\u043e\u0308}{\u0443\u0306}{\u0443\u0308}{\u0443\u030b}{\u0447\u0308}{\u044b\u0308}{\u044d\u0308}{\u0456\u0308}{\u0474\u030f}{\u0475\u030f}{\u04d8\u0308}{\u04d9\u0308}{\u04e8\u0308}{\u04e9\u0308}{\u0627\u0653}{\u0627\u0654}{\u0627\u0655}{\u0648\u0654}{\u064a\u0654}{\u09c7\u09be}{\u09c7\u09d7}{\u0b47\u0b3e}{\u0b47\u0b56}{\u0b47\u0b57}{\u0b92\u0bd7}{\u0bc6\u0bbe}{\u0bc6\u0bd7}{\u0bc7\u0bbe}{\u0c46\u0c56}{\u0cbf\u0cd5}{\u0cc6\u0cc2}{\u0cc6\u0cc2\u0cd5}{\u0cc6\u0cd5}{\u0cc6\u0cd6}{\u0cca\u0cd5}{\u0d46\u0d3e}{\u0d46\u0d57}{\u0d47\u0d3e}{\u0dd9\u0dca}{\u0dd9\u0dcf}{\u0dd9\u0dcf\u0dca}{\u0dd9\u0ddf}{\u0ddc\u0dca}{\u0e4d\u0e32}{\u0ecd\u0eb2}{\u0f71\u0f72}{\u0f71\u0f74}{\u0f71\u0f80}{\u0fb2\u0f71}{\u0fb2\u0f71\u0f80}{\u0fb2\u0f80}{\u0fb2\u0f81}{\u0fb3\u0f71}{\u0fb3\u0f71\u0f80}{\u0fb3\u0f80}{\u0fb3\u0f81}{\u1025\u102e}]");

    public static void main(String[] args) throws IOException {
        UOption.parseArgs((String[])args, (UOption[])options);
        String locale = GeneratePOSIX.options[4].value;
        GeneratePOSIX gp = new GeneratePOSIX(new ULocale(locale), new UnicodeSet(GeneratePOSIX.options[5].value), Charset.forName(GeneratePOSIX.options[6].value));
        PrintWriter out = BagFormatter.openUTF8Writer((String)GeneratePOSIX.options[3].value, (String)(locale + "_posix.txt"));
        gp.write(out);
        out.close();
    }

    private static void testSortedBag() {
        SortedBag foo = new SortedBag((Comparator)Collator.getInstance());
        foo.add((Object)"\u0001");
        foo.add((Object)"\u0002");
        Iterator it = foo.iterator();
        while (it.hasNext()) {
            System.out.println(Utility.hex((int)((String)it.next()).charAt(0), (int)4));
        }
    }

    public GeneratePOSIX(ULocale locale, UnicodeSet chars, Charset cs) {
        this.cs = cs;
        if (cs != null) {
            UnicodeSet csset = new SimpleConverter(cs).getCharset();
            chars = new UnicodeSet(chars).retainAll(csset);
        }
        this.chars = chars;
        System.out.println("Generating: " + locale.getDisplayName());
        this.col = (RuleBasedCollator)RuleBasedCollator.getInstance((ULocale)locale);
        this.allItems = new SortedBag((Comparator)this.col);
        this.contractions = new SortedBag((Comparator)this.col);
        UnicodeSetIterator it = new UnicodeSetIterator(chars);
        while (it.next()) {
            this.allItems.add((Object)it.getString());
        }
        UnicodeSet tailored = this.col.getTailoredSet();
        this.getFilteredSet(chars, tailored);
        this.getFilteredSet(this.uca_contractions, tailored);
    }

    private void getFilteredSet(UnicodeSet chars, UnicodeSet tailored) {
        UnicodeSetIterator it = new UnicodeSetIterator(tailored);
        while (it.next()) {
            if (it.codepoint != UnicodeSetIterator.IS_STRING) continue;
            String s = it.getString();
            if (!UTF16.hasMoreCodePointsThan((String)(s = Normalizer.compose((String)s, (boolean)false)), (int)1) || !chars.containsAll(s)) continue;
            System.out.println("Contractions: " + it.getString());
            this.contractions.add((Object)s);
            this.allItems.add((Object)s);
        }
    }

    public void write(PrintWriter out) {
        out.println("######################");
        out.println("# POSIX locale");
        out.println("# Generated automatically from the Unicode Character Database and Common Locale Data Repository");
        out.println("# see http://www.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap07.html");
        out.println("# charset:\t" + this.cs);
        out.println("# characters:\t" + this.chars.toPattern(true));
        out.println("######################");
        out.println();
        this.doCtype(out);
        out.println("######################");
        out.println();
        this.doCollate(out);
        out.println("######################");
    }

    private void doCollate(PrintWriter out) {
        out.println("LC_COLLATE");
        out.println();
        this.writeDefinitions(out);
        out.println();
        out.println("order_start forward;" + (this.col.isFrenchCollation() ? "backward" : "forward") + ";forward");
        out.println();
        out.println("# weights used, in order");
        out.println();
        this.writeList(out);
        out.println();
        out.println("# assignment of characters to weights");
        out.println();
        Iterator it = this.allItems.iterator();
        while (it.hasNext()) {
            out.println(this.showLine(this.col, (String)it.next()));
        }
        out.println("UNDEFINED \t...;" + GeneratePOSIX.getID('X', 5) + ";" + GeneratePOSIX.getID('X', 5));
        out.println();
        out.println("order_end");
        out.println("END LC_COLLATE");
    }

    private void doCtype(PrintWriter out) {
        int last;
        int item;
        out.println("LC_CTYPE");
        String[][] types = new String[][]{{"alpha", "[:Alphabetic:]"}, {"upper", "[:Uppercase:]"}, {"lower", "[:Lowercase:]"}, {"space", "[:Whitespace:]"}, {"cntrl", "[:Control:]"}, {"graph", "[^[:Whitespace:][:Control:][:Format:][:Surrogate:][:Unassigned:]]"}, {"print", "[[:Whitespace:]-[[:Control:][:Format:][:Surrogate:][:Unassigned:]]]"}, {"punct", "[:Punctuation:]"}, {"digit", "[:Decimal_Number:]"}, {"xdigit", "[[:Decimal_Number:]a-f, A-F, \uff21-\uff26, \uff41-\uff46]"}, {"blank", "[[:Whitespace:]-[\\u000A-\\u000D \\u0085 [:Line_Separator:][:Paragraph_Separator:]]]"}};
        for (int i = 0; i < types.length; ++i) {
            UnicodeSet us = new UnicodeSet(types[i][1]).retainAll(this.chars);
            item = 0;
            last = us.size() - 1;
            UnicodeSetIterator it = new UnicodeSetIterator(us);
            while (it.next()) {
                if (item == 0) {
                    out.print(types[i][0]);
                }
                out.print("\t" + GeneratePOSIX.getID('U', it.codepoint));
                if (item != last) {
                    out.print(";\\");
                }
                out.println(" \t# " + this.getName(it.getString()));
                ++item;
            }
            out.println();
        }
        UnicodeSet us = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(this.chars);
        while (it.next()) {
            int low = UCharacter.toUpperCase((int)it.codepoint);
            if (low == it.codepoint) continue;
            us.add(it.codepoint);
        }
        item = 0;
        last = this.chars.size() - 1;
        it = new UnicodeSetIterator(us);
        while (it.next()) {
            if (item == 0) {
                out.print("toupper");
            }
            out.print("\t(<" + GeneratePOSIX.getID('U', it.codepoint) + ">,<" + GeneratePOSIX.getID('U', UCharacter.toUpperCase((int)it.codepoint)) + ">)");
            if (item != last) {
                out.print(";\\");
            }
            out.println(" \t# " + this.getName(it.getString()));
            ++item;
        }
        out.println();
    }

    private void writeDefinitions(PrintWriter out) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.contractions.iterator();
        while (it.hasNext()) {
            buffer.setLength(0);
            String s = (String)it.next();
            buffer.append("collating-element ").append(this.getID(s, true)).append(" from ").append(this.getID(s, false));
            out.println(buffer.toString());
        }
    }

    private void writeList(PrintWriter out) {
        BitSet alreadySeen = new BitSet();
        BitSet needToWrite = new BitSet();
        needToWrite.set(1);
        boolean maxSeen = false;
        Iterator it1 = this.allItems.iterator();
        while (it1.hasNext()) {
            String string = (String)it1.next();
            Weights w = new Weights(this.col.getCollationElementIterator(string));
            w.primaries.setBits(needToWrite);
            w.secondaries.setBits(needToWrite);
            w.tertiaries.setBits(needToWrite);
            if (this.allWeights.contains(w)) {
                this.nonUniqueWeights.add(w);
            }
            this.allWeights.add(w);
            this.stringToWeights.put(string, w);
        }
        for (int i = 0; i < needToWrite.size(); ++i) {
            if (!needToWrite.get(i)) continue;
            out.println(GeneratePOSIX.getID('X', i));
        }
    }

    private String showLine(RuleBasedCollator col, String string) {
        String prefix = "";
        StringBuffer result = new StringBuffer();
        result.append(this.getID(string, true));
        result.append(" \t");
        Weights w = (Weights)this.stringToWeights.get(string);
        result.append(w.primaries).append(";").append(w.secondaries).append(";").append(w.tertiaries).append(";").append(this.nonUniqueWeights.contains(w) ? this.getID(Normalizer.decompose((String)string, (boolean)false), false) : GeneratePOSIX.getID('X', 1)).append(" \t# ").append(this.getName(string));
        if (prefix.length() != 0) {
            result.insert(0, prefix);
        }
        return result.toString();
    }

    private Object getName(String s) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (i != 0) {
                result.append(", ");
            }
            String n = UCharacter.getExtendedName((int)cp);
            result.append(n);
        }
        return result.toString();
    }

    private static String getID(char leadChar, int i) {
        return "<" + leadChar + Utility.hex((int)i, (int)4) + ">";
    }

    private String getID(String s, boolean isSingleID) {
        StringBuffer result = new StringBuffer();
        if (!UTF16.hasMoreCodePointsThan((String)s, (int)1)) {
            this.appendID(UTF16.charAt((String)s, (int)0), result, false);
        } else if (isSingleID) {
            int cp;
            result.append('<');
            for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
                cp = UTF16.charAt((String)s, (int)i);
                if (i != 0) {
                    result.append('-');
                }
                this.appendID(cp, result, true);
            }
            result.append('>');
        } else {
            int cp;
            result.append('\"');
            for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
                cp = UTF16.charAt((String)s, (int)i);
                this.appendID(cp, result, false);
            }
            result.append('\"');
        }
        return result.toString();
    }

    private StringBuffer appendID(int cp, StringBuffer result, boolean nakedID) {
        if (!nakedID) {
            result.append('<');
        }
        result.append('U').append(Utility.hex((int)cp, (int)4));
        if (!nakedID) {
            result.append('>');
        }
        return result;
    }

    private class WeightList {
        char[] weights = new char[5];
        int count = 0;

        private WeightList() {
        }

        public void append(int i) {
            for (int j = 16; j >= 0; j -= 16) {
                char b = (char)(i >>> j);
                if (b == '\u0000') continue;
                this.weights[this.count++] = b;
            }
        }

        public void setBits(BitSet s) {
            for (int j = 0; j < this.count; ++j) {
                s.set(this.weights[j]);
            }
        }

        public String toString() {
            if (this.count == 0) {
                return "IGNORE";
            }
            if (this.count == 1) {
                return GeneratePOSIX.getID('X', this.weights[0]);
            }
            String result = "\"";
            for (int i = 0; i < this.count; ++i) {
                result = result + GeneratePOSIX.getID('X', this.weights[i]);
            }
            return result + "\"";
        }

        public boolean equals(Object other) {
            WeightList that = (WeightList)other;
            for (int j = 0; j < this.count; ++j) {
                if (this.weights[j] == that.weights[j]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.count;
            for (int j = 0; j < this.count; ++j) {
                result = result * 37 + this.weights[j];
            }
            return result;
        }
    }

    private class Weights {
        WeightList primaries;
        WeightList secondaries;
        WeightList tertiaries;

        public Weights(CollationElementIterator it) {
            this.primaries = new WeightList();
            this.secondaries = new WeightList();
            this.tertiaries = new WeightList();
            while (true) {
                int ce = it.next();
                if (ce == -1) break;
                int p = CollationElementIterator.primaryOrder((int)ce);
                this.primaries.append(p);
                this.secondaries.append(CollationElementIterator.secondaryOrder((int)ce));
                this.tertiaries.append(CollationElementIterator.tertiaryOrder((int)ce));
            }
        }

        public boolean equals(Object other) {
            Weights that = (Weights)other;
            return this.primaries.equals(that.primaries) && this.secondaries.equals(that.secondaries) && this.tertiaries.equals(that.tertiaries);
        }

        public int hashCode() {
            return (this.primaries.hashCode() * 37 + this.secondaries.hashCode()) * 37 + this.tertiaries.hashCode();
        }
    }

    private class IntList {
        private BitSet stuff = new BitSet();
        private int leastItem = Integer.MAX_VALUE;

        private IntList() {
        }

        void add(int item) {
            this.stuff.set(item);
            if (item < this.leastItem) {
                this.leastItem = item;
            }
        }

        void remove(int item) {
            this.stuff.clear(item);
            if (item == this.leastItem) {
                for (int i = item + 1; i < this.stuff.size(); ++i) {
                    if (!this.stuff.get(i)) continue;
                    this.leastItem = i;
                    return;
                }
                this.leastItem = Integer.MAX_VALUE;
            }
        }

        int getLeast() {
            return this.leastItem;
        }
    }
}

