/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.impl.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class GenerateTempDateData {
    public static void main(String[] args) throws IOException {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        Set x = cldrFactory.getAvailable();
        XPathParts parts = new XPathParts();
        PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/datedata/", (String)"DateData.java");
        pw.println("package com.ibm.icu.impl.data;");
        pw.println("import java.util.ListResourceBundle;");
        pw.println("class DateData { // extracted from CLDR 1.4");
        Iterator it = x.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            CLDRFile file = cldrFactory.make(locale, false);
            if (file.isNonInheriting()) continue;
            System.out.println(locale);
            boolean gotOne = false;
            Iterator it2 = file.iterator("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/");
            while (it2.hasNext()) {
                String pattern;
                String path = (String)it2.next();
                if (path.indexOf("dateTimeFormats/availableFormats/dateFormatItem") >= 0) {
                    gotOne = GenerateTempDateData.doHeader(pw, locale, gotOne);
                    String id = parts.set(path).getAttributeValue(-1, "id");
                    pattern = file.getStringValue(path);
                    pw.println("     {\"pattern/" + id + "\",\"" + Utility.escape((String)pattern) + "\"},");
                    continue;
                }
                if (path.indexOf("dateTimeFormats/appendItems") >= 0) {
                    gotOne = GenerateTempDateData.doHeader(pw, locale, gotOne);
                    String request = parts.set(path).getAttributeValue(-1, "request");
                    pattern = file.getStringValue(path);
                    pw.println("     {\"append/" + request + "\",\"" + Utility.escape((String)pattern) + "\"},");
                    continue;
                }
                if (path.indexOf("fields/field") < 0) continue;
                gotOne = GenerateTempDateData.doHeader(pw, locale, gotOne);
                String type = parts.set(path).getAttributeValue(-2, "type");
                pattern = file.getStringValue(path);
                pw.println("     {\"field/" + type + "\",\"" + Utility.escape((String)pattern) + "\"},");
            }
            if (!gotOne) continue;
            pw.println(" };}}");
        }
        pw.println("}");
        pw.close();
    }

    private static boolean doHeader(PrintWriter pw, String locale, boolean gotOne) {
        if (!gotOne) {
            gotOne = true;
            String suffix = locale.equals("root") ? "" : "_" + locale;
            pw.println(" public static class MyDateResources" + suffix + " extends ListResourceBundle {");
            pw.println("  protected Object[][] getContents() {");
            pw.println("   return new Object[][] {");
        }
        return gotOne;
    }

    static class RBundle
    extends ListResourceBundle {
        RBundle() {
        }

        protected Object[][] getContents() {
            return null;
        }
    }
}

