/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.ArrayComparator;
import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.XPathParts;

public class VettingAdder {
    private Map locale_files = new TreeMap();
    private Comparator scomp = new UTF16.StringComparator();
    private Set conflictSet = new TreeSet(new ArrayComparator(new Comparator[]{this.scomp, this.scomp, this.scomp}));
    static Comparator PathAndValueComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((VettingInfo)o1).compareByPathAndValue((VettingInfo)o2);
        }
    };
    CLDRFile english;
    XPathParts tempParts = new XPathParts(null, null);

    public VettingAdder(String sourceDirectory) throws IOException {
        this.addFiles(sourceDirectory);
    }

    private void addFiles(String sourceDirectory) throws IOException {
        File f = new File(sourceDirectory);
        String canonicalName = f.getCanonicalPath();
        if (!f.isDirectory()) {
            String name = f.getName();
            if (name.startsWith("fixed-")) {
                return;
            }
            if (name.equals(".htaccess")) {
                return;
            }
            if (!name.endsWith(".xml")) {
                Log.logln("Wrong filename format: " + f.getCanonicalPath());
                return;
            }
            String localeName = name.substring(0, name.length() - 4);
            TreeSet<String> s = (TreeSet<String>)this.locale_files.get(localeName);
            if (s == null) {
                s = new TreeSet<String>();
                this.locale_files.put(localeName, s);
            }
            s.add(f.getParent());
        } else {
            String[] subnames = f.list();
            for (int i = 0; i < subnames.length; ++i) {
                this.addFiles(canonicalName + File.separatorChar + subnames[i]);
            }
        }
    }

    public Set keySet() {
        return this.locale_files.keySet();
    }

    public void incorporateVetting(String locale, String targetDir) throws IOException {
        Set s = (Set)this.locale_files.get(locale);
        Log.logln("Vetting Data for: " + locale);
        VettingInfoSet accum = new VettingInfoSet();
        Iterator it2 = s.iterator();
        while (it2.hasNext()) {
            String dir = (String)it2.next() + File.separator;
            String fixedLocale = "fixed-" + locale + ".xml";
            this.fixXML(dir, locale + ".xml", dir, fixedLocale);
            CLDRFile cldr = CLDRFile.makeFromFile(dir + fixedLocale, locale, true);
            Iterator it3 = cldr.iterator();
            while (it3.hasNext()) {
                String path = (String)it3.next();
                String value = cldr.getStringValue(path);
                String fullPath = cldr.getFullXPath(path);
                if (value.startsWith("//ldml") || value.length() == 0) {
                    Log.logln("Skipping: [" + value + "] for " + fullPath);
                    continue;
                }
                accum.add(this.stripAlt(path), dir, this.stripAlt(fullPath), value);
            }
        }
        TreeSet uniquePathAndValue = new TreeSet(PathAndValueComparator);
        CLDRFile cldrDelta = CLDRFile.make(locale);
        boolean gotOne = false;
        Iterator it22 = accum.iterator();
        while (it22.hasNext()) {
            String path = (String)it22.next();
            Collection c = accum.get(path);
            uniquePathAndValue.clear();
            uniquePathAndValue.addAll(c);
            if (uniquePathAndValue.size() == 1) {
                VettingInfo vi = (VettingInfo)uniquePathAndValue.iterator().next();
                cldrDelta.add(vi.fullPath, vi.value);
                gotOne = true;
                continue;
            }
            this.conflictSet.add(new Object[]{locale, path, c});
        }
        if (gotOne) {
            Log.logln("Writing: " + targetDir + locale + ".xml");
            PrintWriter pw = BagFormatter.openUTF8Writer((String)targetDir, (String)(locale + ".xml"));
            cldrDelta.write(pw);
            pw.close();
        } else {
            Log.logln("No data left in: " + targetDir + locale + ".xml");
        }
    }

    public void showSources() {
        Iterator it = this.locale_files.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Set s = (Set)this.locale_files.get(key);
            Iterator it2 = s.iterator();
            while (it2.hasNext()) {
                Log.logln(key + " \t" + it2.next());
                key = "";
            }
        }
    }

    public void fixXML(String inputDir, String inputFile, String outputDir, String outputFile) throws IOException {
        String line;
        BufferedReader in = BagFormatter.openUTF8Reader((String)inputDir, (String)inputFile);
        PrintWriter out = BagFormatter.openUTF8Writer((String)outputDir, (String)outputFile);
        int haveLanguages = 0;
        int haveScripts = 0;
        int haveTerritories = 0;
        int haveVariants = 0;
        int haveKeys = 0;
        int haveTypes = 0;
        int inLocaleDisplayNames = 0;
        while ((line = in.readLine()) != null) {
            String trimmed = line.trim();
            if (inLocaleDisplayNames == 1) {
                haveLanguages = this.fixItem(out, haveLanguages, trimmed, "<language ", "languages");
                haveScripts = this.fixItem(out, haveScripts, trimmed, "<script ", "scripts");
                haveTerritories = this.fixItem(out, haveTerritories, trimmed, "<territory ", "territories");
                haveVariants = this.fixItem(out, haveVariants, trimmed, "<variant ", "variants");
                haveKeys = this.fixItem(out, haveKeys, trimmed, "<key ", "keys");
                haveTypes = this.fixItem(out, haveTypes, trimmed, "<type ", "types");
            }
            if (trimmed.startsWith("<localeDisplayNames")) {
                inLocaleDisplayNames = 1;
            } else if (trimmed.startsWith("</localeDisplayNames")) {
                inLocaleDisplayNames = 2;
            }
            out.println(line);
        }
        in.close();
        out.close();
    }

    private int fixItem(PrintWriter out, int haveLanguages, String trimmed, String item, String fix) {
        if (trimmed.startsWith(item)) {
            if (haveLanguages == 0) {
                out.println("<" + fix + ">");
                haveLanguages = 1;
            }
            return haveLanguages;
        }
        if (haveLanguages == 1) {
            out.println("</" + fix + ">");
            haveLanguages = 2;
        }
        return haveLanguages;
    }

    public Set getConflictSet() {
        return this.conflictSet;
    }

    public void showFiles(CLDRFile.Factory cldrFactory, String targetDir) throws IOException {
        this.english = cldrFactory.make("en", true);
        Log.logln("");
        Log.logln("A. Sources");
        Log.logln("");
        this.showSources();
        Log.logln("");
        Log.logln("B. Intermediate Results");
        Log.logln("");
        Set vettedLocales = this.keySet();
        Iterator it = vettedLocales.iterator();
        while (it.hasNext()) {
            this.incorporateVetting((String)it.next(), targetDir);
        }
        Log.logln("");
        Log.logln("C. Conflicts");
        Log.logln("");
        this.showConflicts(cldrFactory);
        Log.logln("");
        Log.logln("D. Missing Vetting");
        Log.logln("");
        TreeSet availableLocales = new TreeSet(cldrFactory.getAvailable());
        availableLocales.removeAll(vettedLocales);
        Iterator it2 = availableLocales.iterator();
        block1: while (it2.hasNext()) {
            String locale = (String)it2.next();
            CLDRFile cldr = cldrFactory.make(locale, false);
            Iterator it22 = cldr.iterator();
            while (it22.hasNext()) {
                String path = (String)it22.next();
                String fullPath = cldr.getFullXPath(path);
                if (fullPath.indexOf("[@draft=") < 0) continue;
                Log.logln(locale + " \t" + this.english.getName(locale, false) + "\texample: " + fullPath);
                continue block1;
            }
        }
    }

    private void showConflicts(CLDRFile.Factory cldrFactory) {
        Set s = this.getConflictSet();
        String lastLocale = "";
        CLDRFile cldr = null;
        Transliterator any_latin = Transliterator.getInstance((String)"any-latin");
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        String[] pieces = new String[5];
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Object[] items = (Object[])it.next();
            String entry = "";
            if (!lastLocale.equals(items[0])) {
                this.showSet(emails);
                lastLocale = (String)items[0];
                cldr = cldrFactory.make(lastLocale, false);
                entry = "==========\r\n" + lastLocale + "\r\n";
            }
            String path = CLDRFile.getDistinguishingXPath((String)items[1], null, false);
            String current = cldr.getStringValue(path);
            entry = entry + "\tpath:\t" + path + "\r\n\tcurrent value:\t" + this.getValue(any_latin, current) + "\r\n";
            entry = entry + "\tEnglish value:\t" + this.getValue(any_latin, this.english.getStringValue(path)) + "\r\n";
            Collection c = (Collection)items[2];
            Iterator it2 = c.iterator();
            while (it2.hasNext()) {
                VettingInfo vi = (VettingInfo)it2.next();
                entry = entry + "\t\tvalue:\t" + this.getValue(any_latin, vi.value) + "\t source: " + vi.dir + "\r\n";
                Utility.split((String)vi.dir, (char)'\\', (String[])pieces);
                emails.add(pieces[2]);
            }
            Log.logln(entry);
        }
        this.showSet(emails);
    }

    private void showSet(Set emails) {
        if (emails.size() == 0) {
            return;
        }
        String result = "Emails:\t";
        Iterator it = emails.iterator();
        while (it.hasNext()) {
            result = result + it.next() + ", ";
        }
        result = result + "cldr@unicode.org";
        emails.clear();
        Log.logln(result);
    }

    private String getValue(Transliterator some, String current) {
        if (current == null) {
            current = "NULL";
        }
        String other = some.transliterate(current);
        return "<" + current + ">" + (other.equals(current) ? "" : "\t[" + other + "]");
    }

    private String stripAlt(String path) {
        this.tempParts.set(path);
        Map x = this.tempParts.getAttributes(this.tempParts.size() - 1);
        String value = (String)x.get("alt");
        if (value != null && value.startsWith("proposed")) {
            x.remove("alt");
            return this.tempParts.toString();
        }
        return path;
    }

    static class VettingInfoSet {
        private Map path_vettingInfoList = new TreeMap();

        VettingInfoSet() {
        }

        public void add(String path, String dir, String fullPath, String value) {
            VettingInfo vi = new VettingInfo(dir, fullPath, value);
            ArrayList<VettingInfo> s = (ArrayList<VettingInfo>)this.path_vettingInfoList.get(path);
            if (s == null) {
                s = new ArrayList<VettingInfo>(1);
                this.path_vettingInfoList.put(path, s);
            }
            s.add(vi);
        }

        public Iterator iterator() {
            return this.path_vettingInfoList.keySet().iterator();
        }

        public Collection get(String path) {
            return (Collection)this.path_vettingInfoList.get(path);
        }
    }

    static class VettingInfo {
        private String value;
        private String fullPath;
        private String dir;

        public VettingInfo(String dir, String fullPath, String value) {
            this.value = value;
            this.fullPath = fullPath;
            this.dir = dir;
        }

        public String toString() {
            return "source: " + this.dir + ";\t value: <" + this.value + ">";
        }

        public int compareByPathAndValue(VettingInfo other) {
            int result = this.fullPath.compareTo(other.fullPath);
            if (0 != result) {
                return result;
            }
            result = this.value.compareTo(other.value);
            if (0 != result) {
                return result;
            }
            return 0;
        }
    }
}

