/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CachingEntityResolver
implements EntityResolver {
    static final String CLDR_DTD_CACHE = "CLDR_DTD_CACHE";
    private static String gCacheDir = null;
    private static boolean gCheckedEnv = false;

    public static void createAndEmptyCacheDir() {
        if (CachingEntityResolver.getCacheDir() == null) {
            return;
        }
        File cacheDir = new File(CachingEntityResolver.getCacheDir());
        cacheDir.mkdir();
        File[] cachedFiles = cacheDir.listFiles();
        if (cachedFiles != null) {
            for (int i = 0; i < cachedFiles.length; ++i) {
                if (!cachedFiles[i].isFile()) continue;
                cachedFiles[i].delete();
            }
        }
    }

    public static void setCacheDir(String s) {
        gCacheDir = s;
        if (gCacheDir == null || gCacheDir.length() <= 0) {
            gCacheDir = null;
        }
    }

    public static String getCacheDir() {
        if (gCacheDir == null && !gCheckedEnv) {
            gCacheDir = System.getProperty(CLDR_DTD_CACHE);
            if (gCacheDir == null || gCacheDir.length() <= 0) {
                gCacheDir = null;
            }
            gCheckedEnv = true;
        }
        return gCacheDir;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        boolean aDebug = false;
        if (System.getProperty("CLDR_DTD_CACHE_DEBUG") != null || "y".equals(System.getProperty("CLDR_DTD_CACHE_ADEBUG"))) {
            aDebug = true;
        }
        String theCache = CachingEntityResolver.getCacheDir();
        if (aDebug) {
            System.out.println("CRE:  " + publicId + " | " + systemId + ", cache=" + theCache);
        }
        if (theCache != null) {
            File aDir;
            StringBuffer systemNew = new StringBuffer(systemId);
            if (systemId.startsWith("file:")) {
                return null;
            }
            for (int i = 0; i < systemNew.length(); ++i) {
                char c = systemNew.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.') continue;
                systemNew.setCharAt(i, '_');
            }
            if (aDebug) {
                System.out.println(systemNew.toString());
            }
            if (!(aDir = new File(theCache)).exists() || !aDir.isDirectory()) {
                System.err.println("CachingEntityResolver: Warning:  Cache not used, Directory doesn't exist, Check the value of  property CLDR_DTD_CACHE :  " + theCache);
                return null;
            }
            String newName = new String(systemNew);
            File t = new File(theCache, newName);
            if (t.exists()) {
                if (aDebug) {
                    System.out.println("Using existing: " + t.getPath());
                }
            } else {
                if (aDebug) {
                    System.out.println(t.getPath() + " doesn't exist. fetching.");
                }
                try {
                    String s;
                    BufferedReader r = new BufferedReader(new InputStreamReader(new URL(systemId).openStream()));
                    BufferedWriter w = new BufferedWriter(new FileWriter(t.getPath()));
                    while ((s = r.readLine()) != null) {
                        w.write(s);
                        w.newLine();
                    }
                    r.close();
                    w.close();
                }
                catch (Throwable th) {
                    System.err.println(th.toString() + " trying to fetch " + t.getPath());
                    return null;
                }
                if (aDebug) {
                    System.out.println(t.getPath() + " fetched.");
                }
            }
            return new InputSource(t.getPath());
        }
        return null;
    }
}

