/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Counter {
    Map map = new HashMap();

    public void add(Object obj, long countValue) {
        RWInteger count = (RWInteger)this.map.get(obj);
        if (count == null) {
            count = new RWInteger();
            this.map.put(obj, count);
        }
        count.value += countValue;
    }

    public long getCount(Object obj) {
        RWInteger count = (RWInteger)this.map.get(obj);
        return count == null ? 0L : count.value;
    }

    public void clear() {
        this.map.clear();
    }

    public long getTotal() {
        long count = 0L;
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            count += ((RWInteger)this.map.get(it.next())).value;
        }
        return count;
    }

    public int getItemCount() {
        return this.map.size();
    }

    public Set getKeysetSortedByCount(boolean ascending) {
        TreeMap count_key = new TreeMap();
        int counter = 0;
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            long count = this.getCount(key);
            if (!ascending) {
                count = Integer.MAX_VALUE - count;
            }
            count_key.put(new Long((count << 32) + (long)counter++), key);
        }
        LinkedHashSet result = new LinkedHashSet();
        Iterator it2 = count_key.keySet().iterator();
        while (it2.hasNext()) {
            Object count = it2.next();
            Object key = count_key.get(count);
            result.add(key);
        }
        return result;
    }

    public Set getKeysetSortedByKey() {
        return new TreeSet(this.map.keySet());
    }

    public Set getKeysetSortedByKey(Comparator comparator) {
        TreeSet s = new TreeSet(comparator);
        s.addAll(this.map.keySet());
        return s;
    }

    public Map getKeyToKey() {
        HashMap result = new HashMap();
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            result.put(key, key);
        }
        return result;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public static final class RWInteger
    implements Comparable {
        static int uniqueCount;
        public long value;
        private int forceUnique = uniqueCount++;

        public int compareTo(Object other) {
            RWInteger that = (RWInteger)other;
            if (that.value < this.value) {
                return -1;
            }
            if (that.value > this.value) {
                return 1;
            }
            if (that.forceUnique < this.forceUnique) {
                return -1;
            }
            if (that.forceUnique > this.forceUnique) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

