/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.test.util.Differ;
import com.ibm.icu.dev.test.util.XEquivalenceClass;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;

class FindDTDOrder
implements DeclHandler,
ContentHandler,
ErrorHandler {
    static final boolean SHOW_ALL = false;
    static final boolean SHOW_PROGRESS = true;
    PrintWriter log = null;
    Set elementOrderings = new LinkedHashSet();
    Set allDefinedElements = new LinkedHashSet();
    boolean showReason = false;
    Object DONE = new Object();
    static final Set ELEMENT_SKIP_LIST = new HashSet<String>(Arrays.asList("collation", "base", "settings", "suppress_contractions", "optimize", "rules", "reset", "context", "p", "pc", "s", "sc", "t", "tc", "q", "qc", "i", "ic", "extend", "x"));
    static final Set SUBELEMENT_SKIP_LIST = new HashSet<String>(Arrays.asList("PCDATA", "EMPTY", "ANY"));
    Set skipCommon = new HashSet<String>(Arrays.asList("alt", "draft", "standard", "references", "validSubLocales"));
    final Set attributeList = new TreeSet();
    TreeMap attribEquiv = new TreeMap();

    public static void main(String[] args) {
        try {
            FindDTDOrder me = new FindDTDOrder();
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            xmlReader.setContentHandler(me);
            xmlReader.setErrorHandler(me);
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", me);
            FileInputStream fis = new FileInputStream("../../common/main/root.xml");
            InputSource is = new InputSource(fis);
            xmlReader.parse(is);
            fis = new FileInputStream("../../common/supplemental/supplementalData.xml");
            is = new InputSource(fis);
            xmlReader.parse(is);
            me.checkData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    FindDTDOrder() {
        this.log = new PrintWriter(System.out);
    }

    public void checkData() {
        Iterator it2;
        Set s;
        Object first;
        this.showReason = false;
        ArrayList<Object> orderingList = new ArrayList<Object>();
        orderingList.add("ldml");
        if (this.log != null) {
            this.log.println("structure: ");
        }
        Iterator it = this.elementOrderings.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            this.log.println(value);
        }
        while ((first = this.getFirst()) != this.DONE) {
            if (first != null) {
                if (orderingList.contains(first)) {
                    throw new IllegalArgumentException("Already present: " + first);
                }
                orderingList.add(first);
                continue;
            }
            this.showReason = true;
            this.getFirst();
            if (this.log != null) {
                this.log.println();
            }
            if (this.log != null) {
                this.log.println("Failed ordering. So far:");
            }
            Iterator it3 = orderingList.iterator();
            while (it3.hasNext()) {
                if (this.log == null) continue;
                this.log.print("\t" + it3.next());
            }
            if (this.log != null) {
                this.log.println();
            }
            if (this.log != null) {
                this.log.println("Items:");
            }
            if (this.log == null) break;
            this.log.println();
            break;
        }
        TreeSet missing = new TreeSet(this.allDefinedElements);
        missing.removeAll(orderingList);
        orderingList.addAll(missing);
        if (this.log != null) {
            this.log.println("Successful Ordering");
        }
        this.log.print("Attributes: ");
        this.log.println(this.getJavaList(this.attributeList));
        this.attributeList.removeAll(CLDRFile.attributeOrdering.getOrder());
        this.log.print("New Attributes: ");
        this.log.println(this.getJavaList(this.attributeList));
        XEquivalenceClass xec = new XEquivalenceClass(null);
        Iterator<Object> it4 = this.attribEquiv.keySet().iterator();
        while (it4.hasNext()) {
            Object ename = it4.next();
            s = (Set)this.attribEquiv.get(ename);
            it2 = s.iterator();
            Object first2 = it2.next();
            while (it2.hasNext()) {
                xec.add(first2, it2.next(), ename);
            }
        }
        this.log.println("Attribute Eq: ");
        it4 = xec.getSamples().iterator();
        while (it4.hasNext()) {
            this.log.println("\t" + this.getJavaList(new TreeSet(xec.getEquivalences(it4.next()))));
        }
        it4 = xec.getEquivalenceSets().iterator();
        while (it4.hasNext()) {
            Object last = null;
            s = (Set)it4.next();
            it2 = s.iterator();
            while (it2.hasNext()) {
                Object temp = it2.next();
                if (last != null) {
                    this.log.println(last + " ~ " + temp + "\t" + xec.getReasons(last, temp));
                }
                last = temp;
            }
            this.log.println();
        }
        this.log.println("New Element Ordering: " + this.getJavaList(orderingList));
        this.log.println("Old Element Ordering: " + this.getJavaList(CLDRFile.elementOrdering.getOrder()));
        this.log.println("Old Size: " + CLDRFile.elementOrdering.getOrder().size());
        HashSet temp = new HashSet(CLDRFile.elementOrdering.getOrder());
        temp.removeAll(orderingList);
        this.log.println("Old - New: " + temp);
        this.log.println("New Size: " + orderingList.size());
        temp = new HashSet(orderingList);
        temp.removeAll(CLDRFile.elementOrdering.getOrder());
        this.log.println("New - Old: " + temp);
        Differ differ = new Differ(200, 1);
        Iterator oldIt = CLDRFile.elementOrdering.getOrder().iterator();
        Iterator newIt = orderingList.iterator();
        while (oldIt.hasNext() || newIt.hasNext()) {
            int i;
            if (oldIt.hasNext()) {
                differ.addA(oldIt.next());
            }
            if (newIt.hasNext()) {
                differ.addB(newIt.next());
            }
            differ.checkMatch(!oldIt.hasNext() && !newIt.hasNext());
            if (differ.getACount() == 0 && differ.getBCount() == 0) continue;
            this.log.println("Same: " + differ.getA(-1));
            for (i = 0; i < differ.getACount(); ++i) {
                this.log.println("\tOld: " + differ.getA(i));
            }
            for (i = 0; i < differ.getBCount(); ++i) {
                this.log.println("\t\tNew: " + differ.getB(i));
            }
            this.log.println("Same: " + differ.getA(differ.getACount()));
        }
        this.log.println("Done with differences");
        if (this.log != null) {
            this.log.flush();
        }
    }

    private String getJavaList(Collection orderingList) {
        boolean first2 = true;
        StringBuffer result = new StringBuffer();
        result.append('\"');
        Iterator it = orderingList.iterator();
        while (it.hasNext()) {
            if (first2) {
                first2 = false;
            } else {
                result.append(" ");
            }
            result.append(it.next().toString());
        }
        result.append('\"');
        return result.toString();
    }

    private Object getFirst() {
        TreeSet firstItems = new TreeSet();
        TreeSet nonFirstItems = new TreeSet();
        Iterator it = this.elementOrderings.iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list.size() == 0) continue;
            firstItems.add(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                nonFirstItems.add(list.get(i));
            }
        }
        if (firstItems.size() == 0 && nonFirstItems.size() == 0) {
            return this.DONE;
        }
        firstItems.removeAll(nonFirstItems);
        if (firstItems.size() == 0) {
            return null;
        }
        Object result = firstItems.iterator().next();
        this.removeEverywhere(result);
        return result;
    }

    private void removeEverywhere(Object possibleFirst) {
        Iterator it2 = this.elementOrderings.iterator();
        while (it2.hasNext()) {
            List list2 = (List)it2.next();
            if (list2.contains(possibleFirst) && this.log != null) {
                this.log.println("Removing " + possibleFirst + " from " + list2);
            }
            while (list2.remove(possibleFirst)) {
            }
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (name.indexOf("contractions") >= 0 || model.indexOf("[alias, base, settings, suppress, contractions, optimize, rules, special]") >= 0) {
            System.out.println("debug");
        }
        this.allDefinedElements.add(name);
        if (this.log != null) {
            this.log.println("Element\t" + name + "\t" + model);
        }
        String[] list = model.split("[^-_A-Z0-9a-z]+");
        ArrayList<String> mc = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].length() == 0 || SUBELEMENT_SKIP_LIST.contains(list[i])) continue;
            if (mc.contains(list[i])) {
                System.out.println("Duplicate element in definition of  " + name + ":\t" + list[i] + ":\t" + Arrays.asList(list) + ":\t" + mc);
                continue;
            }
            mc.add(list[i]);
        }
        this.allDefinedElements.addAll(mc);
        if (mc.size() < 1) {
            this.log.println("\tSKIPPING\t" + name + "\t" + mc);
        } else {
            this.log.println("\t" + name + "\t" + mc);
            this.elementOrderings.add(mc);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        System.out.println("Attribute\t" + eName + "\t" + aName + "\t" + type + "\t" + mode + "\t" + value);
        if (!this.skipCommon.contains(aName)) {
            this.attributeList.add(aName);
            TreeSet<String> l = (TreeSet<String>)this.attribEquiv.get(eName);
            if (l == null) {
                l = new TreeSet<String>();
                this.attribEquiv.put(eName, l);
            }
            l.add(aName);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

