/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.unicode.cldr.util.StandardCodes;

public class LanguageTagParser {
    private String original;
    private boolean grandfathered = false;
    private String language;
    private List extlangs = new ArrayList();
    private String script;
    private String region;
    private List variants = new ArrayList();
    private List extensions = new ArrayList();
    private String localeExtensions = new String();
    private List frozenExtlangs = Collections.unmodifiableList(this.extlangs);
    private List frozenVariants = Collections.unmodifiableList(this.variants);
    private List frozenExtensions = Collections.unmodifiableList(this.extensions);
    private static final UnicodeSet ALPHA = new UnicodeSet("[a-zA-Z]");
    private static final UnicodeSet DIGIT = new UnicodeSet("[0-9]");
    private static final UnicodeSet ALPHANUM = new UnicodeSet("[0-9a-zA-Z]");
    private static final UnicodeSet X = new UnicodeSet("[xX]");
    private static final UnicodeSet ALPHA_MINUS_X = new UnicodeSet(ALPHA).removeAll(X);
    private static StandardCodes standardCodes = StandardCodes.make();
    private static final Set grandfatheredCodes = standardCodes.getAvailableCodes("grandfathered");
    private static final String separator = "-_";

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public List getVariants() {
        return this.frozenVariants;
    }

    public boolean isGrandfathered() {
        return this.grandfathered;
    }

    public List getExtensions() {
        return this.frozenExtensions;
    }

    public List getExtlangs() {
        return this.frozenExtlangs;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getLanguageScript() {
        if (this.script.length() != 0) {
            return this.language + "_" + this.script;
        }
        return this.language;
    }

    public static Set getLanguageScript(Collection in) {
        return LanguageTagParser.getLanguageAndScript(in, null);
    }

    public static Set getLanguageAndScript(Collection in, Set output) {
        if (output == null) {
            output = new TreeSet<String>();
        }
        LanguageTagParser lparser = new LanguageTagParser();
        Iterator it = in.iterator();
        while (it.hasNext()) {
            output.add(lparser.set((String)it.next()).getLanguageScript());
        }
        return output;
    }

    public LanguageTagParser set(String languageTag) {
        if (languageTag.length() == 0) {
            throw new IllegalArgumentException("Language tag cannot be empty");
        }
        this.script = "";
        this.region = "";
        this.language = "";
        this.grandfathered = false;
        this.extlangs.clear();
        this.variants.clear();
        this.extensions.clear();
        this.original = languageTag;
        this.localeExtensions = "";
        int localeExtensionsPosition = languageTag.indexOf(64);
        if (localeExtensionsPosition >= 0) {
            this.localeExtensions = languageTag.substring(localeExtensionsPosition);
            languageTag = languageTag.substring(0, localeExtensionsPosition);
        }
        if (grandfatheredCodes.contains(languageTag)) {
            this.language = languageTag;
            this.grandfathered = true;
            return this;
        }
        StringTokenizer st = new StringTokenizer(languageTag, separator);
        String subtag = this.getSubtag(st);
        if (subtag.equalsIgnoreCase("x")) {
            this.getExtension(subtag, st, 1);
            return this;
        }
        if (!ALPHA.containsAll(subtag) || subtag.length() < 2) {
            this.throwError(subtag, "Invalid language subtag");
        }
        try {
            this.language = subtag;
            subtag = this.getSubtag(st);
            while (subtag.length() == 3 && ALPHA.containsAll(subtag)) {
                this.extlangs.add(subtag);
                subtag = this.getSubtag(st);
            }
            if (subtag.length() == 4 && ALPHA.containsAll(subtag)) {
                this.script = subtag;
                subtag = this.getSubtag(st);
            }
            if (subtag.length() == 2 && ALPHA.containsAll(subtag) || subtag.length() == 3 && DIGIT.containsAll(subtag)) {
                this.region = subtag;
                subtag = this.getSubtag(st);
            }
            while (subtag.length() > 4 || subtag.length() == 4 && DIGIT.contains((int)subtag.charAt(0))) {
                this.variants.add(subtag);
                subtag = this.getSubtag(st);
            }
            while (subtag.length() == 1 && ALPHA_MINUS_X.contains(subtag)) {
                if ((subtag = this.getExtension(subtag, st, 2)) != null) continue;
                return this;
            }
            if (subtag.equalsIgnoreCase("x")) {
                this.getExtension(subtag, st, 1);
                return this;
            }
            this.throwError(subtag, "Illegal subtag");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return this;
    }

    public boolean isValid() {
        if (this.grandfathered) {
            return true;
        }
        if (!this.validates(this.language, "language")) {
            return false;
        }
        if (this.extlangs.size() != 0) {
            return false;
        }
        if (!this.validates(this.script, "script")) {
            return false;
        }
        if (!this.validates(this.region, "territory")) {
            return false;
        }
        Iterator it = this.variants.iterator();
        while (it.hasNext()) {
            if (this.validates((String)it.next(), "variant")) continue;
            return false;
        }
        it = this.extensions.iterator();
        while (it.hasNext()) {
            char ch = ((String)it.next()).charAt(0);
            if (X.contains((int)ch)) continue;
            return false;
        }
        return true;
    }

    private boolean validates(String subtag, String type) {
        return subtag.length() == 0 || standardCodes.getAvailableCodes(type).contains(subtag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtension(String subtag, StringTokenizer st, int minLength) {
        if (!st.hasMoreElements()) {
            this.throwError(subtag, "Private Use / Extension requires subsequent subtag");
        }
        StringBuffer result = new StringBuffer();
        result.append(subtag);
        try {
            while (st.hasMoreElements()) {
                subtag = this.getSubtag(st);
                if (subtag.length() < minLength) {
                    String string = subtag;
                    return string;
                }
                result.append('-').append(subtag);
            }
            String string = null;
            return string;
        }
        finally {
            this.extensions.add(result.toString());
        }
    }

    private String getSubtag(StringTokenizer st) {
        String result = st.nextToken();
        if (result.length() < 1 || result.length() > 8) {
            this.throwError(result, "Illegal length (must be 1..8)");
        }
        if (!ALPHANUM.containsAll(result)) {
            this.throwError(result, "Illegal characters (" + new UnicodeSet().addAll(result).removeAll(ALPHANUM) + ")");
        }
        return result;
    }

    private void throwError(String subtag, String errorText) {
        throw new IllegalArgumentException(errorText + ": " + subtag + " in " + this.original);
    }

    public String getLocaleExtensions() {
        return this.localeExtensions;
    }
}

