/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class LocaleIDParser {
    private String language;
    private String script;
    private String region;
    private String[] variants;
    static final UnicodeSet letters = new UnicodeSet("[a-zA-Z]");
    static final UnicodeSet digits = new UnicodeSet("[0-9]");

    public String getLanguage() {
        return this.language;
    }

    public String getLanguageScript() {
        if (this.script.length() != 0) {
            return this.language + "_" + this.script;
        }
        return this.language;
    }

    public static Set getLanguageScript(Collection in) {
        return LocaleIDParser.getLanguageScript(in, null);
    }

    public static Set getLanguageScript(Collection in, Set output) {
        if (output == null) {
            output = new TreeSet<String>();
        }
        LocaleIDParser lparser = new LocaleIDParser();
        Iterator it = in.iterator();
        while (it.hasNext()) {
            output.add(lparser.set((String)it.next()).getLanguageScript());
        }
        return output;
    }

    public String getRegion() {
        return this.region;
    }

    public String getScript() {
        return this.script;
    }

    public String[] getVariants() {
        return (String[])this.variants.clone();
    }

    public LocaleIDParser set(String localeID) {
        this.script = "";
        this.region = "";
        this.variants = new String[0];
        String[] pieces = new String[100];
        Utility.split((String)localeID, (char)'_', (String[])pieces);
        int i = 0;
        this.language = pieces[i++];
        if (i >= pieces.length) {
            return this;
        }
        if (pieces[i].length() == 4) {
            this.script = pieces[i++];
            if (i >= pieces.length) {
                return this;
            }
        }
        if (pieces[i].length() == 2 && letters.containsAll(pieces[i]) || pieces[i].length() == 3 && digits.containsAll(pieces[i])) {
            this.region = pieces[i++];
            if (i >= pieces.length) {
                return this;
            }
        }
        ArrayList<String> al = new ArrayList<String>();
        while (i < pieces.length && pieces[i].length() > 0) {
            al.add(pieces[i++]);
        }
        this.variants = new String[al.size()];
        al.toArray(this.variants);
        return this;
    }

    public static String getParent(String localeName) {
        int pos = localeName.lastIndexOf(95);
        if (pos >= 0) {
            return localeName.substring(0, pos);
        }
        if (localeName.equals("root") || localeName.equals("supplementalData")) {
            return null;
        }
        return "root";
    }

    public LocaleIDParser setLanguage(String language) {
        this.language = language;
        return this;
    }

    public LocaleIDParser setRegion(String region) {
        this.region = region;
        return this;
    }

    public LocaleIDParser setScript(String script) {
        this.script = script;
        return this;
    }

    public LocaleIDParser setVariants(String[] variants) {
        this.variants = (String[])variants.clone();
        return this;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.language);
        if (this.script.length() != 0) {
            result.append('_').append(this.script);
        }
        if (this.region.length() != 0) {
            result.append('_').append(this.region);
        }
        if (this.variants != null) {
            for (int i = 0; i < this.variants.length; ++i) {
                result.append('_').append(this.variants[i]);
            }
        }
        return result.toString();
    }
}

