/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapComparator
implements Comparator,
Freezable {
    private Map ordering = new TreeMap();
    private List rankToName = new ArrayList();
    private boolean errorOnMissing = true;
    private boolean locked = false;
    private static final UnicodeSet numbers = new UnicodeSet("[0-9.]");

    public boolean isErrorOnMissing() {
        return this.errorOnMissing;
    }

    public MapComparator setErrorOnMissing(boolean errorOnMissing) {
        this.errorOnMissing = errorOnMissing;
        return this;
    }

    public List getOrder() {
        return Collections.unmodifiableList(this.rankToName);
    }

    public MapComparator() {
    }

    public MapComparator(Comparable[] data) {
        this.add(data);
    }

    public MapComparator(Collection c) {
        this.add(c);
    }

    public MapComparator add(Object newObject) {
        Object already = this.ordering.get(newObject);
        if (already == null) {
            if (this.locked) {
                throw new UnsupportedOperationException("Attempt to modify locked object");
            }
            this.ordering.put(newObject, new Integer(this.rankToName.size()));
            this.rankToName.add(newObject);
        }
        return this;
    }

    public MapComparator add(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return this;
    }

    public MapComparator add(Comparable[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.add(data[i]);
        }
        return this;
    }

    public int compare(Object a, Object b) {
        Comparable aa = (Comparable)this.ordering.get(a);
        Comparable bb = (Comparable)this.ordering.get(b);
        if (aa != null && bb != null) {
            return aa.compareTo(bb);
        }
        if (this.errorOnMissing) {
            throw new IllegalArgumentException("Missing Map Comparator value(s): " + (aa == null ? a : "") + "\t" + (bb == null ? b : ""));
        }
        if (aa == null && bb != null) {
            return 1;
        }
        if (aa != null && bb == null) {
            return -1;
        }
        boolean anumeric = numbers.containsAll((String)a);
        boolean bnumeric = numbers.containsAll((String)b);
        if (anumeric && bnumeric) {
            double bn;
            double an = Double.parseDouble((String)a);
            if (an < (bn = Double.parseDouble((String)b))) {
                return -1;
            }
            if (an > bn) {
                return 1;
            }
            return 0;
        }
        if (!anumeric && bnumeric) {
            return 1;
        }
        if (anumeric && !bnumeric) {
            return -1;
        }
        return ((Comparable)a).compareTo(b);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        Iterator it = this.rankToName.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(" ");
            }
            buffer.append("<").append(key).append(">");
        }
        return buffer.toString();
    }

    public boolean isFrozen() {
        return this.locked;
    }

    public Object freeze() {
        this.locked = true;
        return this;
    }

    public Object cloneAsThawed() {
        try {
            MapComparator result = (MapComparator)super.clone();
            result.locked = false;
            result.ordering = (Map)((TreeMap)this.ordering).clone();
            result.rankToName = (List)((TreeMap)((Object)this.rankToName)).clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("should never happen");
        }
    }
}

