/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transliterator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.Utility;

public class PrettyPath {
    private Transliterator prettyPathTransform = CheckCLDR.getTransliteratorFromFile("ID", "prettyPath.txt");
    private Map prettyPath_path = new HashMap();
    private Map path_prettyPath = new HashMap();
    private static Matcher matcher = Pattern.compile("(?<=(^|[|]))([0-9]+-)?").matcher("");

    public String getPrettyPath(String path) {
        String prettyString = (String)this.path_prettyPath.get(path);
        if (this.path_prettyPath.get(path) == null) {
            prettyString = this.prettyPathTransform.transliterate(path);
            if (prettyString.indexOf("%%") >= 0) {
                System.out.println("Warning: Incomplete translit:\t" + prettyString + "\t " + path);
            } else if (Utility.countInstances(prettyString, "|") != 2) {
                System.out.println("Warning: path length != 3: " + prettyString);
            }
            this.path_prettyPath.put(path, prettyString);
            String old = (String)this.prettyPath_path.get(prettyString);
            if (old != null) {
                System.out.println("Warning: Failed bijection, " + prettyString);
                System.out.println("\tPath1: " + path);
                System.out.println("\tPath2: " + old);
            }
            this.prettyPath_path.put(prettyString, path);
        }
        return prettyString;
    }

    public String getOriginal(String prettyPath) {
        return (String)this.prettyPath_path.get(prettyPath);
    }

    public String getOutputForm(String prettyPath) {
        return matcher.reset(prettyPath).replaceAll("");
    }
}

