/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.test.util.ICUPropertyFactory;
import com.ibm.icu.dev.test.util.UnicodeMap;
import com.ibm.icu.dev.test.util.UnicodeProperty;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Random;
import org.unicode.cldr.util.Segmenter;

public class RandomStringGenerator {
    private static final UnicodeSet SUPPLEMENTARIES = new UnicodeSet(65536, 0x10FFFF);
    private Random random = new Random(0L);
    private UnicodeSet[] sets;
    private UnicodeMap map;
    private UnicodeMap shortMap;
    private UnicodeMap extendedMap;
    static UnicodeMap.Composer MyComposer = new UnicodeMap.Composer(){

        public Object compose(int codePoint, Object a, Object b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return a + "_" + b;
        }
    };

    void init(UnicodeProperty.Factory factory) {
        this.extendedMap = new UnicodeMap();
        UnicodeMap tempMap = factory.getProperty("GraphemeClusterBreak").getUnicodeMap();
        this.extendedMap.putAll(tempMap.getSet((Object)"CR"), (Object)"CR");
        this.extendedMap.putAll(tempMap.getSet((Object)"LF"), (Object)"LF");
        this.extendedMap.putAll(tempMap.getSet((Object)"Extend"), (Object)"GCExtend");
        this.extendedMap.putAll(tempMap.getSet((Object)"Control"), (Object)"GCControl");
    }

    public RandomStringGenerator(UnicodeProperty.Factory factory, String propertyName) {
        this(factory, propertyName, false, false);
    }

    public RandomStringGenerator(UnicodeProperty.Factory factory, String propertyName, boolean useShortName, boolean addGCStuff) {
        this(factory, factory.getProperty(propertyName).getUnicodeMap(), useShortName ? ICUPropertyFactory.make().getProperty(propertyName).getUnicodeMap(true) : null, addGCStuff);
    }

    RandomStringGenerator(UnicodeProperty.Factory factory, UnicodeMap longNameMap, UnicodeMap shortNameMap, boolean addGCStuff) {
        this.init(factory);
        UnicodeMap unicodeMap = this.map = !addGCStuff ? longNameMap : longNameMap.composeWith(this.extendedMap, MyComposer);
        this.shortMap = shortNameMap == null ? longNameMap : (!addGCStuff ? shortNameMap : shortNameMap.composeWith(this.extendedMap, MyComposer));
        ArrayList values = new ArrayList(this.map.getAvailableValues());
        this.sets = new UnicodeSet[values.size()];
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i] = this.map.getSet(values.get(i));
            this.sets[i].removeAll(SUPPLEMENTARIES);
            if (Segmenter.DEBUG_RETAIN == null) continue;
            int first = this.sets[i].charAt(0);
            this.sets[i].retainAll(Segmenter.DEBUG_RETAIN);
            if (this.sets[i].size() != 0) continue;
            this.sets[i].add(first);
        }
    }

    public String getValue(int cp) {
        return (String)this.shortMap.getValue(cp);
    }

    public String next(int len) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            UnicodeSet us = this.sets[this.random.nextInt(this.sets.length)];
            int cp = us.charAt(this.random.nextInt(us.size()));
            UTF16.append((StringBuffer)result, (int)cp);
        }
        return result.toString();
    }
}

