/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.Utility;

public class XPathParts {
    private boolean DEBUGGING = false;
    private List elements = new ArrayList();
    Comparator attributeComparator;
    Map suppressionMap;
    public static final int XPATH_STYLE = 0;
    public static final int XML_OPEN = 1;
    public static final int XML_CLOSE = 2;
    public static final int XML_NO_VALUE = 3;
    public static final String NEWLINE = "\n";

    public XPathParts() {
        this(null, null);
    }

    public XPathParts(Comparator attributeComparator, Map suppressionMap) {
        if (attributeComparator == null) {
            attributeComparator = CLDRFile.getAttributeComparator();
        }
        this.attributeComparator = attributeComparator;
        this.suppressionMap = suppressionMap;
    }

    public boolean containsElement(String element) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((Element)this.elements.get(i)).getElement().equals(element)) continue;
            return true;
        }
        return false;
    }

    public XPathParts clear() {
        this.elements.clear();
        return this;
    }

    public XPathParts writeDifference(PrintWriter pw, XPathParts filteredXPath, XPathParts lastFullXPath, XPathParts filteredLastXPath, String v, Comments xpath_comments) {
        int i;
        int limit = this.findFirstDifference(lastFullXPath);
        for (i = lastFullXPath.size() - 2; i >= limit; --i) {
            Utility.indent(pw, i);
            pw.println(((Element)lastFullXPath.elements.get(i)).toString(2));
        }
        if (v == null) {
            return this;
        }
        for (i = limit; i < this.size() - 1; ++i) {
            filteredXPath.writeComment(pw, xpath_comments, i + 1, 1);
            Utility.indent(pw, i);
            pw.println(((Element)this.elements.get(i)).toString(1));
        }
        filteredXPath.writeComment(pw, xpath_comments, this.size(), 1);
        Utility.indent(pw, this.size() - 1);
        Element e = (Element)this.elements.get(this.size() - 1);
        String eValue = v;
        if (eValue.length() == 0) {
            pw.print(e.toString(3));
        } else {
            pw.print(e.toString(1));
            pw.print(TransliteratorUtilities.toHTML.transliterate(eValue));
            pw.print(e.toString(2));
        }
        filteredXPath.writeComment(pw, xpath_comments, this.size(), 0);
        pw.println();
        filteredXPath.writeComment(pw, xpath_comments, this.size(), 2);
        pw.flush();
        return this;
    }

    private XPathParts writeComment(PrintWriter pw, Comments xpath_comments, int index, int style) {
        if (index == 0) {
            return this;
        }
        String xpath = this.toString(index);
        Log.logln(this.DEBUGGING, "Checking for: " + xpath);
        String comment = xpath_comments.removeComment(style, xpath);
        if (comment != null) {
            XPathParts.writeComment(pw, index - 1, comment, style != 0);
        }
        return this;
    }

    public int findFirstDifference(XPathParts last) {
        int min = this.elements.size();
        if (last.elements.size() < min) {
            min = last.elements.size();
        }
        for (int i = 0; i < min; ++i) {
            Element e2;
            Element e1 = (Element)this.elements.get(i);
            if (e1.equals(e2 = (Element)last.elements.get(i))) continue;
            return i;
        }
        return min;
    }

    public boolean isLike(XPathParts last) {
        int min = this.elements.size();
        if (last.elements.size() < min) {
            min = last.elements.size();
        }
        for (int i = 0; i < min; ++i) {
            Element e2;
            Element e1 = (Element)this.elements.get(i);
            if (e1.equals(e2 = (Element)last.elements.get(i))) continue;
            if (i == min - 1) {
                String et1 = e1.getAttribute("type");
                String et2 = e2.getAttribute("type");
                if (et1 == null && et2 == null) {
                    et1 = e1.getAttribute("id");
                    et2 = e2.getAttribute("id");
                }
                if (!et1.equals(et2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean containsAttribute(String attribute) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = (Element)this.elements.get(i);
            if (element.getAttribute(attribute) == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeValue(String attribute, String value) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Map attributes = ((Element)this.elements.get(i)).getAttributes();
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                String v;
                String a = (String)it.next();
                if (!a.equals(attribute) || !(v = (String)attributes.get(a)).equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.elements.size();
    }

    public String getElement(int elementIndex) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        return ((Element)this.elements.get(elementIndex)).getElement();
    }

    public Map getAttributes(int elementIndex) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        return ((Element)this.elements.get(elementIndex)).getAttributes();
    }

    public int getAttributeCount(int elementIndex) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        return ((Element)this.elements.get(elementIndex)).getAttributeCount();
    }

    public Collection getAttributeKeys(int elementIndex) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        return Collections.unmodifiableSet(((Element)this.elements.get(elementIndex)).getAttributeKeys());
    }

    public String getAttributeValue(int elementIndex, String attribute) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        return ((Element)this.elements.get(elementIndex)).getAttribute(attribute);
    }

    public void putAttributeValue(int elementIndex, String attribute, String value) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        ((Element)this.elements.get(elementIndex)).putAttribute(attribute, value);
    }

    public Map findAttributes(String elementName) {
        int index = this.findElement(elementName);
        if (index == -1) {
            return null;
        }
        return this.getAttributes(index);
    }

    public String findAttributeValue(String elementName, String attributeName) {
        Map attributes = this.findAttributes(elementName);
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get(attributeName);
    }

    public XPathParts addElement(String element) {
        this.elements.add(new Element(element));
        return this;
    }

    public XPathParts addAttribute(String attribute, String value) {
        Element e = (Element)this.elements.get(this.elements.size() - 1);
        attribute = attribute.intern();
        e.getAttributes().put(attribute, value);
        return this;
    }

    public XPathParts set(String xPath) {
        return this.addInternal(xPath, true);
    }

    public XPathParts initialize(String xPath) {
        if (this.size() != 0) {
            return this;
        }
        return this.addInternal(xPath, true);
    }

    private XPathParts addInternal(String xPath, boolean initial) {
        String lastAttributeName = "";
        String requiredPrefix = "/";
        if (initial) {
            this.elements.clear();
            requiredPrefix = "//";
        }
        if (!xPath.startsWith(requiredPrefix)) {
            return this.parseError(xPath, 0);
        }
        int stringStart = requiredPrefix.length();
        int state = 112;
        block8: for (int i = 2; i < xPath.length(); ++i) {
            int cp = xPath.charAt(i);
            if (cp != state && (state == 34 || state == 39)) continue;
            switch (cp) {
                case 47: {
                    if (state != 112 || stringStart >= i) {
                        return this.parseError(xPath, i);
                    }
                    if (stringStart > 0) {
                        this.addElement(xPath.substring(stringStart, i));
                    }
                    stringStart = i + 1;
                    continue block8;
                }
                case 91: {
                    if (state != 112 || stringStart >= i) {
                        return this.parseError(xPath, i);
                    }
                    if (stringStart > 0) {
                        this.addElement(xPath.substring(stringStart, i));
                    }
                    state = cp;
                    continue block8;
                }
                case 64: {
                    if (state != 91) {
                        return this.parseError(xPath, i);
                    }
                    stringStart = i + 1;
                    state = cp;
                    continue block8;
                }
                case 61: {
                    if (state != 64 || stringStart >= i) {
                        return this.parseError(xPath, i);
                    }
                    lastAttributeName = xPath.substring(stringStart, i);
                    state = cp;
                    continue block8;
                }
                case 34: 
                case 39: {
                    if (state == cp) {
                        if (stringStart > i) {
                            return this.parseError(xPath, i);
                        }
                        this.addAttribute(lastAttributeName, xPath.substring(stringStart, i));
                        state = 101;
                        continue block8;
                    }
                    if (state != 61) {
                        return this.parseError(xPath, i);
                    }
                    stringStart = i + 1;
                    state = cp;
                    continue block8;
                }
                case 93: {
                    if (state != 101) {
                        return this.parseError(xPath, i);
                    }
                    state = 112;
                    stringStart = -1;
                }
            }
        }
        if (state != 112 || stringStart >= xPath.length()) {
            return this.parseError(xPath, xPath.length());
        }
        if (stringStart > 0) {
            this.addElement(xPath.substring(stringStart, xPath.length()));
        }
        return this;
    }

    public String toString() {
        return this.toString(this.elements.size());
    }

    public String toString(int limit) {
        String result = "/";
        for (int i = 0; i < limit; ++i) {
            result = result + ((Element)this.elements.get(i)).toString(0);
        }
        return result;
    }

    public String toString(int start, int limit) {
        String result = "";
        for (int i = start; i < limit; ++i) {
            result = result + ((Element)this.elements.get(i)).toString(0);
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        XPathParts that = (XPathParts)other;
        if (this.elements.size() != that.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i).equals(that.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.elements.size();
        for (int i = 0; i < this.elements.size(); ++i) {
            result = result * 37 + this.elements.get(i).hashCode();
        }
        return result;
    }

    private XPathParts parseError(String s, int i) {
        throw new IllegalArgumentException("Malformed xPath '" + s + "' at " + i);
    }

    public int findElement(String elementName) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = (Element)this.elements.get(i);
            if (!e.getElement().equals(elementName)) continue;
            return i;
        }
        return -1;
    }

    public XPathParts addRelative(String path) {
        if (path.startsWith("//")) {
            this.elements.clear();
            path = path.substring(1);
        } else {
            while (path.startsWith("../")) {
                path = path.substring(3);
                this.trimLast();
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
        }
        return this.addInternal(path, false);
    }

    public XPathParts trimLast() {
        this.elements.remove(this.elements.size() - 1);
        return this;
    }

    public XPathParts set(XPathParts parts) {
        this.elements.clear();
        this.elements.addAll(parts.elements);
        return this;
    }

    public XPathParts replace(int i, XPathParts parts) {
        List temp = this.elements;
        this.elements = new ArrayList();
        this.set(parts);
        while (i < temp.size()) {
            this.elements.add(temp.get(i));
            ++i;
        }
        return this;
    }

    static void writeComment(PrintWriter pw, int indent, String comment, boolean blockComment) {
        if (comment.length() == 0) {
            return;
        }
        if (blockComment) {
            Utility.indent(pw, indent);
        } else {
            pw.print(" ");
        }
        pw.print("<!--");
        if (comment.indexOf(NEWLINE) > 0) {
            boolean first = true;
            int countEmptyLines = 0;
            Iterator it = Utility.splitList(comment, '\n', indent != 0, null).iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                if (line.length() == 0) {
                    ++countEmptyLines;
                    continue;
                }
                if (countEmptyLines != 0) {
                    for (int i = 0; i < countEmptyLines; ++i) {
                        pw.println();
                    }
                    countEmptyLines = 0;
                }
                if (first) {
                    first = false;
                    line = line.trim();
                    pw.print(" ");
                } else if (indent != 0) {
                    Utility.indent(pw, indent + 1);
                    pw.print(" ");
                }
                pw.println(line);
            }
            Utility.indent(pw, indent);
        } else {
            pw.print(" ");
            pw.print(comment.trim());
            pw.print(" ");
        }
        pw.print("-->");
        if (blockComment) {
            pw.println();
        }
    }

    public static boolean isLanguage(String in) {
        int pos = in.indexOf(95);
        if (pos < 0) {
            return true;
        }
        if (in.indexOf(95, pos + 1) >= 0) {
            return false;
        }
        return in.length() == pos + 5;
    }

    public static int isSubLocale(String parent, String possibleSublocale) {
        if (parent.equals("root")) {
            if (parent.equals(possibleSublocale)) {
                return 0;
            }
            return 1;
        }
        if (parent.length() > possibleSublocale.length()) {
            return -1;
        }
        if (!possibleSublocale.startsWith(parent)) {
            return -1;
        }
        if (parent.length() == possibleSublocale.length()) {
            return 0;
        }
        if (possibleSublocale.charAt(parent.length()) != '_') {
            return -1;
        }
        return 1;
    }

    public XPathParts setAttribute(String elementName, String attributeName, String attributeValue) {
        Map m = this.findAttributes(elementName);
        m.put(attributeName, attributeValue);
        return this;
    }

    public XPathParts removeProposed() {
        block0: for (int i = 0; i < this.elements.size(); ++i) {
            Element element = (Element)this.elements.get(i);
            if (element.attributes == null) continue;
            Iterator it = element.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attribute = (String)it.next();
                if (!attribute.equals("alt")) continue;
                String attributeValue = (String)element.attributes.get(attribute);
                int pos = attributeValue.indexOf("proposed");
                if (pos < 0) continue block0;
                if (pos > 0 && attributeValue.charAt(pos - 1) == '-') {
                    --pos;
                }
                if (pos == 0) {
                    element.attributes.remove(attribute);
                    continue block0;
                }
                attributeValue = attributeValue.substring(0, pos);
                element.attributes.put(attribute, attributeValue);
                continue block0;
            }
        }
        return this;
    }

    private class Element {
        private String element;
        private Map attributes;

        public Element(String element) {
            this.element = element;
            this.attributes = null;
        }

        public void putAttribute(String attribute, String value) {
            this.getAttributes().put(attribute, value);
        }

        public String toString() {
            throw new IllegalArgumentException("Don't use");
        }

        public String toString(int style) {
            StringBuffer result = new StringBuffer();
            switch (style) {
                case 0: {
                    result.append('/').append(this.element);
                    this.writeAttributes(this.element, "[@", "\"]", false, result);
                    break;
                }
                case 1: 
                case 3: {
                    result.append('<').append(this.element);
                    this.writeAttributes(this.element, " ", "\"", true, result);
                    if (style == 3) {
                        result.append('/');
                    }
                    if (CLDRFile.HACK_ORDER && this.element.equals("ldml")) {
                        result.append(' ');
                    }
                    result.append('>');
                    break;
                }
                case 2: {
                    result.append("</").append(this.element).append('>');
                }
            }
            return result.toString();
        }

        private Element writeAttributes(String element, String prefix, String postfix, boolean removeLDMLExtras, StringBuffer result) {
            Set keys = this.getAttributeKeys();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String attribute = (String)it.next();
                String value = this.getAttribute(attribute);
                if (removeLDMLExtras && XPathParts.this.suppressionMap != null) {
                    Map attribute_value = (Map)XPathParts.this.suppressionMap.get(element);
                    if (attribute_value == null) {
                        attribute_value = (Map)XPathParts.this.suppressionMap.get("*");
                    }
                    if (attribute_value != null) {
                        Object suppressValue = attribute_value.get(attribute);
                        if (suppressValue == null) {
                            suppressValue = attribute_value.get("*");
                        }
                        if (suppressValue != null && (value.equals(suppressValue) || suppressValue.equals("*"))) continue;
                    }
                }
                result.append(prefix).append(attribute).append("=\"").append(TransliteratorUtilities.toHTML.transliterate(value)).append(postfix);
            }
            return this;
        }

        public boolean equals(Object other) {
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            Element that = (Element)other;
            return this.element.equals(that.element) && ((Object)this.getAttributes()).equals(that.getAttributes());
        }

        public int hashCode() {
            return this.element.hashCode() * 37 + ((Object)this.getAttributes()).hashCode();
        }

        public String getElement() {
            return this.element;
        }

        private Map getAttributes() {
            if (this.attributes == null) {
                this.attributes = new TreeMap(XPathParts.this.attributeComparator);
            }
            return this.attributes;
        }

        private int getAttributeCount() {
            if (this.attributes == null) {
                return 0;
            }
            return this.attributes.size();
        }

        private Set getAttributeKeys() {
            if (this.attributes == null) {
                return Collections.EMPTY_SET;
            }
            return this.attributes.keySet();
        }

        private String getAttribute(String attribute) {
            if (this.attributes == null) {
                return null;
            }
            return (String)this.attributes.get(attribute);
        }
    }

    public static class Comments
    implements Cloneable {
        public static final int LINE = 0;
        public static final int PREBLOCK = 1;
        public static final int POSTBLOCK = 2;
        private HashMap[] comments = new HashMap[3];
        private String initialComment = "";
        private String finalComment = "";

        public Comments() {
            this.comments[0] = new HashMap();
            this.comments[1] = new HashMap();
            this.comments[2] = new HashMap();
        }

        public Comments addComment(int style, String xpath, String comment) {
            String existing = (String)this.comments[style].get(xpath);
            if (existing != null) {
                comment = existing + XPathParts.NEWLINE + comment;
            }
            this.comments[style].put(xpath, comment);
            return this;
        }

        public String removeComment(int style, String xPath) {
            String result = (String)this.comments[style].get(xPath);
            if (result != null) {
                this.comments[style].remove(xPath);
            }
            return result;
        }

        public List extractCommentsWithoutBase() {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.comments.length; ++i) {
                Iterator it = this.comments[i].keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object value = this.comments[i].get(key);
                    result.add(value + "\t - was on: " + key);
                    it.remove();
                }
            }
            return result;
        }

        public Object clone() {
            try {
                Comments result = (Comments)super.clone();
                result.comments = new HashMap[3];
                result.comments[0] = (HashMap)this.comments[0].clone();
                result.comments[1] = (HashMap)this.comments[1].clone();
                result.comments[2] = (HashMap)this.comments[2].clone();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("should never happen");
            }
        }

        public Comments joinAll(Comments other) {
            Utility.joinWithSeparation(this.comments[0], XPathParts.NEWLINE, other.comments[0]);
            Utility.joinWithSeparation(this.comments[1], XPathParts.NEWLINE, other.comments[1]);
            Utility.joinWithSeparation(this.comments[2], XPathParts.NEWLINE, other.comments[2]);
            return this;
        }

        public Comments removeComment(String string) {
            if (this.initialComment.equals(string)) {
                this.initialComment = "";
            }
            if (this.finalComment.equals(string)) {
                this.finalComment = "";
            }
            for (int i = 0; i < this.comments.length; ++i) {
                Iterator it = this.comments[i].keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object value = this.comments[i].get(key);
                    if (!value.equals(string)) continue;
                    it.remove();
                }
            }
            return this;
        }

        public String getFinalComment() {
            return this.finalComment;
        }

        public Comments setFinalComment(String finalComment) {
            this.finalComment = finalComment;
            return this;
        }

        public String getInitialComment() {
            return this.initialComment;
        }

        public Comments setInitialComment(String initialComment) {
            this.initialComment = initialComment;
            return this;
        }
    }
}

