/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;

public final class CollectionUtilities {
    public static final int ALL_EMPTY = 0;
    public static final int NOT_A_SUPERSET_B = 1;
    public static final int NOT_A_DISJOINT_B = 2;
    public static final int NOT_A_SUBSET_B = 4;
    public static final int NOT_A_EQUALS_B = 5;
    public static final int A_PROPER_SUBSET_OF_B = 3;
    public static final int A_PROPER_SUPERSET_B = 6;
    public static final int A_PROPER_OVERLAPS_B = 7;

    public static Map asMap(Object[][] source, Map target, boolean reverse) {
        int from = 0;
        int to = 1;
        if (reverse) {
            from = 1;
            to = 0;
        }
        for (int i = 0; i < source.length; ++i) {
            target.put(source[i][from], source[i][to]);
        }
        return target;
    }

    public static Collection addAll(Iterator source, Collection target) {
        while (source.hasNext()) {
            target.add(source.next());
        }
        return target;
    }

    public static int size(Iterator source) {
        int result = 0;
        while (source.hasNext()) {
            source.next();
            ++result;
        }
        return result;
    }

    public static Map asMap(Object[][] source) {
        return CollectionUtilities.asMap(source, new HashMap(), false);
    }

    public static Map removeAll(Map m, Collection itemsToRemove) {
        Iterator it = itemsToRemove.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            m.remove(item);
        }
        return m;
    }

    public Object getFirst(Collection c) {
        Iterator it = c.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    public static Object getBest(Collection c, Comparator comp, int direction) {
        Iterator it = c.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Object bestSoFar = it.next();
        while (it.hasNext()) {
            Object item = it.next();
            if (comp.compare(item, bestSoFar) != direction) continue;
            bestSoFar = item;
        }
        return bestSoFar;
    }

    public static Collection removeAll(Collection c, Filter f) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!f.matches(item)) continue;
            it.remove();
        }
        return c;
    }

    public static Collection retainAll(Collection c, Filter f) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (f.matches(item)) continue;
            it.remove();
        }
        return c;
    }

    public static boolean containsSome(Collection a, Collection b) {
        if (a.size() == 0 || b.size() == 0) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a instanceof SortedSet && b instanceof SortedSet) {
            SortedSet aa = (SortedSet)a;
            SortedSet bb = (SortedSet)b;
            aa.containsAll(null);
            Comparator bbc = bb.comparator();
            Comparator aac = aa.comparator();
            if (bbc == null) {
                if (aac == null) {
                    Iterator ai = aa.iterator();
                    Iterator bi = bb.iterator();
                    Comparable ao = (Comparable)ai.next();
                    Comparable bo = (Comparable)bi.next();
                    while (true) {
                        int rel;
                        if ((rel = ao.compareTo(bo)) < 0) {
                            if (!ai.hasNext()) {
                                return false;
                            }
                            ao = (Comparable)ai.next();
                            continue;
                        }
                        if (rel <= 0) break;
                        if (!bi.hasNext()) {
                            return false;
                        }
                        bo = (Comparable)bi.next();
                    }
                    return true;
                }
            } else if (((Object)bbc).equals(a)) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Object ao = ai.next();
                Object bo = bi.next();
                while (true) {
                    int rel;
                    if ((rel = aac.compare(ao, bo)) < 0) {
                        if (!ai.hasNext()) {
                            return false;
                        }
                        ao = ai.next();
                        continue;
                    }
                    if (rel <= 0) break;
                    if (!bi.hasNext()) {
                        return false;
                    }
                    bo = bi.next();
                }
                return true;
            }
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            if (!b.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection a, Collection b) {
        if (a == b) {
            return true;
        }
        if (b.size() == 0) {
            return true;
        }
        if (a.size() == 0) {
            return false;
        }
        if (a instanceof SortedSet && b instanceof SortedSet) {
            SortedSet aa = (SortedSet)a;
            SortedSet bb = (SortedSet)b;
            Comparator bbc = bb.comparator();
            Comparator aac = aa.comparator();
            if (bbc == null) {
                if (aac == null) {
                    Iterator ai = aa.iterator();
                    Iterator bi = bb.iterator();
                    Comparable ao = (Comparable)ai.next();
                    Comparable bo = (Comparable)bi.next();
                    while (true) {
                        int rel;
                        if ((rel = ao.compareTo(bo)) == 0) {
                            if (!bi.hasNext()) {
                                return true;
                            }
                            if (!ai.hasNext()) {
                                return false;
                            }
                            bo = (Comparable)bi.next();
                            ao = (Comparable)ai.next();
                            continue;
                        }
                        if (rel >= 0) break;
                        if (!ai.hasNext()) {
                            return false;
                        }
                        ao = (Comparable)ai.next();
                    }
                    return false;
                }
            } else if (((Object)bbc).equals(a)) {
                Iterator ai = aa.iterator();
                Iterator bi = bb.iterator();
                Object ao = ai.next();
                Object bo = bi.next();
                while (true) {
                    int rel;
                    if ((rel = aac.compare(ao, bo)) == 0) {
                        if (!bi.hasNext()) {
                            return true;
                        }
                        if (!ai.hasNext()) {
                            return false;
                        }
                        bo = bi.next();
                        ao = ai.next();
                        continue;
                    }
                    if (rel >= 0) break;
                    if (!ai.hasNext()) {
                        return false;
                    }
                    ao = ai.next();
                }
                return false;
            }
        }
        return a.containsAll(b);
    }

    public static boolean containsNone(Collection a, Collection b) {
        return !CollectionUtilities.containsSome(a, b);
    }

    public static int getContainmentRelation(Collection a, Collection b) {
        int result;
        if (a.size() == 0) {
            return b.size() == 0 ? 0 : 1;
        }
        if (b.size() == 0) {
            return 4;
        }
        Iterator it = a.iterator();
        for (result = 0; result != 6 && it.hasNext(); result |= b.contains(it.next()) ? 2 : 4) {
        }
        it = b.iterator();
        while ((result & 3) != 3 && it.hasNext()) {
            result |= a.contains(it.next()) ? 2 : 1;
        }
        return result;
    }

    public static String remove(String source, UnicodeSet removals) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)source, (int)i);
            if (removals.contains(cp)) continue;
            UTF16.append((StringBuffer)result, (int)cp);
        }
        return result.toString();
    }

    public static String prettyPrint(UnicodeSet uset, Comparator comp, Comparator spaceComparator, boolean compressRanges) {
        Appender result = new Appender(compressRanges, spaceComparator);
        MultiComparator comp2 = new MultiComparator(new Comparator[]{comp, new UTF16.StringComparator(true, false, 0)});
        TreeSet<String> ordering = new TreeSet<String>(comp2);
        Object it = new UnicodeSetIterator(uset);
        while (it.next()) {
            ordering.add(it.getString());
        }
        result.append("[");
        it = ordering.iterator();
        while (it.hasNext()) {
            result.appendUnicodeSetItem((String)it.next());
        }
        result.flushLast();
        result.append("]");
        String sresult = result.toString();
        UnicodeSet doubleCheck = new UnicodeSet(sresult);
        if (!uset.equals((Object)doubleCheck)) {
            throw new IllegalStateException("Failure to round-trip in pretty-print");
        }
        return sresult;
    }

    public static UnicodeSet flatten(UnicodeSet exemplar1) {
        UnicodeSet result = new UnicodeSet();
        boolean gotString = false;
        UnicodeSetIterator it = new UnicodeSetIterator(exemplar1);
        while (it.nextRange()) {
            if (it.codepoint == UnicodeSetIterator.IS_STRING) {
                result.addAll(it.string);
                gotString = true;
                continue;
            }
            result.add(it.codepoint, it.codepointEnd);
        }
        if (gotString) {
            exemplar1.set(result);
        }
        return exemplar1;
    }

    public static class RegexIterator
    extends FilteredIterator {
        private Matcher matcher;

        public RegexIterator set(Iterator baseIterator, Matcher matcher) {
            super.set(baseIterator);
            this.matcher = matcher;
            return this;
        }

        public boolean isIncluded(Object item) {
            return this.matcher.reset((String)item).matches();
        }
    }

    public static class PrefixIterator
    extends FilteredIterator {
        private String prefix;

        public PrefixIterator set(Iterator baseIterator, String prefix) {
            super.set(baseIterator);
            this.prefix = prefix;
            return this;
        }

        public boolean isIncluded(Object item) {
            return ((String)item).startsWith(this.prefix);
        }
    }

    public static abstract class FilteredIterator
    implements Iterator {
        private Iterator baseIterator;
        private static final Object EMPTY = new Object();
        private static final Object DONE = new Object();
        private Object nextObject = EMPTY;

        public FilteredIterator set(Iterator baseIterator) {
            this.baseIterator = baseIterator;
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException("Doesn't support removal");
        }

        public Object next() {
            Object result = this.nextObject;
            this.nextObject = EMPTY;
            return result;
        }

        public boolean hasNext() {
            if (this.nextObject == DONE) {
                return false;
            }
            if (this.nextObject != EMPTY) {
                return true;
            }
            while (this.baseIterator.hasNext()) {
                this.nextObject = this.baseIterator.next();
                if (!this.isIncluded(this.nextObject)) continue;
                return true;
            }
            this.nextObject = DONE;
            return false;
        }

        public abstract boolean isIncluded(Object var1);
    }

    static class MultiComparator
    implements Comparator {
        private Comparator[] comparators;

        public MultiComparator(Comparator[] comparators) {
            this.comparators = comparators;
        }

        public int compare(Object arg0, Object arg1) {
            for (int i = 0; i < this.comparators.length; ++i) {
                int result = this.comparators[i].compare(arg0, arg1);
                if (result == 0) continue;
                if (result > 0) {
                    return i + 1;
                }
                return -(i + 1);
            }
            return 0;
        }
    }

    private static class Appender {
        private boolean first = true;
        private StringBuffer target = new StringBuffer();
        private int firstCodePoint = -2;
        private int lastCodePoint = -2;
        private boolean compressRanges;
        private Comparator spaceComp;
        private String lastString = "";

        public Appender(boolean compressRanges, Comparator spaceComp) {
            this.compressRanges = compressRanges;
            this.spaceComp = spaceComp;
        }

        Appender appendUnicodeSetItem(String s) {
            if (UTF16.hasMoreCodePointsThan((String)s, (int)1)) {
                int cp;
                this.flushLast();
                this.addSpace(s);
                this.target.append("{");
                for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
                    cp = UTF16.charAt((String)s, (int)i);
                    this.appendQuoted(cp);
                }
                this.target.append("}");
                this.lastString = s;
            } else {
                int cp;
                if (!this.compressRanges) {
                    this.flushLast();
                }
                if ((cp = UTF16.charAt((String)s, (int)0)) == this.lastCodePoint + 1) {
                    this.lastCodePoint = cp;
                } else {
                    this.flushLast();
                    this.firstCodePoint = this.lastCodePoint = cp;
                }
            }
            return this;
        }

        private void addSpace(String s) {
            if (this.first) {
                this.first = false;
            } else if (this.spaceComp.compare(s, this.lastString) != 0) {
                this.target.append(' ');
            } else {
                int type = UCharacter.getType((int)UTF16.charAt((String)s, (int)0));
                if (type == 6 || type == 7) {
                    this.target.append(' ');
                }
            }
        }

        private void flushLast() {
            if (this.lastCodePoint >= 0) {
                this.addSpace(UTF16.valueOf((int)this.firstCodePoint));
                if (this.firstCodePoint != this.lastCodePoint) {
                    this.appendQuoted(this.firstCodePoint);
                    this.target.append(this.firstCodePoint + 1 == this.lastCodePoint ? (char)' ' : '-');
                }
                this.appendQuoted(this.lastCodePoint);
                this.lastString = UTF16.valueOf((int)this.lastCodePoint);
                this.lastCodePoint = -2;
                this.firstCodePoint = -2;
            }
        }

        Appender appendQuoted(int codePoint) {
            switch (codePoint) {
                case 36: 
                case 38: 
                case 45: 
                case 58: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 125: {
                    this.target.append('\\');
                    break;
                }
                default: {
                    if (!UCharacterProperty.isRuleWhiteSpace((int)codePoint)) break;
                    this.target.append('\\');
                }
            }
            UTF16.append((StringBuffer)this.target, (int)codePoint);
            return this;
        }

        Appender append(String s) {
            this.target.append(s);
            return this;
        }

        public String toString() {
            return this.target.toString();
        }
    }

    public static interface Filter {
        public boolean matches(Object var1);
    }
}

