/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.CompactByteArray;
import com.ibm.icu.util.CompactCharArray;

public final class CompactArrayTest
extends TestFmwk {
    public static void main(String[] args) throws Exception {
        new CompactArrayTest().run(args);
    }

    public void TestByteArrayCoverage() {
        CompactByteArray cba = new CompactByteArray();
        cba.setElementAt('\u0005', (byte)-33);
        cba.setElementAt('\u0105', (byte)-33);
        cba.setElementAt('\u0205', (byte)-33);
        cba.setElementAt('\u0305', (byte)-33);
        CompactByteArray cba2 = new CompactByteArray(-33);
        if (cba.equals((Object)cba2)) {
            this.errln("unequal byte arrays compare equal");
        }
        CompactByteArray cba3 = (CompactByteArray)cba.clone();
        this.logln("equals null: " + cba.equals(null));
        this.logln("equals self: " + cba.equals((Object)cba));
        this.logln("equals clone: " + cba.equals((Object)cba3));
        this.logln("equals bogus: " + cba.equals(new Object()));
        this.logln("hash: " + cba.hashCode());
        cba.compact(true);
        cba.compact(true);
        char[] xa = cba.getIndexArray();
        byte[] va = cba.getValueArray();
        CompactByteArray cba4 = new CompactByteArray(xa, va);
        String xs = Utility.arrayToRLEString((char[])xa);
        String vs = Utility.arrayToRLEString((byte[])va);
        CompactByteArray cba5 = new CompactByteArray(xs, vs);
        this.logln("equals: " + cba4.equals((Object)cba5));
        this.logln("equals: " + cba.equals((Object)cba4));
        cba4.compact(false);
        this.logln("equals: " + cba4.equals((Object)cba5));
        cba5.compact(true);
        this.logln("equals: " + cba4.equals((Object)cba5));
        cba.setElementAt('\u0405', (byte)-33);
        this.logln("modified equals clone: " + cba.equals((Object)cba3));
        cba3.setElementAt('\u0405', (byte)-33);
        this.logln("modified equals modified clone: " + cba.equals((Object)cba3));
        cba3.setElementAt('\u0405', (byte)-18);
        this.logln("different mod equals: " + cba.equals((Object)cba3));
        cba.compact();
        CompactByteArray cba6 = (CompactByteArray)cba.clone();
        this.logln("cloned compact equals: " + cba.equals((Object)cba6));
        cba6.setElementAt('\u0405', (byte)-18);
        this.logln("modified clone: " + cba3.equals((Object)cba6));
        cba6.setElementAt('\u0100', '\u0104', (byte)-2);
        for (int i = 256; i < 261; ++i) {
            cba3.setElementAt((char)i, (byte)-2);
        }
        this.logln("double modified: " + cba3.equals((Object)cba6));
    }

    public void TestCharArrayCoverage() {
        boolean EXTENSIVE = false;
        CompactCharArray cca = new CompactCharArray();
        cca.setElementAt('\u0005', '\u00df');
        cca.setElementAt('\u0105', '\u00df');
        cca.setElementAt('\u0205', '\u00df');
        cca.setElementAt('\u0305', '\u00df');
        CompactCharArray cca2 = new CompactCharArray('\u00df');
        if (cca.equals((Object)cca2)) {
            this.errln("unequal char arrays compare equal");
        }
        CompactCharArray cca3 = (CompactCharArray)cca.clone();
        this.logln("equals null: " + cca.equals(null));
        this.logln("equals self: " + cca.equals((Object)cca));
        this.logln("equals clone: " + cca.equals((Object)cca3));
        this.logln("equals bogus: " + cca.equals(new Object()));
        this.logln("hash: " + cca.hashCode());
        cca.compact(false);
        cca.compact(false);
        char[] xa = cca.getIndexArray();
        char[] va = cca.getValueArray();
        CompactCharArray cca4 = new CompactCharArray(xa, va);
        String xs = Utility.arrayToRLEString((char[])xa);
        String vs = Utility.arrayToRLEString((char[])va);
        CompactCharArray cca5 = new CompactCharArray(xs, vs);
        this.logln("equals: " + cca4.equals((Object)cca5));
        this.logln("equals: " + cca.equals((Object)cca4));
        cca4.compact(false);
        this.logln("equals: " + cca4.equals((Object)cca5));
        cca5.compact(false);
        this.logln("equals: " + cca4.equals((Object)cca5));
        cca.setElementAt('\u0405', '\u00df');
        this.logln("modified equals clone: " + cca.equals((Object)cca3));
        cca3.setElementAt('\u0405', '\u00df');
        this.logln("modified equals modified clone: " + cca.equals((Object)cca3));
        cca3.setElementAt('\u0405', '\u00ee');
        this.logln("different mod equals: " + cca.equals((Object)cca3));
        cca3.compact(true);
        this.logln("different mod equals: " + cca.equals((Object)cca3));
        cca3.setElementAt('\u0405', '\u00ee');
        this.logln("different mod equals: " + cca.equals((Object)cca3));
        cca3.compact();
        this.logln("different mod equals: " + cca.equals((Object)cca3));
        CompactCharArray cca6 = (CompactCharArray)cca.clone();
        this.logln("cloned compact equals: " + cca.equals((Object)cca6));
        cca6.setElementAt('\u0405', '\u00ee');
        this.logln("modified clone: " + cca3.equals((Object)cca6));
        cca6.setElementAt('\u0100', '\u0104', '\u00fe');
        for (int i = 256; i < 261; ++i) {
            cca3.setElementAt((char)i, '\u00fe');
        }
        this.logln("double modified: " + cca3.equals((Object)cca6));
    }
}

