/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.util.BagFormatter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public class FileUtilities {
    public static void appendFile(String filename, String encoding, PrintWriter output) throws IOException {
        FileUtilities.appendFile(filename, encoding, output, null);
    }

    public static void appendFile(String filename, String encoding, PrintWriter output, String[] replacementList) throws IOException {
        String line;
        BufferedReader br = BagFormatter.openReader("", filename, encoding);
        while ((line = br.readLine()) != null) {
            if (replacementList != null) {
                for (int i = 0; i < replacementList.length; i += 2) {
                    line = FileUtilities.replace(line, replacementList[i], replacementList[i + 1]);
                }
            }
            output.println(line);
        }
    }

    public static String replace(String source, String piece, String replacement) {
        if (source == null || source.length() < piece.length()) {
            return source;
        }
        int pos = 0;
        while ((pos = source.indexOf(piece, pos)) >= 0) {
            source = source.substring(0, pos) + replacement + source.substring(pos + piece.length());
            pos += replacement.length();
        }
        return source;
    }

    public static String replace(String source, String[][] replacements) {
        return FileUtilities.replace(source, replacements, replacements.length);
    }

    public static String replace(String source, String[][] replacements, int count) {
        for (int i = 0; i < count; ++i) {
            source = FileUtilities.replace(source, replacements[i][0], replacements[i][1]);
        }
        return source;
    }

    public static String replace(String source, String[][] replacements, boolean reverse) {
        if (!reverse) {
            return FileUtilities.replace(source, replacements);
        }
        for (int i = 0; i < replacements.length; ++i) {
            source = FileUtilities.replace(source, replacements[i][1], replacements[i][0]);
        }
        return source;
    }

    public static String anchorize(String source) {
        String result = source.toLowerCase(Locale.ENGLISH).replaceAll("[^\\p{L}\\p{N}]+", "_");
        if (result.endsWith("_")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }
}

