/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test.util;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.ICUBinary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ICUBinaryTest
extends TestFmwk {
    public static void main(String[] arg) {
        ICUBinaryTest test = new ICUBinaryTest();
        try {
            test.run(arg);
        }
        catch (Exception e) {
            test.errln("Error testing icubinarytest");
        }
    }

    public void TestReadHeader() {
        byte[] formatid = new byte[]{1, 2, 3, 4};
        byte[] array = new byte[]{0, 24, -38, 39, 0, 0, 0, 0, 1, 0, 2, 0, 1, 2, 3, 4, 1, 2, 3, 4, 3, 2, 0, 0};
        ByteArrayInputStream inputstream = new ByteArrayInputStream(array);
        ICUBinary.Authenticate authenticate = new ICUBinary.Authenticate(){

            public boolean isDataVersionAcceptable(byte[] version) {
                return version[0] == 1;
            }
        };
        try {
            ICUBinary.readHeader((InputStream)inputstream, (byte[])formatid, (ICUBinary.Authenticate)authenticate);
        }
        catch (IOException e) {
            this.errln("Failed: Lenient authenticate object should pass ICUBinary.readHeader");
        }
        try {
            inputstream.reset();
            ICUBinary.readHeader((InputStream)inputstream, (byte[])formatid, null);
        }
        catch (IOException e) {
            this.errln("Failed: Null authenticate object should pass ICUBinary.readHeader");
        }
        try {
            inputstream.reset();
            ICUBinary.readHeader((InputStream)inputstream, (byte[])formatid, (ICUBinary.Authenticate)authenticate);
        }
        catch (IOException e) {
            this.errln("Failed: Lenient authenticate object should pass ICUBinary.readHeader");
        }
        array[16] = 2;
        try {
            inputstream.reset();
            ICUBinary.readHeader((InputStream)inputstream, (byte[])formatid, (ICUBinary.Authenticate)authenticate);
            this.errln("Failed: Invalid version number should not pass authenticate object");
        }
        catch (IOException e) {
            this.logln("PASS: ICUBinary.readHeader with invalid version number failed as expected");
        }
    }
}

